META
key;value
description;District PB in Warszawa, Białołęka
country;Poland
unit;Warszawa
district;Białołęka
subunit;Białołęka
instance;2024
num_projects;54
num_votes;8422
budget;4767075
vote_type;approval
rule;greedy
date_begin;15.06.2023
date_end;30.06.2023
max_length;15
edition;10
language;pl
currency;PLN
comment;#1: The metadata regarding the age of voters shows very low values (starting from zero), indicating that one doesn't need to be an adult to vote: If a voter is under 13, they can vote with the consent of a parent or guardian. Hence, for example, age 0 likely corresponds to cases where parents/guardians are voting on behalf of their children. #2: Due to a voting system glitch, twelve voters mistakenly cast ballots for projects in two different districts, violating regulations. To align with city-wide results, we tagged these voters with the prefix 999999 and separated their ballots into two distinct votes. The final election outcome was not affected.
PROJECTS
project_id;cost;votes;name;category;target;selected;latitude;longitude
627;301710;3539;Drzewa dla Białołęki;environmental protection,public space,urban greenery;children,seniors;1;52.31645324554016;20.96099439927162
820;376000;3245;Doświetlenie przejść dla pieszych;public transit and roads;;1;52.333863737669866;20.9569787979126
51;356000;2908;Nowa zieleń i chodniki dla Białołęki;public transit and roads,environmental protection,public space,urban greenery;children,seniors;1;52.31216452754241;20.976548194885254
106;935860;2759;Posadźmy drzewa i krzewy wzdłuż ul. Modlińskiej - #STOP SMOG!;public transit and roads,environmental protection,public space,urban greenery;children,seniors;1;52.33684789268439;20.958463276969272
25;98340;2593;Droga rowerowa wzdłuż Kobiałki;public transit and roads,sport;children,seniors;1;52.357222202778104;21.0336319589941
245;250000;2546;Zakup książek, audiobooków, e-booków i filmów dla białołęckich bibliotek;education,culture;children,seniors;1;52.32654945625;20.977201502650345
43;129700;2496;Monitoring na białołęckich ulicach;public transit and roads,public space;children,seniors;1;52.3310728175369;21.00510120391846
347;105000;2493;Posadzenie 500 m² krzewów na Białołęce;environmental protection,urban greenery;children,seniors;1;52.3166117;20.9602486
1518;800000;2401;Park Zaułek;education,culture,sport;children;1;52.3272214;21.06671870275178
5;296000;2357;Jaśniej i bezpieczniej – doświetlenie przejść dla pieszych;public transit and roads,public space;children,seniors;1;52.321836441593476;21.017711427945677
348;605400;2263;Przeprawa przez Wisłę;public transit and roads,urban greenery;children,seniors;1;52.329936815275246;20.928440093994144
53;450000;2210;Bardziej zielona Białołęka - nowy teren rekreacyjny dla mieszkańców;environmental protection,public space,urban greenery;children,seniors;1;52.30711418148015;20.97852230072022
317;126630;2071;Sadzimy drzewa na Żeraniu;environmental protection,public space,urban greenery;children,seniors;0;52.3076387208633;20.99274212987852
344;90000;2012;Ławki i kosze na śmieci;public space;children;0;;
190;952850;1923;Remont chodnika i ścieżki rowerowej przy ul. Światowida;public space;children,seniors;0;52.32127232271467;20.946164131164554
435;490000;1793;Dostępna Modlińska - budowa schodów na wał przy Kanale Żerańskim;public transit and roads,public space;children,seniors;0;52.29956225039019;20.993564128875732
1148;45000;1685;Bezpieczny chodnik przy torach tramwajowych na ulicy Światowida;public transit and roads;children,seniors;1;52.317635873714494;20.96290824003518
433;235000;1633;Teatr dla wszystkich;education,culture,welfare;children,seniors;0;52.318234809018385;20.98023604205248
583;532848;1628;Ninja Park na Białołęce;education,public space,sport,urban greenery;children,seniors;0;52.31188954514337;20.952301025390625
90;270000;1580;Segregacja odpadów w białołęckich parkach, skwerach i placach zabaw;education,environmental protection,public space,urban greenery;children,seniors;0;52.327041693829194;20.990954545828018
6;600000;1572;Zielone i bezpieczne dla ptaków wiaty przystankowe;public transit and roads,public space;children,seniors;0;52.32493808539051;21.04240189579671
45;400000;1558;Remont szkolnych placów zabaw;education,culture,public space;children;0;52.32771975;20.976538415168825
707;100000;1510;Mini park sensoryczny / Ogród terapeutyczny przy ulicy Krzyżówki;education,environmental protection,welfare,public space,urban greenery;children,seniors;0;52.30887221025087;20.993928907793688
9;440000;1504;Budowa oświetlenia wzdłuż ul. Białołęckiej;public transit and roads,public space;children,seniors;0;52.336821954659314;21.034548282623295
345;200000;1473;Leśny plac zabaw przy ul. Stefanika;public space;seniors;0;52.32794358970365;20.938997268564332
52;90000;1465;Czystsza Białołęka dzięki zadaszonym koszom na śmieci;public space,urban greenery;children,seniors;0;52.30542168659498;20.989143848419193
340;900000;1455;Nowe boisko przy ul. Światowida;sport;children,seniors;0;52.330022459957505;20.941464900970463
1658;98000;1376;Aktywny Plac Zabaw przy ul. Strumykowej;education,public space,sport;children;0;52.33402790519474;20.94483385156432
587;30900;1339;Bezpłatne ćwiczenia na zdrowy kręgosłup;sport;seniors;0;52.321285125;21.004709039921313
44;841536;1325;Park na Brzezinach i plac zabaw przy ul. Lemiesz;education,public space,sport;children,seniors;0;52.32159497467586;21.0163950920105
919;38600;1286;Bezpieczna Kobieta w Dzielnicy Białołęka, kurs samoobrony dla kobiet;welfare,sport;seniors;0;;
62;300000;1244;Więcej zieleni dla mieszkańców - nowy edukacyjny skwer leśny;education,environmental protection,public space,sport,urban greenery;children,seniors;0;52.32564248486744;20.98695516586304
1430;100000;1225;Powiosłuj na Białołęce;education,sport;children;0;52.32191381504589;21.060321807599397
1619;170000;1193;Zielona Edukacja;education,public space,urban greenery;children;0;52.32657168496249;20.998964673723414
1118;100000;1182;Ławki solarne z ładowaniem urządzeń mobilnych;education,public transit and roads,culture,environmental protection,welfare,public space;children,seniors;0;52.3206826125;21.051408197731423
1656;190000;1158;Rewitalizacja Placu Zabaw i Psiego Wybiegu przy ul. Ceramicznej;education,environmental protection,public space,sport,urban greenery;children;0;52.32264534522876;20.961655961983883
342;99000;1142;Place zabaw z kolorowym piaskiem;public space;children;0;52.34032852467492;20.964360237121586
1654;200000;1092;Bezpieczniejszy Skatepark;education,culture,public space,sport;children;0;52.324717503907394;20.939426176603934
1456;4500;1068;Rodzinne spacery przyrodnicze w lasach miejskich na Białołęce.;education,environmental protection,public space,urban greenery;children,seniors;1;;
1653;140000;1023;Strefa wypoczynkowa przy ul Ch. Botewa;environmental protection,public space,urban greenery;children,seniors;0;52.318999159550806;20.954832144711084
1411;836000;1018;Zagraj na piasku w Warszawie;public space,sport,urban greenery;children;0;52.3264958108881;21.04780483219656
1655;150000;984;Rewitalizacja Placu Zabaw przy ul. Erazma z Zakroczymia;education,public space,sport;children;0;52.3214911894564;20.94805285464313
1058;13000;963;Bezpłatne zajęcia jogi oraz treningi funkcjonalne na świeżym powietrzu;public space,sport;seniors;1;52.3251451;20.9465699
593;20700;878;Fitness i Zumba na Białołęce;sport;seniors;0;52.32610242381611;20.973202947411274
166;85000;824;Od światła do zdrowia. Modernizacja oświetlenia na terenie rekreacyjno-sportowym SP 31 w Warszawie;education,culture,public space,sport;children,seniors;0;52.361765130806454;21.046628952026367
596;55000;813;Smart ławki - nowoczesne ławki solarne z funkcją ładowania;environmental protection,public space,sport,urban greenery;children,seniors;0;52.32246799986013;20.952911377025888
1422;87945;787;Boisko do gry w bule;culture,public space,sport;children,seniors;0;52.30729785883887;20.979037284851078
1657;190000;778;Rewitalizacja Placu Zabaw w Rejonie ulic Łączącej i Odkrytej;education,environmental protection,public space,sport;children;0;52.32400930869265;20.93899691641582
1485;198000;656;Jasna droga na trening (oświetlenie latarniami drogi dojazdowej do przystani przy ul. Modlińskiej 16);public transit and roads;children,seniors;0;52.29620587421672;20.99759101867676
589;193000;594;Altanka Coworkingowa;environmental protection,public space,urban greenery;children,seniors;0;52.33101207428179;20.96770763397217
898;169740;577;Ogólnodostępny kosz do koszykówki z ławką z oparciem;sport;seniors;0;52.3060228;20.9790273
1226;15200;544;Dzik(a) joga na Białołęce!;culture,sport;seniors;0;52.33439102959624;20.946807861328125
63;150000;365;Ciekawsze place zabaw - doposażenie placu zabaw przy ul. Żywicznej;education,environmental protection,public space,sport,urban greenery;children,seniors;0;52.3260551750516;20.9754753112793
822;350000;365;Niech stanie się światłość! Oświetlenie placu zabaw przy ul. Brzezińskiej;public space;children;0;52.35657578587646;20.97796440124512
VOTES
voter_id;vote;age;sex
14;435;30;M
23;6,25,340,345,62,1148,1653,347,51,348,583,190,1655,106,627;37;M
28;1430,433,344,348,106,435,317;34;M
30;1118,433,587,245,1058,317,707,1518,589,1411;38;F
42;1518,1430;47;F
77;90,51,1118,53,106,627,1411,62,45,1658,1654,52,344,348,340;42;M
82;43,44,820,5,25;39;F
87;433;40;F
91;1411;42;M
106;1430,1411;8;F
119;583,1430,1411;13;F
123;433;48;F
126;822,435,344,51,45,587,5,6,44,1518,820,919,25,43,9;38;F
132;1411;37;M
171;1658,1653,106,820,587,348,1430;46;F
183;433,5,45,25,344,1619,53,820,627,1411;40;M
186;1430,1411;38;M
194;5,6,348,106,435;41;M
201;1411;11;F
208;1518;45;F
209;1411;44;F
217;589,90,596,52,344,1118,1656,340,820,106,627,435;21;F
219;1058,1226,348,25,593,1411;47;F
230;9,25,44,1118,820,435,1518,1411;30;M
242;1430,1619,1411;45;F
243;1411;29;M
247;43,589,348,1118,435,707,1411;41;M
250;1619,1226,345,1456,919,1654,62,433,587,5,593,1658,820,1058,106;34;F
251;1411;35;F
252;9,1430,43,344,25,44;41;F
307;1655,1654,1118,1411,317,707,52,1456,106,627,1619,1518,1430,245,90;34;F
334;1518;37;F
337;45,6,43,90,596,25,919,51,344,1118,53,820,435,627,1518;55;M
338;1518;44;F
343;1058,435,53,5,587,9,245,25,1619,627,1518;39;F
345;51,1619,53,1655,106,583,1658,62,5,9,44,627,707,345,1518;35;M
353;25,1411;35;F
358;435;36;M
377;707,344,51,43,898;35;F
378;433,1656,1118,587,25,317,44,820,1058,627;44;F
404;245,190,593,9,5,587,25,707,43,820;31;M
424;433,245,43,106,435,627,317;50;F
428;1654,348,25,1518;50;M
449;1118,820,45,1148,1654,919,342,340,627,345,1657,190,348,1658,106;47;F
461;90,344,5,1148,25,52,348,340,820,6,1655,63,1411;34;F
465;1411;15;F
466;1619,1430,1411;18;F
485;919,627,317,707,1148,820;21;F
489;433,45,6,347,51,348,53,820,627,106,707,1658,245,317,435;41;F
502;1518;72;M
519;317,106,52,707,435,1656;44;F
525;166;42;M
532;1518;10;F
549;9,1485,5,1430,166,25,919,348,342,1118,1656,820,435,317,1518;40;M
550;5,45,583,1422,344,820,435,627,317,1518;43;F
563;1430,1411;43;F
572;52,344,1656,1456,62,245,90,347,51,53,106,627,317,345;49;M
578;1658,1118,1656,1657,583,1653,190,90,106,627,345,1148,51,348,820;38;M
579;1148,190,347,820,627,106,348,245;31;F
602;344,43,433,347,435,53,627,587,245,1430,25,44,820,1456,1518;39;F
611;583,245,25,1518;40;M
616;166;11;F
617;1430,1619,1411;17;F
622;1518;29;M
633;627,820,344,347,5,587,245,90;52;F
646;166;39;F
676;25,52,348,342,53,820,1456,1411;42;F
690;1518;45;M
716;587,5,9,6,347,90,52,53,820,245,25,344,1619,627,1518;54;M
722;245,1657,1653,345,344,1148,1658,5,596,822,51,348,106,627;54;M
723;1411;14;F
743;587,45,347,90,25,51,1456,1058,317,1518;41;M
744;190,583,1653,25,347,51,344,348,342,1656,340,820,627,1655,345;35;M
751;25,1518;57;F
766;43,347,90,25,51,52,344,1619,820,1456,1058,106,627,317,1518;36;F
772;9,51,44,820,627,1411;27;M
787;5,166;40;F
796;45,1430,583,90,344,342,1118,340,820,1148,190,43,1658,51,348;35;M
798;43,166,25;40;F
801;587,593,43,919,53,340,1655,820,583,25,627,1518;34;F
807;166,25,245,43;37;F
813;166;46;F
814;1411;23;M
824;1518;15;F
836;106,627,1430,245,1411,9,1619,5,90,166,587,593,583,25,820;35;F
840;166;33;F
851;919,707;43;M
861;5,25,51,44,344,53,820,1411,166;41;F
869;433,43,245,45,5,347,25,51,52,344,1118,53,820,627,166;50;F
878;166;45;M
879;44,90,6,245,1118,1430,25,1518;36;F
886;5,9,25,45,166;33;F
900;5,1148,6,1653,190,43,347,51,348,435,106,627,820;29;F
920;583,1148,1485,820,1656,344,51,190,5,433,919,340,627,435,1411;36;F
932;166;47;F
965;44,820,1518;34;F
971;25,52,1619,1411,587,5,1518;38;F
973;342,53,820,1411,1518;38;F
983;1411,1430,1518;37;M
987;898,166,25;42;M
989;1430,583,245,106,1654,43,820,1518;43;F
1001;9,6,5,90,166,583,347,25,44,348,1655,820,106,435,317;35;F
1016;1422,90,1619,435,1411,5,1430,348,53,245,51,344,820,627,1518;39;F
1041;1411;42;M
1043;1411;16;F
1045;62,5,433,43,1654,45,9,587,348,25,1430,583,166;34;M
1067;166,587,593,1654,25,342,1226,820;36;F
1071;1456,587,593,1518;50;F
1077;1518;35;F
1079;1518;55;F
1082;1430,45,1518;37;F
1092;1518;41;F
1118;583,245,1654,1422,344,342,53,820,1518;8;M
1128;627,9,5,433,1430,1422,166,596,25,919,44,348,820,1411,1518;41;M
1131;1518;7;F
1132;820,190,822,347,344,348,342,340,345;33;M
1141;166;49;M
1150;6,583,1430,898,5,344,25,166;44;M
1152;1619,1148,583,245,347,90,596,52,342,1118,53,627,45,344,433;43;M
1155;25,5,6,9,62,347,51,52,53,1619,106,245,627,317,1518;43;F
1170;1518;5;M
1183;589,90,51,52,344,348,53,435,345,583,1148,9,5,190,1411;46;F
1192;44;40;M
1211;1518;45;M
1256;106,627,317,9,43,166,90,25,344,435,820,1118,51,6,62;36;M
1261;53,348,51,347,1654,45,5,9,25,820,106,435,627,317,166;43;M
1267;166,25;38;F
1271;1411;33;M
1281;1411,5,25,166;35;M
1293;627,106,347,1619,1656,52,6,1653,53,348,51,90,190,245,1148;38;F
1308;6,43,106,627;46;F
1317;919,53,707,1411,9,45,6,347,25,44,1518,5,43,820,1148;43;F
1361;919,347,43,1422,190,1654,433,5,1148,583,6,51,348,106,435;44;F
1365;347,25,1430,583,1422,166,52,342,1118,627,820;11;M
1368;190,245,1430,898,9,5,587,433,45,593,6,596,342,627,707;37;F
1371;190,6,1148,1653,347,25,51,344,1656,106,627;35;M
1397;1518;38;F
1398;1058,63,627,1411,1657,345,1148,1653,1456,707,433,45,245,344,1655;35;F
1400;1058,1118,348,25,589,43,245,587,62,45,593,1430,1518;43;M
1406;1656,51,583,1658,45,62,9,1422,25,348,340,820,345,627,190;40;M
1413;433,9,1654,43,347,90,344,820,106,166;38;F
1421;627,348,90,1654,62,1657,1658,583,245,190,342,1656,340,1655,345;32;F
1425;587,190,43,51,52,344,53,627,317,1656,90,342,106;32;M
1443;1148,43,347,51,348,340,820,106,190,1422,589,25,919,435,1411;31;F
1448;589,347,90,25,52,317,627,5,9,6,245,43,44,53,106;25;F
1466;820,340,342,348,344,347,190,822,345;31;F
1467;1411;43;M
1477;166;42;F
1498;1518;44;M
1506;433,5,1485,9,1654,43,347,25,51,348,820,435,627,317,166;8;M
1507;1518;70;F
1514;245,1518;42;F
1527;345,435,820,344,596,190,1658,245;36;F
1531;317,627,106,53,1619,344,245,6,62,52,51,25,90,347,166;54;F
1535;1411;27;M
1540;1619,1118,340,1456,106,627,317,1518;39;M
1541;45,1456,43,166,25;42;F
1557;1619,340,820,106,345,1518,1657,190,347,433,45,51,344,627,1655;40;F
1574;820,627,317,1518,5,583,245,166,25;43;M
1584;433,347,596,51,25,1118,53,820,1456,627,707,1430,1518;46;F
1597;1148,433,5,9,1654,190,347,25,348,820,106,435,627,317,166;12;M
1601;340,1411;37;M
1614;1430,1518;31;F
1621;919,707,106,63,90,589,190,587,593,583,348,1226,820,435,627;41;F
1623;1518;45;F
1624;433,596,245,25,919,1518;41;F
1628;1430,43,344,1118,1619,1518;40;F
1629;62,190,43,347,25,340,435,317,627,90,822,1619,348,106,820;40;M
1642;1654,1653,190,1422,347,90,596,822,25,919,51,44,52,344,166;10;M
1651;344,1430,1518;34;F
1656;707,1430,593,45,62,587,583,245,1654,43,344,820,1456,1058,1518;40;F
1657;6,583,245,1658,9,587,433,347,25,919,44,1619,1518;38;F
1663;62,707,5,6,589,53,820,106,435,9,51,43,25,627,317;18;M
1666;348,344,51,43,6,45,433,245,347,90,822,342,820,106,627;37;F
1667;62,45,593,583,1456,1058,106,627,317,345,433,245,190,340,63;42;F
1688;43,25,1518;42;F
1700;1518;69;M
1703;6,583,1657,45,5,587,433,1430,1658,43,347,348,342,820,106;31;F
1704;433,5,898,62,1430,245,347,51,348,106,627,1148,43,919,820;40;F
1705;6,5,1657,1148,344,1656,820,1655;12;M
1719;1518;11;F
1790;1619,348,52,919,347,43,45,433,1430,166,25,51,344,627,317;39;F
1791;627,1456,820,53,344,44,51,25,347,43,6,62,9,5,1518;32;M
1805;45,43,347,51,344,820,106,1518;47;M
1812;245,25,1456,627,1518;40;F
1814;348,707,245,1654,25,166;42;F
1825;1619,106,5,45,43,53,1656,340,820,707,348,25,190,1653,583;42;M
1844;1430,1657,1148,583,1653,190,1422,43,589,25,627,345,1518,1656,1655;40;F
1862;593,587,5,45,1430,583,1653,348,342,1118,1656,340,1655,820,1518;41;F
1868;627,5,45,583,1653,190,43,25,348,1619,53,340,820,106,707;11;M
1876;919,1058,1518;29;F
1916;707,1456,106,317,348,53,43,587,1654,245,593,898,1058,435,1430;36;F
1920;9,6,43,347,90,25,51,44,52,348,53,820,317,106,627;69;M
1948;44,1226,433,9,45,1430,245,919,1118,53,820,1456,1058,627,1518;32;F
1972;433,583,1422;15;M
1973;1518;39;F
1985;596,1226,9,5,587,433,593,1430,245,43,919,25,166;42;F
2014;317,1654,1658,5,344,1656,820,345,587,1148,45,1655;52;F
2021;1653,344,348,1148;47;F
2026;587,593,1658,433,45,245;41;F
2048;596,1658,583,1430,45,5,25,245,52,435,51,317,90,820,707;35;M
2059;245,587,45,1658,190,90,1226,1058,106,627,1148,6,51,344,820;49;F
2085;433,245,589,51,44,52,344,1456,1058,627,707,1518;40;M
2086;166;45;F
2087;627,707,51,90,52,317,342,190,822,345,820,344,347,340,348;32;M
2088;1456,435,433,583,898,25,1118,53,106,627,1518;16;F
2096;435,166,1456,348,90,6,1430,62,433,245,25,344,43,919,1619;40;F
2108;53,1518;38;F
2134;245,344,1518;50;F
2158;106,435,627,317,5,1430,1148,43,347,822,25,51,344,1619,820;60;M
2160;166;63;M
2165;1422,43,51,344,53,707,1148,347,52,348,820,106,435,627,317;31;F
2166;433,45,245,190;11;M
2173;433,43,25,51,52,317,707;35;M
2175;5,822,820,1456,106;40;M
2176;1657,62,190,51,435,106;46;M
2195;1657,5,245,190,347,51,52,344,348,1656,340,820,106,627,345;49;M
2197;90,898,52,53,820,106,627,5,43,25,51,1456,435,317,707;49;F
2198;433,5,1485,898,6,90,51,53,52,435,707;36;M
2210;51,340,1655,345,627,820,1656,344,25,596,90,43,190,1653,1148;42;M
2224;707,347,5,1485,45,6,1619,245,44,317,433,43,348,435,627;27;F
2228;433,45;9;F
2237;820;33;M
2238;340,627,347,898,433,593,1430,583,25,919,51,348,53,1411,1518;46;F
2241;587,245,347,51,44,348,1656,53,435,106,627,317,1518,166;40;F
2248;51,583,919,344,820,435,345,587,898,627,1518,347,62,6,53;46;F
2295;820,1058,345,433,587,45,593,583,589,596,52,344,348,1118,1518;44;F
2303;919,52,348,1118,627,43,347,344,53,820,106,435,317,707,1518;29;M
2308;589,344,106,627,593,245,348,820,317,51,435,53,5,6,707;32;F
2333;5,1148,245,190,1422,43,347,51,344,53,340,820,1058,106,627;43;F
2345;1657,1658,1148,583,190,348,342,1656,820,340,1655,106,435,627,345;34;M
2351;596,589,898,6,5,245,190,43,347,51,52,348,53,627,820;18;F
2358;1485,587,5,62,45,1655,627,344,52,51,347,43,190,245,1148;39;F
2362;9,45,1430,245,43,25,51,52,344,348,820,435,627,1411,1518;39;M
2367;317,707;25;F
2377;1485,433,587,593,43,589,919,344,1226,1058,317,707;30;F
2382;5,9,820,627,707,25,44,435,317;43;M
2396;1411,1654,1456,435,627,919,347,1422,583,53;38;F
2398;1485,5,1148,6,53,1456,1058,1518,62,347,919,435,317,627,707;43;F
2414;25,1619,53,340,433,587,45,593,90,348,1226,820,1058,627,1518;52;F
2415;25,166;38;M
2420;583,1411,433,25,44,1518;33;F
2427;583,1658,593,62,898,1411,433,1430,1653,1422,919,348,53,820,1058;27;F
2441;166;47;M
2452;1148,1485,433,898,583,348,53;43;M
2457;1485,583,190,347,25,1456,1058,106,317,707,245,43,919,348,435;44;M
2462;51,53,90,52,435,317,707;31;M
2474;340,627,45,1657,1658,583,1653,190,348,1656,820,1655,106,435,345;34;F
2476;433,5,1148,6,245,1654,43,347,51,52,344,106,317,627,589;43;F
2479;433,587,898,593,43,596,25,919,1619,627,53,820,6,1654,1518;41;F
2481;1619,1456,1411,1430,1422,1118,435,317,707;36;M
2486;433,45,593,1657,1148,583,245,1653,1654,190,347,51,1619,627,345;39;F
2499;44,919,25,596,166,1422,587,898,593,1430,1411;41;F
2500;45,583,6,43,589,90,25,919,51,344,342,1118,53,435,707;30;F
2513;5,51,344,53,317,1518,596,25,820,1456,707;34;F
2516;245,106,435,317,707,52;37;F
2525;593,52,344,707,435;26;F
2534;627,45,1657,583,1658,340,345,245;42;M
2552;45,1657,245,166,919,340,820,1456,1411,627,345,707,106,1656,1658;34;F
2558;25,898,9,51,340;44;M
2586;348,1655,1656,1430,1654,1456,245,1422,347,1619,1118,106,627,1411,1518;33;M
2587;1656,820,317,627,340,1655,106,345,1653,190,1148;42;F
2594;342,344,52,919,25,347,43,433,587,1430,1518;8;F
2600;53,51,822,347,43,1148,45,1658,344,820,106,317,707,52,435;34;F
2605;435,583,1653,1656;44;F
2623;820,5,190,43,342,1118,1655,1456,1058,707,345,1658,51,344,1656;37;F
2633;1430,245,106,627,317,707;4;M
2639;583,1654,347,342,106,317,5,898,6,90,51,52,53,435,707;30;F
2646;587,5,1654,1422,919,1619,1058,317,1411,1430,43;33;F
2653;435,627,317,707,1518;30;M
2654;106,627,707,1619,344,52,25,43,6,5,45,593,1430,1518;3;M
2655;317,51,25,435,707,1518;31;M
2668;45,5,433,587,43,9,166,245,25,44,820,1456,1058,627,1518;40;F
2673;822,1456,106,435,1485,5,9,1148,25,51,820,1619,245,45,1518;39;F
2687;45,6,1430,583,347,90,25,52,344,53,820,106,435,317,707;34;M
2704;593,245,43,596,344,348,342,1619,106;35;F
2705;1518,627,820,344,51,347,583,1430,45,9,587,5,166,25;38;F
2708;9,25,44;32;M
2711;5,9,43,44;35;M
2713;1422,6,5,433,1430,1148,1653,245,43,919,344,348,1118,53,820;27;F
2738;5,898,6,90,51,52,53,435,707;35;M
2741;820,106,342,1656,347,52,345,627,348,435,317,1619,5,90,53;30;F
2744;347,51,344,1058,627,345,106,1656,1148,1658,190,348,340,820,435;45;F
2763;51,52;32;M
2766;433,344,342,1456,1058,435,317,707;29;F
2772;898,90,51,52,53,435,707;39;M
2780;347,190,1148,1485,5,898,6,90,51,52,53,435,707;32;F
2783;1518;50;F
2794;1656,347,6,62,45,593,51,245,435,317,90,627,52,707,1485;31;F
2795;433,45,593,1657,1148,583,245,1653,1654,190,347,51,1619,627,345;46;M
2800;9,1430,583,6,90,25,51,44,52,348;66;F
2806;583,6,245,190,1422,25,51,344,348,340;32;M
2810;1619,820,106,627,317,53,347,1148,90,51,52,707,435,1118,1656;35;F
2823;62,245,347,90,51,1619,106,627,317;32;F
2846;245,1430,45,1485,5,898,6,90,51,52,53,820,435,317,707;38;F
2861;45,593,25,1226,340,820,1456,1058,63,106,627,317,707,1411;35;F
2862;342,1656,53,1456,1058,106,435,317,707,345,25,347,1658,1657,62;37;F
2876;5,106,1658,583,43,596,51,52,344,348,53,1456,435,317,707;28;F
2877;587,45,1658,245,43,919,52,342,1655,820;39;F
2897;348,53,1422,43,347,90,52,344,820,1456,106,435,627,317,707;68;F
2898;433,348,342,1456,1058,106,317,707,1518;37;F
2904;593,433,919,435,317,707;30;F
2908;344,348,342,1118,820,1456,317,345,1148,52,53,106,435,627,707;34;F
2909;25,344,1619,1118,1226,53,820,1456,1058,106,435,627,317,707,1518;66;M
2913;435,317,707;30;M
2918;347,589,43,1654,245,433,62,45,583,6,25,51,342,53,1518;40;F
2936;45,593,1654,166,25,1226,1058,1518,587,9,43,596,919,1118,820;37;F
2953;6,344,52,820,627,317,9,43,25,5,245,1518;35;F
2955;1485,5,190,25,51,344,106,627,317;47;M
2966;45,1430,820,627,433,6,90,25,919,44,1619,1226,1456,1411,1518;38;F
2981;587,593,245,53,1518;37;F
2984;25,348,1226,1058,435,317,1518;44;F
2988;1148,348,245,106,1422,589,596,627,1485,51,317,52,90,707;30;M
2992;587,5,1654,43,347,596,822,919,51,344,1226,1656,820,1058,627;33;F
3009;583,6,43,589,347,90,51,344,52,342,820,106,435,317,707;37;F
3014;347,596,51,344,342,53,820,106,627,45,583,43,25,348,1518;36;F
3035;344,53,627,106,317,435,707;40;F
3036;433,587,45,593,1430,820,106,627,317,435,707;38;F
3043;1411;16;M
3059;627,43,166,25,344;42;M
3071;1653,1619,51,820,1485,347,627,43,589,919,1656,6,52,106,317;34;F
3074;166,25;35;M
3075;1654,9,5,587,45,593,1430,583,245,166,25,1619,1456,627,1518;39;F
3096;1148,1485,9,45,1658,44,5,1653,822,25,1656,1655,820,1518;45;F
3105;25,44,1411,1518;29;F
3107;166,1518;42;F
3108;5,45,1148,583,1654,344,820,9,43,90,348,1456,345,1518,44;43;M
3114;5,898,583,6,90,52,51,53,435,707;33;F
3116;1411;16;M
3133;1656,90,62,347,51,627,317,348,106,587,593,1430,25,1226,1058;34;F
3134;62,593,1653,344,348,53,106,435,627,317,345;72;F
3138;1430,25,344,52,317,435;29;F
3148;1148;44;M
3150;53,45,347,51,52,344,342,1456,627,1518;13;M
3151;583,43,347,820,1518;38;F
3159;1518;13;M
3168;1058,63,106,435,627,707,345,1518,1430,1619,1411;16;M
3170;435;43;F
3181;9,245,6,344,5,1430,44,1518,43,1619,1118;35;F
3182;707,1411,317,627,348,90,245,45,62,5,898,1654,25,52,435;29;F
3186;1118,1619,919,596,1422,1654,1658,1148,1657,1430,898,433,190,51,348;52;M
3189;5,9,166,90,25;41;M
3206;44,919,1148,1058,1518,62,190,347,25,51,1456,106,435,317;31;F
3208;166,25,1619,1118,53;46;F
3212;53,820,627,1485,433,5,435,106,51,25,90,347,6,45,317;31;F
3227;25,166;39;F
3237;52,106,435,317;46;F
3246;245,90,317,627,583,1654,51,820,106,1619,347,43,6,1430,5;38;F
3260;53,820,5,1485,347,25,106,435,707;37;M
3277;348,1619,340,820,106,627,317,345,433,6,190,51,1656,1655,1058;39;F
3278;1422,43,90,52,1118,106,627,707,317,435,348,344,51,596,347;34;F
3282;166;43;F
3292;433,1430,166;43;F
3297;1485,190,25,51,919,820,52,344,348,53,106,435,317,707,1411;27;F
3310;820,5,9,45,1430,43,166,25,1456;38;F
3316;583,53,1422,5,707,52,245,435,433,45,898;39;F
3324;5,898,6,90,51,52,53,435,707;31;M
3334;1422,589,348,1118,340,106,435,1411;43;M
3343;166;36;F
3347;1430,340,1411;15;M
3352;348,52,51,919,90,347,43,245,1148,1485,5,317,435,627,707;29;F
3353;1411,1430;15;M
3356;1430,1654,1422,348,342,1058,627,1411,433,1619,1456,1518,707;38;F
3378;62,45,1148,1658,190,347,90,344,342,53,245,106;38;F
3379;166;14;F
3388;1430,1411;15;M
3390;43,348,820,106,435,317,52,707;35;M
3394;317,627,245,1430,898,348;44;M
3409;166;11;F
3416;347,25,51,44,52,344,348,820,1456,1058,106,435,627,317,707;36;F
3425;45,51,44,344,348,1118,1656,53,340,820,63,106,435,627,345;39;F
3426;435,1456,44,51,43,1653,347,348,53,820,106,627,1518,9,5;53;M
3433;1656,820,1118,344,5,9,62,583,43,25,44,348,342,1411,1518;31;M
3434;1653,190,43,347,25,51,52,348,53,820,1456,106,435,627,317;33;M
3444;1518;45;M
3445;1411;44;M
3447;1118,106,433,45,593,1657,1658,1653,25,342,1656,1655,820,1456,345;34;F
3462;1518;33;F
3464;6,1654,43,51,345,1518,190,1422,347,25,348,106,435,627,317;31;M
3484;45,43,347,25,348,340,820,63,106,627;24;F
3498;1148,190,43,347,53,820,106;42;M
3507;62,587,5,45,593,583,245,1654,43,166,25,51,820,1456,1518;45;M
3519;5,6,190,344,1456,106,435,627,317,707;33;F
3528;596,53,63,707,1518;12;F
3572;62,627,317,106,190,51,53,1619;28;M
3588;62,245,43,347,90,627,344,342,1619,583,1518;33;F
3595;1456,1058,106,1411,433,6,90,342,820,435,317,707;34;F
3601;348,344,1422,583,1658,45,433,62,245,52,342,53,106,435,707;33;F
3611;1657,1653,822,344,627,707,345,45,1148,1658,190,348,1656,340,1655;39;F
3617;52,344,53,1456,1058,106,435,317,707;47;F
3623;43,52,348,1456,627;28;M
3651;1657,1148,51,340,1655,345;47;F
3664;25,51,53,106,1518,5,62,45,43,347,344,348,820,1456,627;30;M
3675;106,1411,51,1656,1654,1658,1148,593,45,5,348,1655,820,1058,345;37;F
3676;5,6,90,51,52,435,707;36;F
3695;347,43,245,6,593,433,587,5,9,25,344,820,627,1518;50;F
3711;166,25;42;M
3728;1518,433,43,25,820;46;F
3741;90,707,51,52,53,435;30;M
3746;1456,106,627,317,51,25,1430,43,348,820,435;58;M
3752;317,627,62,5,9,43,166,25,348;38;M
3755;45,62,898,1485,433,587,593,1658,347,25,51,348,53,820,345;46;F
3762;1456,347,245,5,25,43,583,433,587,1226,348,1430,593,1058,707;34;F
3780;587,919,53,435,820,627,1148,106;25;F
3811;583,1657,433,245,348,1226,340,1485,45,106,707,627,345,1658,342;37;F
3831;245,43,435,317;34;M
3845;90,106,627,317,435,707,25;35;M
3865;25,51,52,317;34;M
3872;1518;13;M
3873;52,90,435,317,707,1518;39;M
3880;344,435,317,347,51,53,820,627;36;M
3896;820,627,1411,190,589;46;F
3900;347,106,627,348,1619,5,898,6,90,51,52,53,435,317,707;33;F
3905;25,51,348,820,707,53,344,435;31;F
3907;166,25;44;F
3922;51,25,589,190,1653,1148,6,347,596,348,1118,53,820,435,317;35;F
3964;25,344,627,5,1653,190,347,51,348,53,820,106,435,317,345;26;M
3982;62,1148,190,589,596,52,1118,1058,435,317,5,593,245,344,627;40;F
3991;348,52,51,25,190,1653,1658,1148,45,106,435,627,317,1411,345;25;M
3992;1430,1518;38;M
3994;9,43,919,44,820,707,1518;34;F
4000;898,245,51,342,53,435,317;33;F
4002;52,435,707;29;M
4006;90,52,348,1118,53,5,9,166,25,51,44,820,627,1411,1518;17;M
4016;52,25,347,190,820,106,44,317;32;M
4027;43,90,25,52,820,435,627,317,1411,1518;31;F
4028;63,106,345,583,1655,820;41;F
4030;820,435,627,707;39;M
4035;6,1430,62,898,5,433,245,52,435,317,707;34;F
4048;43,1456,627,433,919,106,317,707,1518;37;F
4065;166,9,5;45;M
4086;587,593,1430,1658,347,919,51,344,342,53,1058,435,317,707;39;F
4091;62,1657,1148,1658,245,347,344,1655,820,433,45,190,51,348,1656;43;F
4101;593,1657,1148,1654,348,340,820,106,627,345;42;F
4109;25,348,435,317,707;44;F
4114;593,52,1118,820,1058,627,587,9,245,25,44,1518;53;F
4134;1619,348,52,1422,190,245,583,1658,1148,1657,1430,5,433,820,1456;39;M
4157;45,1653,43,347,51,344,342,53,820,63,435,627,317,345,1518;33;F
4164;62,1485,52,919,596,347,190,1653,1658,1148,898,587,344,348,627;42;F
4177;342,1226,820,1456,1058,63,106,707,345,433,1485,593,53,435,317;24;F
4193;1456,106,435,627,707,1518,51,25,43,5,9,583,344,53,1655;28;M
4215;1518;14;F
4226;106,820,347,1653,5,190,51,348,53,435,317,345,627,344,25;56;F
4230;348,1656,435,43,6,1148,45,433,627,820,347,190,51,5,106;58;M
4232;342,1118,1656,1655,1456,63,627,317,707,1422,5,6,53,435,51;35;M
4239;6,593,5,587,433,707,53,1619,342,344,51,245,583,45,62;40;F
4242;1411;38;F
4244;45,1148,583,190,43,347,25,51,344,342,1656,820,1058,627,707;27;F
4247;45,1430,347,596,919,51,344,348,342,1226,53,820,106,435,317;8;M
4270;5,6,90,344,340,435,707,1518;32;M
4283;1658,1654,1422,898,51,53;39;F
4284;919,106,435,317,707;29;F
4287;344,348,1656,317,707,435;27;F
4293;5,9,62,6,43,166,347,90,25,919,820,1456,627,317,1518;36;F
4305;9,166,25,820;8;M
4320;62,6,43,25,1518;37;F
4339;433,9,1430,245,1654,43,166,347,25,51,1118,53,820,627;37;F
4344;5,9,898,43,344,1518,1430,25,1411;45;F
4352;45,593,587,583,245,1654,348,1226,1456,1058,106,435,627,317,707;41;F
4355;1411;16;M
4358;45,1148,52,344,348,342,627,707,345,433,245,919,1655,820,1518;35;F
4374;919,348,342,1118,820,106,627,707,1619,6,51,245,435,90,52;30;F
4387;245,583,347,348,1653,190,822,1656,45,433,587,62,1148,342,627;40;F
4391;62,898,587,1148,1658,190,52,1655,317,51,342,1656,53,435,707;33;F
4406;433,593,1658,245,1422,348,342,1655;38;F
4407;1518;40;F
4415;1148;42;F
4426;6,166,347,596,822,919,51,44,1118,53,63,1518,52,435,707;38;F
4428;820,627,106,51,53,52,317,435,707;32;M
4439;820,90,51,52,53,106,435,707,317;29;F
4445;345,52,43,1148,190,344,820;22;M
4462;6,1619,583,627,5,1422,53,106,435,317;36;M
4476;5,62,245,1654,25,1619,53,627,433,45,43,348,342,820,1518;37;F
4481;52,25,347,43,1422,1485,5,51,344,317,53;26;M
4488;1430,25,1518,1411;25;F
4490;5,1411,1619,9,166,90,25;46;F
4494;587,90,347,919,51,106,627,317;45;F
4499;345,317,627,106,1456,820,1655,340,53,348,25,1657,583,1654,1518;39;M
4518;43,6,593,5,106,317,1485,919,51,435,707;42;F
4530;25,5,6,1518;32;M
4534;433,593,583,25,340,166;40;F
4537;25,51,820,1518;48;M
4556;348,344,51,1658,1430,45,62,1657,190,317,345,627,106,347,6;35;F
4559;820,435,587,5,898,1148,1658,589,317,345,45,51,53,106,707;33;F
4565;627,435,106,1655,53,340,1656,51,347,190,1653,245,583,1148,1485;42;M
4568;433,45,593,1657,1148,583,245,1653,1654,190,347,51,1619,627,345;13;F
4578;1226,1058,435,317,587,593,1430,6,589,347,596,919,348,1118,1518;34;F
4579;166;40;F
4593;1422,1619,1118,1456,587,433,45,1430,1658,583,90,52,344,348,340;41;F
4597;6,1148,1653,344,1656,340,820,435,1518,5,9,190,25,1655,345;21;M
4602;433,45,593,1657,1148,583,245,1653,1654,190,347,51,1619,627,345;11;M
4616;1430,1653,1654;34;F
4621;1656,435,707,1518,5,1657,1658,583,1654,344,342,1655,106;28;F
4626;433,5,1430,51,344,348,1656,53,820,106,627,317,707,345,1518;34;F
4628;345,90,596,919,52,344,348,1619,53,340,1456,45,1430,1658,583;46;M
4632;583,245,43,589,347,25,348,342,1118,53,820,435,627,317,1518;37;F
4633;1148,347,583,1653,1654,190,43,51,348,342,820,106,627,433,45;37;M
4672;25,919,344,348,1118,62,190,593,1148,1226,51,820,1058,106,627;46;F
4678;45,593,245,344,348,820,1411,1619,43,25,583,1518;45;F
4684;1654,6,593,345,53,344,52,44,347,45,5,25,820,106,627;46;F
4686;45,596,51,345;18;F
4703;1430,1619,1411;16;M
4711;583,1422,1654,1656,340,1655,1411,587,898,589,919,348,1226,1058,345;41;F
4714;587,433,5,9,62,1430,1148,6,1422,596,51,1411;18;F
4722;433;38;F
4723;1411;16;M
4729;583,45,62,1485,433,90,344,5,1430,25,919,44,1411,1619,9;38;M
4734;1656,44,25,596,583,62,1430,1411;17;F
4744;1148,1658,1653,25,344,1118,435,317,345,106,340,348,51,347,190;48;M
4754;5,898,6,90,53,52,51,435,707;23;M
4769;1655,820,106,627,345,43,1653,1658,1148,1657,62,5,190,347,51;28;F
4789;1653,627,245,190,1655,1058,433,5,1148,1658,348,1118,340,345;44;M
4809;5,898,62,6,1422,90,596,51,52,344,348,53,820,435,317;39;M
4832;51,106,627,317,6;13;M
4833;1118,6,1619,5,9,245,43,25;40;M
4859;1656,1655,820,63;46;M
4862;190,596,627,435,106,820,348,51,90,5,43,347,52,344,317;30;F
4871;9,43,347,25,51,44,52,344,348,1656,53,820,627;24;F
4874;919,6,1485,587,433,1430,245,43,344,1619,1118,1518;7;M
4879;898,583,1654,166,90,25,53,820,627,1518;45;M
4890;344,52,1619,820,9,43,5,45,6,166,25,1518;42;F
4902;1148,1653,190,51,820,627;48;F
4920;1657,1148,1658,1654,347,1656,1655,1518;51;M
4922;433,5,347,51,348,820,106,627,317,9,245,43,25,53,1518;40;F
4923;25,166;50;M
4939;45,245,43,596,25,51,348,52,344,342,1118,820,1456,627,1518;41;F
4952;435,1058,344,43,190,1654,1653,583,51,820,106,5,596,919,348;41;F
4953;1430,1411;17;F
4973;344,25,166,1148,9,1485,5,63,820,1118,348,51,596,43,190;20;M
4975;1430,627,1518,1411,1619,43;40;F
4987;6,589,347,51,342,53,340,820,627,1485,62,1658,106,345;34;F
4989;1518;44;M
4990;44,166;37;F
4991;348,1619,53,583,919,1655,1058,627,345;15;F
5005;45,6,1654,43,347,596,25,51,52,1118,53,1518,583,820,627;40;F
5006;51,347,1653,1658,1657,62,45,9,433,6,5,43,166,90,25;47;M
5016;190,166,822,342,1619,1656,53,820,627,583,1654,44,707,1411,1518;11;M
5017;583,1653,190,43,347,919,51,52,627;29;M
5021;90,190,583,1148,45,433,919,342,1118,340,1456,63,627,317,345;10;F
5034;44;31;M
5047;1656,245;42;F
5048;1118;68;F
5052;43,51,52,344,820,627,1518;40;M
5053;345,106,51,5,1118,820,435,596,25,340,1485,898,1148,190,1422;33;M
5054;347,919,51,52,344,348,342,1619,1118,1226,53,1456,1058,106,627;70;F
5056;1411;51;M
5061;106,435,317,707,5,43,820,627,583,166,25,344,348,1619,1118;44;F
5068;340,43,190,245,45,62,344,348,820,106,63,435,627,53,52;70;F
5076;1518,45,245,51,348,627;36;F
5078;1619,627,1430,45,1148,245,1654,190,43,347,919,340,820,1058,345;46;F
5092;245,9,43,347,25,51,44,1226,53,820,1058,106,627,317,1518;49;F
5096;52,1430,1518;43;F
5102;51,627,1657,593,62,5,1148,1658,43,596,52,344,340,1118,1655;31;F
5119;1518;14;F
5124;63,106,435,627,317,1411,5,587,433,1485,1430,43,347,51,919;27;F
5155;433,190,90,51,52,348,1058,106,1657,344,627,347,1654,340,345;33;F
5160;62,1430,6,245,43,166,90,25,919,344,348,1619,1456,1411,1518;45;M
5168;433,1422,347,90,51,348,435,62,6,25,53,106,627,317,707;32;F
5172;5,898,1430,6,90,51,52,1226,53,435,707;41;F
5179;53,1655,820,345,9,190,1422,347,52,344,106,627,317,1518,25;38;M
5196;53,63,106,627,707,1518,5,9,45,1430,6,43,25,820,1456;42;F
5203;106;47;F
5211;166;38;F
5215;25,90,347,1654,245,6,583,1658,1148,45,62,898,1485,5,1518;9;M
5219;106,5,433,898,45,43,919,51,348,707,62,1658,190,342,53;28;M
5220;433,347,52,342,1518,9,43,25,44,627;37;F
5239;5,1430,1148,1653,190,43,344,348;69;M
5242;587,62,1430,6,245,43,166,90,25,919,344,348,1619,1411,1518;10;M
5259;106,1058,820,596,9,5,1485,1430,190,43,6,90,53,51,52;46;M
5265;245,43,25,51,344,1619,1656,106,317,9,347,90,919,820,627;43;F
5270;587,919,1518;47;F
5283;433,45,1430,1518;9;F
5286;6,1653,822,344,433,1430,245,43,347,919,1619,1118,1518;4;M
5290;344,53,820,106,627,317,1518,1485,5,587,9,593,90,25,52;29;F
5303;587,593,1430,245,347,25,51,1226,1456,1058,627,1518;41;F
5308;1430,52,433,5,245,43,166,25,348;39;F
5309;245,6,1619,5,90,166;42;M
5316;1518;34;F
5323;5,62,45,1654,43,347,1518,9,44;43;F
5329;106,627,245,1430,596,52,344,435,317,707;26;M
5333;43,51,1456,106,435,317,627,1148,583,6,245,1653,190,347,348;44;M
5335;51,344,1656,340,820,1653,919,6,1148,90,53,1655,435,345,317;31;F
5336;1411,51,25,596,90,43,245,6,1148,433,898,62,45,347,1518;14;M
5337;5,51,53,435,317,707;27;M
5342;587,62,1430,6,43,166,90,25,919,344,348,1619,1456,1411,1518;13;F
5351;53,820,627,345,587,593,1148,1658,1653,190,43,347,342,1655,1058;45;F
5359;433,51,53,317,1430,62,9,347,25,52,1118,820,587,348,106;47;F
5360;587,583,1653,348,1226,1656,1058;47;F
5387;1518;13;M
5394;1518;13;M
5396;1518;45;F
5398;1518;14;M
5403;596,347,919,51,52,344,1118,1226,53,820,1456,317,106,627,1518;48;M
5407;342,344,822,190,347,348,345;42;F
5419;587,433,820,1456,1058,63,106,435,627,317,345,1411,1518;37;F
5435;190,43,45,63,166,5,9,62,51,53,435,707,25,44,1518;35;F
5437;587,45,1148,245,43,347,90,596,919,1658,190,1118,1656,820,106;48;F
5458;9;48;M
5460;1148,45,1430,43,51,106;45;F
5464;1653,1619,53,347,51,106,627;44;M
5471;340,43,1422,1653,348,1655,1656;35;F
5490;45,347,919,344,53,820,627,5,245,43,1411,1619;36;F
5496;1430,62,898,433,342,1456,627,345,5,593,1657,919,344,348;33;F
5513;106,62,589,347,596,51,344,1118,627,1430,25,348,820,435,43;39;M
5534;435,707;42;F
5540;1518,44,25,9,166;42;M
5542;44,6,52,627,1518,90,62,898,5,587,433,919,820,106,1411;48;F
5548;245,1654,43,347,90,596,25,51,52,344,342,1619,1118,53,1518;42;M
5550;433,245,348,1226,340,1058,1456,627;29;F
5559;245,347,51,53,106,627,317,348,43,344,6,25,44,1518,5;58;M
5577;245,1422,25,820,106,627,317,5,6,90,51,52,53,435,707;36;M
5579;1148,1653,190,347,52;58;M
5580;919,822,43,1148,9,5,820,435,1411;21;M
5587;587,433,898,1430,593,1654,1422,166,596,25,1226,1656,340,1518,1411;17;M
5590;317,1655,53,1656,1118,342,347,43,245,583,62,1485,5,51,1518;32;F
5597;45,1430,1148,1658,245;48;M
5598;433,1148,1658,1422,596,919,1226,1456,63,707,1411;8;F
5599;1653,190,820,1655;40;F
5608;433,342,707,1518,1411;13;M
5609;1148,898,5,1485,62,45,1654,43,166,1226,53,820,1058,9,25;41;F
5613;347,106;19;M
5631;1518,1148,45,62,9,5,25;34;F
5651;344,342,1656,820,106,627,345,5,62,596,53,1518,435,317,707;36;F
5663;51,52,820,106,707,345,587,62,6,347,344,1656,53,627,317;30;F
5690;433,587,9,1658,1619,1518;46;M
5698;1619,43,1411;43;F
5700;317,5,1430,583,6,245,1654,43,347,90,51,1619,820,106,627;10;M
5707;589,245,6,62,583,190,347,596,25,51,344,1118,53,435,317;21;F
5710;1655,1657,45,1485,583,1654,166,63,435,5,9,1148,25,820,1518;41;M
5721;1148,919,344,433,45;34;F
5727;1148,6,1653,190,43,347,51,1118,53,106,627;44;F
5732;45,62,1485,5,587,1148,583,1653,190,43,919,820;48;F
5735;587,6,190,347,52,5,245,90,51,106,345;51;M
5745;51,587,6,245,347,919,44,348,1226,1058,106,435,627,317;15;F
5761;90,347,6,62,898,583,245,1654,1619,1411,51,820,627,1518;45;F
5769;1148;44;M
5770;820,627,1518;30;F
5776;51,1619,63,627,5,245,1422,347,919,820,106,317,898;30;F
5779;9,43,1118,53,820;38;F
5790;587,593,583,245,1654,1226,1656,1058,435;40;F
5830;1518,44,25,707,435,53,51,62,9,5,166,63,45,43,190;35;M
5831;52,51,245,583,1658,5,347,344,1118,820,1456,106,435,317,707;29;F
5840;62,347,51,52,627,317,344,1430,5,433,1518;32;M
5843;53,106,627,317,707,1411,44;51;M
5846;5,9,43,25,919,820,1411;40;F
5851;52,51,707,90,435;37;M
5856;190,43,347,51,342,627,1148,9,1485,5,25,52,820,435,317;63;F
5860;51,820,106,45,1657,1148,1658,583,190,348,342,1656,340,1655,345;38;M
5864;348,53,106,317,5,45,245,1422,43,166,25,51,342,820,1058;35;F
5867;348,627,9,44,1411;46;F
5870;347,51,344,342,1118,45,25,919,44,52,348,53,1456,627,1518;38;F
5881;51,5,1485,25,344,820,106,317,52,435,707;39;F
5917;347,190,245,45,5,433,1485,593,1148,1658,342,53,820,435,707;30;F
5928;433,5,45,1658,190,347,342,1656,340,820,627,345,1657,583,245;44;F
5945;90,435,345,1148,51,348,53,5,1653,190,347,52,344,820,627;38;M
5948;44,45,317,1118,245,1518,43,1411,1430,6,1619,5,90,25,166;45;F
5959;245,190,25,1619,1656,820,707,433,898,347,51,106,435,627,317;35;F
5973;44,43,1619,1411;40;F
5974;5,898,6,90,51,52,53,435,707,820;32;M
5986;820,9,5,90,51,53,317,345,62,1656,1658,347,348,106,627;50;F
6015;25,583;45;M
6016;433,587,45,245,1518;41;F
6027;433,1518;35;F
6054;53,1058,627,345,51,25,1654,245,62,5,433,587,45,1658,583;38;F
6061;433,587,5,822,52,344,707,245,919,1656,820;30;F
6067;583,1658,1148,1657,593,45,62,898,1485,5,587,433,9,1411,1430;15;F
6076;25,919,53,1422,583,62,342,707,245,43,1619,44,45,433;39;F
6088;52,344,348,51,347,43,190,1148,1657,53,820,1654,90,627,106;38;M
6115;52,53,1655,1518,347,43,9,433,1430,1148,51,348,106,627,1485;28;M
6120;5,6,90,340,45,245,347,44,106,317,627,43,1619,1411,1518;45;F
6127;5,9,45,583,1654,347,90,25,348,1118,820,435,1430,1619,1411;45;F
6128;340,919,587,5,1485,62,1430,1148,1658,6,245,1653,1654,190,43;14;F
6130;5,43,317,1518,627,820,53,9,45,166,347,344,25;38;F
6134;1430,1657,1148,1658,583,6,1653,1654,190,43,347,25,51,53,348;39;M
6139;9,43,919,627,1411;40;F
6147;5,898,6,90,51,52,53,435,707;32;M
6162;1518,9,166,25;37;M
6164;1654,6,347,51,44,53,627,1518;27;F
6167;433,593,1658,583,1422,919,1118,1656,1456,63,435,627,317,345;38;F
6169;1430,348,1411;50;M
6175;1430,6,245,43,347,52,1656,820,106,707,627,317,435;36;M
6178;344,1518;33;F
6186;25,1518;43;F
6191;25,1518;44;M
6193;43,1654,245,583,1653,190,919,1226,1655,435,1148,587,593,25,1058;41;F
6201;627,340,820,1656,344,51,25,347,245,5,190,43,90,52,53;36;F
6208;9,245,43,627,1518;13;M
6213;1653,1518,245,347,90,435,345;77;F
6230;1654,820,317;31;M
6235;53,1656,1118,5,1148,62,6,245,347,596,51,52,344,106,627;54;F
6247;342,1619,1656,53,627,707,345,1658,190,51,44,820,1456,435,317;36;F
6256;1148,6,1653,347,90,51,344,1118,53,340,1655,820,106,627,245;33;F
6261;433,5,1430,6,43,25,51,820,106,435,627,317;27;F
6265;5,6,347,51,348,9,25,820,627;51;M
6304;1656,1653,1148,1485,433,190,43,589,347,919,51,344,53,820,106;22;F
6310;1148,1658,1653,822,1518,627,317,1657,1656,53,1655,1118,340,820,106;30;M
6319;433,45,589,44,342,1226,1058,627,1518;37;F
6353;90,342,1118,53,62,1148,6,347,52,344,820,627,51,1653,245;62;F
6362;44,344,348,1118,340,435,317,587,43,25,51,53,820,106,627;36;F
6372;51,347,919,344,1118,1058,106,627,190,245,6,45,587,593,1654;47;F
6385;433,53,106,919,342,25,583,707,627,51,317,435;31;M
6393;5,1654,190,51,344,1656,340,347,583,1658,1148,820,106,627,345;43;M
6410;1518;2;M
6416;433,587,245,345,348,1656,1456;45;F
6447;1518,45,1430,1619;39;F
6458;9,43,25,919,52,53,820,1456,627,707,1518;28;F
6466;5,25,44,1411,1518;32;M
6471;52,344,51,596,347,190,583,45,62,5,820,106,435,627,317;30;M
6472;45,433,583,342,1148,1653,1656;44;M
6486;1518,90,190,6,5,62,45,1148,245,1653,43,347,51,820,627;63;M
6499;52,898,51,344,317,435,707;33;F
6507;51,919,90,43,190,5,587,433,245,1058,63,106,435,707,1518;39;F
6526;45,1658,245,190,822,52,5,1485,9,1148,583,347,820,106,627;14;F
6557;43,1422,433,62,1658,583,1653,45,587,1654,245,190,340,1655,1058;39;F
6558;1411,1619,43,9,1456,52,820,627,5,45,245,342,25,44,1518;42;F
6571;435,1411,1518,5,1485,45,190,51,44,820,106,627,707,583,245;33;F
6577;1654,1658,62,898,45,1657,583,190,347,25,51,1656,53,340,1655;35;M
6584;166,1653,820,1655,1656,348,51,90,347,45,5,1148,583,1654,190;43;M
6621;45,593,1430,1657,1148,348,1422,190,245,583,1654,25,340,820,1411;38;M
6623;1657,347,820,345,627,1058,1655,1656,51,1148,1653,190;46;F
6626;627,1411,433,5,898,245,43,589,106,317,345,1518,1226,1430,25;30;F
6636;1422,1654,593,433,45,1658,583,1653,1518;35;F
6648;166,25;41;F
6652;627,317,707;27;F
6657;43,822,9,25,44,1518;41;M
6666;820,340,1656,1118,342,348,344,596,190,1654,1148,1657,45,5,1655;39;F
6763;433,347,822,53,820,106,51;27;F
6769;1058,63,106,435,627,317,433,587,1430,1422,53,707,25,51,348;44;F
6786;433,593,627,5,1518;36;F
6797;596,898,5,62,6,347,348,820,627,1518;48;F
6811;583,1148,9,5,433,596,51,52,1619,342,1118,53,63;17;M
6822;1653,1654,347,1656,340,1655,345,1485,5,1148,190,43,919,51,820;50;F
6824;583,43,596,51,344,1118,53,820,317,5,1148,435;29;F
6841;344,51,596,43,1654,583,45,9,5,245,1430,433,1456,25,53;49;F
6913;820,344,51,90,43,593,433,587,5,245,190,52,348,1058,627;60;F
6927;348,1619,587,593,347,919,51,1226,53,1058,106,627,317,62,1118;48;F
6931;5,1654,345,51,45,1148,1658,245,596,919,344,340,1655,820,190;48;M
6934;347,52,1226,1656,1456,435,317,1148,245,190,344,340,820,1058,106;59;F
6937;820,340,25,190,62,1148,347,51,52,344,53,106,435,1518,707;27;F
6938;587,190,90,583,347,51,52,344,348,1226,340,1058,106,627,345;45;F
6940;627,435,106,820,25,90,347,190,5,9,51;60;F
6947;45,1148,1657,1658,583,1654,190,1656,340,1655,345;35;F
6951;1653,1654,433,45,1430,245,190,43,90,25,51,348,1118,53,820;16;F
6966;190,347,52,340,106,435,627,5,9,6,43,25,51,820,317;27;M
6974;1658,106,435,627,317,345,1411,53,44,51,90,347,62,707,342;33;F
6978;583,1658,1148,9,433,5,1430,43,348,342,820,627,707,1411;29;F
6980;166,43,1658,1430,1485,5,1148,1653,190,25,51,348,1656,820,435;51;F
7007;898,51,52,344,348,1118,340,1485,5,583,1654,190,342,820,707;33;M
7011;51,583,433,45,593,1658,245,190,43,344,342,820,1058,627,345;36;F
7021;62,63;34;M
7030;627,317,1485,45,820,5,898,6,90,51,52,53,106,435,707;32;F
7048;583,1430,62,6,1422,25,51,52,344,348,340,106,627,317,1411;41;M
7051;1430,62,9,5,245,43,347,919,51,344,53,106,627,317,707;27;F
7053;1656,342,51,347,1655,1456,627,587,433,1658,45,583,1653,919;38;F
7059;45,245;45;F
7075;1456,1058,1619,342,344,51,52,347,348,627,433,587,593,245,190;67;M
7088;1518;44;M
7099;9,43,347,25,820;39;M
7129;347,596,51,52,53,340,1655,820,627,345,587,1148,1658,583,1654;44;F
7144;44;37;F
7148;1619,52,5,583,43,347,90,596,25,344,1118,820,627,6;48;F
7155;1658,342,245;33;M
7157;348,342,1619,106,435,627,317,707,433,898,1148,190,90,340,1655;37;F
7159;5,166,25;11;M
7168;919,435,1411,1456,820,347,166,245,1148,1430,1485,43,25,1619,1518;40;F
7177;1619,340,106,345,45,1657,583,245,1653,190,347,51,52,342,1656;69;F
7184;90,596,25,919,51,52,344,342,340,1655,435,1657,583,190,1226;39;F
7196;9,45,6,43,347,51,52,348,342,820,106,435,627;32;F
7231;90,51,53,1456,317,433,45,245,166,25,6,435,820,5,43;15;M
7237;5,1485,1148,43,90,51,52,820,106,317,707;34;F
7249;5,1118,9,43,25,344,820,627,317,1518;35;M
7259;317,5,898,6,90,51,52,53,435,707,106,627;30;F
7263;43,25,166;51;F
7303;1655,433,245,1653,347,90,344,1656,53,340,820,106,627,345;42;F
7306;166;37;F
7313;340,1655,317,627,707,5,45,1654,190,589,52,106,348,1656,820;45;F
7326;51,707;36;M
7336;44;61;F
7352;317,435,344,25,583,6,1653,1422,347,820,51,190,106,627;31;M
7380;6,245,43,344,1619,1118,820,1456,627,1518;44;F
7387;166;25;F
7433;820,898,344,106,435,627,245,583,5,51,348,53,6,52,317;42;M
7436;820,1058,9,5,587,433,44;64;F
7448;347,435,317,1518,9,1148,43,822,25,51,344,53,820,627,707;29;F
7461;43,166,25;10;M
7479;245,340,707,433,190,25,820,106,627,317;17;F
7481;166;25;M
7510;43,166,25;8;M
7516;44;61;M
7531;245,43,347,348,342,1619,106,317,707;32;F
7552;1485,596,52,1118,317,707,435;31;M
7562;44;47;F
7574;45,5,245,347,90,25,919,51,52,344,1619,1118,820,1456,627;39;F
7586;62,587,627,433,245,1422,43,52,348,1456,106,435,707,1518,1411;27;F
7587;1619,583,1657,898;35;M
7589;1518;34;M
7639;190,90,348,1656,245,52,1226;47;F
7646;1658,90,51,344,820,627,345;42;F
7669;820,1518;40;F
7678;348,820,435,345,1653,190,25,340,1655,106;32;M
7680;348,106,25,1485,51,435,317,627,5,898,52,1422,90,6,53;31;M
7683;190,106;61;F
7706;433,90,51,5,1656,190,25,348,596,1619,1485,1148,106,1422,245;40;F
7727;1422,587,106,1456,1118,348,25,245,433,1430,51,53,435,898,707;36;F
7747;45,6,347,90,51,344,342,53,1058,106,435,627,317,1518,707;36;F
7754;583,627,317,1411,596,348,1118,435;33;M
7769;1658,1148,62,898,9,5,587,45,1430,583,1411,51;14;F
7777;245,919,106,190,627,345,583;28;F
7781;433,593,587;53;F
7793;1430,5,587,627,1058,53,1619,348,344,51,43,245,433,45,340;46;F
7795;596,25,919,51,52,344,348,342,1118,53,820,106,435,317,707;35;F
7812;1658,1654,1422,347,342,53,340,1456,627,45,583,245,1653,190,348;43;F
7814;9,45,166,25,44;40;F
7825;347,345,1226,596,90,1654,1148,1657,45,1658,190,1422,344,342,340;39;M
7827;190,589,51,344,342,820,627,707,1411,340,45,1148,1658,583,245;38;F
7834;5,106,435,345,587,62,52,1655,627,1653,347,342,53,317,707;40;F
7841;348,340,707,435;32;F
7864;9,1430,25,1518;36;F
7867;51,348,1619,820,1456,627,1118,53,1058,919,596,583,62,1430,1411;30;F
7888;433,1148,1653,340,820,345,707,1518;42;F
7889;587,45,822,919,348,820,627,1518;40;F
7902;433,5,45,245,596,25,344,342,1118,820,627,9,583,44,1518;36;F
7924;43,919,627,340,5,25,820;51;F
7931;347,6,9,5,245,1658,593,1485,587,433,43,25,44,342,1518;32;F
7940;898,25;42;F
7941;342,340,820,1058,587,45,583,1653,190,919,51,52,1656,1655,1456;44;F
7942;435;33;M
7982;106,345,5,90,347,51,52,1430,583,6,435,317,627,707,53;33;M
7984;1430,1518,627,1058,820,53,1619,44,245,433,45,593,583,1226,1456;36;F
7990;5,62,45,583,6,245,43,25,1411,9,44;31;F
8011;435,317,707;46;M
8016;1148,435,1654,1422,106,707,345;32;M
8021;166;41;F
8032;43,919,596,1658,593,5,1118,53,1058,106,627,707,345,1518,245;29;F
8043;898,9,587,45,593,245,43,919,342,1619,53,1058,627,1411,1518;41;F
8054;51,348,627,1518,44,190,6,53,820,106,435,317,25,5,9;31;M
8081;1655,1656,1118,342,348,596,347,589,190,1653,245,583,433,1148,53;32;F
8086;166;72;F
8093;1058,435,51,43,245,593,9,1485,5,587,1148,6,190,25,820;42;F
8098;166;44;M
8124;53,348,344,90,43,1654,6,1430,45,245,347,51,820,627,1518;12;M
8125;5,1518,435,820,53,344,9,51,44,52,106,627,317;36;F
8133;707,53,583,596,44;42;F
8140;1485,1148,1658,919,1118,340,627,898,583,596;44;F
8145;5,898,6,90,51,52,53,435,317,707;33;M
8148;342,1422,583,347,345,433,898,1148,1653,190,919,51,340,1655,627;34;F
8152;166;49;F
8168;1619,25,5,90,9,1430,6,245,1422,1518;34;M
8199;245,1518,6,25,106,627,51,435,317,43,1619,5,44;27;F
8224;317,52;33;M
8235;52,342,820,340,317,245,190,1422,43,347,25,51,53,106,627;21;M
8244;5,1654,1619,53,1456,433,587,45,1148,245,190,348,342,1656,340;41;F
8251;317,627,106,820,25,90,347,190,245,1148,1485,5;28;M
8254;43;51;M
8266;25,43,587,5,593,919,51,820;43;F
8272;1619,6;25;M
8282;1654,90,342,1619,820,1456,707,1430,583,43,25,919,44,1518,1411;44;F
8293;317,106,1656,90,190,5,62,1148,1653,43,347,51,627;40;M
8296;1518,5,433,1118,1619,6,44;26;M
8329;820,106,1148,25,51;52;M
8336;627,435,106,53,52,90,347,43,5,1148,190,820,1518;48;F
8341;5,1430,583,25,919,44,348,1656,1411,1518;44;F
8345;898;45;F
8357;587,1485,62,593,583,245,1422,90,1058,53,1656,1118,51,52,1518;58;F
8359;1485,5,1456,106,627,317,1518,9,347,25,51,44,1619,53,820;27;F
8392;433,1148,1658,1653,1654,190,43,820,345,1656,53,45,5;32;F
8414;433,9,45,583,245,822,44,348,820,1456,106,627,317,25,166;49;F
8416;1518,9,1430,1148,190,347,90,51,44,52,53,106,435,627,317;35;M
8417;6,627,707,5,245,190,51,348,106,1485,43,25,820,435,317;35;F
8422;62,5,245,43,51,344,820,63,106;38;M
8427;1148,1430,593,433,587,6,245,43,347,919,51,348,1058,106,627;48;F
8450;166;18;F
8455;1118,348,106,435,25,9,1485,5,1148,6,43,51,820;57;F
8465;435,106,1655,53,51,190,1148,898,5,583,6,1653,344,1656,820;39;F
8467;25,820,1518;38;M
8479;5,1485,898,583,51,63,317,345;30;F
8542;245,347,898,5,190,1422,43,51,348,342,340,820,627,707,345;20;M
8556;245,106,627,317;53;F
8588;6,347,51,820,435,627,317,44;49;F
8590;1148,43,1653,347,51,627;55;F
8611;1118,348,596,1148,1656,627;47;F
8617;898;50;M
8628;433,1430,190,344,348,1118;39;M
8632;317,245,1118,627,53,90,347,596,51,348,106,1518;39;F
8643;919,52,344,1619,1456,435,317,25,44;36;M
8665;348,344,52,51,25,822,583,1148,1430,587,5,1658,1422,90,919;17;M
8671;433,1658,90,62,1653,596,25,435,627,317,707,190,1118,1656,1518;31;M
8675;45,44;40;F
8683;587,593,596,1058,919,589,90,51,106,43,820,435,433,245,1118;27;F
8707;1518,317,435,347,43,25;39;M
8712;1653,1654,919,348,340,1058,63,1148,106,5,45,190,43,1656,820;39;F
8719;1148,1658,245,1653,190,347,919,342,340,1655,820,627,345;46;F
8732;5,707,1658,583,345,342;46;F
8750;90,596,919,53,1456,106,627,345,1148,1658,43,190,344,1118;48;F
8795;166;37;F
8803;1430,245,90,344,348,53,25,820,627;33;M
8813;9,593,43,51,344,53,1456,44;37;F
8854;190,45,62,1148,6,1657,1658,245,347,90,344,342,1226,106,627;40;F
8870;90,347,45,1430,9,245,166,51,342,587,820,1456,1058,627,1518;34;F
8904;44;65;M
8917;45,1657,1658,583,6,1654,190,1422,347,51,52,348,1619,106,627;42;M
8936;106,1656,51,589,43,1148,5,25,919,52,348,820,435,317,707;33;F
8966;245,25,1518;38;M
8969;43,51,344,820,1118,1655;39;F
8987;166,25;47;F
8996;348,435;37;M
9009;166;39;F
9010;51,1619,1518,345,1456,1655,245,1430,433,45,593,344,348,342,53;35;F
9015;433,5,9,898,45,583,1654,43,166,25,344,1619,820,1411,1518;42;M
9025;5,6,43,25,44,1619;30;M
9052;348,43,1653,583,1657,898,433,45,1658,245,596,1619,1456,340,1655;39;F
9074;344,52,51,6,1658,593,45,62,5,245,1653,1422,919,820,1058;40;F
9076;6,1619,9,898,45,90,25,166;45;M
9091;1148,6,90,1226,820,1058,317,433,587,245,347,51,344,627,106;39;F
9098;596,44,1518;45;F
9113;190,347,822,344,348,342,340,820,345;66;M
9115;52,822,90,62,583,53,707;38;F
9119;53,707,317,627,51,347,62,45,593,1657,1658,245,1655,106,345;32;F
9135;340,106,627,596,43,1422,190,593,5,1148,1653,1518;46;F
9139;53,342,1148,5,583,6,347,51,52,344,820,627,1518,245,707;33;F
9154;43,1619,1411;43;F
9155;1430,245,25,5,1518;42;F
9157;596,348,106;43;M
9168;340,820,317,707,1411,1518,1485,62,347,51,1619,53,106,627,345;33;F
9171;587,43,347,106,627,317,9,45,245,919;38;F
9176;62,1430,6,345,317,53,587,190,348,1058,106,627,1226,25,245;39;F
9180;190,1658;52;M
9186;5,1148,1653,190,43,344,1118,51,820,345;48;M
9193;190,43,589,347,90,51,344,820,1456,1058,106,627,6,348,1118;50;F
9195;51,245,25;42;M
9202;190,43,51,52,347,344,820,106,627,317;45;M
9223;1411,820,348,43,593,433,587,1430,245,166,90,25,919;46;F
9251;345,1411,340,919,90,1657,593,627,1226,587,433,1658,583,245,342;34;F
9261;435,51;30;M
9266;90,707,51,435;33;M
9294;6,25,43,5,9;45;M
9317;5,1148,1653,1422;45;M
9331;1148,6,245,52,106,627,345;32;M
9335;820,348,43,245,45,433,5,898,6,90,51,52,53,435,707;31;F
9339;435,317,51,707,90,52;26;M
9341;820,1058,106,317,707,433,587,1657,1658,344,53,1655,1456,627,345;31;F
9405;433,1657,1658,1058,345;31;F
9409;5,9,45,43,822,25,919,51,44,1656,820,1456,1148,627,1518;50;M
9415;190,347,822,344,348,342,340,820,345;65;F
9416;25,166;39;F
9436;190,820,627,25,340;37;M
9452;593,43,25,51,52,1226,53,820,1456,1058,106,435,627,317,1518;34;M
9457;1148,347,348,1657,6,190,43,344,53,627,345;70;F
9472;347,90,51,52,348,5,1148,190,43,627,106,820,344,45,433;44;M
9497;1411,53,5,62,6,25,51,435,106,627,317,1518,347,9,44;20;M
9502;43,1430,6,1118,1411,1518;34;F
9508;43,53,919,51,44;30;F
9510;51,190,1148,6,1656,45,344,919,90,433,62,245,347,52,627;66;F
9516;822,166,583,62,1485,5,9,43,347,51,44,344,348,820,627;36;F
9518;90,919,344,348,342,1118,1656,53,820,1456,106,627,340,1655,1657;39;F
9530;245,1654,347,1226,820,587,9,45,43,919,25,1058,106,627,317;41;M
9531;707,435,1655,340,53,348,44,51,347,190,6,62,9,820,106;32;M
9539;43,627,587,1657,1148,1658,1653,347,90,919,1226,340,1655,820,345;40;F
9572;245,190,90,25,919,51,52,342,106,435,627,317,707;32;F
9586;587,593,1148,1658,340,345;33;F
9594;245,1485,587,5,1148,6,43,347,344,1656,820,106,627,317,345;25;F
9597;6,43,51;36;M
9603;44,25;35;M
9615;62,583,90,822,52,53,707;40;M
9618;1226,1656,53,1655,820,1058,587,9,6,166,344,1619,340,627,1518;43;F
9619;587,5,593,43,919,433,1430,245,1422,166,90,25,348,820,1411;10;M
9624;6,5,898,1422,53;42;F
9629;317,627,435,106,53,342,51,347,43,190,1148,45,62,5,9;32;F
9633;6,43,347,53,340,820,435,627,317,345,1518,1485,190,51,106;31;F
9637;433,587,5,1430,593,347,344,348,53,1655,820,1058;43;F
9650;1518,5,45,583,43,347,51,52,344,342,53,820,627;8;M
9653;45,583,1656,1655,820,63;35;M
9657;1148;47;M
9666;342,344,52,51,25,596,45,62,1485,5,245,106,435,317,707;31;F
9669;1430,43,25,1411;39;M
9674;62,90,1118,53,1456,347,51,106,627,317;35;M
9681;51,435,707;30;F
9689;166,25;45;F
9700;45,1657,53,106,1658,342,820,345,340,190,1653,1655;32;M
9708;1411,1422,317,53,43,1456,1619,52,51,344,627,5,90,106,63;71;M
9718;245,317,5,898,6,90,51,52,53,435,707;75;F
9731;1430,245,820,1518;37;F
9732;190,344,820,1653,1148;44;M
9737;245,1654,589,347,340,820,106,1653,43,342,1655,627,345,1422,45;47;F
9738;51,433,627,919,820,166,5,587,43,53;41;F
9741;919,45,190,347,90,51,52,344,5,9,1148,6,43,25,820;24;M
9743;245;40;F
9749;820,707;18;F
9768;1430,348,53,1411,1518;39;F
9769;1657,583,43,342,340,345,707,433,62,1658,245;42;F
9792;53,25,43,51,1653,347,190,6,1148,106,348,627,820;30;M
9810;90,587,1058,245;31;M
9846;433,9,1430,245,820,627,1518;41;M
9852;433,5,9,25,919,44,820;42;F
9857;583,190,1456,106,433,1657,1658,347,90,51,52,627,348,340,345;34;M
9867;51,587,433,5,45;56;F
9874;25,344,1148,245,6,1619,345,1657,1653,347,106,317,190,627,820;27;F
9881;5,43,348,435;32;M
9903;106,1118,348,25,596,347,166,43,190,5,9,1148,6,1653,820;48;M
9911;433,245,1518;9;M
9915;1518,1411,1655,1226,1422,1485,1657,1148,1658,1653,1654,190,1656,340,345;39;F
9928;5,1148,6,190,43,347,25,52,344,348,1118,820,106,627;58;M
9932;1456,1656,1226,1619,919,1422,1653,1148,1657,593,1658,583,1654,1118,63;41;F
9943;433,52,1619,627,106,1456,51,1430,62,347,90,822,348;46;F
9955;433,1485,583,52,106,317,435,707;38;F
9956;1148,190,43,919,347,627,1058,820,1656,51;30;F
9967;45,190,1422,43,347,342,1619,53,1655,820,1456,1058,627,345,1657;34;F
9985;433,245,627,1518;6;F
9989;62,347,90,51,52,344,348,342,1619,1118,53,63,106,627,317;43;F
9994;433,1148,190;39;M
9996;44,342,1656,63,1058,1411,1653,1658,1657,62,317,106,627,345,1518;34;F
10037;707,317,435,1058,1456,1226,1518;34;F
10044;593,1653,347,919,51,344,342,1226,1656,820,1456,106,435;37;F
10046;344,433,1657,1658,583,1654,190,347,51,348,340,1456,106,627,345;1;F
10072;5,587,593,43,822,1655,433,9,1118,1226,53,44,1456,435,345;35;F
10081;52,344,820,106,435,627,317,1411,1430,245,43,596,25,348,1118;35;M
10090;45,1456,1422,166;37;M
10091;587,5,822,51,344,820,1518,9,43,25,44,1619,1118,1655,627;39;F
10099;583,245,43,596,1619,1118,1456,1518;13;F
10112;45,1654,190,43,51,52,344,340,820,1148;32;M
10132;1148,583,1654,340;39;F
10133;898,62,6,245,1422,43,589,919,51,53,106,435,627,317,707;34;F
10146;1619,317,90,340,1655,820,106,627,345;37;F
10154;1653,43,90,344,53,190,589,347,25,51,52,106,435,627,317;43;F
10158;898,919,433,5,1148,6,245,1422,51,52,1619,53,435,317,707;36;M
10161;1518;47;F
10184;919,51,6,43,90,53,435,707,106,627,317,348,1058,433,5;35;F
10193;347,43,245,6,9,5,593,1657,25,51,44,53,820,627,1518;53;F
10202;433,1430,707;36;F
10210;1657,1654,1226,348,52,51,347,1422,190,245,583,1430,898,1058,345;37;F
10219;51,25,5,9,43,348,1118,435;34;M
10233;433,43,589,919,348,1656,53,1058,627,317;28;F
10242;1619;37;F
10247;62,1422,347,90,1619,1118,53,106,317,627,1411,9,6,25,1518;33;M
10260;1518,707,317,627,106,820,340,53,1619,51,347,43,62,898,5;48;M
10262;822,25,51,344,53,1655,106,627,317,707;35;F
10264;707;39;M
10277;43,919,52,344,820,1058,627,5,1430,1411,1518;43;F
10287;44,9,166,25,1518;38;M
10300;435,317,707,6,90,52;46;F
10303;1619,53,898,90,1422;39;M
10306;245,435,589,190,52,6,106,627,90,5,1619;38;M
10314;317,1518,1655,5,9,1148,190,43,822,25,51,52,1619,342,820;29;F
10343;9,25,1518;43;M
10352;1226,245,627,317,707,9,25,52,344,348,820,1518,44,5,6;36;F
10358;583,627,587,433,593,190,347,25,919,52,348,1118,1058,63,106;39;F
10364;433,106,1411,1456,317,25,6,5,53,627,1518;36;F
10369;348,820,1656,1456,435,627,317,90,53,245,5,1619,6,52,707;35;F
10381;9,583,245,347,52,1619,1226,53,106,435,627,317,345,1518;14;F
10391;627,51,707,317,435,62,90;28;M
10403;707,342,1657,345,1518;31;F
10414;627;34;M
10440;1655,435,51,347,1422,6,1148,583,1654,348,340,820,627,345,106;43;M
10449;1658,245,342,340,1655,707,345;35;F
10469;9,344,820,5,43,52,1518;11;F
10493;1518;8;M
10494;52,435;37;M
10495;62,245,822,583;40;F
10508;9,45,1657,1658,245,596,25,51,44;24;M
10514;51,245,583,5,627,1485,593,1430,1148,43,347,52,344,820,106;22;M
10521;347,1654,45,1148,583,1653,190,51,1656,53,340,1655,106,627,345;39;F
10543;1655,340,106,627,345,587,433,344,51,43,245;42;F
10555;347,51,53,106,627,317,9,25,52,344,435;41;M
10598;53,1058,627,1411,1430,433;48;F
10609;245,190,1654,1148,1485,433,45,1430,347,52,344,627;40;M
10632;317,820,43,245,433,5,1485,898,6,90,51,52,707,53,435;32;M
10637;589,348,435,1118,51,25,347,190,6,1485,5,317,627,106,820;51;M
10646;317,820,1619,344,919,90,190,6,62,245,347,51,52,106,627;21;F
10651;51,52,344,1118,53,820,627,1518,587,348,1619,106,435,317,707;47;F
10652;1430,62,1485,5,433,627,106,820,348,344,52,51,90,435,707;32;M
10676;433,62,1658,51,53,1456,106,707,627,317;31;F
10678;348,433,5,898,6,51,52,53,707,90,43,1485,435,317,627;35;F
10689;45,593,583,6,1654,347,25,44,344,1118,53,63,435,627,1518;36;F
10693;25,348,342,1619,1655,1456,627,345,1411,919,51,1656,53,820,1518;34;F
10707;583,51,347,1148,820,342,1656,106,627,345;36;F
10709;90,106,627,317;57;M
10715;435,1518,627,1456,820,348,51,919,25,347,245,593,9,5,587;38;F
10727;45,1658,245,822,342,53,340,1655,106,345,5,1148,820,317,707;36;F
10780;344,589,5,1148,6,190,43,347,51,348,820,106,435,317,627;20;F
10783;245,62,9,433,587,593,1430,25,44,348,820,1058,317,1518;33;F
10801;106,344,190,6,9,5,347,52,348,1118,820,1148,245,43,596;37;M
10809;9,1148,6,43,589,53,820,707,1518,190,347,51,106,627,317;43;F
10813;6,43,25,348,1456,627;44;M
10816;1619,340,317,345,347,51,53,106,627,348,589,43,1422,1654,245;57;M
10818;820,1118,9,5,62,6,347,25,51,44,1619,1656,53,627;32;M
10828;166,919,344,1118,820,627,1485,25,9,1518;34;M
10833;587,583,348,317,707,1518;35;F
10834;1485,433,5,9,6,245,43,90,25,344,1619,1118,820,1411,1518;47;M
10867;898,5,433,587,593,1658,25,44,342,1226,1656,53,1058,435,1411;32;F
10889;5,6,90,317,627,1654;19;F
10919;433,587,5,62,6,90,25,919,52,348,344,820,435,317;28;F
10926;707;33;F
10962;1148,583,347,51,342,1656,820,106,627;37;M
10963;820,1518,317,627,435,106,348,51,25,90,347,43,1422,1430,9;50;F
10974;5,9,62,583,6,245,919,52,820,627,1411;32;F
10980;345,1619,1456,707,1518,1485,587,1422,589,583,245,1656,820,106;14;M
10994;53,5,1485,45,43,25,51,1118,820,627,707,348,106,435,317;47;M
10996;52,344,707,317,627,1656,347,5,1148,245,190,43,1226,820,106;31;M
11009;347,51,1148,43,596,820,627;22;M
11016;583,9,347,596,6,43,25,51,820,106,627,1518,45,1118,166;45;F
11017;1456,919,589,6,1430,433,587,5,593,245,190,344,1226,820,1058;31;F
11024;1148,583,347,51,342,1656,820,106,627;5;M
11036;1148,583,347,51,342,1656,820,106,627;3;F
11055;45,1148,583,347,51,342,1656,820,106,627;;M
11078;53,43,347,90,25,51,52,348,820,106,707,898,6,627,317;38;F
11091;5,347,344,53,820,106,1411,435,627,317,707,90,51,245,52;31;M
11093;5,9,1148,6,347,25,919,51,1619,53,820,106,435,627,317;27;F
11104;342,90,822,1518,5,1430,62,9,245,43,25,44,52,1619,1456;29;F
11105;43,347,596,52,348,1656,53,1456,1058,435,627,317,1148,51,1619;25;F
11127;44;40;F
11142;62,347,52,53,627;40;M
11145;9,898,1422,166,25,1226,820;39;F
11146;44,51,347,6,1658,1148,1657,62,5,433,348,627,317,345;23;F
11209;587,62,1422,25,51,106,627,317,433,898,589,919,348,1226,1058;31;F
11229;898,1485,5,1654,25,51,587,433,1148,6,52,344,1656,820,63;55;F
11244;190,43,51,53,1058,63,1655,5,1658,245,342,340,820,106,435;31;F
11249;1653,90,627,347,1148,51,62,1656,820,589,1619,63,43,106,5;31;M
11264;344,51,1654,583,1658,1148,1485,433,1430,1118,348,596,589,43,190;51;F
11288;5,433,62,1148,6,1653,347,596,919,51,1118,53,106,317,345;38;F
11298;1619,342,1226,340,1058,345,1411,1148,45,1485,1658,52,348,1656,1655;36;F
11313;1653,1658,62,9,5,587,1654,43,25,348,1118,53,820,106,1518;47;F
11337;583,166,347,51,344,53,340,106,627,317,1518,245,25,348,820;42;M
11353;1619,317,627,106,53,25,51,820;40;F
11354;62,1148,347,344,342,1655,820,106,435,627,345,1430,348,1656,1456;41;M
11357;63,62;33;M
11377;44,106,627,317,707,1411,53,1619,342,25,245,433,348,1456,1518;32;F
11386;593,433,348,1226,53,106,435,317,345,190,1148,587,1058,707,1518;39;F
11441;5,1653,190,43,347,25,51,820,106,1148;40;M
11470;345,190,820;46;F
11491;1518,25;28;F
11502;1430,1654,43,822,1456,435,707,433,9,25,344,342,1118,820,1518;33;F
11548;25,51,53,344,348,1619,1118,340,435,317,1411,627,5,820,106;48;M
11556;1148,45,245,348,63,106;41;M
11561;9,44;37;M
11564;1148,1653,583;38;F
11567;1654,820,1518,593,43,25,166;44;F
11569;347,317,627,51,583,45,5,43,106,820,25,1654,166;43;M
11575;90,583,1658,1148,1657,45,9,245,348,1456,106,435,627,317,1518;41;F
11587;62,1430,1619,1518;36;F
11600;348,53,340,707,583;34;M
11601;166;47;F
11608;347,51,348,342,1619,53,820,106,627,1518,433,5,52,1411,317;40;M
11625;53,1456,317,345,919,596,433,1422,342,106,435,707;43;F
11627;1226,433,587,593,1430,245,1058,1518;36;F
11629;347,106,627,317;40;M
11630;166,25;35;F
11670;166,25;41;F
11684;435,1118,348;27;F
11701;166;17;F
11755;344,342,1655,435,45,43,1148,245,190,51,340,820,106,1430,1411;43;F
11777;1118,1619,90,1654,245,583,62,433,1430,1518;36;F
11783;5,45,596,51,52,345,583,90,820;36;F
11792;1658,1654,166,919,1226,1058,1518,25,433,1430,593,583,1422,340,1411;29;M
11797;1518;32;F
11838;1658,583,90,596,344,342,53,627,317,1518,5,1485,106,1411,820;16;M
11845;1657,62,587,820,919,190,1148,45,166,1518,583,245,596,435,707;27;F
11857;1148,1653,1654,596,344,190,52,348,1118,340,820;38;M
11878;51,347,190,45,62,5,1148,344,342,1656,53,820,106,627,1518;36;F
11879;340,1658,245,1518;41;M
11894;435,707;31;F
11899;1518;33;F
11928;1518;3;F
11944;587,62,190,43,166,347,25,52,1619,1226,1656,340,1058,106,627;27;F
11955;52,435,707,317,106,51,627,347,45,596,583,898,1422,53,1619;33;M
11965;25,51,1656,317,898,62,1657,6,190,347,342,53,435,707,1422;32;F
11982;51,1619,1656,53,1655,820,190,1653,1148,5,433,62,45,593,245;33;F
11987;345,1411,1058,820,1226,44,43,1430,587,707,919,822,245,593,45;46;M
11995;245,347,90,342,345,53,106,820,348,52,919,43,1653,1658,822;40;F
12017;52,344,1619,820,1148,6,190,1656,583,1653,43,53,106,627,317;33;F
12021;245,190,348;42;F
12047;1658,1653,1654,919,583,348,342,707,627;36;F
12067;1411,1430;44;F
12073;433,1148,344,5,898,6,90,51,52,53,820,1058,435,317,707;31;M
12075;106,53,52,51,347,62,45,1657,6,90,44,348,342,1118,1656;37;F
12084;435,1485,62,593,583,190,25,919,44,52,344,1118,53,707,317;28;F
12147;5,898,6,1422,53;12;M
12158;345,1411,1518,317,627,820,53,6,433,587,9,63,25,51,44;50;M
12161;6,1148,45,433,5,62,43,919,344,1656,53,820,63,106,1518;57;F
12164;45,6,245,43,90,25,51,44,52,1118,53,1655,63,707,1518;40;F
12185;43,347,90,25,51,52,344,348,1118,1656,53,820,1058,106,627;40;F
12187;5,898,6,1422,53;7;M
12188;45,43,44;38;M
12200;25,9,1485;42;F
12206;43,190,1658,9,45,347,51,44,53,106;68;F
12212;1430,1148,347,52,348,1118,1619,1656,53,820,345,1058,433,190,627;30;F
12240;44;38;M
12242;707;31;M
12263;62,1148,1654,190,820;37;M
12270;245,90,51,820,627;50;F
12274;820,707,345,1518,433,62,1657,583,1653,43,589,90,52,344,53;35;M
12293;1148,1653,190,53,340;27;F
12321;587,245,1653,43,347,90,52,344,342,53,820,707,345;32;F
12341;1430,1518;40;F
12349;5,583,190,43,347,51,52,342,1656,340,820,106,435,627,1518;40;F
12378;6,245,52,348,344,1656,106,317,345,587,347,90,1226,53,627;26;F
12397;44,51,589,190,6,5,583,347,106,1518,317,627,435,1148,1619;32;M
12398;347,51,52,106,627,1148,190;31;M
12406;1518;10;F
12412;1518,345,627,1456,53,1656,342,25,347,433,45,1658,245,190,43;35;F
12415;1422,1654,1148,62,9,433,53,820,106,627,5,583,245,347,822;41;F
12417;593,6,1422,51,106,627,433,1653,190,43,25,348,1118,340,345;31;F
12421;5,9,43,90,1118,1411,344,44;39;M
12430;62,25,1656,53,106,317,707,348;34;F
12445;51,348,106,627,317,345,707,1518,53,1619,44,25,347,43,9;36;F
12451;25,44,245,45,822;38;F
12455;344,342,1118,820,106,627,1411,1430,245,1422,348;40;M
12469;820,317,345,5,1148,6,1653,190,25,347,51,348,340,106,627;33;M
12503;1656,820,627,433,45,1657,1148,1658,245,1653,1654,190,340,1655,345;40;F
12518;627,1653,1656;27;M
12530;317,627,435,106,820,25,1657,1148,1653,190;27;F
12536;1456,435,317,707,627,106,344,51,245,9,45,90,25,820,166;39;F
12539;5,62,1148,190,52,53,1518,820,317,345,245,347,51,106,627;34;F
12541;347,596,25,51,52,820,583,245,190,1657,1654,348,1658;44;F
12571;898,53;34;F
12576;348,25,9,5,43,347,245,1148,190,820,435;40;F
12589;589,347,627,317,1411,433,1657,583,190,348,1619,340,1655,820,345;35;F
12590;433,347,51,44,106,627,317;54;F
12619;348,627,9,62,45,593,1430,245,166,25,1518;39;F
12632;1148,6,1653,190,43,347,90,919,51,344,106,627,317;46;F
12641;1653,1658,1657,45,820,5,344;34;F
12654;348,1118,596,90,62,6,347,25,51,1619,53,106,627,317,707;19;F
12674;25,51,340,106,627,345,62,1430,1148,1658,190;46;F
12687;1148,51,344,348,627,317,106;41;M
12700;1148,52,344,53,435,317,1518,5,583,51,347,1656,820,106,627;32;M
12706;627,106,1456,53,1619,344,51,347,190,1653,62,5,596,1118,820;31;F
12713;433,1411,627,43,583,62,6,1654,347,106;29;M
12720;1518;62;M
12722;433,9,589,347,596,25,44,1118,1226,53,1058,106,435,627,317;24;F
12723;1411,435,25,433,587,9,593,245,348,820,627,1518;8;F
12736;317,106,53,347,43,6,5,433,1485,90,51,344,820,627;23;F
12751;919,90,347,1148,62,1485,587,820,340,707,627,345,5,1658,106;33;F
12762;6,190,347,25,51,106;36;F
12773;190,1657,583,51,342,340,820,106,435,627,707,345,1411,1518,53;32;F
12788;45,9,5,1058,25,347,593,245,919,348,106;28;F
12805;820,344,51,596,347,1653,583,1148,1657,345,435,1655,340,348,190;53;F
12822;347,1422,245,593,9,62,25,51,52,348,53,106,435,627,317;36;M
12853;820,1655,51,43,1658,45,245,583,1148,1653,190,340,345;36;F
12866;919,90,347,245,583,1430,9,5,587,593,25,44,344,627,1518;43;F
12869;106,820,344,5,587,593,1148,1653,245,1226,1656,1655,1058,627,345;46;F
12877;166,25,5,9,43;53;M
12885;342,1430,43;49;F
12886;1456,1619,1518,433,5,9,1430,1657,1658,245,43,44,344,820,627;28;M
12911;1655,1518,25,44,53;42;F
12913;433,898,1657,1658,190,344,348,53,820,340;44;M
12960;435;36;M
12962;43,51,344,1656,820,627,587,593,1148,90,919,1226,53,1058,435;42;F
12963;317,627,106,43,190,245,45,5,820,340;45;M
12996;435,90,245,6,45,5,43,347,51,52,344,820,106,627,317;56;F
13011;348,245;67;F
13054;1619,596,43,587,5,25,344,820,317,6,51,52,53,106,627;35;M
13056;707,1619,347,1148,51,1653,627,45,587,433,5,190,344;42;F
13062;106,707,1411,5,1658,43,342,1655,820,45,1148,245,919,1656,1653;68;F
13065;1518;14;M
13069;435,52,90,820,317,707;31;M
13079;1656,53,106,317,435,1058,1226,44,1422,589;26;M
13080;25,43,587,5,62,1148,1653,190,347,51,344,1619,820,627,345;67;F
13088;63,345,1657,45,1658,342,53,820,627,707,1518;45;F
13099;25,190,62,1485,5,51,53,820,1456,106,627,9,317,707,435;36;F
13112;1518,433,593,1658,245,43,589,90,25,51,44,348,1118,435,317;26;F
13122;5,9,43,166,25;50;F
13143;1411;27;M
13150;1411;20;F
13153;5,9,43,166,25;92;F
13160;45,9,62,1657,1658,43,51,342,1655,820,1456,345,707,1518;50;M
13180;62,348,317,627,106,820,52,51,919,347,190,6,1148,5;47;F
13183;5,9,43,166,25;17;M
13205;596,822,25,166,43,45,5,345,1518;10;F
13214;317,627,435,106,1656,1619,25,347,43,6,1148,62,9;27;F
13223;1118,1619,1654,583,433,587,593,43,25,919,1226,53,820,1456,1058;33;F
13248;1656,53,1655,106,627,317,1518,5,9,190,25,344,820,63,345;30;M
13251;348,1148,589,90,340,45,1657,1658,583,1654,347,596,1655,820,345;39;F
13256;5,9,43,166,25;24;F
13262;433,5,45,62,898,9,1422,25,53,820,1058,106,627,1411,1518;32;M
13266;1518,707,53,1656,344,51,190,898,45,1658,583,1653,1422,348,340;25;M
13267;587,583,435,707;38;F
13269;587,1518,25,106,62,45,919,707,348,53,51,820,5,9,43;34;M
13278;433,587,62,348,593,1430,583,347,919,1619,1226,53,1058,627,1411;47;F
13285;5,9,62,6,43,90,25,52,344,820,596,1118,53,627,1518;44;M
13296;43,51,342,340,435,45,347,820,106,627,1148;44;M
13299;51,53,345,245,919,1619,317,9,45,1430,6,25,44,627,1518;47;M
13302;1518;5;M
13358;435,106,348,344,51,347,43,583,5,1657,1148,190,340,1655,820;39;M
13362;1518;13;F
13375;6,43,25,1118;41;M
13384;347,52,820,1456,1411,1485,190,1422,25,51,348,106,435,627,317;39;M
13428;53,340,1655,5,190,820;42;M
13442;51,344,52,1619,707,53,317,1518,62,245,347,25,820,106,627;46;F
13444;1148,1656,433,190,1655,627,340,106,62,1657,345,245,820,348,1658;27;F
13464;707,317,106,1456,820,53,1226,342,348,43,583,1658,1148,5,435;41;F
13465;1654,166,347,596,919,51,52,342,53,820,627,1518;11;F
13467;25,919,344,1456,106,348,43,1118,1430,90,433,1518;43;M
13469;45,1430,583,1422,25,44,342,1226,1456,1058,106,435,1411,1518,317;37;M
13482;51,347,90,6,62,5,433,190,589,25,348,1118,1226,1058,106;22;F
13490;317,1411,1422,190,62,433,593,6,25,51,344,348,53,435,707;40;F
13494;25,1148,1485,5,9,62,43,190,347,51,53,106,627,317,52;36;M
13508;166;41;F
13520;583,6,245,347,596,435,106,820,1619,587,433,593,43,627,1411;37;F
13554;9,166,25;46;M
13556;587,245,190,347,90,919,340,1058,627;18;F
13559;593,6,596,52,1118,51,5,9,245,166,25;57;M
13585;53,51,919,90,347,589,1422,245,6,1657,62,5,344,627,1518;28;F
13600;1422,53,627,5,1485,45,43,90,51,344,106,435,317,707,1411;28;M
13620;1657,583,6,245,190,347,51,52,344,340,820,1058,106,627,345;30;M
13639;1619,90,347,589,1485,433,1430,1148,583,1654,342,317,1518,44,707;27;F
13664;1655,433,1148,1658,347,25,344,53,340,245,190,51,106,317,627;60;M
13671;5,1148,340,1655,820,345;36;F
13693;1657,1148,1653,1654,190,1422,43,342,1656,1655,1411,1658,583,340,345;32;M
13698;433,1658,245,190,1422,347,25,51,342,1619,53,820,1456,627,345;35;M
13737;190,1656,340,820,106,317,62,1653,43,347,90,52,344,53,627;46;F
13795;45,347,348,342,627,345,1658;40;F
13802;1657,45,9,5,62,347,51,53,1655,820,106,627,317,1518,345;38;M
13827;587,245,190,347,919,51,340,1058,627;49;F
13842;166;46;F
13848;627,435,1058,820,53,1226,348,51,347,898;49;F
13872;245,596,43,589,52,344,348,435,627,317,707,433,1118,53,820;32;F
13878;1518;12;F
13906;166;42;F
13916;6,245,898,583,1430,45,433,1148,1422,43,25,1456,1518,348,63;38;M
13929;348,1226,53,340,1456,1058,106,627,345;47;M
13985;90,166,6,1430,62,5,43,347,51,820,1058,106,627,317,707;21;F
13990;1411;54;F
14004;51,25,596,90,190,1654,1658,1657,45,5,43,344,435,627,345;37;F
14035;583,51,52,344,1656,340,627,45,1658,245,1654,90,596,345,1655;35;F
14056;433,5,593,1430,1653,190,43,589,596,919,51,344,348,820,1118;24;F
14106;1148,62,1654,43,25,51,344,340,820,106,435,627,317,433,245;47;M
14107;433,45,1657,1148,1658,6,245,190,347,90,342,1226,106,627,345;4;F
14137;43,190,245,45,820,1518,1148,5;37;F
14172;1148,245,1654,90,344,53,627,317,707,5,6,347,1656,820,106;55;F
14188;166,9,5,90,25;39;F
14211;1411;41;M
14230;1653,6,62,245,190,589,25,919,51,344,52,106,435,627,707;35;F
14234;90,1619,627,106,5,45,6,245,43,347,51,44,820,1411,1518;7;F
14266;45,1148,1655,245,1653,190,347,1656,820,627;42;M
14292;583,1654,596,822,342,898,45,1422,627,1518,435,820,348,25,9;49;M
14295;1411;35;F
14304;62,342,820,1456,106,707,345,5,9,822,25,1619,53,627,1518;39;F
14373;1411;4;F
14378;5,6,90,919,1656,435,1411,9,43,245,822,25,44,317,1518;38;F
14383;627,106,820,340,53,1619,52,51,347,190,1658;30;M
14396;433,587,62,1430,583,1654,43,347,25,51,52,344,53,1518;37;F
14413;106,627,1653,1656,820,1148,51;33;M
14417;1411;;F
14425;340;42;M
14443;433,898,62,45,1657,1148,1658,583,245,1422,43,53,1456,627,345;38;F
14446;51,707,435;37;M
14451;1518,345,435,52,707,5,342,1658,583,90,1653,245,51,1656,820;34;F
14463;44,51,583,593,45,1430,245,25,919,1619,1058,1411;46;F
14470;53,5,317,51,245,90,52,435;33;M
14473;347,25,317,919,43,5,1430,6,90,51,52,53,435,707;33;M
14491;583,6,820,1518;49;F
14517;51,317,245,44,1619,9,90,25,5,587,433,1118,1430,6,1518;45;M
14524;589,9,5,587,44,348,1118,53,106,1518,627,25,347,43,6;34;F
14539;1411;30;M
14542;1422,589,347,90,25,51,53,106,627,1518,583,44,435,317,707;35;F
14555;5,1485,9,43,51,348,1118,820,106,435;33;M
14578;6,245,347,90,25,51,106,627,317;28;M
14625;25,347,583,1148,45,9,433,6,245,43,90,44,106,317,1518;50;F
14632;342,317,1148,45,5,898,6,51,53,707,245,43,52,106,435;32;F
14653;707,627,51,43,317,52,435,1485,44,1518,1118,433,5,90,6;25;M
14692;6,1654,190,90,25,51,344,348,1118,53,627,345,433,1657;38;F
14712;596,345,1653,1456,348,344,340,1411,190,1148,593,62,583,342,1655;36;F
14742;52,53,435,1518,5,9,347,25,51,44,344,348,820,627,317;23;M
14778;245,1656;41;F
14786;707,627,106,51,347,62,1653,43,589,348;49;M
14802;1148,1658,43,589,596,348,345,435,1456,820,52,344,245,583,1118;50;M
14811;587,5,344,435,1411,9,1430,583,25,44,52,53,820,627,317;26;M
14827;5,898,6,90,52,53,435,707,587,51;28;F
14834;9,5,433,1518,6,190,43,347,44,344,820,1411,317,627,106;30;M
14844;62,51,44,52,344,342,1656,53,1655,63,106,627,317,345,1518;41;M
14884;1518;42;F
14893;347,190,587,1653,43,1058;48;F
14896;593,62,707,5,347,25,344,1226,820,1456,1058,627,1118,433,919;25;F
14897;1411,106,340,1655,51,43,1148,583,245,1654,919,348,345;41;F
14904;245;72;F
14953;5,45,583,1422,820,627,1518;9;M
14969;106,317,627,596,9,5,820,1411,344,90,25,44,245,1430,1518;38;F
14970;63,62;63;M
14979;9,583,6,51,348,1619,1118,44,1518;38;M
15055;62,63;59;F
15072;5,583,6,190,347,25,51,348,106,627,317,1148,344,820,435;33;F
15096;25,166;47;M
15099;593,1430,1422,90,25,348,1226,106,190,435,317;37;F
15141;433,5,6,347,25,820,106,627,1518,344,43,245,1148,190,1655;57;F
15159;1518,45,347,919,51,106,627,317,345,62,1430,44,1118,1656,53;35;F
15171;166;14;M
15183;6,62,1653,190,43,347,51,348,53,340,820,106,627,345,1518;60;M
15185;166;14;M
15193;1485,344,347,6,583,45,43,90,51,52,53,435,106,627,317;36;M
15204;435,43,347,344,53,627,707,9,1148,190,25,51,52;28;M
15219;1655,1456,1058,1422,583,587,593,1658,245,1654,1653,90,820,348,1656;43;F
15242;45,1518;43;F
15246;1655,820,593,1657,1148,583,245,1654,190,919,348,1619,340,627,345;41;F
15249;51,587,1226,25,1058,43,90,52,1619,347,1656,106,627,317;32;F
15261;1518,45,9,245,166,25;37;F
15269;587,245,1456,1058;61;F
15293;245;84;F
15294;45,1654,1422,43,51,344,106,435,627,317,707,1518;36;F
15298;348;47;M
15302;593,25,344,1058,45,43,53,820,627,1518;43;F
15316;317,435,51,6,106;31;M
15319;587,43,52,1226,1656,1058,347,90,25,51,1619,106,627,317;27;M
15343;435,317,707;56;F
15344;587,245,43,90,52,344,348,1118,820,1456,1058,106,1518;64;F
15373;245;50;F
15383;820,1654,90,106,1656,1658,583,627,596,1657,348,345,340,1226,342;37;M
15394;1485,9,45,583,245,347,51,1655,820,1148,1658,190,43,106,627;44;F
15397;62,593,106,627,317,345,433,1148,245,43,25,52,53,820,435;30;F
15423;51,1655,820,1456,433,62,45,342,345;39;F
15427;435,52,51;34;M
15454;1485,596,90,25,1656,106,435,587,43,344,348,1118,707,63,345;68;F
15455;1518;37;F
15457;344,1148,1653,347,51,820,345;47;F
15462;166;37;M
15466;1485,62,190,51,106,627;32;F
15491;9,1430,25,44;47;M
15508;348,52,51,347,43,6,106,627;30;M
15530;1422,1653,1658,1148,62,5,587,433,1657,6,245,348,1456,627,345;65;F
15563;52,1656,6,1653,347,1655,317,345,1148,90,51,340,820,435,627;22;M
15566;433,587,1430,1653,347,25,51,348,1226,1058,1518;28;M
15570;9,51,1619,1456,707,62,45,1430,583,43,347,919,348,627,1518;38;F
15616;25,166;41;M
15642;347,919,1619,587,593,583,1654,43,25,53,820,1456,1058,627,1518;36;F
15675;435;28;F
15691;1656,245,63;41;M
15699;52,344,1456,1058,435,317;37;F
15708;1655,63,106,62,1653,348,820,627,345,1658,583,1654,1422,1656,1518;46;F
15710;53,1485,5,1430,245,90,25,344,52,106,435,317;54;F
15713;898,190,106,627,317,1422,53;38;F
15718;190,1430,593,62,1485,5,433,587,583,245,919,348,342,1619,1518;39;F
15720;1656,1653,1456,106,433,9,45,245,25,919,44,348,342,435,1518;34;F
15734;43,52,344,820;48;M
15740;587,6,347,90,919,44,52,348,1619,1226,1456,1058;57;F
15742;62,433,587,43,919,1226,53,1058,106,435,707,345;50;F
15746;106,190;27;M
15767;190,43,589,596,344,348,1118,53,820,1411,435,583,63,106,707;41;F
15796;348,1118,820,435,1148;55;F
15811;44,435,707;34;M
15812;44;34;F
15815;190;25;M
15839;90,190,6,51,5,62,1148,1658,347,52,344,348,340,820,627;47;F
15843;5,587,45,1657,1658,245,1654,190,347,90,596,52,344,1118,820;40;F
15846;1430,587,433,1658,1148,347,1411,919,820,1058,627,593,245,1518,190;37;F
15855;1485,342,53,435,707,51,25,62,317,433;28;M
15868;583,45,9,6,245,43,90,25,44,52,53,63,707,627,1518;45;M
15869;583,1653,919,348,433,1148;27;F
15874;53,1226,51,347,62,433,1653,1422,1058,317,1411,1518,627;45;F
15891;106,435,627,707,245,583,1430,1653,1657,1654,433,1619,45,53,317;37;F
15936;25,52,344,435;34;M
15942;62,1619,44,51,90,1148,1658,6,1654,340,1655,347,25,190,627;35;M
15948;52,5,1658,1148,190,43,347,90,1118,340,820,106,435,627,345;42;M
15954;6,347,90,25,51,52,1619,820,106,317,1430,348,1655,627,345;50;F
15973;317,5,1485,587,433,45,593,245,43,589,1226,1058,106,627,707;25;F
15985;53,90,51,52,435,707;37;F
15986;820,1058,106;28;F
15990;593,1657,1658,190,90,596,52,344,342,1118,1226,340,1655,1058,345;37;F
16014;52,106,627,1148,1658,190,43,347,90,344,348,1118,340,820,345;13;F
16022;433,435,820,342,344,51,1485,340,348,596,347,589,1654,583,245;37;F
16031;90,190,583,5,62,347,342,1655,345,45,1657,1658,245,1619,1656;37;F
16065;347,51,52,344,348,1226,53,820,1058,106,435,627,317,707,1518;32;F
16075;5,43,51,344,1118,106,820,90;43;F
16094;44;3;F
16103;25,1518;41;M
16108;44;1;F
16117;433,1657,1658,1654,190,340,345,51;38;F
16131;1653,347,596,52,1656;48;F
16132;707,190,1456,1058,587,1658,347,51,344,627,433,245;47;F
16171;90,25,166;46;F
16182;245,1518,1118,433,707,63,45,593,583,919,1656,587,820,1456,1058;28;F
16188;1430,583,166;19;M
16197;25,342,106,707,317,348,190,43,44,1148,45,51,898,5,53;37;M
16205;587,593,583,1653,919,348,245,1518;48;F
16207;627,345,344,348,1118,340,820,583,1430,5,587,433,45,1148,190;40;M
16249;190,25,45,593,1430,245,1654,596,919,348,1118,1226,340,820,1058;48;F
16253;106,820,1656,52,90,1430,5,587,433,45,6,1422,919,245,707;33;F
16325;433,9,62,1118,1656,1655,1456,435,627,1518,348,344,190,1658,1657;33;M
16326;51,44,52,344,1619,1456,106,707,9,1430,90,25,348,1118,340;47;F
16336;9,62,5,347,51,627,1518;39;F
16349;90,25,317,1148,6,245,347,596,919,51,1118,435,106,627,707;27;F
16356;1657,1148,347,51,348,190;37;F
16358;25,45,433;39;F
16359;433,45;40;F
16378;1148,1653,190,43,347,51,348,1118,1655,820,435,317,345;49;M
16390;1148,45,898,9,1485,5,583,1658,43,820;38;M
16407;9,1430,245,43,25,340,1518;38;F
16408;433,1518,1456,340,348,596,589,1658;39;M
16411;51,1118,433,5,190,347,348,820,627,344,53;47;F
16431;6,1653,43,589,347,51,52,342,820,106,627,190,25,344,53;21;F
16438;1430,593,1485,1656,1655,106,435,345,898,45,583,25,919,348,340;39;M
16456;1148,5,1653,190,43,596,51,344,348,1118,820,435,627,317,1518;37;M
16467;90,6,62,898,5,53,106,435,345,51;27;F
16515;344,1655,53,1456,627,317,345,1518,587,5,245,1654,190,25,51;49;M
16523;5,347,90,25,52,348,1619,53,1148,190,51,820,106,435,627;29;M
16537;1654,589,596,344,348,820,106,627,345,593,1658,583,919,1226,1058;30;F
16611;51,52,344,348,342,1619,435,627,106,345,340,1658,1118,596,90;16;M
16632;1430,245,190,347,90,52,53,627,51;27;M
16650;1619,52,344,348,435,317,627,245;56;F
16670;1653,1422,347,1656,627,1148,190,43,51,344,53,1655,820,106,345;50;M
16717;43,347,106,627,317;40;F
16746;52,51;30;F
16765;317,435,627,344,51,589,190,433,43,25,919,348,1656,820,106;37;F
16777;53;48;F
16783;583,1148,1653,1654,190,90,51,344,348,1656,340,1655,820,106,435;48;F
16855;820,5,9,344,317,627,51,90,347,190,1148,52,106,435,707;33;M
16886;52,25,347,43,5,51,435,707,317;34;F
16897;44,52,1118,1226,1058,627,317,707,587,1430,245,348,820,106,435;23;F
16905;52,51;1;M
16924;433,5,898,6,90,51,52,53,435,707;38;F
16931;433,1485,43,347,51,348,53,820,106,435,317,707,345;35;F
16933;596,53,1655,1058,627,317,587,9,25,44,1619,820,1456,707,1518;39;F
16945;25,53,1485,5,1148,347,51,344,52,820,106,627,317,435,707;34;F
16946;347,51,52,344,348,342,1619,106,435,627,317,707,5,245,820;30;F
16967;53,1655,106,707,317,919,51,1456,1058,1656,1430,1485,435,627,1411;27;F
16968;583,43,51,63,345,1657,1148,1658;37;M
16972;53,1226,1619,344,919,347,62,898,9,587,583,25,51,44,627;48;F
17005;45,62,5,433,587,9,6,245,25,344,342,1118,820,627,1518;31;F
17019;433,1430,1657,1148,1658,1653,1654,190,43,348,340,820;38;M
17033;6,43,596,822,25,51,44,1118,53,1456,106,627,317,707,1518;12;F
17040;43,51,53,435,245,190,25,820;47;F
17043;707,51;29;F
17047;433,5,9,45,593,190,166,822,1118,1655,63;43;M
17067;43,347,435,627,342,106,317,707;31;F
17070;25,44;48;F
17072;245,593,45,1657,1658,583,1654,190,43,166,347,51,348,340;36;M
17076;587,9,245,43,596,822,25,44,1118,1655,820,106,627,317,1518;10;F
17100;593,9,587,317,583,245,25,44,1411,1518;36;F
17124;583,5,1654,43,347,596,348,1118,820,106,627,317,6,245,1518;43;F
17136;435,707;31;F
17159;348,342,1619,1118,820,1456,106,435,627,317,345,1518,1485,51,707;29;F
17161;433,5,45,62,587,9,6,245,25,344,342,1118,820,627,1518;32;M
17163;342,344,51,25,5,62,45,587,9,6,245,1118,820,627,1518;1;F
17173;1485,583,245,43,51;30;F
17198;166;41;M
17201;1619,44,1430,1411;41;F
17216;52,1656,9,6,43,25,51,106,317,627,820,190,344,347,348;20;F
17234;45,1430,1658,1654,166,1518;45;F
17241;5,51,53,106,627,9,45,245,43,25,820,1518;43;F
17262;820,1148,1619,5,898,90,317,435,345,1653,45,51,340,347,627;27;M
17272;348,25,190,1430,898,1485,593,1148,435,1411,51;29;F
17275;1118,1655,820,1518,433,587,593,1148,245,190,25,348,1226,1058,345;48;F
17276;1148;34;M
17287;166,45,245,90,822,52,342,1656,1655,63,435,43,1657,593,51;32;F
17293;62,347,51,52,344,53,627,1518;38;F
17297;51;33;M
17308;245,43,90,25,51,52,1619,106,707,435;42;M
17309;1422,43,589,340,345,627,51,190,1654,1658,245,106,62,1657,583;37;F
17314;245,43,90,25,51,52,1619,106,435,707;43;F
17330;6,5,43,1518,433,9,1430,245,90,25,919,44,1619,820,1456;37;F
17333;820,1456,1058,106,435,627,345,1411,5,433,245,190,347,51,344;54;F
17345;5,342,1118,340,820,106,62,1657,1148,583,245,1653,43,1656,1655;39;F
17349;583,1411;33;M
17380;347,1654,106,5,627,245,51,1619,6,1485,435,317,52,90,707;35;M
17387;6,43,347,51,344,53,106,435,627,317,1518,9,25,820;39;F
17397;587,1148,190,43,347,52,344,53,820,106,435,627,1518;49;F
17405;1422,190,589,596,25,51,44,344,348,1118,340,820,435,627,707;42;M
17496;1148,245,1653,1118;44;F
17501;347,1658,1430,25,44,106,317,348,53,1655,820,1058,627;40;M
17509;25,166;48;M
17515;1518;47;F
17616;1226,45,1456,1430,43,347,348,44,919,245,587,433,317,707,1518;47;F
17624;9,45,1658,583,166,25,44,1656,63,106,627,1518;38;M
17630;596,898,5,1148,347,344,1118,820,340,435,627,583,190,43,348;49;F
17644;348;23;M
17655;1411,345,627,435,106,1058,1456,53,1226,348,51,919,347,1430,587;54;F
17663;435,627;32;F
17684;1430,1619,1411;43;F
17687;166;17;M
17706;587,898,62,593,245,1619,340,63,627,583,347,90,1655,345,1658;37;F
17749;596,51,1619,1118,53,820,1456,106,435,627,345,1411,62,25,344;24;F
17778;1518,45,166;39;F
17785;433,344,5,898,45,1430,6,43,90,51,53,106,627,435,707;29;M
17795;63,1656,583,62,245,9,1456,1411,1518,587,90,433,6,1430,1118;42;F
17800;1456,1058,106,627,317,707,433,1430,1422,589,348,344,51,53,435;32;F
17814;6,245,1518;39;M
17821;5,898,43,51,53,820,106,435,627,317,707,345;29;M
17834;589,347,51,344,1118,1656,53,106,1148,583,190,348,342,340,435;45;F
17854;919,1118,433,1148,45,5,1485,9,43,106,317,627,51,347,596;21;F
17864;25,44;42;M
17865;433,90,1518;17;F
17874;919,587,62,347,90,25,51,52,344,1118,53,820,435,106,627;23;M
17883;5,347,90,9,43,25,51,344,348,820,435,106,707,627,52;37;F
17885;433,1518;58;F
17895;51;35;M
17949;166;50;F
17950;1485;76;M
17955;1430,45,106,435,627,1148,1658,1653,1654,190,344,348,345;57;F
17960;347,820,190,1148,583,90,25,51,52,348,53,106,435,627,707;40;M
18042;45,1430,1518;49;F
18048;1653,1148,6,589,90,344,1619,106,707,317,627,1656,51,347,190;32;F
18059;245,51,317,1411,596,348,52,344,583,190,347,340,106,627,345;29;M
18086;53,340,820,627,1518,1411,583,1654,245,43,347,822,919,344,106;41;F
18091;707,1518;42;F
18098;6;49;F
18107;435;44;M
18128;43,347,90,51,344,348,1656,1655,345,1658,342,53,106,627,707;28;F
18131;347,1656,106,435,627,707,317;29;F
18138;1456,627,1518,433,587,5,43,919;44;F
18139;245,1654,43,25,51,44,1655,433,5,9,596,344,820,1456,1518;48;F
18140;433,45,1148,583,245,1422,589,347,919,1656,340,627,1654,190,1518;42;F
18174;587,1657,1658,43,347,90,919,106,627,45,245;39;F
18178;166,1518;44;M
18212;596,347,1422,583,1430,62,1518,587,593,589,25,348,1226,820,1058;36;F
18214;53,340,820,627,1411,433,593,1148,583,245,190,348,1456,106;41;F
18227;1226,1656,53,1655,1058,627,345,348,52,51,43,1653,245,25,190;40;M
18232;589,43,1148,45,587,433,898,593,1658,583,1654,190,345,1655,340;38;M
18236;822,317,627;48;M
18246;190,707,347,1485,5,898,583,6,1422,25,51,1619,53,435,106;33;M
18249;1653,52,345,1148,1658;44;M
18254;53;32;F
18257;898,1658,1422,344,342,1656,53,340,1655,820,345,1148,1653,190;35;F
18258;53;31;M
18281;583,344,53,1655,820,106,25,347,43,245,45,62,898,9,5;45;M
18288;347,90,344,342,53,1411,1518,1657,1658,1653,190,340,1655,345;37;F
18297;587,347,596,25,344,53,106,627,317,707,345,51;34;F
18310;1657,1658,245,1653,1654,190,347,596,51,344,1656,340,1655,106,627;3;M
18312;45,1653,1655;39;M
18314;53,342,433,1148,1658,1653,190,347,51,348,1656,1655,1058,345,1657;40;F
18315;1518;46;F
18338;433,587,45,1148,583,6,245,1653,190,347,822,344,342,1656,627;67;F
18355;347,51,627,317;33;M
18358;707,435,106,52,583,1485,433;38;M
18408;90,1619,5,45,583,347,51,52,344,348,53,820,106,627,317;32;F
18416;587,6,245,347,44,106,627,1518,9,166,25;34;F
18425;106,1456,1655,51,1148,1657,45,433,593,1658,1654,190,340,345,1518;39;F
18457;1485,9,433,5,62,45,1658,190,347,919,51,106,627,345,1518;31;F
18461;919,52,317,435,707;31;F
18471;1655,43,435,1656,1422,25,53,106,627,317,1148,1653,190,347,51;39;M
18476;1518,1411;32;F
18486;1654,6,62,587,433,45,1430,583,51,919,348,106,435,317,707;32;F
18488;1658,583,1653,245,344,51,342,1058,106,1422,587,340,1456,627,345;41;F
18492;433,898,245,919,1226,340,1058;42;F
18506;1658,190,43,822,348,1656,340,820,345,1411,1518,9,1657,25,44;41;M
18509;433,587,45,1430,1148,1658,583,1656,1655,345;39;F
18517;1058,707,435,51;28;F
18520;433,587,5,9,6,43,166,347,51,44,1656,820,627,707,1518;46;F
18532;52,344,1619,1656,340,317,345,190,347,435,627,106,348,51,820;18;M
18536;1654,1518,583,1655,44,51,435,106,627,1657,348,1656,340,345,190;35;F
18545;62,9,1485,5,433,587,45,583,245,43,347,90,919,51,344;30;F
18561;1518,345,1655,53,1422,1148,245,90,52,62,347,51,106,627,317;48;F
18568;1422,347,919,51,348,53,820,627,6,1653,190,589,1118,1485,1411;32;F
18597;1430,1518;42;M
18620;583,106,317;36;M
18641;347,51,1656,1653,583,820,106,627,345;34;F
18658;245,1654,90,596,53,627,317,583,1653,190,347,51,340,1655,106;41;F
18660;433,707;32;F
18661;190,1654,245,1658,1148,1657,45,62,5,583,90,347,106,435,627;40;F
18694;5,1658,583,6,1653,190,347,51,342,1656,820,106,627,345;37;M
18713;5,433,587,9,593,6,245,43,25,51,348,1619,820,317,1518;50;F
18720;52,627,433,820,1058,919,43,1148,5,587,190,589,51,344,348;23;F
18723;190,1619,1656,1456,435,707,25,1430,898,340,317,45,583,51,344;27;F
18726;583,1653,190,347,90,51,1619,53,340,1655,1058,106,435,627,317;42;F
18728;340,583,1653,190,347,90,51,1619,53,1655,1058,106,435,627,317;65;F
18737;25,822,589,190,245,45,898,1148,1658,43,344,340,820,345;41;F
18740;1485,51,348,106,435,317,707;49;F
18766;342,106,627,1657,347,345,1148,340,583,1658,1654,190;43;F
18778;345,707,1655,342,583,1658,1657;39;F
18792;344,1456,587,820,90,345,1148,1658,1654,1422,596,919,52,1226,1058;54;F
18796;1485,1148,51,348,340,1655,106,435;33;M
18822;51,106,435,317,707;37;M
18860;190,44,1226,53,1518,433,587,9,1430,245,43,25,348,1118,435;59;F
18865;587,43,822,1058,435;50;F
18885;433,344,340,587,5,1430,1148,245,190,43,919,52,348,820,435;46;F
18887;589,90,51,52,344,53,627,317,106;45;M
18899;1654,1422,347,822,52,344,348,342,1456,435,627,317,707,1411,1518;33;F
18964;9,43,44;38;F
18985;51;29;F
19008;9,43,44,1518;37;M
19026;9,1422,43,44,1518;13;M
19031;1411,245,166,348,433,587,9,593,25,919,820,43,1430,1619,1518;53;F
19034;62,6,347,51,52,344,348,106,627,317,435,1518;29;M
19057;51,44,344,1656,53,1655,820,63,106,627,317,707,345,1518,342;31;F
19058;166;43;F
19059;5,9,1430,43,347,90,25,348,53,820,1456,435,627,317,166;32;F
19062;9,51,44,344,53,1655,820,1456,627,707,1518;30;F
19067;5,9,593,43,347,822,919,51,820,63,106,627;35;F
19075;25,166,1518;36;F
19079;1658,587,1654,919;40;F
19088;5,1148,190,90,51,348,53,62,43;60;M
19096;348,1655;39;M
19099;1148,190,1656;26;F
19104;1653,347,1456,627,1422,52,1619,53,317,62,583,51,106,707;23;M
19118;596,1148,43,344,1118,627,106,347,53,51,348,435,1619,6,317;45;F
19123;433,347,344,627,1518;27;F
19132;1456,820,1619,596,90,347,190,1653,1658,1148,587,6,245,348,106;56;F
19159;190,347,51,52,820,627;40;M
19173;1148,1658,245,1653,1654,190,90,596,348,342,340,820,1058,106,345;39;M
19200;45,62,9,1485,433,707,1656,1654,5,1148,583,90,106,1058,63;28;F
19232;347,190,6,62,587,433,593,1148,245,1653,1226,53,1058,106,627;47;F
19247;45,593,25;40;F
19260;1430,6,52,348,1226;26;F
19275;348,53,820,106,627,433,6,245,190,43;65;F
19299;435,627,433,5,1485,62,1658,583,6,245,1654,190,43,340,345;39;F
19307;166;39;M
19320;342,44,822,43,1422,245,45,62,707,345,1518,5,9,1148,25;42;F
19322;1518;42;F
19332;919,1655,1456,1518,1485,1619,1656,627,1411,1118;18;F
19350;62,45,587,1148,1653,190,106,627;37;F
19354;1456,1411,587,9,6,43,25,344,1619,820,245,90,627,317,1518;34;F
19355;44;36;M
19359;596,52,1118,190,43,347,25,919,51,344,53,106,435,627,317;26;M
19380;593,587,433,45,1657,1148,1658,1654,190,166,342,348,1656,1655,345;34;F
19389;1485,1148,45,1653,1422,1655,106,627,190,43,1656,340;22;F
19395;190,51,52,106;42;M
19407;1411;16;F
19410;1148,190,589,1656,53,340,106,62,1657,1658,583,1654,342,627,345;38;F
19430;53,6,106,1058,1654,1226,820,348,347,1148,1653,190,627,340,587;43;F
19432;1619,45,347,433,51,1657,627,583,1653,190,1148,820,1656;42;M
19444;433,6,589,347,90,52,344,348,1619,1118,53,820,435,627,317;25;F
19480;6,90,53,435,707,1518,62,25,44;41;M
19482;345,433,1657,1658,583,245,1654,190,347,51,344,348,1656,627,1518;31;F
19496;5,9,583,6,44;35;F
19514;317,627,820,90,43,1654,593,6,44,1118,1518,53,9,5,25;34;M
19520;106,190,1653,1148,245;72;M
19535;593,62,1485,5,587,433,45,1658,348,342,340,820,106,627,345;36;F
19551;433,898,340,627,106,344,190,1653,43,1148,62,5,245,820;45;F
19552;245,1430,62,433,6,1422,25,348,1118,1656,53,1456,820,627,1518;29;F
19554;1148,1658,583,1654,190,1422,51,52,344,342,1118,340,1655,820,627;37;F
19558;51,344,317,587,5,9,43,90,25,44,1619,53,820,627,1518;42;M
19562;593,1430,1658,1653,190,1422,589,344,348,1118,53,340,1655,345;39;F
19594;1485,1148,1658,1654,1118,1656,1655;30;F
19596;6,52,820,317,627,53,1619,344,51,25,347,43,45,106,1518;39;M
19597;62,6,90,25,44,53,435,707,1518;36;F
19615;52,435;28;F
19619;433,5,245,190,51,344,348,1118,1226,53,820,1058,627,345,1518;21;F
19632;43,63,1518,433,587,593,1430,583,589,919,348,1118,1226,707,1058;18;F
19650;1657,1148,1658,245,1654,1653,43,344,342,1656,340,1655,345,190;34;F
19678;1148,190,345;58;M
19700;1148,245,53,820,1518,1653,190,347,51,340,1655,106,435,627,345;42;F
19724;348,1657,190,820,1655,1058,345,1654,898,593,1658,583,1148,919,340;38;F
19728;435,317,1518,1430,245,190,347,589,596,25,53,820,627,1619,1148;48;F
19740;820,1655,344,1148,1658,190,1422,43,90,51,348,245,53,1058,106;41;F
19753;9,347,25,51,53,1456,106,627,317;38;F
19756;587,1653;60;F
19764;1411;73;M
19777;9,627,1518,25,820;41;F
19792;245,43,44,1148,1656;31;M
19796;587,1518,1655,25,822,190,1653,1148,5,344,340,820,9;32;M
19798;1411,1518,52,342,106,435,345,1653,190,919,344,340,820,1148,9;29;F
19803;587,5,45,347,51,53,1456,1518,1148,245,43,348,340,820,106;46;F
19820;90,1456,593,587,348,1653,627,347,1430,1411,596,245;50;F
19895;1430,52,344,45,1658,1654,43,589,707,5,583,25,342;32;F
19914;5,190,51,53,1058,1518;31;F
19923;347,51,342,1656,53,340,1655,1456,707,1518,62,820,106,627,345;36;F
19924;90,9,433,5,583,6,190,589,25,52,348,53,106,435,627;31;M
19926;1411,345,707,1655,342,1654,1430,1148,1658,1058;57;F
19943;1654,1653,190,43,347,25,51,52,53,820,1456,106,435,317,1518;37;M
19944;435,345,1619,53,627,6,190,347,589,90,51,52,1118,820,106;51;F
19947;190,347,25,435,317,1619,1226,820,340,596,919,1118,1656,627,106;49;F
19948;106,627,317,707,345,62,9,45,593,6,347,25,348,342,820;37;F
19956;822;40;F
19960;6,25;38;F
19963;5,43,820,1518;36;F
19964;43,166,25,1518;39;M
19966;347,166,6,583,5,589,25,51,52,344,1118,53,820,627,317;40;F
19969;1148,1654,347,51,344,348,53,627,317,106,1518;52;M
19973;43,344,348,1118,820;37;F
19994;627;26;M
20003;347,51,627,106;30;F
20009;1148,51,190,1518;45;M
20012;1518;9;M
20023;435,317,1422,106;23;M
20024;433;52;F
20025;245,53,898;46;F
20030;190,347,25,51;42;M
20035;898,5,587,707,106,1058,1456,52,1654,1422,589,25,51,344;40;M
20038;433,596,43,1658,5,45,1148,1653,583,190,90,1118,340,820,345;40;M
20052;6,25;12;M
20062;1518;45;M
20069;593,1658,1654,51,344,348,1058;51;F
20080;1518;8;M
20082;345,106,1456,1653,1430,1148,348,340,1619,1485,45,347,344,820,627;46;F
20092;6,25;9;M
20107;1422,5,1658,245,190,43,90,919,1148,583,1653,52,344,1656,345;52;F
20112;1148,348,820;49;F
20113;6,25;46;M
20117;348,344,1654,245,6,1148,1657,1658,347,51,340,106,627,317,1411;37;M
20140;43,347,919,348,344,53,820,1058,317,45,245,52,1656,340,1518;49;F
20141;190,919,51,344,348,1656,1655,820,1456,1058,627,1658,583,245,345;37;F
20169;587,9,45,6,245,90,52,53,627,1518;40;F
20171;52,53;49;F
20180;190,589,90,919,51,1656,53,340,317,587,348,1226,1058,627;35;F
20181;51,190,1148,898,9,5,593,1430,245,1654,347,919,342,340,435;26;F
20183;1658,90,344,348,627,345;46;F
20188;627,106,1656,1619,52,596,90,1653,583,62,347,51,348,53,1456;38;F
20192;106,820,53,1118,344,52,51,596,90,347,589,190,1653,6,1148;51;M
20206;53,707,51,90,583,1657,1148,1658,245,190,348,340,1655,820,345;37;F
20213;62,1430,6,190,347,90,52,348,1656,53,340,1456,106,627,345;35;M
20220;5,90,25,919,51,52,344,348,1226,820,1456,1058,627,317,1656;30;F
20221;433,898,593,53,707;35;F
20235;1148,1658,1654,43,90,596,51,919,344,348,1226,433,340,820,106;28;M
20239;435,707,44,62,317,90,433;40;M
20241;627,43,1654,245,6,583,62,317,90,433;39;M
20248;62,1430,6,347,25,51,348,1118,1226,1058,106,627,317;24;F
20266;1658,1657,583,1411;42;F
20268;345;30;F
20278;347,53,1058,106,627,317,1518;42;F
20315;5,43,1485,62,51,44,1655,820,627,53,1518,106,435,317,707;38;F
20330;1118,1656,53,435,1411,245,1653,1654,1456,587,593,1430,340,63,1058;37;F
20338;1653,190,348,340,1655,627;45;F
20349;62,45,1658,347,51,44,342,1656,53,340,1655,820,63,627,1518;27;F
20350;106,627,53,52,51,62,433,9,6,245,90,919,44,435,317;33;F
20352;898,593,1148,1658,583,245,1654,43,347,596,344,53,820;43;F
20365;347,596,25,51,44,52,344,1118,53,820,435,627,1518,1226,1058;38;F
20387;5,1485,1148,245,190,43,51,348,53,340,1655,820,1058,435,1518;25;M
20390;1148,45,433,5,62,1430,1657,43,90,919,52,820,1456,345,25;37;F
20391;5,1430,1657,1148,1658,190,348,1118,1656,345,6,344,340,820,106;23;F
20392;347,344,348,53,627,820,5,587,1658,190,43,25,51,52,340;47;M
20393;1430,6,245,344,348,820,106,43,90,52,1656;36;M
20401;44,51,347,1657,190,348,106,627,317;41;F
20408;317,1148,190,90,53,106,627,45,583,1654,347,245,51,1619,1655;39;F
20409;435,820,53,317,106,1058,1226,90,43,5;35;F
20428;45,1148,245,51,1430,583,190,347,348,342,53,1456,106,627,345;31;F
20447;317,707,53,1619,342,51,1653,1148,433,1658,245,190,25,344,435;33;M
20450;1658,1148,1657,587,433,589,919,348,1118,340,106,435,345,1422,190;30;M
20462;340,1411,6,25,348,317,106,45,347,596,820,627,51,1653,190;17;M
20466;1430,587,433,1653,190,596,348,1656,340,1058,106,435,345,583,1658;33;F
20469;1657,1148,583,1653,1654,190,596,25,348,340,820,1655,435,317,345;14;M
20471;1653,5,587,1148,347,51,52,53,1656,1655,820,45,190,43,433;34;F
20482;45,583,245,1653,190,347,90,627,6,340,106,345;36;M
20487;43,25,51,344,1118,820,627,345,593,1658,245,90,1058,106;24;F
20515;919,43,190,1654,1653,583,1658,593,62,587,433,1657,44,1655,345;38;F
20528;347,9,587,898,45,593,1430,43,51,342,317,707,820;39;F
20530;707,1518,1657,593,5,433,245,190,919,44,344,820,1058,106,627;48;F
20552;44,348,1118,1518,9,43,166,25,820;44;F
20554;51,90,627,106,347,1422;25;M
20557;317,52,90,435,707;32;F
20560;53,62,347,51,1456,106,627,1518;48;F
20561;106,820,344,348,627,317,345;48;M
20563;345;32;F
20573;1148,593,45,347,596,51,52,1619,1118,1656,340,820,106,627,190;44;M
20579;587,62,1430,245,52,348,1118,53,435,345;33;F
20591;340,1430,583,43;42;M
20595;347,53,106,627,317;41;F
20641;1657,1148,1658,1654,190,342,340,820,345;32;F
20644;62,1485,5,1656,340,820,317,627,435,106,347,1422,1148,898,53;28;F
20650;44,596,245,6,190,51,106,435,43,589,53,317,347,627,1653;28;F
20654;1148,1655,340,1653,1658,345;34;M
20656;433,587,62,1658,347,90,596,1226,340,1655,345,245,190,348,1058;63;F
20662;45,6,51,1226,63,707,1518,9,43,166,25,919,344,1118,1058;27;F
20669;62,348,1226,53,820,1058,106,627,707,345,1518;70;F
20708;583,43,25,44,1619,1058,433,45,90,919,52,820,106,435,707;23;F
20716;340,1118,1619,342,344,52,51,190,583,1657,593,433,1658,245,345;38;F
20719;1411,43,9,898,1430,583,25,627,1518;38;F
20729;1456,435,1518,433,587,245,44;57;F
20733;583,707,342,348,44,596,90,245,9,1657;32;F
20736;1658,1148,62,5,6,245,190,347,51,1619,53,820,627,1518,1656;42;F
20750;1118,1656,106,435,627,317,1518,5,9,6,245,43,166,25,820;46;M
20756;344,348,820,435,627,317,1518,1657,1148,1658;44;M
20777;166;19;F
20803;1148,25,820,340,344,51,1658,1657,45,190,1655,345,43,90,52;43;M
20811;898,45,344,9,5,1148,583,190,1422,52,348,340,1655,820,435;39;M
20836;707,166,25,820;36;F
20842;51,1619,820,348,106,627,345,245,190,43,347,1518,25;46;F
20844;1653,347,25,51,52,53,106,627,348;30;M
20864;5,1658,190,344,1118,317,62,245,347,51,52,53,820,106,627;34;M
20870;1148,6,25,51,344,53,627,5,190,347,52,820,106,435,317;40;F
20878;347,52,342,435,245,190,43,596,344,348,1118,1656,1655,820,106;46;F
20885;1658;36;F
20890;317,45,898,1653,245,347,51,344,342,1619,1656,820,627;35;F
20893;898,90,919,51,52,435,317,1518;34;F
20941;62,6,245,1653,1654,190,347,51,1619,53,106,627,345;51;F
20944;1658,583,6,245,1653,1654,190,347,317,345,1518,51,53,106,627;51;M
20990;1654,347,90,596,348,342,1619,53,340,1456,1058,345,1657;35;F
21004;53,345,1657,1658,583,245,1654,190,51,340,1655,820,63,106,627;31;F
21036;348,1656,345;41;F
21040;45,1430,1657,1658,583,1654,1656,1655;42;F
21064;344,1655,1518,898,583,190,43,347,1656,53,340,820,106,627,317;17;M
21075;90,45,1148,583,245,1654,190,347,51,1619,53,1655,106,627,317;40;M
21079;822,51,348,1656,53,1655,820,1456,627,1518,433,9,45,1430,44;40;F
21098;53,1619,344,51,596,1430,45,433,9,593,583,245,25,919,820;39;F
21100;5,1653,43,820;40;F
21102;433,898,1430,583,245,1654,1422,919;17;F
21114;583,593,1658,348,345,1657,1654,62,63;36;M
21116;344,106,435,317,433,898,62,190,1422,43,347,51,1619,53,707;17;M
21124;5,190,43,347,596,51,52,344,348,1118,53,820,1456,106,627;25;F
21126;5,1430,1148,1658,583,6,1653,190,43,347,51,52,344,340,627;47;M
21133;348,1656,53,1655,583,347,51,106,627,317,433,898,245,190,340;21;M
21138;245,51,348,53,1655,1657,347,340,106,820,1148,190,43,344,627;49;F
21139;583,1654,43,348,340,1655;16;M
21143;627,433,62,45,1657,1658,6,245,919,51,342,340,1456,106,345;35;F
21147;317,53,106,45,1148,583,245,1654,190,347,90,51,1619,1655,627;8;M
21154;589,51,820,317,62,1657,190,347,52,344,53,106,627,345,348;33;M
21157;62,1148,583,347,51,344,348,627,1653,190,1654,43,1656,820,1518;39;M
21159;190,344,347,593,1653,51,919,348,1226,1058,627;39;F
21160;1148,62,5,1485,435,317,345,1657,1653,190,347,51,340,106,627;40;M
21201;5,9,583,820,627,1518,25,166;36;M
21206;51,25,90,347,43,1653,245,6,52,348,1656,1655,106,627,317;34;F
21208;51,53,317,45,1148,583,245,190,1654,347,90,1619,1655,106,627;6;F
21217;593,1430,43,344,1226,820,1518,1148,1658,190,347,348,1655,345,1058;43;F
21239;245,1654,190,1422,43,347,348,53,340,1655,1456,345,1430,1657,627;33;M
21249;51,707,317,52,1518;32;M
21255;898,583,52,1118,1656,820,627,1518;16;M
21262;106;35;M
21276;106,1148,347,1658,345,1657,627,190,342,1655,1653,51,820,1656;38;M
21278;627,348,1118,1656,63,435,317,344,90,1422,1653,245,583,1430,1456;13;M
21286;1430,627,25,1619,1118,6,1518;46;M
21298;1653,106,820,347,51,1657,1619,583,1148,45,345,190,627,1655,340;31;M
21300;51,245,43,348,53,1456,1058,344,317,347,1656,820,106,627,1653;59;F
21320;587,52,53,317;23;F
21323;5,596,348,340,1655,345,106,1485,90,1118,435,1148,347,51,820;35;M
21325;596,919,52,344,348,1118,1226,1656,53,1456,1058,63,106,435,627;48;F
21328;1456,1058,627,317,433,90,919,25,344,820;37;F
21346;1653,51,52,344,348,1656,53,106,1148,245,190,347,340,1655,627;45;F
21353;106,345,190,1658,1148;44;F
21362;707,317,51,1422,596,245,347,820,435,627,433,43,589,340,106;29;M
21392;348,919,589,43,190,1653,245,6,593;21;F
21395;433,587,62,593,43,347,25,919,51,348,1118,1456,106,627,53;49;F
21397;587,43,25,919;38;F
21403;106,587,1456,707,245,6,583,593,1485,1118,1226,1656,1058,627,317;30;F
21405;1518,348,589,433,587,5,593,1148,245,51,52,344,1226,820,1058;48;F
21417;90,43,190,593,5,1148,347,919,51,52,344,317,627,820,106;37;F
21418;45,1430,1653,347,51,53,106,6,1058,627;47;F
21425;707,1657,1148,190,43,345;34;F
21430;347,190;44;M
21432;583,190,1656,53;30;F
21435;1518;7;F
21447;245,43,51,53,820,627,1518;3;M
21464;53,433,45,1657,583,1653,348,342,1656,1655,106,627,317,707,345;33;F
21492;1411,53,1422,190,583,898,1485,587,5,245,43,25,919,348,435;49;F
21498;1653,583,1148,1657,593,433,587,1430,1658,245,596,348,435,345,1518;53;F
21542;589,1226,898,583,1422,919,348,1456,1058;43;F
21557;344,53,1655,106,627,1411,1518,9,6,43,822,820,5,166,25;43;F
21594;340,1653;46;F
21595;1657,1656,1654,596,1118,1655,1422;29;M
21597;90,344,1456,587,593,1657,1658,1654,190,919,342,1226,820,1058,627;36;F
21610;106,345,433,6,347,1619,707,62,245,44,53,1058,317,627,1518;46;F
21614;627,1058,820,53,1226,43,6,583,5,587,1518;40;F
21633;25,919,1456,1411,587,5,245,1518,433,43,344,1118,627,45,90;56;F
21655;587,5,583,6,43,1226,53,1058,627,1518;10;M
21667;1653,190,347,51,344,1656,53,340,1655,820,106,627,345,45,1148;70;F
21669;587,5,583,6,43,1226,53,1058,627,1518;45;M
21678;25,347,62,433,593,589,919,52,348,1226,1058,435,627,1411,245;29;F
21684;62,1653,53;39;F
21688;1653,53,340;46;M
21701;587,5,583,6,43,1226,53,820,1058,627,1518;8;F
21709;53,345,106;70;F
21713;6,245,1653,190,347,51,1656,340,1655,820,106,627,345,45,1148;78;M
21715;25,5,9,6;34;M
21719;43,90,1619,347,245,6,919,51,106,627,317;21;F
21721;245,25,919,1058;39;M
21734;51,596,347,190,1653,1658,1657,5,1148,245,52,344,435,627;39;F
21736;5,45,347,344,1656,340,820,106,1148;13;F
21738;1411,1518,43,583,593,587,62,898,1485,1148,1654,190,348,340,345;40;F
21765;587,1148,43,51,348,1226,106,627;33;F
21792;344,1619,1118,1656,820,106,627,345,707,1411,1518,9,43,25,53;39;M
21795;344,1619,435,1518,433,6,347,51,52,53,106,627,317;22;F
21806;62,347,51,348;64;F
21817;1148,1653,1656,1058;53;F
21843;45,1657,1658,190,51,342,53,106,345,1148,583,348,340,627,1518;47;F
21845;5,6,43,1118,317,1456,347,1653,245,190,596,51,435;35;F
21864;90,1422,1518;43;F
21865;43,1456,25,348,1411,1518;33;M
21881;1657,1148,1658,1653,190,340,1655,820,1058,345;43;F
21889;1148,1658,340,820,106,627,345;38;M
21894;62,5,9,43,1118,25,44,1518;36;F
21907;45,90,52,53,820,344,51,25,347,1657,5,587,245,627,1518;42;F
21912;593,9,587,62,6,347,90,919,820,43,51,1656,106,317,627;26;F
21920;52,51,1658,1430,433,1148,1619,583,1653,43,344,348,1656,820,1456;39;M
21926;348,52,596,245,5,587,347,51,344,53,627,1656,820,1456,106;39;F
21963;1430,166,51,342,1619,345,5,43,347,90,25,344,820,1518,1411;41;F
21966;6,245,52,348,820,106,435,627,317;41;F
21991;1654,25,44,348,1619,340,1655,1518,190,347,51,53,106,627,317;49;M
21999;1456,1058,63,435,627,317,707,345,587,433,106;32;M
22002;62,1658,43,51,53,340,1655,820,63,435,627,317,707,1657,106;36;F
22004;5,62,1657,1148,1658,245,190,43,90,51,1655,820,106;34;F
22006;5,6,44;38;M
22097;1657,345;38;F
22100;433,593,583,245,1422,589,25,348,1118,1226,820,1456,1058,627,1518;37;F
22101;347,245,583,898,5,587,53,435,317,707,1148,43,90,51,1518;30;F
22103;1619,1656,53,1655,63,106,435,627,317,1518,347,62,433,245,44;27;F
22142;43,707,9,1148;41;F
22161;43,1148,1430,433,62,45,1657,1658,583,245,1654,348,1118,63,1518;42;F
22166;1430,1148,1658,1653,190,166,347,348,342,1656,53,340,820,1456,345;44;F
22186;1485,1148,6,166,822,51,1118,435,5,43,25,52,344,820,63;31;M
22190;435,345,245,1654,190,342,106,627,317;43;F
22196;1653,1655,1456,63,627,587,5,9,1657,1148,1658,190,51,820,345;59;F
22202;106,5,51;40;M
22211;707;39;F
22245;342,707,345,1657,1653,190;32;F
22257;44;29;F
22275;5,898,90,51,820,52,53,106,435,627,317,707;33;F
22304;5,347,51,344,820;27;M
22311;45,1657,1148,1658,1654,190,347,51,344,348,1656,53,820,627,345;39;M
22313;62,587,51,1518,317,90,45,25,44,707;32;F
22327;1430,62,898,9,1485,5,587,433,593,1148,1653,90,919,348,1656;27;F
22414;1058,435,627,1430,25,919,348,820,9,45,245,43;33;F
22426;1657,317,1411,344,822,90,1422,1148,1485,5,245,820,106,435,707;40;F
22434;51,820,822;46;M
22435;919,53,627,707,1518,62,1430,1653,1422,348,1656,340,63,106,435;51;F
22452;1619,348,344,52,51,919,596,90,347,245,6,62,106,317,627;30;F
22453;166;36;F
22454;435,5,62,90,1655,820,317,345,1148,1653,190,347,51,106,627;45;M
22467;190,1654,345,627;32;M
22469;820,25,9,45;38;M
22470;820,1430,43,25,919,44,348;41;F
22489;5,9,25,44,317,627;35;F
22512;43,344;39;F
22538;433,1430,6,245,43,52,348,435,317,707;39;F
22544;51,1411;25;F
22551;347,589,43,1654,583,1148,1657,62,898,45,1658,245,190,1422,342;36;F
22559;317,342,45,5,1654,347,919,627,245,820,106,51,1148,90,1658;29;F
22573;1485,898,593,1430,1657,1148,1518,1411,435,1655,348;21;F
22586;587,433,1430,583,1653,820,45,1657,1148,1658,1654,190,348,340,345;38;F
22590;596,106,627,1226,1655,1456,587,433,593,245,1422,589,919,344,1058;47;F
22605;344,342,820,435,317,587,1148,6,347,51,1656,106,627,1653,52;49;F
22616;51,344,348,342,53,340,820,627,345,90,43,45,433,1658,1653;42;F
22621;707,63,1456,53,596,589,1653,62,1657,347,90,51,1656,106,627;41;M
22641;1656,51,1058,593,90,245,627,820,348,5,583;34;M
22652;52,1619,1226,1456,317,345,593,347,348,1058,106,627,245,190,25;34;F
22656;627,5,1430,1148,1653,43,347,25,51,344,348,1118,53;44;F
22661;43,25,1456,1518,166;36;F
22662;435,627,1518,1430,9,5,1619,1411,6,90,596,25,919,1118,44;31;F
22668;1658,43,51,348,53,1456,106,1518,1654,587,1653,190,347,627;73;M
22674;1654,1653,5,6,589,347,344,52,820,627;22;F
22704;190,589,347,1655,820,106,587,1657,345;52;F
22725;1656,919,347,43,6,433,1430,245,589,596,822,348,1226,820,1518;31;F
22736;435,627,317,53,344,52,51,1654,106,707;38;F
22754;433,587,1657,43,90,51,820,344,919,62,347,1656,106,627,345;46;F
22772;707,583,245,53,820,1456,627,1411,1518,433,593,43,166,25,342;40;F
22777;1148,190,347,25,344,820,5,1485,43,51,53,106,435,627,317;28;M
22784;5,9,1148,6,245,347,435,1518;23;F
22795;433,587,5,45,245,43,90,25,919,344,1118,1456,627,1411,1518;11;F
22796;587,1430,6,245,90,25,919,344;41;F
22817;583,1654,1619,63,317,1411,433,587,45,245,919,348,820,1456,707;40;F
22820;433,43,347,344,53,820,106,435,627,317,707;33;F
22821;51,348,342,1619,1226,53,1058,106,435,627,345,433,245,317,707;33;F
22844;583,190,53,435,1411,43,589,25,51,52,344,348,1656,820,106;25;F
22859;345;34;M
22865;433,62,1653,919,1656,1655,345;34;F
22897;433,587,5,45,245,43,90,25,919,344,1118,1456,627,1411,1518;16;M
22919;583,166,344,1658,51,1653,106,340,1657,245,347,342,820,190,1656;33;M
22927;1411,317,627,344,52,919,596,90,347,589,43,245,6,5,106;45;F
22929;1430,1654,348,43,90,340,820,5,583,6,51,52,53,435,707;38;M
22933;707,435,106,1058,53,342,344,51,347,190,1653,1658,1148,627,345;27;F
22944;593,1657,1148,1658,596,919,345,342,1656;28;F
22959;190;38;F
22969;583,45,342,1657,1658;37;F
22973;6,245,1654,347,345,627,1655,51,919,43,190,1653;70;F
22975;433,587,5,45,245,43,90,25,919,344,1118,1456,627,1411,1518;58;M
23005;707,1430,1518,6,5,43,25,347,245,587,433,593,919,53,1411;26;F
23034;919,51,52,53,1058,627,317,62,245,1654,90,1619,1118,1456,63;18;F
23040;1430,822,348,342,1655,820,1619,90,5,9,6,166,25,1118;43;F
23048;106,627,1518;41;M
23062;1422,348,317,5,1655,820,627,345;50;M
23082;1656,53,820,106,627,707,433,1118,5,90,25,44,1619,6,1518;21;F
23090;1619,348,6,433,245,347,90,52,1456;45;M
23092;627,342,5,106,898,6,1619,51,317,1485,90,52,53,435,707;39;F
23100;344,51,106,627,317,25,347,6,9,5;24;F
23102;593,1485,5,587,433,1657,1658,1654,596,1411,1422,1118,627,589,1518;36;F
23110;1148,1619,52,5,344,6,245,348,820,707,433,45,43,90,435;37;F
23116;898,1148,245,43,596,919,1118,627,106,53,348,51,347,190,345;39;M
23125;1058,106,627,1148,190,596,919,344,587,43,5,435,90,245,820;46;F
23130;587,593,1148,245,1619,627,345;44;F
23166;45,5,433,707;45;F
23170;593,1430,43,627,1456,820,53,1619,348,51,1654,583,45,347,245;42;M
23180;348,435,317,1422,190,1148,1430,1485,583,347,820,627,51,106,1654;46;F
23192;44,1619,596,25,344,1456,1518,1118,6,1430,9;44;F
23243;1456,5,25,627,53,51,6,1430,344,348,820,106,435,317,707;34;F
23260;43,627,106,1058,919,1148,593,45,5,433;31;F
23262;1148,1654,345;49;F
23269;345,5,593,1148,1658,583,245,1654,190,43,90,51,52,344,820;48;F
23276;1518,596,344,25,1422,6,9,1118,820;47;M
23282;62,919,1619,1656,1518,317,345,6,245,43,347,53,820,627,106;49;F
23290;43,1619,52,6,106,345,62,245,347,919,344,53,820,627,1518;46;M
23292;1656,53,106,1518,1411,435,1058,1226,919,589,587,433,627,317,707;38;F
23313;583,45,587,53,62,433,1657,1655,707,1518,1658,1653,344,342,345;44;F
23315;587,1658,340;37;F
23324;347,344,53,820,106,627,707,1518,51,43,45,587,245,44,342;38;F
23345;347,919,344,1058,106,627,587,245,90,51,52,53,435,317,707;26;F
23357;45,51,344,435,317,707;33;F
23364;587,44,593,583,589,596,627;43;M
23366;627,596,43,190,1654,1148,1657,45,62,5,347,344,348,820,345;51;M
23370;344,348,1619,1118,1226,1058,1456,587,9,1430,589,919,820,435,25;35;F
23421;919,348,1456,106,627,345;46;F
23427;44,25,1619;38;M
23450;25,1518;37;F
23456;190,245,583,1658,1657,1430,45,62,9,433,587,348,1226,820,707;38;F
23462;435,53,6;34;F
23470;433,587,62,593,583,245,919,44,348,53,1456,1058,707,345,1226;39;F
23481;9;50;F
23501;62,593,583,1654,190,90,596,51,627,1658,919,106,345;44;F
23506;6,1485,9,898,245,51,53,435,1518,433,5,190,44,340,106;41;F
23517;5,44,9,1411;46;M
23522;1148,6,245,90,627,1518;41;F
23536;6,62,1430,583,347,25,51,1226,53,1058,106,627,317,707,345;37;F
23603;1430,25,51,348,1456,627,1518;31;F
23619;51,52,344,340,1655,106,587,1653,919,53,820,435,627,190,25;50;M
23621;106,627,317,1518,5,43,90,596,1118;28;F
23625;1430,1518,1411,1118,1619,344,90,6,9,5,245,43;40;F
23634;1658,1430,62,898,5,583,348,820,1456,106,627,317,707,345,1518;45;F
23638;106,627,62,1657,1148,1658,583,1653,190,25,51,340,1655,820,345;28;F
23643;347,90,51,919,25,348,1118,1456,1058,707,62,245,106,627,317;36;M
23688;1148,1658,245,1653,1654,190,348,53,340,1655;43;F
23710;344,52,51,90,347,6,1148,1658,245,1653,190,919,1656,106,627;42;F
23711;1658,1058,1485,62,190,52,43,347,51,348,1456,106,435,317,707;33;F
23752;9;35;F
23758;62,1653,51,348,53,1456,106,627;47;M
23791;587,5,9,6,166,25,820;56;M
23802;1653,348,1456,245;68;M
23857;1148,1658,190,1656,1655;48;F
23876;62,45,1430,1148,583,1658,1653,596,25,348,345,1654,190,340,1655;29;M
23878;9,596,44;39;F
23881;317,9,435,5,347,51,820,106,627,1485,1148,190,43,589,25;55;M
23893;587,347,596,106,435,344,1058,317;28;F
23910;587,5,9,6,166,25,820;53;F
23927;1654,190,1422,1619,1118,820,1456,106,317,1518,1485,348,435,707,1411;34;M
23945;1485,45,6,43,90,25,51,707,435,820,342,5,52,53,898;44;M
23958;5,898,6,1422,53;40;M
23964;593,589,596,1226,1058;22;F
23967;5,1148,1656,344,245,90,587,919,317,820,190,347,1619,627,106;23;F
23972;1485,344,820,106,62,347,348,53,627,317,707,25,44,5,1518;29;F
23973;433,587,593,1430,245,347,344,348,1226,1456,627,345;67;F
23986;245,433,25,919;26;F
24004;1485,5,596,347,25,348,1118,820,1456,106,627;49;F
24033;45,1657,245,344,90,43,820;37;M
24039;51,53,627,44,1411;19;M
24046;1148,6,1485,9,166,347,90,627,317,1518,43,25,344,340;38;F
24081;1485,9,1653,190,1422,347,25,51,1118,1656,53,820,106,627,317;29;F
24111;627,1411,587,1430,342,245,45,1658,6,1654,340,1655,583,106,345;38;F
24136;90,344,63,1456,1411,1657,1148,1658,1619,348,340,1655,820,345;38;M
24142;344,919,347,190,6,1148,5,1619,90,587,245,820,627,433,106;51;F
24201;1148,190,43,820,435,627;25;F
24219;433,1653,166,348,342,53,820,1456,1518;44;F
24222;9,51;40;F
24233;1411,345,106,1656,433,587,5,898,1430,1654,245,90,52,342,1655;10;F
24240;1430,1518;38;F
24242;62,1148,1654;49;M
24247;90,344,898,5,1430,6,1654,190,919,348,53,820,106,707,1518;27;F
24257;1430,344,1654,820,919,245,5,6,587,9,25,44,1518,1411,1619;41;F
24266;1411,593,45,62,1485,9,245,43,348,820,627,5,587,433,1518;36;F
24275;433,1653,90,53,317,627,245,25,348;51;F
24278;166;42;M
24288;166,25;11;M
24309;166,25;8;M
24320;62,6,52,820,1456,317,1148,190,51,344,53,106,245,347,627;51;F
24321;348,1656,53,317,435,1485,5,25,1518,9,347,51,820,106,627;32;M
24325;44;42;M
24327;347,51,340,317,45,90,25,1619,5,9,43,53,820,627,1518;41;F
24356;587,898,1430,1657,1148,1658,583,190,1422,919,1118,1656,1655,1058,345;20;F
24372;1658,1654,347,51,344,348,340,820,627,1148,190,1653,345,1656,1655;31;F
24388;51,52,344,53,340,820,627,5,1654,1653,190,43,1656,1655,345;31;M
24412;51,62,6,245,43,589,347,90,344,348,1619,53,820,1456,435;69;F
24413;1148,190,347,52,106,435,627,317,707,589,583,6,1485,1456,898;43;F
24425;5,9,45,43,347,90,25,51,1619,53,340,820,627,317,1518;11;F
24429;583,1653,347,596,51,52,1656,53,106,627;51;F
24438;5,9,45,245,43,90,25,51,1619,1118,53,340,820,627,1518;10;M
24440;340,6,1653,347,344,348,53,106,627,317,345,62,245,190,25;50;M
24441;347,62,583,90,51,52,1619,1118,53,1456,63,106,627,317,1411;52;M
24446;62,25,707,6,245,347,596,919,51,348,1118,106,435,627,317;19;F
24458;106,435,317,166,1430,348,820,627,1518;47;F
24483;898;29;M
24490;707,1518,90,596,51,52,348,1619,1118,1656,820,106,435,627,317;19;M
24493;345,435,1656,52,25,43,245;43;F
24498;51,52,344,820,627,25,1518;42;F
24559;5,347,25,1518;11;M
24561;9,347,25,51,52,820,106,627,1518;47;M
24571;44;44;F
24597;45,6,43,347,90,25,1518,1411,1619,1430;45;F
24604;5,587,433,166,25,106,435,627,317,707;53;F
24609;1518,1411;43;M
24613;166;21;M
24629;583,1148,1430,435,627,317,345,1518,9,593,166,25,51,44,1226;34;F
24633;166;46;F
24647;1422,898;37;F
24648;166;18;M
24652;1518,25;36;M
24666;166;48;M
24673;190,347,348,342,53,106,627,345,1658;33;F
24679;106,344,596,90,589;33;M
24690;589,44,52,1118,53,435,1518,587,1148,190,25,51,344,340;22;M
24705;1411,1430,44,1518;42;F
24708;317,707,345,1658,1058,587,5,1657,1148,106,627,245,90,348,820;30;F
24710;166;74;F
24712;6,1653,1422,43,589,347,90,344,53,820,1058,106,627,317,1518;19;F
24717;820,1058,1518,63,1456,1656,1118,1619,90,1654,1658,1657,62,433,245;71;F
24739;342,340,317,1422,627,1485,1148,1654,347,51,53,820,106,435,707;29;F
24819;166;39;M
24831;1485,25,345,1411,5,348,53,435,317;49;M
24862;51,52,344,342,1118,820,1655,627,62,1657,1658,190,348,340,345;44;F
24883;53,344,52,596,90,347,1653,583,898,5,45,1148,190,340,627;27;F
24887;1058,1148,1658,245,1653,1654,190,90,596,348,342,340,820,106,345;41;F
24948;5,587,1430,1422,1411,583,342,433,45,1654,44,1619,1118,53,820;38;M
24959;433,5,245,1653,1654,190,43,347,919,51,348,1656,820,627,106;65;F
24965;245,345,627,52,190,1653;60;F
24966;43,347,51,53,627,707,587,593,1619,106,919,1456,435,317,345;48;F
24975;62,245,43,51,627,5,820,106,435,317,707;34;F
24985;106,347,90,51,52,53,340,627;16;F
24987;344,347,43,433,5,62,45,245,51,820,106,435,627,317,707;35;M
24990;1485,9,45,593,1430,1148,1658,6,596,822,919,52,820,1058,435;18;F
25020;166;38;M
25023;166;36;M
25039;62,1485,1430,1148,583,190,25,51,52,348,1118,1656,820,345,435;24;F
25043;345;50;M
25044;44,1518,190,344,53,62,627,317,245,25,51,5;32;M
25066;45,1148,1658,583,245,1653,1654,190,90,51,52,1656,340,1655,345;36;F
25078;190,45,5,342,1148,1658,245,1654,1422,340,820,345;38;F
25097;62,1654,51,53,340,627,1148,1658,190,347,90,344,1656,1655,345;43;F
25109;820,1456,45,1658,348,627,345,898,62,589,90,596,51,344,342;47;M
25112;1430,1148,245,348,435,344,342,53,340,820,317,707;33;F
25119;62,106,627,317,190,1654,587,45,245,347,919,52,51,820,1656;35;F
25129;820,25,1518,5;46;F
25138;44,820,1226,52;62;M
25143;1658,245,190,342,820,1456,106;35;M
25146;587,433,5,62,593,1148,245,190,347,53;52;F
25150;435,317;44;M
25157;433,583,5,348,106,627;31;M
25183;433,1658,63,342,317,1485,90,51,52,53,345,435,707;35;F
25232;166,51,45,9,1485,587,5,1654,190,919,820,593,1148,245,43;36;F
25238;190,348,820,106,435,627;48;M
25243;1654,53,1619,347,245,190,90,340,820,1148,1658,1653,1656,1655,345;16;F
25246;1422,190,245,6,1430,62,898,433,90,596,344,1118,587,348,1058;52;M
25249;1148,347,51,52,344,1118,53,820;62;F
25259;1148,245,344,5,190,348,820,106;67;M
25271;53,820,1058,106,627,317,707,1411,1518,433,587,5,9,1430,43;32;F
25284;6,90,344,1619,106,627;61;F
25288;106,627,1148,6,190,43,596,25,919,1118,1656;28;F
25299;166;46;F
25301;1518;37;F
25311;1657,62,245,190,90,340,820,1148,1658,1653,1654,347,1656,1655,627;9;F
25316;1148,1658,1654,347,90,51,340,820,627;49;M
25329;51,344,1118,53,820,106,627,317,5,6,43,347,90,919,52;14;F
25336;340,1118,1619,190,587,25,919,51,1226,53,1058,106,627,707,317;34;F
25338;6,90,25,344,1118,340,106,627,317,707;38;F
25351;820,340;27;M
25352;1430,822,25,52,820,1456;32;M
25356;51,52,348,820,106,317,5,1148,6,245,190,43,919,344,435;25;F
25367;51,627,45,344,190,1654,1658,1657,1148,1653,1656,340,1655,820,345;43;M
25411;347,106,435,627,317;34;M
25426;435,1456,820,347,1148,1654,1653,583,1658,1657,190,1656,340,1655,345;39;M
25428;43,596,344,1118,53,820,1456,106,627,587,593,51,435,317,707;46;F
25434;1518;43;M
25441;1430,1658,245,190,348,340,820,345,1518;38;M
25446;433,435,707;38;M
25485;1653,245,5,62,583,1422,589;35;F
25486;166;50;F
25493;62,1148,1658,347,25,51,344,1655,435,190,340,820,106,627,345;45;M
25641;1485;29;M
25661;433,587,593,1658,190,43,344,1619,53,340,1058,106,627,317,1518;36;F
25673;433,62,593,1148,43,919,52,53,820,1058,106,627,345;25;F
25690;9,1430,25,44,627;40;F
25695;25,822,90,190,62,9,820,51,347,5,6,435,627,317,707;28;F
25721;587,9;49;F
25760;9,1430,1658,25,627;41;M
25776;347,25,1518;9;M
25812;106,627,345,1411,5,433,62,45,583,245,347,1456,435,317,707;37;F
25822;45,707,1518;6;F
25847;1485,1657,1658,342,1656,1518;38;F
25885;1485,190,25,52,348,1656,166,435;32;F
25893;53,1655,820,1456,106,627,1411,5,898,45,190,347,340,345,1658;41;M
25899;822,345,1518,25,1619,348,342,435,627,5,433,9,62,245,44;35;F
25918;340,1456,627,5,45,1148,583,43,347,90,344,348,342,820,1518;40;M
25927;820,9,1148,190,1422,822,342;15;M
25941;245,1654,1422,435,317;45;F
25947;62,45,1658,583,1653,1654,43,822,44,344,342,1656,435,1411,1518;29;M
25951;44;20;F
25957;44;50;F
25960;51,53,1518;9;F
25965;433,587,898,1430,1653,43,25,348,53,820,435,317,707,345,1411;35;M
25969;347,348,1118,53,1411,433,5,1657,344,820,106,627,435,317,707;37;F
25991;45,1430,43,1654,1485;38;F
26000;1518;41;M
26001;587,5,9,1430,583,6,245,1422,25,919,44,348,1118,1456,1518;47;F
26010;245,6,583,45,62,5,1518;51;M
26013;62,347,51,820,106,627,317,53;25;F
26015;898,245,347,106,627,317,345;49;F
26018;1518,317;46;M
26021;1619,1485,245,166,347,51,53,345,348,1148,1653,1656,1655;45;F
26023;45,5,25,9,43,166;30;M
26035;593,6,1422,43,596,25,919,344,342,1619,1118,53,820,1411,1518;52;F
26064;1518;45;F
26072;589,51,1118,1619,1430,593,43,166,347,90,25,53,820,1456,627;40;F
26102;1430,1411;14;F
26119;43,347,596,25,51,344,348,1118,1656,53,820,627,587,345,1657;36;F
26121;5,43,1058,627,1518;47;F
26132;62,1148,43,347,90,820,106,627,51,52,1485,435,317,1619,6;27;M
26165;1118,53,627,317,433,587,1485,1148,190,1422,589,347,820,435,245;47;F
26203;347,1653,583,1658,1485,1148,1654,190,43,340,63,106,627,345,1656;39;M
26237;245,822;59;F
26238;593,45,62,9,5,1148,1653,190,43,347,51,1655,106,627,317;49;F
26250;9,1654,1422,166,53,820,245,25,344,1518;41;F
26289;1619,433,45,1148,583,1653,1654,190,43,347,51,348,342,820,106;32;F
26298;1422,589,1656,707,106,52,25,435,317;23;F
26320;5,44,1118,340,1655,63,707,433,62,45,1658,1653,342,1456,345;34;F
26327;589,347,596,51,1656,627,707,898,1422,52,25,435,317;28;M
26332;593,1430,1657,1658,245,1653,347,25,1456,1058,345;36;F
26339;820,245;31;F
26364;245,43,820;35;M
26366;820;13;M
26424;593,6,245,1654,43,90,596,919,344,342,1619,1118,1456,627,1411;42;F
26434;596,707,51,53,340,433,587,5,583,6,1422,90,1118,820,898;12;M
26443;9;49;M
26445;587,5,1148,245,190,43,347,51,820,1058,106,435,627;40;F
26446;9;53;M
26464;820,898,1658,583,190,43,348,340,1456,435,627,345,1518;35;F
26465;627,340,1456,317;43;F
26504;106,435,627,5,9,62,1430,166,822,51,53,820,1411,1518,25;29;M
26520;9;29;F
26523;9;28;M
26530;1656,53,317,1148,1658,347,51,344,345,106,596,190,348,820,627;32;F
26535;5,1654,51,348,1118,1656,435,627,1148,583,190,43,90,344,820;45;F
26537;1058,435,6,317,245,90,1148,1658,190,347,51,340,106,627,345;44;M
26543;5,583,190,43,51,344,348,1656,820,627,63,435,587,898,25;39;F
26548;1658,245,190,1655,345;35;F
26595;53,820,344,317,435,1518;49;F
26623;5,1148,820,106,627;36;M
26632;245,43,90,347,596,342,1058,1657,1654,583,190,820,1456,627,345;37;M
26633;6,347,51,52,344,348,53,820,1456,317,345,1148,627,106,1518;31;M
26647;627,1657,1148,1658,190,344,342,340;37;M
26656;5,1653,347,51,1656,53,820,106,627,344,1619;30;M
26658;1485,345,1456,1118,1657,1148,1658,1653,1654,1619,1655,627,1656;29;F
26666;62,1148,1658,342,340,345;30;F
26698;583,245,166,347,919,51,1619,1058,45,6,90,52,106,627,317;45;F
26699;433,45,1148,583,1653,1654,190,43,347,51,348,342,820,106,627;8;F
26704;587,593,245,348;34;F
26720;5,898,1657,1148,1658,190,347,51,583,1653,90,345;40;F
26726;433,45,1148,583,1653,1654,190,43,347,51,348,342,820,106,627;6;M
26746;433,1485,245,1654,1422,347,820,106,435,317;34;F
26764;433,6,52,344,1118,1456,106,435,627,317;18;M
26785;433,45,1148,583,1653,1654,190,43,347,51,348,342,820,106,627;4;F
26798;51,106,435,707,342,1485,245,1518;35;F
26815;433,45,1148,583,1653,1654,190,43,347,51,348,342,820,106,627;4;F
26835;589,347,919,348,1655,1456,345,1411,433,587,45,593,1658,1422,342;38;F
26846;1657,1148,245,1654,190,1422,43,90,348,340,1655,106,345,45,1658;47;F
26849;587,593,245,190,919,348,53,820,106,317;56;F
26862;62,45,593,1148,1658,6,1653,51,344,1656,820,106,627,707,345;30;F
26865;166;50;M
26869;345;34;M
26884;9,43,25,820,106,627,317,44;34;M
26885;44;29;F
26892;589,919,51,348,342,1619,340,1655,106,627,1148,583,1654,190,347;33;M
26903;62,1148,245,1653,190,347,51,344,53,820,1058,106,435,627,317;46;M
26932;347,190,43,919,51,344,348,342,53,1655,820,106,627,345,1518;35;F
26946;5,898,1430,6,245,43,90,919,348,1619,1518,9,25,344,166;45;M
26951;898,62,1148,1653,51,340,820,106,627,1657,1654,190,345;37;F
26953;1658,44,707,435,51,43,1653,6,898,25,347,245,190,340,1518;48;F
26958;62,347,43,5,1148,1658,1654,190,1656,340,820,106,627,317,345;38;F
26963;593,1058,435,707;28;F
26968;5,9,6,347,90,822,25,919,1619,1118,317,245,106,627,1518;47;F
26972;51,348,342,1619,1226,1656,340,345,433,62,1430,1456,593,1658,344;41;F
26975;51,106,627,317;49;F
26980;1657,1658,25,435,348,245,1148,1430;46;M
26985;1518;39;F
26999;1619,348,1422,1654,583,1430,593,5,1485,587,245,190,1226,1658,340;41;F
27013;6,317,435;30;M
27017;90,51,820,106,627,317,5,9,1430,43,166,25,344,1518;44;M
27028;1518;27;F
27039;587,433,627,583,245,190,1422,589,919,348,1226,53,1058,435;29;F
27043;1619,106,90,6,317,5,9,245,347,25,919,1118,820,627,1518;47;M
27044;347,190,1653,1658,1148,1657,62,5,106,627,345,51,53,1655,1518;43;M
27052;347,589,51,820,1058,435,317,707,587,1148,43,919,344,1656,627;30;F
27077;1422,106,627,317,898;36;M
27078;5,9,6,245,347,90,25,919,1619,1118,820,106,627,317,1518;18;F
27094;5,9,6,245,347,90,25,919,1619,1118,820,106,627,317,1518;12;M
27106;347,90,919,348,1619,106,627,317;28;F
27109;627,62,583,51,52,344,342,1118,53,820,435,317,347,106,707;38;F
27194;25;29;M
27224;52,1656,340,820,106,627,342,1411,45,53,345,5,1148,1654,43;38;F
27237;433,52,1422,51,1118,1656,1456,106,435,627,317,345,1148,245,1654;22;F
27245;583,25,1456,627,1518;39;F
27263;25,51,344,1656,1655,820,106,345,1148,1653,190,166,627,347,340;30;M
27268;1148,1658,1456,63,707,1411,1518,627,1657,345,106,820,342,822,62;32;F
27312;166;40;F
27325;1456,1518,245,25,5,1485,347,90,820,106,627,317,6,43,344;25;F
27326;1657;42;M
27383;1148,5,43,347,919,25,820,106,317,707,1411,583;38;M
27394;51,348,344,1619,5,6,43,166,347,25,53,820,106,627,317;40;F
27413;342,822,90,6,62,5,190,43,347,25,51,348,820,1456,106;33;F
27442;347,166,1148,1657,1430,62,5,190,43,25,1456,1058,106,627,9;31;F
27471;245,1411,707,63,820,25,45,1148,1653,190,43,1656,340,1655,345;37;F
27477;345,340,707,45,90,5,1654,820,1656,51,627,43,1148,583,589;37;F
27490;1456,63,345,1485,5,45,1657,1658,1654,919,348,342,1656,1655,820;35;F
27493;1518;15;F
27495;433,587,5,9,25,919,820,1619,1518;34;M
27498;44,51,596,6,190,1148,45,9,1658,583,1653,166,822,25,820;42;M
27505;245,583,1658,1148,45,190,919,1226,53,820,627,345;34;F
27506;43,347,25,344,53,106,627,317,919,348;29;F
27523;51,1656,820,627,1653,106,1148,1658,245,190,25,348,340,1655,345;42;F
27524;51,919,90,347,166,43,190,1654,583,1658,1148,593,45,1485,345;57;F
27534;345,707,627,435,106,51,166,190,45,53,1658;37;M
27539;53,347,6,45,587,433,593,1430,245,90,25,919,342,627,1518;38;F
27542;344,90,43,51,52,348,106,627,317,1518;51;F
27556;106,627,898,45,1518,345,820,340,1655,43,1654,190,1658,1148,1657;42;M
27569;433,587,9,6,245,25,1619,1118,820,1456,1058,627,1411,1518;37;F
27570;51,344,1118,1226,1655,1456,820,1058,627,593,587,1657,245,347,345;63;F
27576;44,345,1518,62,51,348;37;F
27590;45,433,5,1658,583,1654,342,820,345;36;F
27591;433,45;42;F
27622;106,345,348,6,43,25,51,52,627,1657,190,347,820;35;M
27631;587,1430,583,25,919,348,44,1518;30;M
27632;25,52,435,627,317,9,1485,44,344,348,820,6,5;39;M
27636;62,45,6,245,1654,347,25,51,348,1619,53,820,1456,627,1518;8;M
27653;245;33;F
27664;433,9,45,6,245,43,347,25,51,1619,53,820,1456,627,1518;5;F
27670;1655,820,1456,707,62,45,433,1657,1148,1658,245,348,342,340,345;34;F
27708;1518;45;M
27725;433,62,583,1654,166,344,342,1118,53,1655,1456,1518,43,25,51;33;F
27732;5,1485,45,1148,1654,43,347,52,344,342,340,820,106,627,345;38;M
27749;589,1654,245,583,1430,5,587,433,45,1148,9,1411,43,166,25;41;F
27792;52,596,347,43,190,1658,1657,898,5,433,1148,345,820,348,340;42;F
27795;1518;35;F
27800;919,1430,593,587;35;F
27801;1658,190,347,348,340,820,106,45,245;47;M
27819;1430,583,5,433,43,90,919,51,348,342,1118,820,1456,166,25;42;M
27908;9;27;F
27917;9;25;F
27922;317,9,5,166,820,435,90,25;43;M
27927;898,6,589,1518,340,106,627,317;15;M
27932;1656;46;F
27939;106,820,5,898,1658,583,190,51,53,340,1655;40;M
27981;1619,898,62,1654,1422,90,347,25,348,340,106,627,317;30;F
27995;25,627,317;50;M
28015;1657,62,1658,6,1654,589,1619,1655;41;F
28027;707,1485,587,62,1430,245,1422,589,25,51,344,1656,53,435,627;37;F
28034;348,52,62,1485,1148,190,43,347,919,51,344,1656,340,820,345;28;M
28061;1485,5,45,593,1148,1658,583,1653,1654,190,342,340,1655,820,345;43;F
28073;1619,342,52,51,919,1654,245,6,583,593,433,166,25,44,707;41;F
28096;317,1058,435,707;29;F
28107;53,1619,51,90,62,9,5,1456,435,1518,43,347,25,348,627;47;F
28108;5,433,1430,583,245,43,342,820,63,9,25,44,166;40;F
28120;707,45,9,62,6,43,90,25,44,51,52,53,820,435,1518;32;M
28122;245,820,1518,1058;35;F
28135;707;33;F
28137;1518,1411,1655,1654,1653,1658,1148,1657,347,344,1656,340,820,627,345;35;M
28148;1619,1656,106,435,627,1518,5,583,6,1654,166,25,51,820,707;33;F
28155;63,707,1411,433,9;31;F
28181;5,898,348,52,53,90,51,344,435,317,707;38;F
28197;1518,45,43,166,25,342,1619,820,1456,1411;33;F
28213;52,344,1456,707,317,627,106,53,44,51,25,90,347,6,45;31;M
28221;25,707,52,90,62,51,1619,53,345,1657,347,348,317,106,627;37;M
28240;9,898,25,344,820,1411;17;F
28250;347,53,106,627,1411,190,245,898,25,340;40;M
28273;317,707,898,1148,583,1422,347,51,348,1656,53,106,435,627;35;M
28304;52,820,90,344,342,1619,627,51,62,5,190,43,347,63,106;51;M
28332;9,166,1654,583,6,25,51,1619,820,1656,627,435,106,707,1518;5;M
28373;25,1411,1518;51;M
28382;587,45,583,1653,596,822,25,52,1619,820,63,707,5,245,1518;37;M
28392;53,5,583,6,166,25,51,820,1619,1656,106,435,627,707,1518;5;M
28396;44,52;48;M
28405;1148,345;44;F
28525;583,106,435,245;40;M
28565;9,44;39;F
28579;245,344,1118,1518;50;F
28597;9;19;F
28604;25,1411,1518;48;F
28609;317,44,5,6,25,627,1518;47;M
28617;166;13;M
28620;62,1657,6,347,51,340,1456,63,106,627,317,707,583,245,345;37;F
28622;1485,1656,340,106,1658,435,627,317,596,433,1422,53,1619;31;F
28633;1148,190,1422,43,51,340,820,63,106,435;31;M
28644;583,1653,1654,1422,347,90,52,1058,5,587,1456,1430,919,1656,820;50;F
28654;6,347,348,820,1456,106,627,707,345,1518,5,62,45,1148,1653;33;M
28657;1657,1658,166,345,6,53,1655,820,63,707,45,106,627,317;36;M
28684;1653,245,6,583,62,5,106,317,1456,345,53,51,433,435,707;30;F
28689;1654,344,340,820,63,106,707,345,1411,587,1657,1658,583,348,342;47;F
28694;1456,1430,245,45,62,1148,1658,1653,190,43,348,340,820,106,345;43;M
28708;583,1422,589,25,348,1118,627,1411;24;M
28711;190,1422,51,52,348,627,587,583,1656;44;M
28721;53,51;26;F
28722;1485,1148,1118,820,627,435;32;M
28728;340,627,106,190,245;40;M
28743;45,62,593,583,245,1653,44,1655;42;F
28747;342,317,898,583,53,340,820,1411;30;M
28749;53,1656,342,589,43,62,898,5,587,583,63,348,435,317,707;38;M
28765;433,587,593,1430,6,245,347,919,348,1226,53,1058,106,435,317;41;F
28769;1654,347,919,317,627,583,245,190,1422,43,589,25,348,1656,53;37;M
28771;340,1518,44;35;M
28788;347,627,5,587,433,45,1430,245,166,90,25;39;F
28789;190,51,1619,340,5,1148,347,344,348,106,627,317,820,53,1655;55;F
28790;587,45,43,589,347,90,596,348,820,627,1518,583,1422,25;42;M
28803;5,43,342,53,820,627,707;43;F
28805;245,25,344,1518;43;F
28818;45,433;40;F
28824;1518,317,627,106,5,9,6,90,51,52,53,435,707;29;F
28838;25,1118,106,435,707,345,51,1411,340,5,53,583,898,1619,342;29;F
28849;433,90,52,348,1518,1411,707,317,627,820,53,342,347,45,51;35;F
28853;317,190,45,5,898,1654,43,25,820,106,6,51,52,53,435;29;M
28870;1148,1430,62,898,9,433,5,587,52,25,348,1456,106,435,627;33;M
28895;589,1653,583,627;39;M
28911;344,348,342,820,435,9,166,90,25;36;F
28924;435,90,347,45,820,583,43,596,340,190,25,342,1118,63,106;40;M
28947;433,25,919,1518;44;F
28971;583,627;12;F
28988;347,317,5,43,822,820,106,627;52;M
28995;898,1422,53,435,317;36;F
28996;1619,52,51,596,347,1422,245,583,45,1485,106,435,627,317,707;39;F
29001;583,627;1;M
29014;1653,62,53,435,627,245,1657,25,5,1148,190,43,348,820,345;57;M
29036;627,820,5,45,433,583,1654,43,44,348,342,53,340,63,106;39;F
29059;9,433,62,347,51,344,1118,820,43,44,1430,348,1456,1411,1518;36;F
29070;347,90,25,51,342,1118,820,1411,1148,348,53,106,435,627,317;28;F
29075;6,347,25,106,627,1518;33;M
29090;53,1226,342,348,596,190,1654,583,593,587,433,1658,820,707,345;32;F
29134;245,43,5,919,820;33;F
29150;5,45,1657,1658,583,245,1656,53,1654,1653,25,52,1411,190,340;40;M
29159;1658,45,1148,583,190,342,1655;32;F
29174;9,898,45,1148,6,52,342,340,63,1518,1485,62,25,1619;36;F
29181;587,1226,1655,1456,5,43,44,820,106,9,25,1518;37;F
29183;1655,62,45,593,583,245,1653,44;12;M
29217;1518;39;F
29230;340,707,1518,317,627,435,106,53,44,51,25,822,347,45,166;38;F
29252;25,627,317;37;M
29268;1655,44,1653,245,583,593,62,45;42;M
29276;25,1619,190,919,51,1655,1058,627,345,1226,433,587,45,593,1653;32;F
29298;1619,433,245,25,348;15;M
29300;1653,190,342,53,1655,63,707,1411,1518,1658,245,348,1656,340,345;38;F
29307;1148,1657,5,1422,25,820,106,435,627,317,51,53;33;F
29324;1655,44,1653,245,583,593,62,45;4;F
29328;587,433,1657,1658,583,1654,1656,1655,1058,345;42;F
29345;9,62,6,43,347,51,44,344,348,820,1456,435,627,317,1518;28;F
29371;245,5,433,898,106,348,190,627,90,1653,51,1148,820;43;M
29390;6,245,106,348,53,627,317,43,344,435,1422;36;M
29413;90,919,1619,62,9,52,344,106,435,627,317,707,1518,6,51;57;F
29427;51,52,106,317,190,43,90,596,344,1118,820,627;46;F
29446;1658;63;F
29458;190,347,25,344,1226,1058,1456,43,51,348,52,53,435,317,707;34;M
29471;589,340,820,1058,63,1456,627,707,1148,1658,583,1653,190,1655,345;31;F
29478;53,1118,348,51,596,347,1422,190,6,1148,62,5,820;36;F
29493;45,9,5,587,317,627,820,348,596,1430,1485,166,90,25,919;47;F
29520;53,627,433,587,1485,6,1422,347,90,25,348,1058,106,435,317;38;M
29524;1653,1656,106,627,1518,345,1655,342,44,245,1658,63,435,317,707;37;F
29532;51,583,1148,62,5,820,342,919,90,45,1658,245,1654,43,345;37;F
29535;5,53,820,106,6,52,344,435,627,317;40;F
29542;1148,106,433,62,53,707,627,1058,1226,348,90,347,1653,245,583;42;F
29547;317,52;35;M
29576;62,1430,583,245,90,1619,45,1654,1118,1518;51;F
29584;9;50;F
29586;820,106,1411,1422,1654,583,1658,1430,62,1657,190,51,348,340,345;43;M
29598;106,596,347,43,344,820;49;F
29602;345,1411,62,45,593,1148,190,347,51,1619,53,5,1658,820,627;40;F
29620;45,433;40;F
29626;1518,317,627,435,106,1058,1456,53,25;26;F
29637;45,62,898,9,1619,1118,820,1058,106,627,1518;49;M
29665;90,435,707,345,1518;37;M
29681;596,5,898,45,1619,1118,53,1058,106,627,1518;11;F
29709;348,435,106,820,627,342,190,345,340,583,1658,1653,1657,1656,1655;7;F
29721;1655,1656,90,898,1485,1658,25,44,342,106,435,317,345,707,1518;4;M
29729;90,344,1619,820,345,1518,52,1656,53,317,627,51,6,347,106;46;F
29730;1653,919,1118,820,5,245,190,51,344,627,707,53,347,1148,1656;49;F
29735;1657,43,347,344,53,1148,1658,583,1654,190,52,340,1655,820,345;32;M
29748;345,707,106,435,347,589,5,587,820,344,90,43,1654,919,1619;53;F
29756;45,583;43;F
29757;45,1657,51,340,345,1658;36;F
29767;1655,106,435,345,340,45,1658,245,919;42;F
29771;347,45,1485,5,106,1148,583,1654,190,1655,345,340,1657,1658,1518;39;F
29773;1654,919,1658,583,1518;41;F
29781;1654,1657,587,583,340,1058,345,1658;49;F
29784;43,596,919,51,342,1619,1118,53,340,820,1456,627,593,898,1658;39;F
29785;627,1411,45,62,898,5,345,340,51,919,190,1653,583,1658,1148;39;F
29788;1657,1148,342,1655,63,106,1654,1058,1658,583,190,43,340,820,345;36;F
29792;90,707,898,583,53;36;M
29802;1058,919,52,348,1226,435,707;51;F
29805;6,348,919,5,898,1148,190,43,347,51,340,820,106,627;47;F
29808;6,245,627,43,25,1518;44;F
29818;5,1658,190,43,348,340;48;M
29828;898,1485,5,433,45,583,245,1654,190,347,25,344,348,340,317;39;F
29839;45,62,898,9,587,1656,53,433,5,90,25,919,820,627,317;55;F
29848;5,433,342,1655,51,1657,1658,190,347,919,340,820,106,345;34;F
29855;51,1226,106,1411,1654,190,342,1058,345,433,45,1430,1658,583,1655;43;F
29856;1658;38;F
29862;1658;38;F
29869;245,347,1656,53,106,627;32;M
29888;345,707,435,1058,587,1658;45;F
29891;433,1656,106,345,5,1148,245,190,820,627,1658;44;M
29907;45,1148,245,347,90,25,435,190,43,52,51,344,820,317,707;32;M
29911;587,45,593,245,190,1422,43,53,820,345,1658;47;F
29914;1619,627,1430,25,106,1518,433,587,43,589,1456,1226,919,6,245;47;F
29921;1422,190,1148,1430,45,245,1654,43,347,51,1656,53,340,106,1658;41;M
29922;1658;39;F
29923;820,627,9,1485,317,25,5,898,6,90,51,52,53,435,707;38;M
29934;342,5,898,1619,1422,627,53,90,51,52,245,435,317,707;38;F
29937;6,919,51,587,593,245,1422,347,90,344,348,342,1118,345;63;F
29941;5,6,25,51,344,1619,348,53,820,106,627,317,433,190,347;42;F
29952;1518;8;F
29956;344,435,1430,51,52,53,106,317,627,340,345,245,820,348,1658;38;F
29960;344,348,1118,1656,340,627,345,1411,583,1658,45,898,1430,53,1456;46;F
29980;433;43;M
29988;1658;28;F
30001;1653,190,25,820,627,1148;46;M
30008;245,190,919,344,348,106,627,317;25;F
30019;1518;2;F
30038;1657,1656,1655,1654,1653,1658;44;F
30041;348,53,317,627,106,344,51,90,347,1148,5,190,340,820,345;46;F
30049;1658;39;F
30050;583,627,245,707,90,52,348,53,106,317,51,898,1619,6,435;38;M
30062;345,1658,593;35;F
30065;593,589,342,340,820,1411,1619,583,245,433,45,1430,1658,1654,1118;36;F
30066;1658;43;F
30069;106,707,340,1485,45,1148,190,820,435,317;35;M
30093;344,53,317,5,1485,166,347,90,52,1619,820,106,627,43,822;45;F
30096;348,1658;39;M
30097;433;45;F
30100;344,919,43,190,45,9,1485,1118,820,1658;42;F
30110;25,1653,1658,593,898,587,433,1430,583,1422,589,348,1058,1411,707;28;M
30114;347,589,245,433,583,596,52,820,51,1148,190,435,707,627,317;70;F
30120;348,342,53,820,627,317,345,433,9,45,583,43,166,25,1456;41;F
30128;583,245,190,344,342,340,45,433;35;F
30132;596,589,43,1422,1658,1148,593,45,62,1430;49;F
30138;245,1658,1148,898,1485,5,433,62,1430,347,348,1619,1226;49;F
30139;51,53;29;F
30151;433,587,45,593,347,919,51,344,1226,1456,1058,345,245,106,1658;35;F
30153;345,627,340,1422,1653,593,5,587,45,583,245,43,51,348,63;48;M
30155;348,1118,1226,433,45,435,1148,820,51,106,1422,6,627,5,1619;36;F
30164;340,820,106,627,433,587,1148,245,1653;52;M
30171;190,1653,583,1148,593,587,433,62,45,1430,1658,245,342,1656,345;33;F
30177;347,1654,245,62,5,433,43,919,51,52,344,348,820,627,1518;17;F
30210;190,51,53,1518,1655,348,342,344,90,6,1657,45,919,345,1658;47;F
30229;347,822,51,52,53,106,627,317,820,340,43,1422,190,1485,435;32;M
30239;1430,62,898,5,593,1658,6,190,43,25,919,51,53,1226,1058;27;F
30244;1456,1619,1485,1430,1422,344,1118,106,435,317,627,1411,707;30;M
30261;53,1656,51,347,43,1422,190,1653,898,348,583,25;22;M
30266;53,820,348,51,919,347,43,1422,245,6,62,106,317,627,1411;50;M
30271;1658;48;F
30296;1430,347,51,344,348,1226,1058,106,627,1518;47;F
30315;5,820,435,1148,190,587,627,106,348;65;M
30343;593,587,433,51,348,342,1058,919,317,707;30;F
30363;627,317,43,51,342,1655,340,63,435,1654,190,1422,25,348,820;38;M
30377;53,1456,25,919,44;37;F
30418;1518,627,435,51,25,596,9,5,587;54;F
30493;593,245,53,1656,1655,1058,919,1148;38;F
30496;1656,1619,51,347,593,1485,587,433,1430,1654,344,348,820,106,317;33;F
30502;1619,90,6,1118,44;45;F
30512;433,583,1654,344,820,627,1518;34;M
30537;43,820,1485,5,347,90,51,52,344,53,106,435,627,317,707;33;F
30563;1658,1657,342,1118,340,345;31;F
30571;1430,583,6,90,25,51,344,1619,1656,53,820,435,627,707,1518;46;M
30589;45,62,9,5,587,1518,245,43,25,51,342,53,820,1456,627;61;M
30597;44,6,1118;49;M
30616;9;22;M
30617;820,106,317,5,587,433,593,6,245,43,52,348,25,44,707;30;F
30673;62,5,433,190,90,25,51,1619,53,340,1456,627,707,45,1658;37;F
30715;587,43,435,317,62,1148,1653,347,25,51,340,627,345,1518,1655;49;M
30725;25,583,45,1148,1654,190,1656,1655,1657,347,51,1619,345,106,627;40;F
30726;898,1148,583,1653,1654,1422,51,344,340,627,345,1658,1657,190,52;41;M
30754;433,45,62,5,9,1148,190,43,347,90,25,51,1656,340,820;51;M
30760;1658;7;F
30769;52,1656,627,1148,820;73;F
30785;1148,342,345,51,820,433,45,1657,1658,583,245;29;F
30791;106,43,1655,1148,583,245,1653,190,347,820,627;42;M
30813;345;31;F
30822;347,51,53,820,317,245,43,822,25,348;65;M
30846;43,90,919,51,52,348,1058,106,317,707,435,593,587,245;52;F
30861;1619,583,62,587,433,593,1430,1658,245,348,1226,1456,1058,707,345;32;F
30862;5,6,43,90,345,1456,707,1619,1656,317,62,347,51,106,627;12;M
30882;106,627,5,43,51,435,317,707;32;F
30894;1518;14;F
30895;898,317,707;47;M
30912;9;26;M
30916;1658;33;F
30919;1518;39;F
30922;245;69;F
30932;1518;5;F
30936;1518;17;M
30945;1518;3;F
30987;52,51,90,587,1148,5,43,62,627,317,347,1656,53,820,106;32;M
31012;1411,317,53,1619,820,707;33;M
31030;1226,627,345,1411,433,1430,583,51,344,317,707,348,1456,1058,435;35;F
31052;1653,1655;48;M
31086;245;54;F
31098;45,1485,5,433,587,593,1422,919,53,1226,106,627,1058,435,707;51;F
31111;822,25,44,348,106;45;M
31115;245,43,596,344,1118,1656,820,345;49;F
31126;1658;37;M
31138;43,347,919,344,106,627,317,1148,190,245,51,340,820;42;F
31158;1658,245;55;M
31224;1430,1411;42;F
31225;62,45,1148,1658,1656;42;F
31236;166,919,1118,106,5,45,1148,43,90,822,51,344,342,1619,820;48;F
31247;587,62,45,593,583,6,245,347,25,919,51,53,627,1518;9;F
31262;707,589,347,62,1430,593,245,25,919,627,1058,1518;47;F
31275;190,1655,820,1658,166,345,340;49;M
31283;1658;46;F
31310;5,435,627,106,53,51,43,9,347,919,1656,317;28;F
31363;435,707,1658,583,1653,347,342,1656,1655,345;37;M
31377;1485,435,820,166,5,9,25,627;24;F
31384;820,1058,63,435,627,317,707,1411,1518,587,583,919,52,1456,106;31;F
31387;1422,43,347,822,51,820,106,435,627,317,1411;32;M
31398;1619,1411,433,898,1658,245,589,919,1118,348,340,1058,106,345,627;19;M
31411;90,166,245,5,45,1148,1658,583,190,43,347,51,344,1619,820;43;F
31412;1654,245,1657,5,9,62,45,1653,347,51,53,820,106,627,707;46;F
31414;593,45,245,51,1411,435,106,1655,1118,348,589,43,190,1653,1656;19;F
31422;245;47;F
31424;587,5,9,593,25,52,1058;49;F
31429;898,1518,583,1654,1422,25,52,1619,53,340,820,106,435,317,707;41;F
31436;9;24;F
31448;62,347,52,53,190,596,25,344,348,820,627,317;41;M
31455;596,45,62,90,587,593,583,6,245,347,25,919,51,627,1518;7;F
31478;1411,43,5,1485,45,1658,820;43;F
31479;340,347,1654,106,919,627,345,1658;47;F
31490;1658,348,1411,707,317,53,43,583,5,9,45,1657,1148,919,1456;41;F
31494;190,344,342,53,1655,45,583,1653,43,822,25,44,348,707,1411;39;M
31495;340,1658,190;42;F
31515;1456,707,1226,587,62,593,583,245,347,596,919,1619,53,627,1518;58;M
31516;5,9,43;52;F
31518;5,1658,6,190,90,1656,53,106,317,627;37;M
31541;342,596,583,593,45,433,587,898,6,51,52,53,435,707,1518;8;F
31557;919,43,593,62,433,5,587,344,348,342,1118,53,820,1456,1518;26;F
31561;245;58;M
31577;898,583,1658,6,51,52,342,1226,53,1456,1058,435,317,707,1518;5;F
31594;347,51,348,1619,345,1658;40;M
31607;5,1430,1657,1658,583,245,1654,919,344,348,342,1655,820,1456,707;36;F
31613;1485,5,1148,190,589,51,348,53,340,1655,820,106,435,345,1658;48;M
31618;166;35;M
31637;820,190,347,51,106,317,627,345;52;M
31640;1430,583,6,25,51,52,342,1118,1226,53,1058,435,317,707,1518;38;M
31706;348,1619,25,166,43,245,1430,9,5,587,433,919,820,1411,1518;50;F
31720;9;39;F
31731;43,44,348,627,317,1518,25,9;44;M
31757;52,344,1226,1058,347,44,348,53,435,317,1653,51,1656,106,627;50;F
31760;190,433,43,51,348,1619,820,627,5,9,45,1422,166,25,44;38;M
31776;51,9,25;21;F
31779;433,6,347,51,106,627,317;32;M
31792;1456,627,433,45,245,43,52,344,1619,1656,820,106,435,317,707;36;M
31797;62,1148,344,53,820,106,190,43,347,51;47;M
31811;51;26;F
31870;820,1422,6,593,62,5,1655,1456,317,245,1653,43,347,106,627;61;F
31874;25,90,1148,45,5,340,63,707,345,342,587,1485,1430,245,1518;44;F
31909;245,348,53,433,9,5,45,1422,43,166,25,44,342,820,627;37;F
31933;5,1657,1148,1658,1653,1654,190,90,342,340,1655,820,106,627,345;41;M
31943;90,342,345,627,106,820,340,190,1654,1653,1658,1148,1657,5,1655;7;M
31948;5,1657,1148,1658,1653,1654,190,90,342,1655,340,820,106,627,345;41;F
31989;1658,1485,340,166;30;M
32002;435,317,9;30;M
32080;1148,62,9,317,627,435,106,820,1118,348,51,596,347,1430,5;44;F
32100;1422,43,347,90,52,53,627,5,9,6,25,919,51,344,820;44;F
32112;190,1653,583,1148,593,45,1657,245,919,342,340,1655,345,1658,1518;37;F
32113;53,51,596,1430,45,62,9,1657,1148,1658,1654,190,43,348,342;34;F
32152;820,348,1148,5;43;F
32192;1658,1118,1655,820,707,587,1148,583,245,342,1656,345;38;F
32241;340,106,820;46;F
32261;1658;62;F
32320;1456,1518;44;M
32349;51,344,340,1456,1058,345,45,593,1657,1653,190,348,587,1655;44;F
32352;1518;7;F
32358;1518;47;M
32388;1518;46;F
32403;1518;15;F
32415;45,593,1430,589,1518;4;M
32418;707,106,347,245,25,344,1118,53,317,596,1422,583,90,627,1518;39;F
32419;1655,53,51,190,1654,1148,898,62,1430,1658,583,25,627,340,345;41;M
32423;1518;10;M
32441;51,166,6,62,587,25,919,1118,627,589,347,52,344,820,1058;21;F
32449;1518;39;F
32459;1518;9;F
32470;1518;4;M
32501;1518;39;F
32523;51,1619,627,1518;30;F
32551;166;38;M
32566;820,347,1148,9,1485,5,190;45;M
32568;45,43,583,245,25,44;37;F
32599;1430,919,348,342,1118,1058,627,707,5,433,62,593,53,435,317;30;F
32602;1411;24;M
32608;820,45,1657,1148,1658,245,190,347,348,345;33;F
32626;245,347,345,1657,1148,1658,190,348,820;35;M
32633;1411,44,5,45,1657,583,245,1654,190,43,348,1656,53,340,345;40;F
32640;62,898,593,1430,6,347,90,51,52,1226,53,435,627,317,707;29;M
32662;1518;5;M
32669;1430,1518;41;F
32688;707,317,1619,344,52,347,6,5,1148,190,43,51,53;21;F
32704;45,43,51,344,820,1518;34;F
32706;596,347,6,593,1118,53,1456,1058,627;65;F
32724;1430,1148,583,6,190,90,596,51,52,344,1118,53,820,106,627;24;F
32728;1518;44;M
32775;348,106,25,707,44;40;F
32858;593,1430,6,1422,589,44,435,627,433,919,1118,53,1456,1058,1518;38;F
32868;25,919,53,317,707,1518;43;F
32891;1653,583,340,166;42;M
32901;25,44,1619,1655,820,1518,433,587,593,90,342,53,1456,345,707;32;F
32920;344,6,9,25,44,1518;47;F
32957;62,583,245,589,1654,347,596,51,52,344,53,106,627,317,1518;45;F
32980;1654,6,1430,45,1485,9,5,317,627,820,348,43,166,25,435;40;F
32994;1430,1518;10;M
32999;348;27;M
33003;707,344,1653,245,583,1658,45,62,433,342,1656,1655,345;33;F
33011;5,820,52,43,347,51,106,53,627,317;32;F
33021;62,1430,583,245,1654,43,347,919,44,1118,53,820,1058,627,1518;34;M
33025;45,433;61;F
33045;433,5,9,45,1430,245,1654,43,919,44,1118,53,820,1058,1518;10;M
33062;1656,45,433,62,1658,583,1653,245,344,342,1655,707,345;3;F
33068;45,1654,25,919,820,1456,627,1518;42;F
33083;433,25,344,820,627;22;F
33097;45,62,9,587,1518;9;F
33104;1518;44;M
33107;347,51,348,106,317,627;36;M
33126;317,1456,1619,348,25,1430,5,898,6,90,51,52,53,435,707;31;M
33139;45,190,347,596,52,344,1118,53,1655,627,1518,106,25,51,348;50;M
33179;707,1655,1656,1619,44,433,1658,45,245;42;F
33183;45,1148,1658,43,52,344,627,596,90,245,5,347,919,1619,820;56;M
33186;43,25,1619,1518,6;63;M
33200;898,53,347,43,342,317,707;36;F
33207;348,344,51,43,1654,583,593,433,347,25,1518;38;F
33208;433;33;M
33210;45,190,106,342,245,820,1654,348,1658,1148,433,583,593,1653,90;22;F
33214;45,190,43,347,90,44,51,348,1619,1118,53,820,627,62,245;30;F
33219;51,1619,435,53,106,627,317,345,45,190,52,344,1656,63,707;30;F
33225;347,627,348,1518;52;M
33226;348,342,820,1456,63,106,435,627,317,707,345,1411,1518;38;F
33306;587,433,583,822,348,342,63,345,1518,6,898;36;M
33315;45,9,5,190,822,44,52,1656,340,1655,820,627,707,345,1518;41;F
33321;51;1;F
33327;345,1658,820,707,1655,348;33;M
33346;433;41;M
33351;245,1422,25,44,342,345,707,1518;53;F
33371;1656,1148,627,345,342,245,1456,820;24;M
33376;627,1485,190,347,340,317,5,898,6,90,51,52,53,435,707;27;F
33383;822,25,51,344,53,1655,820,63,627,345,9,43,44,52,1518;55;M
33391;587,593,1518;45;F
33416;190,1654,6,583,43,25,348,342,627,435;41;F
33417;1656,106,435,190,1654,245,45,627,344,820,5,1658,1657,340,345;37;F
33418;1411;39;F
33419;52,51,190,5,347;36;M
33423;433,1619,106,5,347,51,342,820,627,1148,190,43,348,340,1655;37;F
33437;52,1148,1658,340;43;M
33478;1653,583,1658,166,340;50;M
33486;820,627,898,593,583,342,5,1485,317,435,707,1654,52,1456,106;41;F
33493;166,44,344,1485,5,1656,1430,9,245,43,25,820,1456,1518,627;48;F
33499;898,53;9;F
33520;1654,190,589,25,1422,1657,1658,898,345,1655,344,596,1653,583,1148;25;M
33525;45,1422,43,53,340,1655,820,190,25;53;M
33540;51,596,90,62,898,1485,5,627,106,1456,587,348,53,1058;27;M
33559;433,587,593,1430,1658,583,43,90,25,348,820,435,627,1411,589;32;M
33570;587,1518;45;F
33577;587,1518;44;M
33584;707,6,245,1654,1422,44,583,52,25,43,45;40;M
33586;1430,347,90,435,317,9,62,51,52,348,53,627,433,43,1518;44;F
33598;1430,1148,6,1654,820,1518,344,190,245;51;F
33602;587,45,1657,1658,1654,1422,25,52,1226,345,919,593,433,583;32;F
33626;435;34;M
33629;433,1657,6,1653,347,596,919,52,344,53,106,627,317,707,583;16;F
33639;1430,1657,348,345;41;M
33641;587,433,1148,583,245,190,348,342,1656,340,435,627,317,707,1518;29;M
33644;166;37;F
33646;5,9,587,245,166,90,25,1619,1118,1518;36;F
33656;25,317,820,245,347,51,348,106;50;F
33676;106,317,245;65;M
33693;433,45,43,347,344,5;45;M
33712;1456,1655,1619,347,43,190,1654,1653,1485,898,1658,344,340,820,106;40;F
33715;1658,1456,340,90,1657;42;M
33740;1430,245,433,5,45,344,820,627,1518;53;F
33781;1654,820,1226,53,340,435,345,1148,1658,1653,90,344,348,433;39;F
33786;45,6,51,52,342,53,435,593,43,90,344,820,106,317,5;39;M
33800;919,1118,1656,1655,820,345,1430,1148,190,1422,25,51,348,340,53;38;F
33833;9;16;F
33844;919,25,596,90,347,593,344,1058,106,627,317,5,51,1118,6;20;F
33851;820,345,627,106,53,344,51,90,347,43,190,340;39;M
33872;1148,1653,190;56;F
33887;9,898,583,43,25,44,53,820,627,317,1518;43;M
33903;1430,1657,1658,245,51,52,342,820,1456,1058,63,106,435,317,707;32;F
33957;919,51,52,344,348,1226,53,820,1058,106,435,627,317,1411,1518;47;M
33969;6,347,51,344,348,627,317,583,106;32;M
33977;1118,1058,820,51,1148,5,9,1485,6,317,90,44,43;43;M
33983;1657,1658;33;F
33995;106,62,596,344,340,435,627,1653,190,43,347,51,348;38;M
34009;5,1658,1654,348,820,1518;35;F
34017;5,9,43,25,106,1518;37;M
34022;340,51,90,347,6,583,1658,1485,433,62,45,245,190,589,106;35;F
34037;348,627,245,1430,433,106,317,1485,1148,190,25,51,820,435,1518;29;F
34044;348,106,627,53,820,898,90,435,317,707;37;F
34058;1654,190,340,345,1148,820,1657,1658,342;39;F
34062;344,106,596,820;42;M
34064;6,433,587,5,9,62,45,166,347,90,25,1619,245,44,1518;43;F
34070;1653,1654,190,25,340,1655,820,106,435,317;42;M
34081;5,9,6,44;38;F
34091;347,106,627,6,317;39;F
34099;707,51,53;33;F
34101;25,51,344,1619,1456,627,707,587,433,898,45,593,1430,820,1518;47;M
34103;245,62,342,90,1619,43,63,5;34;M
34134;433,587,593,245,347,51,53,820,1518;39;F
34140;340,52,25,433,62,583,6,43,596,51,344,1118,53,820,1518;44;M
34165;5,1148,1658,1654,43,106,347,51,245,190,348,627,340,820,345;44;F
34183;90,44,344,435,317,347,51,348,53,820,1518,627,5,9,25;38;M
34195;106,1619,348,51,347,589,43,1422,190,1658,1148,340,1655,345,245;28;F
34218;433,5,51,44,9,43,90,596,25,52,344,348,1118,1655,1518;32;M
34233;596,166,1654,245,6,1148,9,5,347,43,45,820,1619,627,1518;40;F
34235;62,587,1658,1654,347,51,52,53,340,106,345,583,190,344,627;38;M
34242;245,43,589,51,52,348,340,820;51;F
34259;342,340,820,63,106,435,627,1518,1619,5,52,53,51,317,707;33;F
34260;1148,190,347,51,52,1485,53,340,820,106,435,627,317,707;29;F
34310;9,25;44;M
34311;345,1411,1518,62,898,583,1654,1422,51,1456,106,707,317,435,52;37;M
34334;53,340,90,589,1654,190,1422,6,1657,898,348,1456,106,51,345;29;M
34352;52,106,53,317,707,51;37;F
34356;587,1148,45,583,190,347,44,1619,340,106,627,345,348;45;M
34365;1485,1148;72;F
34370;1518;43;M
34381;1658,1657,1656,1655,1654,1653;40;F
34442;583,245,1653;39;F
34462;627,317,707,106,919,25,347,587,1485,5,1148,190,51,433,45;38;M
34486;1148;47;M
34505;1148,25,348,345,1658,340;48;M
34511;348;51;M
34528;583,898,45,1657,1148,1658,245,190,43,344,340;39;M
34562;9,43,25,1518;47;M
34570;1430,919,1226,1456,348,587,25;42;F
34572;347,25,919,1456,1058;42;M
34581;342,1118,53,820,1058,627,1518,90,347,43,898,9,5,587,433;44;F
34582;593,6,43,347,919,344,342,1118,1656,53,820,1058,627,317,1518;43;M
34592;245,166,25;42;M
34603;5,1657,1148,6,1653,190,43,347,25,51,348,340,820,106,627;31;M
34616;25,1518,1658;39;F
34655;587,1485,898,43,90,919,51,344,1619,1656,820,106,435,627;36;F
34691;317,707,1518,433,6,51,1656,106,190,43,25,245,627,347,1653;48;M
34695;898,166,25,51,344,45,5,1485,347,820,106,435,627,317,1430;32;F
34728;1518,1430,587,433,44,245,1118,1411,9,1619,6,5,90,166,25;34;F
34737;348,1226,53,627,433,1430,1619,820,1456,1058,1518;44;F
34784;820,106,1485,1430,1657,1148,1658,583,1653,190,919,340,1655,435,345;44;F
34789;6,1654,25,344,1518;46;M
34815;1518;15;F
34816;707,344,25,1422,1485,190,340,1655,345,245,63,1656,44,820,51;35;F
34821;1518;13;M
34829;707,43,596,45,627,435,106,340,348,51,190,6,1148,5,347;56;F
34831;1518;8;M
34837;190,43,589,25,919,51,52,344,348,1619,1118,1656,820,106,317;25;F
34861;1518,5,6,25,344,44;37;M
34873;43,1658;40;F
34934;1518;43;F
34941;5,1148,245,1653,190,43,347,25,51,344,340,1655,820,106,627;34;M
34947;345,63,1058,1655,245,45,344,53,435;37;M
34948;25,53,106,435,627,317,5,9,1430,1422,51,52,1656,820,245;22;F
34952;245,1422,589,822,25,340,1058,627,1518,1118,820;30;F
35030;1148,1226,348,53,106,317,1518,62,593,1653,190,347,25,51,627;45;F
35067;583,1654,51,348,340,1657;47;F
35070;342,1422,583,1657;38;F
35082;342,1656,1655,345,1657,1148,1658,190,43,347,340,1058;36;F
35086;348,435,1411,317,707;44;F
35111;52,25;39;M
35114;1657,45,6,347,90,51,52,344,1118,53,820,106,627,317,707;39;M
35115;190,627,587,90,25,1656,820,1518;38;F
35124;1619,1058,5,433,587,593,1657,1148,1658,245,1653,919,340,1655,345;40;F
35127;25,53,627,1518;46;F
35141;347,90,51,52,348,820,898,583,344,53,106,435,627,317,707;32;M
35156;345,51,62,583,53,898,1658,1422,589,44,317,1518,245,587,707;31;F
35173;43,245,62,433,5,45,1657,1148,1658,348,53,1655,820,1456,627;38;F
35175;1518;42;F
35179;340,1655,345;46;F
35195;820,106,627,43,5,1148,166,51,52,344,348,1456,435,317,707;40;F
35207;1518;7;F
35215;435,345,1518,587,62,45,245,43,347,25,52,106,627,317,707;39;F
35231;1518;5;F
35232;53,1430,6,245,347,106,317,707;39;F
35237;820,9,1518;47;M
35324;1148,1422,53,340,345;39;F
35365;593,245,90,919,1456,106,627,1658;37;F
35366;90;41;M
35369;1518;38;F
35401;583,1430,5,433,9,1148,245,43,589,822,348,1226,820,1456,1058;38;F
35407;1518;32;M
35428;1518;7;F
35442;1411,1518,433,587,1485,593,1430,43,596,25,1118,348,435,317,707;42;M
35449;1518;38;F
35476;1518;3;M
35493;1657,44,51,190,583,898,348,53,1655,106,627,317,345,1518,340;24;M
35503;707,5,1148,1653,347,822,51,52,348,53,820,106,435,627,317;52;F
35531;1656,583,1653,106,51,627,340,1657,345,820,348,1658;40;M
35534;1518;38;M
35540;347,435,1653,1148,1485,596,1226,1411,627,106,1058,1456,1118,583,1430;24;F
35581;1518;8;M
35607;1518;32;F
35661;25,344,919,52,348,1619,1226,1655,820,1456,1058,627,345,106,1658;50;M
35691;53,820,63,707,345,627,1655,344,919,43,583,1658,1657,45,62;34;F
35697;347,90,52,344,627,62,1148,190,43,589,51,820,106;20;M
35724;245;50;M
35767;340,1411,345,317,627,435,106,433,587,62,593,1430,245,348,1456;35;F
35787;1653,25,53,820,317,45,1148,1654,190,51,52,1656,340,106,627;43;M
35803;587,1657,1619,1656,1655,45,593,1658,342,340,707,345;34;F
35806;245;14;F
35813;5,587,9,45,245,1654,1422,43,25,919,44,344,433,583,1518;36;F
35817;5,435,583,190,348;33;M
35829;898,587,9,1430,583,245,589,52,348,342,106,435,1411,166,25;43;F
35838;245,317,627,106,820,1655,340,1118,583,190,596,25,51;13;F
35906;1485,245,1619,317,627,435,820,347,190,1430,1148,25,106;50;M
35909;6,347,90,51,52,344,340,1655,627,62,63,106;40;F
35942;627,345,90,43,1658,9,5,340,1655,1653,347,52,1656,1148,435;47;F
35947;9,45,1658,347,51,44,348,342,340,820,106,1518,317,627,1653;42;F
35957;5,1148,1658,6,1422,43,348,1656,53,340,106,627,317,1411;24;F
35963;5;39;M
35971;1518;43;M
35974;1654,583,593,166,25;43;F
35975;345,583,1658,1148,1430,106,317,51,435,25,344,348,53,1456,627;36;M
36012;1658,1657,9,90,43,1653,583,5,1058,435,627,317,190,51,53;35;F
36067;1518;45;F
36071;53,106,51,45,190,345,340;48;M
36073;1653,1430,1485,245,348,1654,589,90,1456,106,62,583,596,63,1058;42;F
36146;1456,53,1656,348,52,25,43,1422,1430,1485,5,433,593,587,919;43;F
36205;25,347,62,9,433,45,51,348,53,1655,820,627,1456,44,1518;44;M
36210;347,627,317,1518,1058,53,344,44,166,1653,587,245,90,25,51;31;F
36234;435,51,25,190,820,5,9;48;M
36286;919,348,627,1653,245;67;F
36322;583,245,52;37;F
36348;433,583,1653,53,707,45;40;F
36350;1657,347,589,44,53,1655,106,627,433,245,1653,190,1456,345,51;39;M
36364;583,106,589,25,919,344,53,347,43,593,587,627,317,1411,1518;22;F
36384;43;46;M
36400;5,347,51,53,1518,62;49;F
36409;1657,1658,1653,1654,1656,1655;44;M
36411;45,627,106,347,5,51,344,53;42;M
36431;25,1118,1058,52,344,53,587,5,9,245,589,1619,820,1456,627;52;F
36450;6,52,898,5,1485,62,245,43,25,51,53,435,317,707,345;30;M
36454;52,433,1118,627,344,53,342,589,347,90,25,348,340,820,106;48;M
36502;43,627,820,106,5;48;F
36505;317,820,44,51,62,347,106,627;38;M
36531;340,166;21;M
36570;1411;64;F
36602;52,820,345,53,348,344,51,190,898,583,1422,347,90,340,106;25;M
36603;898,433,1118,1411,90,5,347,25,52,344,348,340,106,627,1518;14;M
36631;433,587,593,1430,1148,245,1653,919,344,348,1226,53,820,627;50;F
36662;1422,53,1456,106,627,45,51,5,43,25,245,820,433,6,1518;36;M
36674;1658,583,190,1422,589,90,596,51,52,344,348,1619,53,340;45;F
36702;1411;42;F
36715;1148,190,344,45,6,43,90,1118,820,245,348,340,106,627,1518;49;F
36722;1658,583,245,1422,348,342,1118,1656,1655,1456,1058,63,707,345,1518;39;F
36725;1411;40;M
36764;587,919,44,707,63,1656,1657,45,898,1658,1654,190,340,1655,345;40;F
36768;43,1658,583,190,52,106,820,51,919,596,90,347;48;F
36787;347,51,106,627,317,587;53;M
36820;1148;14;M
36843;898,587,1658,583,1422,347,90,596,344,348,1656,53,340,820,345;12;M
36877;106,5,1518,190,6,25,345;51;M
36899;43,347,822,25,44,52,1619,1655,9,245,51,820,344,435,1518;47;M
36902;1422,190,1654,245,898,593,583,347,919,51,340,820,1058,106,627;44;F
36907;52,106,627,317;49;F
36909;106,627,583,347;43;M
36916;1148,190,43,51,52,344,348,1118,53,820,106,435,627,1518;50;F
36918;62,245,1654,190,1422,347,1619,340,1148,348,25,820,627,345;43;M
36924;1653,45,340,820,898,347,90,596,51,52,344,348,345,53,627;51;M
36937;1058,63,106,627,1657,1148,1658,190,344,1226,340,1456,707,345,51;47;F
36946;433,587,9,62,1430,347,25,51,44,53,820,1456,627,317,1518;41;M
36971;1657,587,43,347,1655,1456,435,627,317,707,5,433,245,919,822;48;M
36973;587,589,51,344,348,820,1456,106,345,5,62,583,63;31;M
36987;90,344,1226,1058,106,317,1518,45,593,245,43,25,919,52,820;42;F
37019;583,1148,245,1653,43,347,90,51,52,342,1656,53,1456,1058,106;68;F
37027;583,1653,589,1656,53,1411,707,317,62,347,596,52,1456,106,627;19;M
37066;25,820,106,627,1518;50;M
37098;245,25,627,1518;43;F
37099;106,627,345,90,62,245,1518;49;F
37103;166,340,1518;39;M
37121;245,106,627,587,919;40;F
37132;1658,1430,62,5,45,583,347,51,348,342,53,820,106,317,707;34;F
37153;347,25,919,51,106,435,627,317,345,1518,1485,1430,1148,190,340;49;M
37165;5,1619,43,51,52,344,348,53,340,106,6,435,627,317;26;M
37197;245,583,45,62,898,5,1653,342;44;F
37202;347,596,90,919,51,52,1619,1118,53,1456,106,627,317,707,1518;13;F
37211;433,190,6,1148,1658,1485,587,5,245,90,820,106,435,627,707;40;F
37217;1411;68;F
37235;1148,822,919,51,435,627,317,707,345,1518,5,45,43,347,820;37;F
37265;62,593,347,51,52,53,345,627,106,587,1226,1058;39;M
37277;245,1655,435,5,51,52,106,317,345,190,43,347,90,583,627;44;F
37284;25,106,317,43,822,1619;45;M
37317;433,587,1485,596,51,820,1148,583;31;F
37331;190,1654,1658,433,45,1148,583,245,1653,52,344,1656,340,1655,820;31;F
37339;435,53,51,6,62,245,347,25,106,627,317;23;F
37360;1422,593,347,52,106,627,583,1657,190,245,43,51,348,340,820;40;F
37423;1411,1430,6,348,25,5,898,51,53,106,90,52,435,317,707;38;M
37473;433,1456,583,245;42;F
37513;707,435,52,245,1658,51,344,317,345,62,190,347,820,106,627;31;F
37548;1518,820,166,25,1654,1653,45,9;50;F
37557;166;52;M
37569;45,1430,1148,583,1422,245,596,344,348,820,627,345;9;M
37582;1656,1148,1411,190,347,1118,1655,344,1619,62,596,919,1456,627,345;49;F
37632;340,627,106,344,1422,6,245,51,52,348,435,317,707;32;M
37664;344,90,5,435,317,707;41;F
37693;1518;47;F
37706;344,348,1619,587,5,1430,6,245,43,166,90,25,1118,1411,1518;44;F
37718;1518;9;F
37736;347,596,25,51,44,52,344,53,707,345,348,1118,627,317,1518;45;M
37810;51,348,63,317,45,62,5,1430,1148,43,344,1656,53,435,707;31;M
37815;1148,347,1619,45,62,1658,43,90,822,25,51,820,106,627,317;46;M
37819;63,62;42;F
37861;1657,62,1658,583,1411,345,820,822,25,344,342,1656,340,1655,63;35;F
37863;106,52,583;12;M
37882;106,820,53,51,25,596,347,589,190,583,1148,45,43,63,1518;43;F
37904;1430,593,587,63,106,627,5,1485,1148,190,919,52,344,820,245;53;F
37914;589,190,1653,5,62,1148,6,245,51,52,1118,1058,106,627,317;44;F
37922;51,347,190,583,1430,5,45,1657,1148,1658,245,1654,596,627,345;36;F
37959;435,627,5,9,1430,1658,6,43,25,44,1518;36;M
37983;340,63,106,627,707,62,1485,433,45,6,245,1654,1422,820,345;50;F
38077;583,44,348,53,820,1456,1058,627,1518,1411,593,245,1654,43,25;46;F
38111;25,340,435,9,52,317,820,583,5,348,106,347,51,1653,627;31;M
38115;45,317,627,433,6,245,1654,1422,166,25,1118,340,1518,1430,1411;54;M
38128;1619,820,627,1430,898,433,593,583,245,53,1518;36;M
38130;587,5,43,347,51,52,344,820,1058,627;40;F
38135;1654,190,898,593,1657,1148,1653,348,340,1655;59;F
38164;9;46;F
38165;25,1655,820,63,345,583,166,822,1656,53,435,317,707,9,44;37;F
38169;1422,90,51,1619,53,62,1658,190,347,1456,106,627,345;50;M
38187;25,1518;33;F
38190;433,587,5,45,1430,583,6,245,347,90,596,919,344,1118,1518;38;M
38218;1518,106,1655,1118,347,589,1148,1657,1485,190,596,344,53,820,345;35;F
38220;5,45,1148,1658,1653,1422,919,1656,1655;35;F
38246;1058,1456,820,53,1619,342,348,583,5,433,6,245,1411,1118,25;31;F
38252;1619,344,1653,245,583,1148,45,62,1430,1654,190,43,347,51,348;40;F
38258;43,435,45,1654,1655,1148,245,317,583,1653,51,190,347,106,627;42;M
38272;1656,344,1422,1658,62,1653,190,347,51,340,1655,106,435,627,345;40;F
38286;596,25,1619,1656,340,1655,1456,63,433,44,348,53,707,1411,1518;39;F
38295;245,1456,627,317,6,348;43;F
38299;25,106,435,317,707;39;F
38308;5,433,593,1430,583,1654,43,596,344,342,1118,1226,820,63,707;13;F
38324;347,822,90,52,53,707,345,6,43,25,51,820,106,627,317;29;M
38368;62,51,1654,245,583,1658,1657,190,589,822,25,52,348,342,627;41;F
38383;5,9,43,25,51,1518;28;F
38388;1656,340,435,1518,1411,627,106,63,53,1619,342,347,583,9,44;39;F
38393;9;13;M
38400;433,1430,52,1118,1226,1656,1058,435,317,707;30;F
38407;9;53;M
38435;25,43,1654,45,5,1518;48;M
38448;342,627,1657,1148,245,1655,820;40;F
38535;593,1430,1658,166,822,25,44,9,45,245,342,340,820,1518,1411;40;M
38539;433,587,45,1658,245,1655,707,345;35;F
38558;106,53,51,25,9,5,6,43,347,44,52,820,627,1518;32;F
38620;1430,45,62,1485,5,6,347,90,51,53,820,106,435,627,317;33;M
38633;190,43,1656,820,106,435,627,317;37;M
38644;43,348,820,435,5,9,25,51,106,627,317;48;F
38661;1485,190,347,90,25,52,1619,1118,1226,820,1058,106,627,317,1518;40;F
38780;5,587,45,593,1619,1226,820,1456,1058,1518;33;F
38782;1518;45;M
38793;627,707,345,433,62,583,6,43,25,51,44,344,342,820,1518;28;F
38815;1058,627,587,5,9,45,593,6,245,43,90,44,342,820,1518;35;F
38818;1422,90,25,44,344,1226,53,340,820,1058,106,435,317,345,1518;42;F
38839;5,587,9,45,593,6,245,43,90,44,342,820,1058,627,1518;4;F
38843;1518;46;M
38848;9,6,245,43,344,1411,1518,1619;37;F
38852;348,898,43,90,822,45,62,9,5,433,1430,1619,53,820,1518;46;F
38863;1148,190,347,348,1656,53,820,106,435;30;F
38890;245,51,344,340,1656,106,627;40;M
38897;5,1430,6,347,919,51,52,344,53,820,1058,627,317,707,1518;35;F
38901;433,62,1658,90,348;41;F
38905;1654,190,919,25,820;38;F
38938;1518,1619,25;42;F
38943;44,51,435,707,1518,433,898,1657,245;44;M
38944;45,1485,5,1148,583,43,25,52,348,1118,820,106,435,317,707;34;F
38947;51,1619,106,317,62,1653,344,348,820,345,45,347,1655,1456,627;39;F
38954;587,1485,5,898,45,593,1430,43,820,1655,435,190,25,348,53;46;F
38971;1430,43,1619,435,1411,433,587,5,9,6,245,919,344,1118,1518;47;F
38973;433,348,1619,106,627,317,707;17;F
38979;433,1148,43,347,627,919,1653,245;63;F
38990;1518;41;F
38999;44;33;F
39016;596,44;45;F
39018;166,340;36;M
39039;90,25,919,52,1619,1058,1226,707,1485,53,51,627,106,435,317;32;F
39043;166,25;45;F
39054;1485,1430,344,25,5,9,6,43,90,44,1619,1118,245,1411,1518;43;F
39056;596,44;11;F
39068;1518;35;F
39076;44,90,6,1118,1411;39;F
39080;1411;44;M
39128;1658,583,589,433,587,51,919,52,348,1656,340,1655,820,627,707;33;F
39155;90,166,190,1654,245,6,1148,1657,62,898,5,587,45,1658,1518;50;F
39159;9,44;38;F
39164;1518;39;F
39168;166;14;F
39171;44;39;M
39172;1518,820,348,166,1430,5,9,6,43,25;34;F
39175;44;65;F
39191;1422,589,51,53,106,1518,5,1653,43,347,90,52,344,627,1656;28;M
39201;166;14;M
39204;166;14;F
39208;9,44;39;M
39212;317,1485,583,190,1422,596,51,348,1619,1118,1456,435,707,1411,5;32;F
39224;1518;41;M
39229;166;46;F
39236;9,44;8;M
39242;587,5,9,45,593,6,245,43,90,44,342,820,1058,627,1518;5;M
39243;1518;19;F
39252;9,44;10;F
39253;9,44,1619;32;M
39282;1430,587,5,593,245,1653,190,43,90,51,344,53,820,1058,627;49;F
39306;44,1118;43;F
39317;25,344,348,342,627,5,587,62,45,1148,245,190,51,820,345;37;F
39331;587,898,593,1430,342,53,820,1456,345,1411,1518;49;F
39341;345,1411;26;M
39353;583,1658,1430,45,898,9,587,245,822,44,342,820,707,345,1518;6;M
39359;9,919,51,53,627,317,433,587,593,44,1226,1058;49;F
39370;898,5,62,43,347,52,342,1118,53,1456,1058,627,1518,51;34;F
39371;1430,1148,344,593,5,898,6,90,51,52,53,435,707;31;M
39387;62,5,1430,583,245,1654,822,44,348,342,820,707,1411,1518;4;M
39389;90,347,1654,245,5,596,433,1619,1411,25,919,344,1118,1518;38;F
39398;433,1430,245,347,342,1619,1456,627,707,1411,9,45,25,44,1518;38;F
39424;433,5,45,1654,347,820,1518;34;F
39437;1485,5,898,62,1654,190,1422,43,347,51,52,344,340,820,106;29;M
39453;9;42;F
39482;587,1518;42;F
39483;43,1118,820,587,596,1518;46;F
39496;433,587,245,90,596,822,51,52,344,348,1118,435;49;F
39506;347,1430,5,433,9,6,596,90,1118,43,25,44,1619,1411,1518;41;F
39513;347,90,25,51,348,342,1118,1226,53,820,1456,1058,627,1411,1518;38;M
39540;587,5,9,593,6,25,44,348,627,317,1518;42;F
39545;347,25,348,342,53,820,1456,627,1411,1518;7;M
39548;90,5,9,25,44,1619,1656;37;F
39566;1518;43;F
39589;5,51,106,317,898,53;30;M
39608;166;37;F
39613;1653,583,1656;50;M
39622;348,627,106,51,245;45;F
39637;25,1518;50;M
39711;317;53;F
39718;1518;45;F
39724;62,433,6,245,190,347,90,919,51,52,1619,1058,106,627,317;44;F
39730;1422,589,596,44;40;M
39753;348,1058,317,587,1430,593,245,347,90,51,44,53,820,627,1518;49;F
39761;1148,43,90,435,5,190,347,106,245,51,348,820;49;F
39778;347,820,106,627,1148,245,51,190;47;M
39796;45,1657,583,340,627;39;F
39797;1518;42;M
39836;433,90,51,53,820,345,45,1657,1148,583,245,1654,190,340,1658;36;F
39862;51,820,25;42;F
39875;45,1657,583,340,627;13;M
39877;627,317,347,25,51,344,340,63,106;34;M
39895;166,1430,1619,1411,6,1518;46;F
39899;5,6,166,1430,1619,1411,1518;12;F
39903;166,1430,1619,1411,1518;14;M
39921;51,1619,106,348,344,6,62,583,347,25,53,1456,44,9,433;37;F
39941;898,1148,51,344,348,53,820,106,317,627;27;M
39979;707,435,1456,1655,1656,1118,1619,919,1653,583,1658,1430,1485;27;M
39981;166;44;F
40000;53,44;28;F
40036;166,25;13;M
40060;190,1148,627,51;26;M
40062;919,52,342,53,340,820,345,707,627,106,1658,898,45,43,1518;40;F
40086;1518,1656,627,1456,348,90,43,245,583,1430,62,347,51,344,106;64;F
40093;593,1654,51,6,25,44,344,348,342,1118,53,820,1058,435,627;32;F
40099;1658,583,1456,63,707,1518,6;36;F
40102;43,245,1148,1657,5,190,919,51,344,348,340,1655,820,106,627;36;F
40103;627,1411,435,190,5,9,45,1430,583,1654,43,25,53,820,1518;40;F
40109;1411;54;F
40115;5,25,245,43,51,348,820,627,1148,583,919,1656,340,1456;48;F
40148;1654;28;M
40162;1518;42;M
40185;43,1619,1656,345,1411,9,1653,1654,1118,1655,820,1657,1658,627,1518;34;M
40189;1518;8;F
40205;707,345,587,1658,43,347,51,344,342,1656,106,627,63,5,820;34;M
40211;1518;6;M
40237;707,347,1654,245,583,344,1485,6,51,53,348,317,627,435,106;8;F
40270;317,627,63,1456,1656,342,5,898,6,90,51,52,53,435,707;9;F
40273;345,1518,347,62,51,6,90,1619,53,435,627,245,919,106,317;34;F
40280;583,9,1485,5,587,1653,166,25,44,348,1226,820,1456,1058,435;43;F
40318;6,43,347,90,51,344,1619,1118,53,820,106,435,317,919,627;28;F
40320;44,1118,1518;41;F
40321;62,52,348,627,1518,6,245,90,596,25,51,344,1118,9,44;38;F
40322;433,5,589,25,344,345,1655,1148,1658,583,190,1653,348,1656;44;M
40328;596,43,90,1456,347,51,44,344,52,820,627,9,435,5,6;47;F
40336;348,1456,106,627,45,62,5,898,6,90,51,52,53,435,707;6;F
40342;45,820,9,1485,435,52,90,166,43,6,5,25,1518;49;M
40358;6,1430,5,51,1226,1058,435,627,433,587,593,245,919,348,820;53;F
40379;1518;41;M
40397;9,6,25,820,1518;30;M
40405;627,1058,820,344,919,43,583,1430,45,5,587,593,6,1654,1518;40;F
40409;587,593,583,245,919,1226,340,820,1058;43;F
40416;919,44,340,53,820,1058,435,1411,1518,5,593,898,9,587,433;31;M
40418;820,43,583,1658,587,45,593,44,340;43;F
40445;62,45,190,596,44,53,25;54;M
40455;51,348,1656,340,63,627,433,45,1657,1658,245,190,342,1655,345;35;F
40489;1226,1058,919,820,593,587,583,340,245;13;M
40496;9,898,583,435,62,44,1118;12;M
40498;9,25,44,1118,435;47;F
40516;45,1148,1658,1653,1422,347,344,348,820,627,190,43,25,340,345;35;M
40535;1430,593,1654,52,1619,1118,433,9,245,43,25,348,820,627,1518;13;F
40539;1226,1058,919,820,593,587,583,340,245;10;F
40552;347,25,919,51,348,820,106,317,707,9,6,53,627,1411,1518;32;M
40554;106,63,1656,342,51,347,589,1422,190,1430,45,62,433,583,25;48;M
40631;6,1148,45,898,5,820,1658,90,245,106;29;M
40632;166,583,1653,340;40;F
40651;433,583,589,25,1518;37;F
40668;433,587,593,1430,1658,245,919,51,44,342,53,820,1456,1058,627;35;F
40670;348,52,51,5,1456,627,9,6,43,25,44,106,317,1411,1518;46;F
40761;90,347,6,1658,1148,62,9,1485,1657,44,53,1456,435,627,1518;54;M
40767;1226,344,90,347,6,62,898,5,433,587,593,589,25,53,1518;29;F
40791;1518,317,106,347,6,25,44;26;M
40828;919,348,1226,53,340,820,1058,435,1411,1518,587,45,593,245,25;49;F
40836;190,627,348,342,45,5,583,43,347,596,51,1118,345,1654,1422;47;F
40868;583,1653,342,1456,345,1518,587,1658,1422,53,593,919,1226,340,1058;32;F
40869;44,53,1411,1518,347,90,51,106,627,317,5,9,43,25,820;44;F
40892;106,1656,43,1654,1148,45,1485,1657,1658,583,245,190,342,820,345;39;F
40893;5,433,822,44,348,9,1430,45,166,25,1518;44;F
40905;1619,53,9,45,62,245,347,25,106,627,317,5,43,52,820;49;M
40918;53,45,25,51,348,1518;44;F
40939;347,25,627,9,44;30;M
41010;44;37;M
41012;348,1148,1653,190,43,340,1655,627;64;M
41041;62,1485,5,820,345,1518,6;34;M
41050;106,627,433,5,898,62,245,822,344,1118,820;49;F
41059;1619,51,25,1422,245,583,45,587,44,707,433;34;F
41062;9,5,6,822,25,44,1518;37;F
41072;1411;38;M
41090;919,596,106,345,190,1619,1148,583,51,820,245,1653,347,348,627;46;F
41095;1653,1657,1148,190,596,44,348,342,1226,1656,820,1058,106,627,345;38;M
41106;348,1619,1118,53,340,106,435,90,347,589,190,245,317,627,25;32;M
41118;435,43,1518,9,317,627,342,589,106,245,1619,1411,5,25,6;31;M
41172;1518;7;F
41174;25,6,5,9,43,51,820;52;F
41178;627,820,344,347,9,593,43,25,51,44;49;F
41185;5,43,347,90,25,51,344,1619,820,106,627,317;24;M
41194;433,587,62,1430,245,166,90,919,344,342,1656,1456,1058,317,1518;67;F
41195;433,25,344,1226,53,820,1456,1058;28;F
41203;587,1485,1430,1422,347,25,44,1058,627,5,51,106,317;44;F
41243;1430,1411;68;F
41249;53,820,106,627,1430,245,1518,1118,1411,9,1619,166,25,5,6;27;F
41251;1657,90,51,1518;75;F
41256;1118,90,347,43,9,5,6,25,51,919,52,344,1226,820,627;36;F
41280;6;40;F
41351;9,6,166,589,51,52,317,627;23;M
41366;593,1430,1619,1518;4;F
41377;435,106,820,1118,348,1485,5,9,43,25,51,6;37;F
41379;1118,106,627,435,317,707,1430,1485,5,43,596,51,44,52,820;32;F
41384;344,52,51,919,90,347,190,587,1148,245,589,348,820,1456,1058;31;F
41422;1653,347,1657,1654,190,45,1619,593,583,596,90,245,1655,106,627;38;M
41461;25,347;54;M
41497;9,25,344,340,1655,820,435,627,317,1148,190,347,51,348,106;24;M
41534;822,44;33;M
41545;5,1148,190,51,344,820;50;F
41562;5,433,45,1658,245,1422,919,344,348,342,1656,340,106,707,345;38;F
41565;6,25,1518;33;M
41567;6;25;F
41591;166;45;F
41615;1518;44;F
41622;344,820,435,317,707;37;F
41634;1518;75;F
41652;347,25,51,52,344,53,820,1058,106,435,627,317,1411,1518,44;11;F
41653;5,9,43,347,25,44,348,820;56;F
41656;587,1518;10;F
41676;1657,342,53,1655,435,1658,63;36;F
41681;1422,589,347,25,919,51,44,348,1619,1226,53,1058,627,317,1411;32;M
41705;1148,1653,43,347,90,596,919,51,106;58;F
41718;5,9,6,43,25;56;F
41740;1518,53,344,51,166,5,9,25,820;27;F
41762;1653,1654,347,820,1456,435,1148,1658,245,190,25,348,63,345,1518;42;M
41794;596,344,348,1118;53;M
41818;43,190,62,587,5,1148,1658,245,347,51,340,1456,106,627,345;44;F
41832;820,106,245;36;F
41863;583,348,820,1456,1058,106,435,627,317,707,51,919,347,6,62;36;M
41874;347,52,344,348,1118,820,106,435;30;F
41879;433,587,898,593,6,245,90,1058,5,43,25,51,52,344,820;34;M
41894;587,1658,583,245,190,347,90,342,1226,340,1655,1456,1058,106,345;36;F
41906;44;41;M
41914;707,348,25,433,1430,583,6,190,51,820,1456,106,435,627,317;33;F
41919;90,25,919,51,44,344,348,435,317,1518,166,898,9,5,587;24;M
41923;166;36;F
41943;6,245,43,822,919,52,344,627;46;F
41948;1430,25,348,1518;39;M
41967;348,347,1430,5,583,25,51,53,820,1058,106,435,627,707,317;4;F
41981;1658;42;F
42012;347,342,820,627,317,1430,90,345,1485,5,9,822,106,245;33;F
42028;43,348;51;M
42048;1656,348,90,347,43,190,245,9,5,433,587,340,435,627,317;64;F
42070;1518;26;F
42081;1058,1456,1619,919,1658,1148,1485,435,1518,53,1226,51,1430,433,62;27;F
42104;52,344,45,44,90,1485,25,5,43,342,106,1456,1619,1118,6;44;M
42125;347,44,1656,1655,106,627,345,1518,51,52,53,596,435,317,707;38;M
42162;5,1657,1148,1658,1653,1654,190,90,342,340,1655,820,106,627,345;12;F
42166;340;37;M
42180;1518;42;M
42200;348,433,5,1657,1658,245,1654,43,919,51,340,820,627,106,345;34;M
42231;25,1430,5,9,898,62,1148,6,245,347,90,44,344,317,627;45;F
42248;9,44,345,43;55;M
42251;1518,627,245,43,820;33;M
42306;347,52,106,627,317;51;F
42315;898,5,45,1148,190,43,25,51,44,348,342,53,106,317,707;36;F
42321;583,190,347,820,627,340;11;M
42324;344,52,44,51,1422,9,627,106,1655,596,1654,1485,5,583,1658;13;M
42334;44,1118;39;M
42383;245;41;F
42402;106,53,1118,44;10;M
42409;627,6,245;71;F
42431;587,5,1430,6,245,43,166,90,25,344,348,1619,1118,1411,1518;15;F
42432;51,90,190,1148,62,9,5,6,43,347,344,1656,820,106,627;31;M
42435;1411,433,587,593,1430,583,1422,43,589,52,348,1656,1058,106,435;37;F
42460;587,5,1430,6,245,43,166,90,25,344,348,1619,1118,1411,1518;13;M
42467;1148,245,1653,190,347,106,627;46;F
42488;44,1118;39;F
42493;44,1118;10;F
42499;9,43,919,44;40;F
42508;1430,898,587,433,1653,190,43,596,348,1619,1118,820,106,627,245;44;M
42515;190,1655,62,1148,1658,1654,43;40;M
42528;1118,44;7;M
42550;1118,44;7;M
42567;1148,593,1430,1653,589,344,348,1656,340,1655,627,433,245,596,1118;50;F
42579;348;58;F
42580;587,820,1058,106,435,317,1411,43,919,52,348,53,627,345,1518;20;F
42581;6,347,51,1619,820,106,627,43,25,44,344,53;38;F
42585;9,25,344,348,820,435,44;36;M
42603;1518;36;F
42604;44,1619,1656,53,1655,1456,63,106,627,345,1518,62,6,245,919;36;F
42614;583,433,5,347,90,25,52,344,348,820,435,44;44;F
42618;435,53,44,347,433,245,25,51,348,106,627,317;39;F
42619;44,627,45,1518;42;F
42642;1411,5,62,51,106,317,435,345,190,43,347,820,627;35;F
42674;25;41;M
42728;44;48;M
42729;44,53,820,1518,6,190,347,627,317,51,90,45,106,25,245;36;M
42742;1619,106;41;F
42746;1657,45,1456,433,245,90,25,1619,53,435,1518;33;F
42748;52,25,5,9,45,1430,6,245,43,347,596,1619,1518,1118,627;44;F
42758;898,1148,245,1653,190,347,1619,1655,340,820,627,433,5;52;M
42766;9,45,583,25,44,348,342,707,345,1411,1655,820,1456,63,1518;39;M
42779;1658,342,583;38;F
42790;340,820,1456,1058,627,345,919,596,1148,587,433,898,45,593,1658;43;F
42797;1148,347,51,820,627;25;M
42803;587,593,43,344,1226,1456;57;F
42804;51;32;M
42816;433,347,51,820,106,627;20;M
42846;5,1430,245,90,596,25;45;F
42897;1456,317,1518,5,62,45,1658,6,51,52,344,820,106,627,345;37;M
42904;90,1654,245,5,9,62,43,589,25,44,1656,1655,820,1411,1518;37;F
42931;53,1655,9,1430,822,587,43,25,44,1411,1518;70;F
42993;587,9,347,596,822,25,919,344,44,1118,1655,820,1058,627,1518;7;F
43001;90,707,1411,5,245,25,1118,627,9,433,583,43,6,44,348;41;M
43028;6,5,9,43,25,51,820;31;M
43032;919,344,587,9,822,25,51,44,1118,1655,820,1058,627,1411,1518;3;M
43053;593,1658,1654,43,166,25,51,342,1226,53,820,1058,627,707,1518;42;M
43064;348,51,822,1653,583,587,9,44,342,53;37;F
43069;25,1619,707,1411,9,43,44;47;M
43082;190,5,587,1148,1653,43,347,51,52,344,53,340,820,106,627;33;F
43098;9,45,593,1658,1654,190,43,166,822,25,342,1655,820,707,1518;7;F
43103;245,1411,5,44,25,6;49;M
43105;1456,25,587,435,433,53,6,1619,627,90,52,51,245,707,317;37;F
43108;433,1430,1148,1658,583,1654,190,340,345,1411;49;M
43146;433,593,1654,1422,166,596,919,342,1118,1058;15;F
43148;347,90,344,1656,340,627,245;48;F
43150;25,1619,707,1411,9,43,44;47;F
43155;822,347,62,1485,6,1422,43,1456,435,9,25,44;35;F
43163;1430,44,1655,1518;70;M
43171;9,43,25,44,1619,627,317,707,1411,1518;10;M
43184;9,43,25,44,1619,627,317,707,1411,1518;8;M
43195;820,1656,1118,344,5,9,62,583,43,25,44,348,342,1411,1518;31;F
43203;5,433,342,820,166,25;38;F
43204;5,433,9,583,6,245,43,90,25,44,348,1118,627,707,1411;10;M
43222;433,5,9,583,6,245,43,90,25,44,348,1118,627,707,1411;44;F
43230;587,190,51,344,1226,1058,707,627,1518;51;F
43256;1518;36;F
43280;627,106,820,1619,344,348,51,919,25,347,5,166;47;M
43282;45,1485,5,433,583,1653,190,1422,43,596,52,348,1118,820,345;38;M
43296;348,433,5,9,583,6,245,43,90,44,342,1118,627,707,1411;12;F
43328;1456,53,1619,342,348,44,347,583,1658,62,25,589,166,1430,1518;36;F
43335;348,1456,587,9,1518;45;F
43341;190,1654,45,342,340,1655,1456,707,1411,5,1430,1148,1658,583,433;34;F
43343;1411,9,62,1148,587,5,6,245,43,90,25,919,344,1619,1518;41;F
43350;587,25,344,1118,1518;45;M
43362;1653,1148,106,53,340,820,707,5,45,43,51,44,348;39;F
43389;342,25,90,1422,1148,245,345,51,190,435,62,106,347,1653,627;49;M
43405;344,52,51,25,589,43,190,1654,245,6,1485,5,45,1653,1656;47;F
43434;1656,1518,707,5,583,6,43,347,51,53,106,627,317,820,587;30;M
43448;5,9,6,43,25,51,342,820,627;25;F
43451;1619,90,44;35;F
43487;433,5,43,347,90,51,52,344,1619,53,820,627,9,25,348;37;F
43491;53,51,43,245,190,919;27;M
43493;593,45,587,5,43,347,25,919,1656,53,820,317,106,9,627;52;F
43513;344,1656,707,587,5,583,6,43,347,51,53,820,106,627,317;28;F
43530;433,587,593,919,344,348,342,53,1058,435,317,707;43;F
43531;1518;7;F
43556;9,6,245,90,344,596,1118,5,25,1619,1518;38;M
43559;43,9,587,433,347,596,627,6,245,583,5,52,344,1118,820;54;M
43566;5,9,583,6,25,44;34;F
43582;596,90,347,898,627,9,6,25,348,820,1456,106,435,317,1411;33;M
43604;1656,1411,166;37;F
43626;53,1518;5;M
43664;25,51,44,344,342,1656,820,1456,63,106,435,627,317,707,1518;7;F
43707;1657,190,627,1148,583,1422,1656,245,1658;38;F
43725;1422,1657,1658,583,245;40;M
43771;1619;42;M
43783;1619,51,347,245,5,433,1430,1148,1653,190,43,589,919,348,820;38;F
43801;433,593,583,1654,589,166,596,919,342,1118,63;4;M
43806;1655,627;50;F
43815;62,5,1657,6,1654,190,347,25,51,340,1655,820,106,627,317;29;F
43839;587,1657,1653,190,348,340,1655,1456,435,345;16;F
43843;62,45,1430,1657,583,245,1654,43,90,44,344,342,53,435,707;40;F
43844;593,43,53,1058,106,627,1518;24;F
43856;344,627,707,1518,5,347,596,52,53,345,43,90,51,820,106;34;F
43863;9,45,245,347,348,106,627,317,707,44;34;F
43864;435,5,9,1654,190,51,344,1656,53,1653,347,25,106,627,317;34;F
43889;44;38;M
43895;44,707;33;F
43912;43,435;41;F
43941;190,25,347,820,5,9,6,43,51,44,106,435,627,1518;53;M
43972;433,43,90,919,1656,898,1657,1658,190,348,342,340,1456;36;F
43982;6;60;M
43992;45,9,62,6,1654,43,51,44,344,348,53,820,106,627,317;39;F
44040;1518,317,53,348,25,1658,1657,62,347,90,51,52,1656,106,627;55;F
44102;9,1485,317,627,820,344,51,25,90,347,43,245,1148,45,5;14;F
44108;1654,593,45,1657,1658,583,245,348,627,190,587,340,1226,342,345;36;M
44175;5,589,43,1653,583,1430,593,62,433,587,1148,190,347,51,820;44;M
44190;51,348,5,9,25,44,820;44;F
44208;51,820,1148,1518;64;M
44213;707,1619,1148,1654,347,1118,1656,1655,45,1657,1658,596,340,820,627;45;F
44228;5,9,593,822,919,348,820,1058,63,1658;30;F
44243;1654,1619,627,53,1148,1657,587,245,589,919,1118,1656,1655,820,345;37;M
44266;1411;31;M
44268;106,1148,1657,190,51,344,53,627,707,1653,345,347,1658,583,1422;57;F
44287;1653;36;M
44300;433,6,90,25,1619,1456,1411,1518;31;F
44306;1658,1148,1654,1653,190,347,822,25,1619,1656,340,1655,820,1411,1518;37;M
44323;1430,6,245,347,919,51,348,342,1619,340,106,435,627,317,345;40;F
44338;433,62,1148,1658,190,43,347,25,51,348,820,63,106,627,345;27;F
44341;62,898,5,433,587,1430,6,43,596,51,52,1226,1058,1518;33;F
44367;1456,1226,245,1430,587,45,1148,190,43,919,348,1058;75;F
44370;245,348,435,707,317,627,106,1619,344,44,51,919,596,90,347;31;F
44379;6,347,90,25,344,1118,53,106,627,317,1518,51,44,52,820;31;F
44398;9,44,52,1656,53,627;47;F
44422;53,340,1411,433,1118,5,820,1518,245,106,166,25,6,1619,90;38;M
44436;53,340,317,6;32;M
44464;583,245,342,1456,1518,9,44,344,348;30;F
44482;707;30;M
44496;1657,345,62,317,106,1656,347,245,627,344,51,596,190,1653,1148;60;F
44546;340,90,317,1148,1619,106,627,587,433,919,1226,1656,820,1058,707;41;F
44576;1518,433,593,6;22;F
44592;52,1148,1485,5,6,1653,190,820,106,627,317,43,347,51,1656;50;F
44595;1657,589,583,190,43,25,51,52,344,1118,53,340,820,1456,1058;22;M
44597;1655,820,1456,106,707,317,587,1148,1653,190,347,51,348,340,627;33;M
44641;1148,5,62,347,51,52,344,53,106,627,317,25,90,9,1518;22;F
44646;245,43,589,596,919,52,344,348,1226,340,1058,106,435,317,707;28;F
44661;820,245,1653,348,627,1658,190,347,51,342,106,345;37;M
44703;1658,583,596,25,344,1118,627,345;31;F
44739;348,433,5,344,53,820;45;M
44754;347,43,1430,9,45,6,44,342;33;F
44827;1518,1411,1619,5,9,6,44;26;F
44865;5,1657,190,43,344,348,820,106,596,627,90;51;M
44913;820,5,1148,583,245,1653,190,1422,347,90,51,344,348,1655,627;38;M
44937;1148,245,1653,348,1656,1058,627;45;M
44970;25,587,5,1653,340,820,106,627,1148,190,43,1422,347,51,1656;29;F
44993;1148,1430,9,898,245,190,43,25,348,820;45;F
44999;6,1619,44;31;M
45008;593,1430,1619,1518;;M
45022;44;28;F
45035;433,6,245,344,1411,1518;37;M
45055;1654,1148,433,5,62,45,1657,190,347,51,340,435,317,345,1518;50;F
45074;587,9,593,583,1654,347,919,51,344,340,820,627,44,433,245;24;F
45100;1456,1058,627,25,43;44;F
45129;51,5,1619,627,62,245,63,106;39;F
45147;435,345,347,1658,1653,190,43,1656,106,317,627;41;M
45155;348,53,340,106,5,6,347,344,627,820,1655,51,190,1653,1148;71;M
45175;44,25;38;F
45205;1058,1619,51,347,190,583,1657,1430,90,345,820,587,1658,1226,340;44;F
45238;45,245,44;40;F
45272;433,587,593,1148,43,344,1656,1655;58;F
45290;45,1653,190,52,344,5,43,90,51,1655,340,820,435;67;M
45322;707,345,433,587,583,245,1654,190,25,344,348,342,1456,1518,1058;32;M
45354;627,820,51,919,5,587,433,245;47;F
45361;1411,166,45,9,5,820,435;40;F
45394;1619,1518,43,25;39;F
45410;1657,5,587,1658,583,51,44,1656,1655,820,63,707,62;32;F
45468;5,9,1654,820,1655,1118,596,43,1653,1658,1657,190,348,340,345;32;M
45509;25;20;F
45515;433,45,593,245,1654,43,347,53,820,1058,627,1518;44;F
45517;1430,583,596,25,51,52,344,348,1619,1118,53,820,1456,627,1518;14;M
45525;1619,627,6,90,51,52,435,707,53,5,898;38;F
45530;593,25,820,627,587,245,1518;42;F
45531;596,1653,587,6,589,90,51,1619,1518,106,52,1118,627;41;F
45532;1518;47;M
45536;1430,347,25,51,348,106,435,627,317,1148,6,245,190,919,820;40;F
45554;43,342,53,1655,820,63,707,1058,25,5,433,45,348;63;F
45591;820,1118,348,45,5,1148,190,344,342,340,106,627,707,345,9;32;M
45592;1654,589,347,51,44,348,1226,340,1058,106,317,1518,627,1422,25;55;M
45635;1430,347,51,52,348,1619,53,1456,106,627,707,587,6,245,43;69;F
45641;166;47;F
45668;1655,53,1656,1619,348,347,43,190,1658,1148,45,62,245,596,51;36;F
45748;1118,1656,340,1655,1058,1456,63,106,435,317,62,53,820,627,1518;36;F
45823;627,317,820,53,51,25,90,347,43,190,1148,62,5,106,1518;24;F
45888;166,190,1657,1485,9,45,1148,43,347,44,53,820,317,1518;69;M
45908;9,593,25,919,51,344,627;51;F
45911;45,1148,90,919,51,342,1058,63,106,435;43;F
45925;1658,340,106,435,627,317,345,1411,62,1148,6,190,43,51,820;43;M
45928;587,51,344,1058,62,190,52,348,53,340,820,106,435,627,345;42;F
45937;433,5,1485,62,1653,347,51,52,348,1148,190,1656,820,106,627;34;M
45957;245;69;F
45965;1456,627,1422,53,344,52,51,822,347,43,245,9,5,587,433;43;F
46049;106,348,347,1422,190,6,1148;44;F
46079;1485,1148,6,190,43,90,596,348,589,820,627,1518,1226,106,317;28;F
46121;433,1148,583,245,589,90,25,51,344,342,106;46;F
46127;245,1654,1422,51,347,583,25,919,345,1411,627,589,348,53,1058;33;F
46150;45,245,190,25,344,820,317,5,898,6,90,51,52,435,707;28;M
46157;245,6,347,90,25,919,344,1619,820,317,62,43,51,106,627;27;F
46163;627,106,53,347;23;F
46174;433,5,6,627;39;F
46197;45,1430,1148,245,1653,190,43,51,52,344,820,1456;57;M
46237;593,1485,5,435,433,245,190,919,348,1058,106;62;F
46247;5,898,45,6,245,190,90,25,51,52,344,820,435,317,707;30;F
46270;6,106,348,1148,190,1485,62,317,5,1422,25,52,53,435;37;M
46275;9,45,245,43,347,90,166,25,919,51,344,1656,820,106,627;42;F
46300;5,820,62,347,51,53,90,25,344,106,627,1430,348,190,1411;50;M
46339;435,627,317,1485,587,1058,707,1148,190,347,90,25,344,348,340;49;F
46348;596,51,53,340,820,1058,627,433,587,593,1653,190,347,919,1656;45;F
46398;9,583,6,347,25,51,342,627,435,707;32;F
46430;433,245,90,919,51,52,340,627,1148,1653,190,43,344,348,820;52;M
46488;587,245;69;F
46495;433,587,6,245,43,347,90,25,919,1619,1118,1226,1058,627,317;44;F
46511;5,9,1430,90,1619,6,43,1411,596,25,44,1118;39;F
46515;1411,583,245,190,1422,43,347,51,919,348,53,340,820,106,627;19;F
46540;245,919;31;F
46579;348,342,707,345,583,1658;37;F
46590;45,347,90,52,1619,53,627,1411,433,5,51,344,342,820,1518;11;M
46595;1226,1656,53,820,1058,627,1518;40;F
46609;345,1058,1456,1655,1657,1658,1654,1619;38;F
46644;1518;8;F
46648;589;52;F
46651;344,1058,348,90,589,1654,1653,583,593,62,587,1411;53;M
46655;9,587,822,25,44,820,627,1518;46;F
46660;317,1518,627,820,342,51,919,25,347,245,1148,62,433,6,190;10;F
46667;587,593,245,1653,1226,53,1456,1058;69;F
46688;106,348,190;54;M
46696;25,5,166;36;F
46742;62,1148,6,1653,1654,43,822,25,51,348,1656,1456,63,106,627;8;F
46770;106,317,627,919,25,347,1430,45,5,587,433,9,245,348,1518;43;F
46785;5,166,25;14;M
46798;1430,245,589,348,106,435,317;43;F
46827;166,347,52,344,342,1656,53,1456,627,345,1518,106,435,317,51;37;M
46885;6,90,317,707,1148,52,51,435;34;M
46889;6,1148,898,1518,345,317,106,1656,53,51,347,62,190,348,340;29;F
46907;43,919,51,348,1118,53,435,627,317,707;33;F
46946;5,1657,1148,190,43,347,51,348,1656,1655,340,106,627,317,345;41;M
46955;627,596,90,347,43,245,6,1430,593,9,1485,5,44,348,1118;48;F
46977;51,347,919,52,348,1118,106,53,340,1456,1657,596,820,90,1619;43;F
46986;347,90,596,919,51,52,344,348,1619,1118,340,1456,106,627,345;48;M
46990;898,62,1430,587,45,596,340,433,1657,1658,90,1619,1118,1656,1456;10;F
47015;1148,583,1653,190,51,52,348,1619,1656,820,1058,106,435,627,345;40;M
47018;820,1118,348,344,919,596,1422,1148,190;43;F
47037;90,5,9,6,190,347,919,344,51,106,317,43,1656,820,627;29;F
47056;51,435;40;M
47066;90,51,344,1118,106,435,317,587,6,245,347,52,1619,53,627;64;F
47070;587,245,44,1226,53,90,344,62,25,51,348,106,435,627,317;37;F
47075;435,317,51;46;M
47077;45,587,5,593,6,245,43,347,596,51,44,348,1619,1118,9;54;M
47086;1518;54;F
47125;1430,1148,1658,1654,190,347,919,1656,340,1655,106,435,627,1653,348;60;F
47168;245,347,1226,51,52,348,627,43,25,9,593,344,1118,1058,1518;46;F
47222;25,1422;45;M
47227;5,245,1654,43,44,344,348,342,820;70;M
47229;1518;39;F
47261;25,820,627,1518;10;M
47273;1118,106,627,317,1518,1411,43,245,9,44,1619,25,90,6,5;37;M
47282;44,1518;7;M
47301;317,435,53;32;M
47333;43,1518;35;F
47336;1653,348,627,435,106,1655,340,1656,919,347,190,1654,1658,1148,1430;67;M
47357;44,52,348,1619,1118,53,1518,106,627,317,820,6,9,25,5;32;M
47361;1148,6,1653,43,589,347,1118,317,53,348,52,51,919,1656,627;47;F
47362;43,1518;4;M
47365;6,347,51,52,53,317,627,435,1148,43,190,344,348,820,106;47;F
47375;45,9,5,166,342,1619,627,707,1518,6,25,51,43,44,820;42;F
47388;43,1518;8;F
47439;53,90,1422,6,596,106,627,317,5,347,51,52,348,820,435;52;F
47459;1655,345,1485,1653,1422,44,1656,820,63,707,583,45,1657,1658,342;33;M
47498;587,62,6,245,589,347,25,51,344,348,53,106,435,627,317;38;M
47509;44;10;M
47523;1654,593,5,587,1456,1058,627,1485,9,45,583,43,53,820,1518;38;M
47530;1658;53;F
47534;5,587,593,245,1653,43,347,90,51,52,344,348,820,106,627;67;F
47573;433,1148,348,435,627,317,5,342,820,345,1655,340,1656,344,190;46;M
47582;1148,1485,5,435,820,348,245,627,106;46;M
47590;44;45;F
47605;5,106,435,317,707;26;M
47659;5,1485,1148,245,190,43,51,348,820,106,435,627,317;48;F
47674;433,6,43,347,90,344,820,106,627,5;22;M
47689;347,919;28;M
47692;106,340,1226,51,919,347,1422,62,45,587,433,1430,6,245,1456;46;F
47719;433,347,25,51,1656,53,820,106,627,707;36;F
47738;1148,62,5,1485,6,1422,347,348,53,820,106,627,52,317,435;34;M
47857;53,627,317,435,51,5,190,344,340;50;M
47867;62,6,190,25,1456,106,5,583,245,51,52,53,820,435,345;39;F
47895;245,43,347,90,596,25,51,344,348,1619,1118,820,106,627,6;35;F
47928;52,51,90,347,45,342,106,435,317,707;35;F
47938;345,707,627,106,340,1656,1118,342,344,919,43,190,1654,583,1658;37;F
47980;820,627,51,596,1148,245,1653,190,919;48;F
47997;5,347,596,51,344,1118,53,820,1456,106,435,627,317,707;39;M
48008;25,43,5,9;19;M
48059;583,6,190,344,52,53,820,435,1411;33;M
48065;1422,583,1148,1430,593,45,245,1653,347,90,51,53,627,1658,340;14;M
48066;245,9,166,25,435,820;55;F
48067;587,5,593,1148,190,348,1118,820;69;M
48073;51,52,627,106,347,6,44;38;F
48089;433,62,45,1430,1148,1658,245,190,1422,347,25,51,53,340,627;11;M
48104;587,45,593,1657,1658,583,1654,43,347,51,348,1619,340,1058;38;F
48110;5,1148,6,245,1653,190,43,347,919,344,820,106;46;F
48145;1518;40;M
48159;1518;9;F
48161;1518;8;F
48178;583,245,190,347,51,53,340;36;F
48179;43,347,596,919,1619,1655,627,587,1148,1658,190,348,1118,820,345;57;F
48221;1148,245,190,53,106,627;47;M
48276;583,6,1654,1422,347,90,596,51,52,1118,1226,53,1058,435,627;44;F
48283;1118,6,62,433,593,43,190,90,919,340,820,106,1656,53,627;24;M
48292;433,1430,245,1619,53,627,1518;62;F
48313;43,342,1619,433,45,44;43;M
48330;166,25;44;F
48339;51;46;M
48342;583,347,1655,1148,345;42;M
48392;44,1430,53,707,345,1411,1518,90,51,6,347,1619,106,627,317;39;F
48393;53,62,1653,43,347,51,344,348,1655,106,435,627,317,190,820;35;M
48405;1657,1654,190,90,919,348,342,340,820,627,345;37;F
48425;583,51,1518;36;F
48464;6,593,45,344,347,51,1058,1226,627,587,245;51;F
48468;62,90,53,345,6,347,51,44,1619,106,627,317,707,1411,1518;44;M
48473;90,53,62,6,347,51,44,1619,106,627,317,707,345,1411,1518;80;F
48474;62,1619,347,6,51,90,345,707,53,44,106,317,627,1411,1518;16;M
48496;1518;46;F
48500;245,190,1422,43,25,919,51,52,344,53,106,435,317,627,707;26;F
48510;340;40;F
48516;51,707;34;M
48539;627,106,820,317,51,347,245,1430,344,348,435;46;F
48607;166;39;M
48608;166;42;F
48618;433,898,1430,1658,583;38;M
48630;348,52,51,919,25,347,43,190,1148,5,62,245,344,53,820;31;F
48642;166;43;M
48643;1058,345,1422,583,593,587,898,6,245,317,1656,347,589,348,919;41;F
48648;347,245,1148,62,587,593,43,589,596,1655,106,627,317,707,1518;29;F
48673;166;46;F
48674;166;47;F
48699;1657,1654,1658;43;F
48703;166;48;F
48714;9,5,587,898,1148,245,1653,344,348,342,1118,1456,340,1058,1411;60;F
48723;43,583,190,347,589,25,919,51,348,1619,1226,340,106,627,1411;20;F
48727;348,1657,1430,587,593,347,44,1656,106,627,45,1658,583,1654,342;44;F
48728;166;42;F
48731;1148,583,348,53,340,820,345,1658;39;M
48732;433,583,1658;37;F
48743;166,25;45;F
48759;5,1148,190,43,51,348,820,245;68;M
48814;587,433,1485,1657,43,166,5,898,348,344,90,190,45,9,1658;42;F
48817;5,9,6,90,52,587,245,25,820,627;50;M
48835;1518;23;F
48852;166;40;F
48854;45,433,5,1657,1148,1654,190,43,348,340,1655,820,345,245;66;F
48886;1656,1518,345,1411,340,1655,820,1456,1058,63,106,627,435,317,707;17;M
48906;6;49;F
48935;1485,1657,1658,589,596,1619,820,1518,9,6,1422,25,344,1118,707;32;M
48943;245,342,53,627,5,587,190,589,347,25,51,820,106,345,317;20;M
48944;1658;35;F
48952;1518;40;F
48989;52,707,1658,1653,340,106,435,627,345,317,190,43,347,51,820;22;M
49016;166;42;M
49023;62,1518,435,1485,245,90,347,51,342,53,820,106,627,317,707;30;F
49047;166;62;M
49051;166;47;F
49054;1430,1148,245,166,347,25,51,52,348,1619,1226,53,1456,435,1518;26;F
49093;9,51,344,348,820,106,627,25;63;M
49121;1118,53,106,317,433,587,5,44,820,1058,435,627,51,344;33;F
49134;345,342,190,822,820,340,348,587,1657,1658,1653,1654,919,1656,1655;44;F
49150;1619,1226,1411,1456,1058,106,317,433,9,43,25,344,53,820,627;58;F
49191;166;7;F
49205;1430,190,919,25,348,1118,820,106,627,317,1411;44;M
49207;344,1456,627,1518,6,245,820,583,43,347,596,1118,44,90,1411;37;M
49211;51,340,9,707,435,898,6,25;40;F
49246;1658;44;M
49256;25,166;42;M
49260;166;11;F
49268;166;42;M
49274;166;45;F
49278;166;9;F
49281;166;40;F
49287;166;3;M
49292;1422,348,1456,345,627,25,596,1653,1148,1430,1658,190,43;45;M
49301;166;38;M
49305;62,90,347,51,348,317,53,106,627,1654,1658,1657,1656,1655,1653;40;F
49312;166;12;M
49321;166;11;M
49322;166;8;M
49328;166;10;F
49337;166;40;F
49339;589,1226,62,6,596,1619,53,1456,707,5,51,820,106,317,627;41;F
49340;166;7;F
49352;166;12;F
49353;166;39;F
49369;166;9;M
49372;1658,433;32;M
49377;5,347,51,345,52,106,1518,6,1653,43,919,344,1655,820,317;29;F
49380;166;14;M
49383;166;13;F
49390;166;40;F
49401;44,1619,1118,53,340,63,627,707,25,589,1658,1148,1657,345,1456;39;M
49407;166;38;M
49409;166;71;M
49423;166;37;F
49426;166;6;F
49436;166;44;M
49442;166;39;F
49448;166;47;M
49460;347,348,53,1456,1411,1518,1485,1657,1658,1653,1619,1656,1655,190,1422;41;F
49476;166;40;F
49495;340,1658;35;M
49498;166;40;F
49515;166;38;F
49525;433,62,1148,1658,245,348,1456;39;F
49527;166;35;F
49531;707,1518,1655,1656,44,90,166,1654,245,1430,433,45,1658;28;F
49534;90,593,587,62,1148,6,190,347,51,344,348,106,627,317,245;36;F
49543;166,589,347,596,51,820,433,587,5,25,348,340,106,627;17;M
49547;166;44;F
49548;44;51;M
49571;166;43;F
49578;1058,166,1619,43,433,587,5,1430,6,245,90,344,1118,1411,1518;39;F
49606;166;47;F
49624;166;9;F
49625;166;13;M
49626;62,1485,52,348,53,106,820,344,51,5,433,1658,43,340,345;44;F
49641;25,348,1118,5,6,90,344,1518;39;F
49643;166;45;F
49651;1655,106,707,53,348,44,9,1430,190,51,1656,627,347,25,1518;39;F
49653;166;7;M
49661;596,344,348,53,820,106,51,245,52,627,317,1485,589,25,435;35;M
49702;44,919;9;F
49707;166;34;F
49719;166;10;M
49730;5;24;F
49744;820,348,25,822,347,9,5,44;39;F
49750;9,245,1118,44;26;F
49764;589,90,44,435,1655,340,342,53,1656,63,106,345,707,1411,1518;30;F
49787;25,51,1118,435,317,190,52,53,106,1430,344,348,820,627,1411;34;F
49789;1411,433,583,1422,90,344,340,820,627;40;M
49793;43,90,596,822,52,1118,340,106,627,1411,820,344,51,25,166;16;M
49800;1658;40;F
49837;1657,1654,90,1655,345;41;M
49866;44;39;M
49871;1411,1430;49;M
49896;589,433,627,435,106,53,348,51,44,245,1518,43,25,5,6;26;M
49899;51,5,6,52,53,707;33;M
49901;51,342,53,1518;47;F
49910;166;45;F
49922;62,433,587,1485,1658,245,596,820,1456,106,435,627,317,707,1411;34;F
49924;166;38;F
49956;9,1430,190,25,53,1456,345,820,627,106,51,43,62,90,5;25;M
49957;589,1619,1456,62,1148,1653,190,1422,317,1518,1658,583,245,342,707;33;F
49960;166;39;F
49975;589,1485,348,596,340,1653,45,593,583,820,106,51,627,1656,1148;31;M
49989;166;7;M
49994;627,62,5,1657,1658,245,589,347,596,344,1118,53,340,1655,820;38;F
50028;166;42;M
50057;1058,166,25;38;F
50058;596,347,6,1485,25,53,1058,435,345,1411,1518,433,62,583,707;24;F
50098;44;33;F
50135;596,919,51,344,53,820,1456,627,317,707,1518,9,43,25,44;34;F
50157;583,1655;8;F
50158;53,820,1058,435,345,1430,1657,1148,583,1654,190,348,1656,1655,340;39;M
50175;1518,707;31;F
50220;43,347,90,51,344,348,106,435,317,5,1148,190,53,820,627;32;F
50262;166,25;34;F
50268;707,433,5,43,25,51,342,1619,1456,587,45,245,820,627,1518;39;F
50274;62,1422,1654,245,340,63;40;M
50275;583,1654,190,90,344,1118,106,627,345,1518,433,1657,1658,245,347;37;F
50287;344,51,190,62,5,245,347,53,820,345,627;41;F
50291;1518;40;M
50403;347,627,106,1655,340,53,348,51,898,1657,583,43,52,344,345;45;M
50407;190,1654,1148,1657,62,5,587,433,1658,583,1653,43,342,1655,345;37;F
50426;1658,345;35;M
50427;1430,45,62,898,433,5,1657,1658,342,340,820,63,627,707,345;27;F
50470;820,106,627,51,25,347,190,1148,1430,62,9,5,6;19;M
50473;1658,627,106,1656,348,596,347,1653,583,62,53;46;M
50475;1658,62,45,5,344,348,342,1656,53,1655,1657,6,1654,190,347;10;M
50476;106,627,5,587,1485,1148,43,190,822,919,25,52,344,820,1658;37;F
50489;433,1658,344,348,53,340,627,707,345,245;36;F
50499;1430,25,166;40;F
50545;5,9,43,822,627,44,25,166;43;F
50581;1456,1430,1518;49;F
50594;1658,106,1518;36;F
50609;9,1658,583,190,822,25,342,348,1656,340,820,435,317,1411,1518;37;M
50618;347,627,1058,245,1653,190,51,345;54;M
50659;25,5,44;39;F
50677;1654,25,344,342;66;F
50688;1656,53,435,317,166;28;F
50695;25,90,166;42;M
50701;9,347,25,51,44,344,53,820,1518;38;M
50709;433,5,1653,44,919,43,820,1518,51,53,627;36;F
50744;166;37;M
50745;166;38;F
50762;166;9;M
50765;1654,166,25,1518;37;M
50774;1422,1654,583,1658;43;F
50775;166;64;F
50788;51,52,1656,820,1456,345,433,45,1657,1658,1654,43,344,348,342;33;F
50790;344,627,342,52,587,245,1118,9,5,6,1619,820,25,90,166;44;F
50797;1422,1654,583,1658;8;F
50800;166,25;86;F
50804;9,1430,6,1654,822,51,820,435,45,583,43,25,44,348,342;41;F
50805;166;12;M
50813;898,62,45,1148,190,919,51,820,53,340,1658,245,106,627,345;47;M
50820;1658,583,1654,1422;45;M
50823;166;11;F
50827;707,106,433,62,583,342;23;F
50834;587,1653,1226,1058;36;F
50836;1422,1658,583,1654;13;M
50839;587,245,43,596,342,1118,1058;21;F
50858;25,1653,6,1658,62,1430,348,342,51,9,44;28;F
50864;348,52,1118,53,106,1485,1148,589,347,596,344,1656,51,317,627;27;F
50871;51,919,43,190,593,898,433,587,45,1657,1148,1658,245,344,342;36;F
50892;583,1654,347,51,53,627,6,245,25,342;36;F
50895;433,9,1654,820,342;33;F
50903;166;66;M
50914;1422,583,433,62,45,1657,1658,245,190,1654,344,1226,1655,1456,345;38;F
50915;166;65;F
50924;1456,1058,1411,587,62,898,593,1430,1658,1619,820,627,583,245,1518;34;F
50934;5,433,45,1657,1658,583,245,1654,190,344,348,342,1655,340,1411;39;F
50939;45,593,583,589,90,596,52,344,342,1118,63;23;F
50940;1456,345,587,433,245,1422,90,342,1518,593,1657,583,340,1655,1411;34;M
50956;43,589,919,51,52,344,342,1655,820,1058,106,627,317,707,1518;28;F
50960;433,62,245,348,820,1058,63,1411;51;F
50968;43,347,90,25,51,52,344,820,106,317;40;F
50978;45,348,707,342,1518;41;F
50987;43,348,1619,1456,345,1411;46;F
51001;1430,245,1654,1422,347,596,51,52,348,1619,1226,53,1655,345,583;29;F
51002;45,583,6,245,190,43,347,90,822,51,52,344,342,106,1518;35;M
51008;820,6;48;M
51027;1456,433,587,45,245,347,1518,1619,1226;37;F
51037;1148,6,25,51,106,317,435,1653,190,348,820,627;32;F
51044;583,45,1658;45;F
51049;1456,627,317,53,1422,583,90,25,348,1430,166;40;F
51053;820,106,627,317,1518,5,9,583,589,90,52,166,25,435,707;35;F
51070;342,1518;39;F
51074;44,6,9,5,43,25,348,1456,435,1518;36;F
51078;583,25,51,52,348,53,820,317,5,1485,1430,43,166,435,707;45;M
51088;1658;39;F
51105;62,583,1653,190,919,627,707,345,43,52,342;33;F
51106;25,44,1456,627,433,587,593,1430,43,589,348,342,1226,820,1058;30;F
51107;347,1148,62,45,1657,1658,1654,190,348,342,1619,53,340,820,345;37;F
51118;433,587,5,9,245,1422,43,347,822,51,52,344,53,1456,627;47;M
51120;583,51,52,344,1619,1226,53,820,1456,106,627,317,1518,707,593;18;F
51121;1118,1518,433,62,45,593,1657,1658,583,342;36;F
51135;342,707,1518;37;F
51140;1518,433,587,5,9,245,43,347,822,51,52,344,53,1456,627;13;M
51153;347,589,1422,190,245,1148,1430,593,62,587,433,1658,583,348,340;38;F
51156;1619,342,348,52,347,433,1430,1657,1148,1658,1654,190,340,106,345;34;F
51160;1518,43,919;37;F
51164;245,190,43,344,342,1656,340,1655,345,45,1657,1148,1658;41;F
51182;433,587,5,9,245,43,347,822,51,52,344,53,1456,627,1518;11;M
51192;596,51,342,583,1422,589,25,919,344,348,340,820,435,433,898;27;F
51203;1456,5,1148,1658,1653,1422,43,344,1226,820,1058,106,627,345,1411;44;F
51220;1148,345,1619,62,5,190,347,342;47;F
51223;1658;47;F
51224;245,340,1658;43;M
51230;627,919,317,587,344,245,1518,1411,1118,1619,25,43,6,9,5;53;M
51234;9,245,25,51,348,1518;70;F
51260;627,344,44,51,190,6,45,5,1485,9,1422,43,340,106,435;37;F
51261;53,1456,627,1518,317,435,348,44,51,25,596,190,1653,1148,62;54;M
51270;435,1485,596,1655,820,317,345,1148,583,1653,190,347,51,342,1656;38;F
51273;583,1658,245,340;41;F
51284;166;37;F
51289;589,435,317,1518,433,583,6,245,1422,43,90,348,342,820,106;37;F
51300;583,245,43,347,90,51,348,53,627,1118,25,44,820,1411,1518;33;F
51313;347,919,348,820,627;39;F
51316;1658;37;M
51330;433,1485,51,348,53,435,707,190,245;47;F
51346;53,1058,317,344,52,6,347,51,106,627,5,190,43,1656,820;54;F
51364;52,344,348,820,106,435,1654;30;M
51382;1118,1656,1655,820,106,627,707,1518,1658,583,245,1422,347,342,345;41;F
51393;317,345,820,1655,1656,342,51,25,90,347,190,1653,245,348,627;38;F
51394;340;42;F
51397;344,1619,820,435,106,53,90,6,43,166,347,25,51,627,317;8;F
51399;51,822,596,1657,9,433,5,898,1148,190,43,347,1656,53,820;16;M
51402;348,344,52,51,347,43,5,25,820,433,1430,583,245,1518,627;33;F
51410;1118,1655,106,1657,190,43,596,51,344,1411,44,1658,583,342,707;25;F
51427;583,5,9,45,6,43,166,347,25,51,53,820,106,627,317;10;F
51434;1657,1658,583,1654,919,342,53,340,820,106,345;43;F
51440;53,627,5,1148,6,43,347,344,587,1430,919,52,1619,1058,106;45;F
51447;5,9,62,45,583,6,43,166,347,25,51,820,106,627,317;12;M
51458;52,90,435,51,6,1619;29;M
51471;1411,1518,433,587,5,9,1430,166,43,90,25,44,344,1619,1118;40;F
51475;344,347,5,433,45,1148,1658,919,52,342,1655,627,587,1657,583;34;F
51483;106,5,1148,1658,6,245,190,43,347,90,919,51,344,820,627;18;F
51493;44,1518;33;M
51502;1456,435,1658,53,627,51,43,5,90,342,589,596,106,63,62;42;M
51505;63,340,1118,344,596,90,347,166,190,1654,1653,1658,1148,1657,348;29;F
51513;166,25;37;M
51514;166,25;10;M
51520;25,51,90,589,43,245,1148,1430,45,5,347,44,348,342,1518;34;F
51532;6,627,433,9,1430,245,43,589,347,25,51,344,348,820,106;43;M
51533;166;10;M
51540;166;40;F
51543;707,317,627,106,51,347,919,1226;31;F
51553;5,245,43;81;M
51569;166;14;F
51570;1430,1658,1422,342,1456,190,1655,340,627,345;34;M
51584;347,6,62,9,25,51,820,627,317;24;F
51591;166;43;M
51604;1518,707,63,820,344,51,347,433,245,1654,90,52,342,106,627;33;M
51605;44,596,347,43,583,1658,1148,62,1485,5,1657,190,51,348,342;32;F
51612;9,583,342,53;36;M
51642;344,340,1655,707,345,433,45,1657,1148,1658,583,245,919,52,342;36;F
51643;1658;24;F
51671;433,587,45,593,583,245,1422,589,919,348,342,1058,106,627,707;38;F
51680;45,1658,90,52,344,342,1118,340,820,106,627,707,345;33;F
51691;5,9,1430,347,25;32;F
51692;347,1619,435,627,6,43,596,51,52,344,348,1118,106,820,90;24;M
51693;44,348,342,1619,1226,1655,1456,43,1654,45,9,433,245,1411,1518;32;F
51695;1619,593,1226,53,106,5,587,919,1118,820,1058,435,627,317,707;44;F
51700;44;38;M
51710;1148,245,1653,190,589,347,596,919,348,1619,1655,1058,435,627,345;27;F
51715;44,1118,1518,9,45,43,166,596,51,820,627,25,5;29;M
51717;583,106,245;37;M
51727;1518,1422,435,707,433,1411,1619,6,5,9,583,43,166,90,25;38;F
51733;1658,1653,919,342,1656,1655;35;F
51740;5,9,43,166,1619,6,245,25,44,1518;34;F
51747;43,9,25,51,44,342;28;F
51752;166,587,593,1430,1658,820,53,344,433,5,45,245,1422,347,1619;32;F
51757;433,245,1422,25,1456,627;36;M
51759;433,45,1658,583,1654,1653,1422,589,919,342,1226,340,1058,345,1655;48;F
51770;1653,347,596,51,90,1656,53,344,342,583,5,45,106,627,1658;45;F
51784;433,5,45,1430,1658,1422,51,348,342,1656,63;39;F
51787;1654,1653,245,583,1658,1657,45,62,433,898,342,52,53,317,707;31;F
51788;45,583,245,190,43,919,348,1619,53,340,1456,1058,435,345,1658;39;M
51790;53,106,627,317,820,344,52,51,5,9,45,245,43,90,25;32;M
51794;593,1148,583,245,90,52,344,348,1654,190,1422,43,820,106,435;46;F
51805;6,51,344,53,820,106,1518,1411,435,1619,52,919,43,1430,593;40;F
51825;1655,583,45,1658,190,348,342,340;36;F
51840;347,25,166,1658;36;F
51849;433,6,90,1118,627,1518;33;M
51853;1658,245;13;F
51856;1422,1619,1518;23;F
51860;589,348,245,822;53;M
51862;5,587,707,345,1411,1518;25;M
51870;345,583;33;M
51875;25,347,1658,1430,627,43,245,5,587,45,583,919,342,1456,1518;45;F
51882;6,1654,1118,53,340,1456,1058,627,1518;44;F
51908;1118,820,1456,433,1658,583,342,1518,1422,9,245,25;29;M
51916;587,919,345,1148,596,53,1658,43,589,342;37;F
51924;1148,190,919,627,345;51;F
51935;53,596,1422,433,1658,583,245,1654,1619,1118,1656,1655;29;F
51951;1658,583,345,344,43,1148,245;16;F
51952;1619,52,596,347,1654,245,587,45,25,51,53,820,1456,435,317;38;F
51954;1430,43,25,52,348,342,435,1518;36;M
51966;1422,347,822,51,44,1456,317,433,9,1658,43,25,348,820,435;44;F
51990;6,919,51,342,1619,1226,820,1058,707,1518,1430,25,44,53,1456;38;F
51996;1518;37;F
52004;1658,340;33;F
52011;245,190,342,1656,1655,63,106,707,433,62,1657,1658,1058,345,1654;36;F
52014;106,1654,919,51,342,627,433,1430,52,435,317,707;35;F
52016;1654,45,1657,245,347,596,90,820,627,345,348,106;38;M
52020;583,596,51,342,1118,53,1655,435,348;30;F
52026;52,106,435,317,5,9,6,43,347,25,344,53,820,627,1518;44;M
52030;433,1118,44,53,596,90,589,1654,583;19;F
52031;45,1148,1654,190,43,347,348,1656,340,1655,820,106,435,627,317;41;M
52040;9,1658,43,596,348,342,1656,1655,820,707,345,1411;29;F
52048;62,1658,583,245,190,589,344,348,340,1518;40;F
52052;52,348,820,45,6,347,51,44,342,53,583,1619,106,627,317;41;F
52059;627,245,583,820;46;M
52063;342,1656,340,1655,1456,1058,63,433,45,1654,25,919,44,707,1518;31;F
52068;627,1485,5,587,45,245,344,348,1118,820,1058,63,106;45;F
52077;1422,9,583,1654,44,1118;40;F
52086;1655,627,317,433,45,51,347,190;42;M
52100;593,1657,1148,583,43,347,25,51,52,344,53,820,627,1518,340;33;M
52108;348,90,596,347,245,1657,45,1654,820,106,627,345;39;F
52134;6;36;F
52141;1653,1654,1619,1456,90,52,51,348,53,106,627,62,583,1422,340;20;M
52158;5,583,596,1485,1148,6,245,43,51,344,53;21;F
52168;43,51,433,5,45,1658,245,347,919,348,820,106,627;49;F
52174;6,90,51,52,1619,317,9,347,25,344,106,627;28;M
52191;1148,190,43,347,596,51,52,344,348,1118,1656,106,627,340;41;M
52193;1654,190,166,589,1118,820,345,1411,433,898,593,1430,1658,348,340;34;M
52198;1518,1411,1619,44,822,347,1654,45,62,9,583,245,43,25,342;34;F
52200;433,587,245,1430,106,342,1518;36;M
52202;587,245,348,342,1619,340,1411;39;F
52204;1657,1148,1658,583,1654,190,347,822,51,44,345,5,342,820,106;36;M
52210;344,1456,44,317,1411,53,1118,348,1654,583,43,589,25,820,1518;20;M
52220;433,587,1148,245,919,51,344,348,1226,1656,820,1456,1058;43;F
52225;1485,587,433,1654,5,9,43,166,596,822,52,1118,340,1655,820;20;M
52233;589,1422,190,1654,1653,245,583,1430,593,898,1485,587,433,345,1658;27;F
52247;1656,44,593,587,1058;25;F
52260;51,596,1654,583,898,433,245,347,627,707,1655,62,5,1658,44;38;F
52265;820,348,166,43,1430,9,25,1518;44;M
52276;589,596,822,820,25,919,44,340,1655,1456,1518,1657,1658,348,345;29;M
52285;1411,593,433,587,6,25,44,348,1619,53,1456,627,707,345,1518;62;F
52289;5,9,6,43,90,52,1118,1619,25,583,44,344,342,1518;34;M
52296;1422,43,347,596,51,52,344,1619,1118,53,1411,106,435,317,707;38;F
52300;9,43,51,44;31;F
52304;1411,1518,317,435,106,51;53;M
52305;25,344,348,820,63,707,587,593,1148,52,1226,1058,106,435,317;43;F
52310;45,51,583,190,596,25,348,53,63,433,1653,43,342,820,627;37;F
52313;627,106,820,53,51,347,190,587,9,433,5,45,583,1148,245;47;F
52321;340;47;M
52322;190,1118,1656,340,1456,627,348,820,345,62,587,45,1657,1658,245;38;F
52326;9,347,820,435,627,51,106,1619,6,433,90,5,587,1518;52;F
52330;340,1657,344,1655,820,317;38;M
52337;1658;37;F
52378;5,9,822,820,707,1148,43,589,919,344,106,435,627,317,342;25;F
52385;433,587,5,1485,1654,43,1226,340,820,1058;48;F
52388;51,348,435,1518,1430,190,317,43,6,106,44,25,9,90,5;44;M
52391;898,593,1148,1653,43,90,52,344,1118,1226,53,340,1058,106;46;F
52400;166;43;F
52418;51,348,820,435,707,587,5,593,1430,919,44,344,1226,340,1058;48;F
52428;1656,63,345,1518,1658,583,342,707,1411;28;F
52440;820,345,627,435,340,51,25,90,583,245,1148,348,1658,190,596;34;F
52449;9,62,593,1658,1148,25,822,53,1058,345,1518,245,919,1118,820;40;F
52451;317,1653,627,1148,1658,583,245,190,347,596,51,348,340,820,345;34;M
52472;340;49;M
52476;44,1518;36;M
52478;166,25;42;M
52501;1658,1518;45;F
52519;9,25,51,348,1226,53,627,1411;45;M
52538;45,593,583,1654,44,344,1118,435,1518;38;F
52544;583,245;25;M
52556;1148,1653,347,344,90,51,52,627,707,53;32;M
52558;347,44,919,1118,53,1456,627,317;10;F
52567;45,342,340,345,1658,820;42;F
52575;45,433,62,583,1658,43,347,25,51,44,1619,53,1456,340,63;35;F
52582;5,1485,245,43,589,190,1619,90,596,25,348,342,820,106,627;42;M
52585;919,51,44,344,348,1118,53,1058,627,317;8;F
52607;43,822,44,433,62,593,245,589,90,348,53,1058,435,627,317;52;F
52608;1656,340,820,1485,347,52,106,435,627,1430,1422,90,51,317,707;32;F
52616;9,62,45,583,245,1654,43,347,51,342,53,820,627,1411,1518;7;M
52629;5,587,433,9,62,45,583,245,1654,43,347,51,342,627,1518;4;M
52634;6,317,90,5;55;M
52648;433,1456,583,245,1654,1422,919,342,1226;64;F
52680;62,1430,583,1456,44;33;F
52682;1118,587,9,90,919,344,44;41;F
52693;106,5,1485,245,190,43,820,1619,25,348,342,589,90,596,627;41;F
52715;5,1148,190,347,25,51,52,348,340,820,106,627,1518,435;21;M
52716;62,90,52,348,1118,53,340,820;20;M
52722;25,166,245;38;F
52733;1657,342;37;F
52755;587,593,245,1422,43,589,347,90,919,344,348,1226,820,1058,627;38;F
52756;347,45,62,1485,5,898,6,90,52,53,51,106,435,707,317;34;M
52759;347,587,593,245,43,1118,1226,820,1058,106,435,627,317,707,1411;48;F
52765;245,166,919,45,347,51,344,342,820,1058,627,345,6,5,587;45;F
52768;1485,1148,245,1118,1411,106;18;F
52769;340,820,627,1148,596,51,1411,106;16;M
52776;433,583,5,45,593,1148,1658,1654,190,43,344,340,1655,820,345;42;F
52779;190,1657,5,587,433,593,1148,1658,583,43,344,342,820,627,345;39;F
52788;45,51,348,53,627,433,583,190,344,342;37;F
52789;347,1422,1654,1148,5,45,1657,1658,190,919,344,1411,583,342,1655;38;F
52804;433,45,593,583,245,596,1118,53;38;F
52813;340,820,345;42;M
52816;345,5,9,898,1148,190,1422,596,348,1118,820,627;10;M
52822;1485,45,583,245,1654,1656,1518;32;M
52857;90,245,347,51,627,5,1657,1148,1654,190,1656,53,340,820,106;16;M
52867;340,820,1058,627,707,345,433,1485,45,593,1148,1658,245,190,919;44;F
52868;596,90,1422,6,593,5,1148,1653,190,43,919,344,1118,820,1456;41;F
52871;433,45,1148,1422,43,347,344,348,342,820,106,627,340,1518;41;F
52875;317,166,25;38;F
52879;1619,51,583,1430,433,898,1654,43,589,919,1656,820,1058,627,1411;22;F
52897;51,342,1118,106,435,627,317;23;F
52943;707,587,919,344,348,1058,106,245;38;F
52955;1655,106,317,1656,51,5,1654,345,583,1657,1658,347,340,820,627;34;F
52957;166,51,53,106,435,5,9,45,1148,43,820,627,25,44,1518;38;M
52962;90,820,435,1655,340,1656,348,344,190,245,1658,1148,593,5,345;37;M
52968;245,44;30;F
52990;166,25;42;F
52993;1653,1656,707,345,627,106,1655,90,347,1422,1654,583,62,344,63;33;F
52998;583,1422,43,589,596,919,344,348,1118,820,1058,1411,342,435,707;30;F
53006;5,52,25,6,43,51,1619,820,627,347,90,106,317;27;F
53012;1518;46;M
53024;52,51,347,43,1657,62,1658,190,90,25,342,820,106,627,345;28;F
53027;1518,317,627,820,1619,347,1430,5,9,1654,43,166,25;41;M
53033;1518;45;F
53045;1518;10;M
53049;898,593,1485,587,433,9,45,1658,245,25,44,344,435,627,1518;35;M
53062;587,344,347,166,433,5,9,6,43,822,25,44,435,627,317;47;M
53108;44;37;F
53196;433,62,583,1653,707,345;24;F
53198;5,25,166;41;M
53239;1148,898,593,5,587,6,245,25,919,51,1118,820,106,317,627;33;F
53241;51,6,45,5,44,344,1619,707,62,317,627,106,53,1656,347;53;F
53286;919,1619,627,5,245,51,820,317;34;M
53301;898,62,45,1148,1653,190,1422,43,51,344,348,1619,1656,1456,1411;48;F
53324;1148,1658,583,1653,1654,190,25,51,348,342,1656,340,1456,435,345;40;F
53359;5,1485,45,898,1430,1657,1148,583,6,1653,190,589,347,90,342;20;F
53370;1485,587,190,6,347,822,106,627,317,5,898,245,25,344,820;21;F
53402;45,1658,583,190,25,342,1656,1655,820,1485,5,340;23;M
53406;433,587,1430,347,919,1619,1456,627,1518;3;M
53422;44,820,1456,106,627,1518;4;F
53427;593,1485,5,596,919,344,1619,53,820,106,435,317,1148,52,51;33;F
53444;1485,5,9,1148,43,90,25,340,1058,190,245,344,820,435;38;F
53450;45,245,1654,347,90,51,52,344,342,53,1058,106,627,5,820;34;M
53458;5,6,245,25,344,1456;46;F
53494;919,822,596,166,43,583,9,45,5,593,25,51,44,344,342;42;F
53509;166,25,435;56;F
53510;435,166,25;62;M
53518;166,25;6;F
53530;1430,1411;50;F
53537;347,822,820,627,317,707,1058,1226,25,6,1430,587,593,589,919;24;F
53576;166,25;35;F
53592;1118,587,593,583,589,596,627;65;M
53612;106,919,166,1653,433,1430,1657,1148,1658,245;42;M
53613;51,919,52,344,1655,340,1518;18;F
53618;90,51,589,433,45,1657,1658,245,190,342,1456,707,1654,43,1619;35;F
53627;5,9,25,44;41;F
53641;1654,51,25,106,627,1518,5,9,1657,245,190,919,348,1656,820;47;M
53644;587,593,583,596,589,627;62;F
53656;1422,1654,6,1430,45,9,62,43,822,25,44,52,1118,820,1518;37;F
53682;1430,45,433,9,347,44,344,1118,1226,820,1456,435,627;41;F
53694;6,43,25;43;M
53696;1654,583,190,1655,1619,45,433,1653,347,1148,1656;42;F
53711;1148,1658,190,43,348,1518;42;M
53718;62,1148,347,6,51,344,435,627,1518,593,1430,317,707;48;F
53748;707;23;M
53768;62,627,1655,340,53,190,1658,1657,1148,345,1411;51;M
53777;9,62,347,51,53,106,1518,317,627,1118,348,344,25,596;45;F
53781;5,1485,898,45,583,190,43,25,344,342,1656,53,340,820,63;8;M
53786;342,44,51,1654,245,5,348,53,820,627,1430,6,1518,344,593;45;F
53790;6,245,62,919,347,190,348,1619,340,1655,820,106,435,627,317;42;M
53797;583,190,596,25,51,344,342,1656,53,340,820,1456,63,1411,1518;12;M
53801;919,593,348,583,1518,1456,25,587,9,6,245;25;F
53820;348,62,9,5,587,347,919,51,433,1430,1411,90,44,1619,6;42;M
53827;587,593,6,245,44,1619,820,707,1518;46;F
53834;587,51,1118,1518,344,919,25,1430,9,5,45,43,166,53,820;44;M
53860;1430,62,5,433,587,45,1657,1148,1658,1653,190,342,1656,340,345;9;F
53863;1518;4;M
53877;106,317,9,5,433,45,1430,245,43,347,25,51,348,627,1518;11;F
53886;5,1485,1148,190,43,347,25,51,344,53,820,106,435,627,317;27;F
53895;596,6,245,1430,5,9,43,25,51,344,820;17;F
53901;433,5,9,45,1430,245,43,347,25,51,348,106,627,317,1518;13;M
53902;90,347,43,1654,583,45,433,5,9,593,6,245,596,51,1118;33;F
53913;51,90,347,43,1422,6,583,45,5,9,25,820,1456,627,1518;36;M
53926;433,106,5,9,45,245,43,347,25,51,348,53,317,627,1518;6;M
53944;90,596,919,348,1619,1118,1226,1656,340,820,1657,1148,1658,190,342;28;F
53983;5,9,45,583,6,1422,43,347,90,25,51,820,1456,627,1518;6;M
53987;62,6,347,344,1456,106,627,1518;48;F
53999;52,190,6,1430,62,43,347,51,53,106,627,317,345,1518;48;F
54037;52,53,707,898;45;M
54040;348,53,345,919,342;41;F
54047;45,245,1654,44;51;F
54052;45,5,433,1658,583,1653,190,342,1656,340,1655,820,63,707,345;58;F
54054;5,1411;16;M
54071;1411,583,1518;21;F
54084;5,43,347,51,344,1619,53,820,106,627,317;34;F
54085;1430,245,347,44,53,820,435,627,190,348,25,9,583,1518;33;F
54119;106,433;43;M
54142;1619,53,1658,433,52,344,627,345,820,342,919,340,1518;40;F
54194;1518,317,820,51,25,5,9,44;46;M
54196;190,166,347,51,44,52,342,1656,53,340,1655,820,63,707,345;59;M
54212;587,9,62,1430,1148,245,347,348,1619,1226,1058,1518,106,627,317;34;F
54214;166,25;31;M
54283;1658,919,340;29;F
54290;1658,1518;46;M
54303;90,53,5,1485,51,707,6,344,52,348,820,106,435,627,317;53;F
54320;1657,245,25,348;41;M
54325;820,1422,106,43,9,1485,433,5,51,435,1118,348,25,6,1518;35;M
54329;587,1658,583,245,1653,190,43,589,90,348,1118,1058,435,707,1518;41;F
54342;317,347,1058,106,627;20;M
54353;5,9,25,44,1518,6;26;F
54365;43,51,348,587,1148,245,190;63;F
54368;1657,1658,245,25,348,345;7;F
54395;347,1619,53,1655,63,627,1430,1657,1658,245,190,25,348,820,345;39;F
54399;106,820,51,347,245,435,317,707;40;F
54463;1148,245,347,53,106,627,317;47;M
54487;1058,1411,1518,166,25;47;F
54508;53,43,1653,62,5,1148,245,190,919,51,344,348,342,1118,1518;50;F
54512;583,433,587,1148,1658,245,1653,190,919,52,344,348,1058,435,345;64;F
54516;5,9,45,583,6,1422,43,347,90,25,51,820,1456,627,1518;36;F
54521;62,583,245,1422,347,919,348;42;M
54531;1518,435,820,53,348,51,347,43,9,5,6,25,44;35;M
54534;5,9,45,583,6,1422,43,347,90,25,51,820,1456,627,1518;11;F
54550;1518,583,245,25,919,44,317,62,1653,190,347,51,53,627,345;44;F
54565;1656,583,587,919,51,1619,1655,345,1148,245,347,53,106,627,317;45;F
54567;245,1656;53;F
54572;587,1485,1422,1430,45;44;F
54582;340,1657,587,1148,1654,190,919,820,1058,1658;45;F
54583;25,9,90,44,6;15;M
54584;1518,1657,583,43,347,25,919,51,44,1619,1226,53,820,1456,1058;34;F
54609;1656,345,1518,51,583,1658,1148,62,433,898,347,25,53,340,1422;28;F
54612;596,593,9,587,5,45,583,1422,166,25,51,342,1118,820,627;36;F
54620;5,43,52,627,317,707,44,347,25,344,596,1118,820,1518,9;47;F
54627;435,1118,1518,1411,348,90,9,25,5,6;27;M
54628;1655,820,583,1658;30;F
54633;5,1518,166,25;50;M
54639;1518,317,106,344,5,9,45,43,25,44,53,627,820;47;M
54655;1485,5,433,583,1654,1656,340,1657,1658,348,342,53,1655,707,345;37;F
54667;45,342,340;36;F
54683;1657,1658,1656,1655,1654,1653;67;M
54687;1422,919,1619,820,707,345,1657,1658,90,596,822,344,348,342,1655;37;M
54699;1226,340,1058,627,317,1657,1658,245,190,348,342,53,820,435,345;41;F
54702;317,6,5,347,43,90,596,25,44,52,53,820,106,627,1518;12;M
54712;1518,9,6,1654,43,25,51,52,44,342,1118,53,820,627,317;9;M
54719;1148,1430,593,587,433,43,25,52,348,820,1456,1058,435,1518;30;F
54726;583,245,190,589,347,596,51,344,1118,340,820,106,435,627,317;21;F
54733;587,1657,1148,1654,190,919,340,820,1058,1658;7;M
54743;9,583,190,1422,43,589,347,822,1656,820,1411,345,5,340,1148;23;M
54747;347,51,1148,1658,583,245,1654,190,348,342,1226,340,820,1058,627;41;M
54767;433,1657,1654,347,342,53,820,106,627,345;32;F
54770;587,1657,1148,1654,190,919,340,820,1058,1658;60;M
54771;53,435,44,51,190,1148,62,589,347,245,6,1619,106,627,317;19;F
54775;583,45,5,587,433,593,1657,1148,1658,1654,348,342,1118,1226,345;33;F
54784;347,344,348,820,1058,317,707,587,245,190,43,90,25,106,627;58;F
54790;587,1657,1148,1654,190,919,340,820,1058,1658;68;F
54803;348,90,347,62,1485,5,45,43,51,342,820,106,435,317,707;34;F
54808;5,6,245,43,90,1619,1118,106,317,1411;36;M
54822;627,593,822,587,1148,245,435,348,51,25,589,190,5,820,106;29;M
54831;1456,1058,1657,1653,1422,51,344,45,1148,1658,433,90,106,627,245;37;M
54850;90,1422,190,1430,62,5,587,433,898,1148,245,1654,43,348,820;45;F
54860;1654,1518,345,317,627,106,1422,245,1148,5,25,348,53,340,820;35;M
54871;9,245,43,25,44,1411;56;F
54897;583,1655,433,245,190;40;M
54901;62,1118,53,435,627,348,51,25,347;48;M
54903;1148,190,106,348,345,627,820,90,596,347,245,1657,45,1654;;M
54905;44,340,820,1518,1411,106,822,90,589,62,583,596,348,1118,1655;59;F
54906;9,44;43;M
54916;433,45,1657,1148,1658,245,166,1653,90,51,344,820,1456,106,627;35;F
54936;51,347,43,245,6,1485,9,90,25,348,820,435,627,1518;66;F
54943;166,822,44,342,1656,53,1456,63,345,1518,587,1430,583,25,707;37;F
54954;345,342,63,5,62,1148,1657,1658,583,44,1118,1656,53,820,707;29;F
54960;435,53,1619,596,1422,245,45,5,433,9,25,44,63,707,1518;25;F
54961;245,348,627,345,587,1148,1658,190,43,347,342,1226,1656,1058,106;38;F
55047;62,1430,1657,6,1654,190,822,44,348,342,53,340,1655,707,345;29;M
55054;166;38;M
55067;166;11;M
55071;166;5;F
55079;5,583,1654,1422,43,90,822,25,51,1518;43;F
55084;587,5,593,344,348,1226,820,1058,245,43,596,51,1118;34;F
55086;596,1118,627,43,1422,1430,1657,1658,1619,1655,1485,45,245,1653,25;38;F
55100;317,1655,1118,25,596,43,1422,1653,245,583,1430,45,62;10;M
55149;587,596,919,344,348,1058,317,707,1518,1118,245,433;33;M
55154;433,52,435,627,5,45,1658,190,43,51,344,1118,53;32;F
55182;62,627,190,342,340,1657,1658,583,1653,1654,1422,90,1656,1655,345;43;F
55186;1422,44,1619,1655,63,1518,1657,1658,347,342,1456,106,627,707,345;37;F
55187;53,1226,1619,51,25,596,245,583;33;M
55218;245,1654,347,822,44,348,1656,1655,820,627,317,345,1518,25,1411;38;M
55223;25,5,43,1118,1619,9,1430;27;F
55226;5,898,45,245,90,52,344,342,1656,340,1655,820,627,1653,1654;37;F
55240;435,1058,1456,1226,344,25,583,1430,433,5,587,593,1654,1422,166;43;F
55247;166;11;F
55255;166;13;M
55262;166;68;F
55267;166;68;F
55273;166;67;M
55276;43,342,1619,340,1655,820,1456,63,106,627,317,707,345,1411,1518;38;F
55279;25;34;M
55280;245,166,627,5,25;46;M
55286;51,52,348,1518,62,583,190,43,347,90,344,627,106,53,340;34;F
55296;433,587,45,919,51,44,1456;28;F
55300;1654,1430,45,1658,583,348,1656,340,345;42;F
55313;6,589,347,596,348,1118,106,627,317,1658,435;38;F
55315;5,820,317,1518,433,9,6,245,1654,25;33;M
55359;190,43,347,51,52,344,53,820,106,435,627;43;M
55368;1148,344,340,820,317,898,45,6,43,347,919,51,53,106,627;44;F
55376;627,898,62,1657,106,45,1148,51,348,342,1656,1658,583,1654,190;40;M
55416;62,587,45,1430,6,347,51,344,348,1619,53,1456,106,627,1518;47;F
55418;820,25,43,5,587,583,627;71;M
55424;898,45,593,1430,1411;44;F
55437;45,43,44;38;F
55463;5,6,52,53,435,317;8;F
55475;5,9,53,1430,44,1518,433,245,1226,51,6,25;21;F
55481;317,5,6,52,53,435;41;M
55496;1654,190,822,51,44,1619,820,63,898,45,1658,245,90,345,1518;36;F
55497;919,51,53,5,433,45,342,1655;34;F
55498;1654,166,589,596,822,1619,1226,1656,1655,1456,45,820,435,317,1518;38;M
55508;43,1148,593,62,1456,1058,106,627,587,583,1653,347,919,1226,1656;28;F
55520;5,6,52,53,435,317;38;F
55526;51,344,53,1456,627,1518,1411,44,348,342,820,106,435,317,707;38;F
55548;587,1411,1518,707,317,627,435,106,820,919,166,43,45,433,25;39;F
55564;1518;31;F
55565;627,106,820,53,51,919,596,347,43,190,245,62,45,1148,1658;41;F
55567;44,43,45;9;F
55569;44,43,45;40;M
55572;1658,1653,1654,1657,1656,1655;8;M
55587;45,43,44;7;F
55594;587,1422,1619,5,919,51,820,106,627,317,1148,245,347,1656,53;25;F
55602;583,1654,1619,1118,1456,707,1518;36;F
55623;1658,1657,1656,1655,1654,1653;76;F
55653;898,9,1485,5,583,190,919,344,340,820,1456,1518,345;39;M
55671;6,190,43,90,25,344,62,347,52,1619,53,106,627,317,51;32;M
55719;44;35;M
55724;25,344,1619,435,707,345,245,190,347,51,52,53,106,317,627;29;F
55728;627,707,51,589,1058,62,347,90,1619,1411,587,245,6,5,1518;28;F
55760;1430,1657,1148,1658,583,245,1654,190,43,90,53,340,1655,345,1518;39;F
55761;583,344,340,627;25;M
55776;433,587,5,1485,9,593,1654,43,25,919,1226,53,820,1058;28;F
55777;593,583,1653,596,51,348,1118,1456,627,587,245,190,347,53,1518;45;F
55779;1430,1657,1658,1654,1422,822,342,53,1456,63,345,1518,583,25,44;35;F
55780;1430;25;M
55784;433,25,51,52,106,317,347,627,245,190;15;F
55789;1411,1655,820,1148,1657,1485,1658,1653,190,1422,348,52,1656,106,627;19;M
55815;6,1456,340,62,347,820,106,344;27;M
55820;1422,166,627,587,433,593,583,245,1654,340,1658;40;F
55829;52,344,1655,345,342,919,90,43,190,1653,1148,1657,62,245,348;35;F
55848;45,1422,245;55;F
55853;45,1657,1658,190,43,51,44,348,1656,53,340,1655,63,707,1518;36;M
55854;587,898,593,1658,43,25,348,342,340,707;41;F
55870;1148,25,1653,589,1058,317,435,347,1226,106,627,1658,245,190,51;40;M
55872;1518,627,106,820,340,53,51,347,1422,190,62,898,1148,583,43;26;F
55883;106;55;M
55895;1148,820,345,317,106,627,62,1430,1654,190,347,25,51,1619,348;42;F
55900;317,627,52,51,90,43,1654,1658,62,1485,5,1148,347,820,106;38;M
55903;45,1430,1657,1658,190,347,919,348,1118,53,340,820,1456,345,583;37;F
55904;1658,1653,190,43,347,25,51,52,1619,53,820,106,627,345,1518;39;F
55905;348,1656,53,820,106,627,317,433,5,6,245,1422,347,90,51;42;F
55921;317,1518,433,587,62,593,1657,1653,51,1656,53,1655,1456,1058,63;33;F
55931;1118,344,919,1430,587,43,1619,52,51,90,245,6,5,1411,1518;40;F
55944;44,1411;30;M
55975;433,245,919,1656,627,707;67;F
56032;1430,587,919;43;F
56058;433;14;F
56076;5,898,6,90,51,52,53,435,707;36;M
56084;1518,1456,53,1656,25;27;F
56090;1654,5,340,317,1657,1148,1658,245,190,90,347,51,820,106,627;50;M
56094;52,344,820,435,345,62,6,1653,53,317;40;M
56108;166;44;M
56112;166;11;M
56114;190,51,820;37;M
56141;51,344,342,1118,820,1456,1058,106,433,587,9,347,1619,627,1518;44;M
56149;45,1653,43,342,1655,820,627,347,62,1657,1658,190,51,340,345;39;F
56152;1430,348,1619,51,6,62,433,587,245,347,90,52,344,1456,627;52;M
56172;1654,5,340,317,1657,1148,1658,245,190,90,347,51,820,106,627;46;F
56178;62,45,1148,1658,190,347,51,348,53,340,820,106,317,627,345;38;F
56185;245;52;M
56207;1411,345,317,627,435,106,820,44,51,347,43,5,190,9,25;31;M
56213;45,1657,1658,1148,1654,190,347,51,348,820,106,627,345,340,898;44;M
56215;45,1657,1658,583,245,1653,919,342,1656,1655,1058;38;F
56222;317,707,1411,5,62,43,589,90,596,51,52,342,820,627,106;48;F
56227;596,587,1485,1456,1058,627,317,90,898,6,51,53,435,52,707;33;M
56230;5,9,6,190,43,589,90,25,51,348,53,820,106,627,317;30;M
56233;5,43;40;M
56247;6,190,43,90,51,348,53,820,5,9,589,25,627,106,317;33;M
56254;898,1430,583,596,166,25,1655,345,340;15;M
56285;1118,344,919,25,822,190,1148,593,5,587,45,245,43,596,435;61;F
56314;1657,1148,583,1653,1654,190,347,596,25,51,348,340,1655,435,317;50;M
56333;345,627,433,9,347,822,25,44,1655,63,435,317,45,583,1654;41;F
56335;820,317,106,348,919,340,1148,1653,190,347,627;66;F
56346;9;70;M
56377;587,5,1148,1653,190,43,347,344,1656,340,1655,820,106,627,345;68;M
56386;583,1658,45,433,62,898,1653,348,1656,1456,106,627,345;37;F
56387;347,822,25,344,820,627,345,1411,9,190,43,51,44,1118,1518;31;M
56391;190,25,342,1656;34;F
56422;347,596,52,348,106,435,345,45,1148,1653,245,1656,340,1655,820;51;M
56425;1658,1653,190,43,347,25,51,344,1226,1655,340,106,627,317,345;38;M
56436;1148,6,245,1654,1653,43,596,822,44,348,1656,820,435,1518,707;25;F
56443;433,190,51,435,106,25,348;25;F
56444;1653,1485,5,62,1430,1148,190,347,51,344,348,820,106,435,627;25;F
56447;587,1148,1658,1653,190,347,25,344,1656,53,340,1655,820,106,627;66;F
56514;347,90,596,342,1118,53,340,1655,433,5,45,43,25,344,820;57;F
56550;1411,1656,1658,1654,45,245,43,44,1619,342;44;M
56590;898,347,822,1619,1656,53,820,106,435,707,9,62,44,627,317;29;F
56612;593,166,25,344,342,1118,435,317,707,1411,1518;34;F
56626;51,52,1118,1655,627,317,345,5,1148,190,347,344,340,820,106;34;M
56671;433,1485,1430,1422,1411;22;M
56678;345,1518,1485,1148,1658,245,190,589,822,342,106,5,1654,43,348;33;M
56691;317,627,106,820,340,1411,342,166,6,5,1518,44,25,43,9;35;M
56740;433,587,9,593,1430,583,43,25,919,348,1226,1058,435,627;71;F
56753;1654,1653,1658,1657,1656,1655,1518;38;M
56783;44,1118;43;F
56784;1654,589,90,44,1619,1656,106,627,62,583,25,919,342,707,1518;38;F
56791;5,9,43,25;52;F
56793;5,190,1422,43,347,90,25,51,52,340,820,1058,435,627,317;26;M
56813;1148,1657,51,344,348,1656,820,106,627,433,62,1430,1658,245,1058;43;F
56828;1118;14;F
56838;1118;11;F
56848;1411,345,627,5,190,43,820;48;M
56862;1118,1653;64;F
56870;587,347,340,919;48;F
56878;1118;89;F
56905;1118;68;M
56918;166,25;75;M
56932;1653,1118;65;M
56937;1118;46;M
56949;166,25;12;M
56951;166,25;8;M
56964;166,25;40;M
56967;25,44;35;F
57020;44,51,822,90,433,5,43,52,348,1118,820,106,435,627,317;32;M
57024;166,25;41;M
57031;820,348,52,51,596,90,347,43,190,1654,245,1658,1148,1430,5;41;F
57057;919,348,1456,707,9,347,344,1118,820,106,43,44,435,627,317;29;F
57090;44,25,596,347,589,43,1654,583,1658,1657,1430,62,245,1456,1518;46;F
57092;245,1430,45,62,5,1148,1658,190,43,52,348,1619,1118,820,1456;12;M
57099;317,43,1118,820,106,435;36;F
57127;1485,583,1456,1058,435,1518,707;34;M
57133;52,347,593,62,245,348,627,1518;37;F
57135;344,53,820,106,435,317,345,1148,1653,347,90,6,245,52,627;40;F
57144;1430,6,1654,43,1422,589,348,919,1619,1118,1226,1656,1058,435,345;22;F
57167;593,62,898,9,587,5,45,1654,43,90,25,344,53,627,1518;41;F
57171;90,345,1657,1148,190,245,43,51,919,344,348,1656,820,106,627;20;F
57176;919,596,589,190,1430,5,587,593,43,1656,433,583,1422,1655,1518;33;F
57181;45,62,433,435,317,627,344,348,1619,1411,1518,53,51,44,9;44;F
57188;1518;77;M
57202;245,43,166,347,25,52,53,1655,1456,106,317,627,44,9,1518;45;M
57206;707,435,1411,106,317,1485;34;F
57222;627,820;70;M
57254;345,344,347,6,5,9,190,25,348,53,820,106,51,627,317;34;M
57259;9,43,822,25,51,44,52,344,1619,53,820,1456,106,627,317;38;M
57288;51,52,106,1657,1658,1653,1654,347,340,345;46;F
57295;25,435,707;32;F
57306;45,898,583,9,1518,627,63,820,53,52,347,6,62,5,587;63;F
57319;62,1658,190,1422,43,589,348,342,1118,1226,820,1058,627,433,245;36;F
57360;596,344,589,347,593,62,433,587,43,1058,1456,627,317,919,44;64;F
57366;1657,1148,1658,245,1654,190,1656,340,820;24;F
57373;1653,190,51,340,106,627,345;34;M
57376;90,43,245,583,1148,593,587,1456,1058;26;M
57386;1430,898,583,1653,1658,1148,1657,596,1619,1118,820,627,340,345,348;38;F
57407;1456,919,589,348,62,51;26;F
57415;707,51,317,347,1148,245,344,106,345,587,593,583,1226,1058,627;26;F
57432;245,45,583,1148,1653,344,1656,340,627,345,190,347,51;30;F
57456;1658,1654,190,1422,347,596,25,344,348,1619,1118,53,340,820,1456;43;F
57512;1658,1653,707,345,51,347,919,1619,53,820,627,317,245,190,106;19;F
57514;1656;36;F
57523;1657,1148,1658,190;33;M
57546;583,433,45,245,707;32;F
57586;90,347,1422,6,583,9,5,822,25,44,52,344,53,820,627;48;M
57643;6,1422,347,90,25,919,52,348,1118,820,435,106,627,317,707;49;F
57652;90,596,52,1619,317,106,583,43,589,25,820,435,627,1518,1411;27;F
57710;1226,1058,587,106;62;F
57782;820,51,627,106;56;F
57818;43,1422,347,90,342,106,45,25,52,344,53,820,627,317,51;38;M
57855;90,344,627,106,820,53,1656,51,347,589,43,190,583,342,345;38;F
57889;433,9,43,51,52,344,820,106,627,317;17;M
57903;1654,589,1485,1422,820,707,44,25,919,1655,45,1148,1658,340,345;58;F
57934;6,1422,43,90,919,51,52,348,1118,53,820,106,435,317,707;27;F
57989;1654,51,344,1653,45,583,90,1657,820,1656,1655,190,245,627,345;31;F
58039;53,1456,9,1148,6,190,347,51,52,344,820,5,1422,43,435;25;M
58045;1422,51,44,344,342,1655,1518;37;F
58070;190,6,1148,347,627,587,245;49;F
58110;627,106,1655,1619,342,344,44,90,43,1422,6,62,5;1;F
58114;106,627,1656,342,52,51,245,6,1658,1148,45,62,347,90,345;37;F
58192;1456,106,627,1518;45;F
58227;106,627,1518;10;M
58238;5,52,340,820,435,317,707,6,245,43,347,51,53,106,627;35;F
58242;53,1456,627,1518;15;F
58254;25,583,44;32;F
58264;90,627,1518;48;M
58296;44;34;M
58305;1118,433;26;M
58372;44;6;M
58386;44;5;F
58406;5,9,6,43,25,344,1118,820,1518;46;F
58425;51,52,106,435;31;M
58461;45,345,1518,627,317,106,340,6,9,5,347,1656,90,63;55;F
58470;1658,1148,1657,45,62,5,245,53,1655,820,106,627,317,345,1518;35;F
58498;596,245,1430,62,9,5,587,166,25,44,344,348,53,1456,1518;44;F
58499;106,627,317,707,1411,433,587,5,9,45,593,6,245,51;35;F
58554;820,340,1226,587,593,583,589,596,919,344,348,1118,53,1058,627;21;F
58593;90,347,166,6,1430,45,5,62,9,245,25,44,348,53,1518;11;F
58595;245,190,1655,1653,627;70;F
58609;820,340,106,342,51,1148,583,1653,190,589,1655,345,1654,1657,348;31;M
58634;1456,53,44,1654,25,1619,1518;35;F
58637;820,340,106,342,51,1148,583,1653,190,589,1655,345,1654,1657,348;29;F
58640;1653,5,1148,1658,190,347,51,344,348,53,340,820,345,627,106;43;M
58648;1118,348,44,51,25,822,596,90,347,245,6,1430,62,9,5;16;M
58657;25,51,820,1518;35;M
58662;587,433,583,1653,596,344;36;F
58674;51,53,627,106;36;M
58688;51,1058,627,106,1518;54;F
58695;1411;19;F
58714;1658,1148,1430,1654,348,1058,627,345,190,245,589,820,342,1118,106;37;M
58726;822,1411,1518,1430,587,166,25,1619,44,1118,433,90,5,43,245;28;M
58728;9,25,44,52,348,53,820,1518;19;M
58746;9,345,707,317,52,25,822,245,1619,1518,44,5,90,433,6;41;F
58793;245,583,1658,1148,45,898,587,43,596,51,44,344,348,820,1118;39;F
58814;435;29;M
58835;340,1655,63,45,9,1148,190,43,596,51,344,1118,820,435,1518;38;M
58849;106,435,707;40;M
58854;707,166,90,6,1619,1411,1118,820,317,435,627,1518,9,25,44;26;M
58886;51,822,190,1654,1657,45,433,62,1658,583,43,589,25,348,53;33;F
58902;245,342,1655;32;F
58938;587,433,1485,90,51,317,1422,43,707,25,1148,5,190,820,245;58;M
58973;433,43,596,348,820,1058,106,435,1518;55;F
58984;344,348,53,820,1456,1058,5,106,317,90,43,245,6,627,1518;46;F
59010;1653,245,190,348,342,1655,820,435;33;M
59025;1148,1657,45,5,344,340,1655;36;F
59069;317,627,106,344,51;28;F
59088;52,1118,53,5,1485,6,190,347,51,344,820,106,627,435,317;29;M
59100;53,1411,62,9,1148,345,5,6,190,347,51,820,106,627,317;32;M
59104;1655,1619,245,1430,344,190,1653,1148,347,51,106,435,627,345;31;M
59118;44;39;F
59122;43,435,5;36;F
59126;1456,342,1653,5,433,583,245,190,43,347,1655;42;M
59129;1485,9;49;F
59161;9;33;F
59173;45,1654,190,589,90,898,25,5,9,43,596,820,1118;50;M
59174;44;43;M
59187;245,342;32;F
59198;9;72;M
59222;51,348,820,5,9,43,25;50;M
59226;106,707,345,1518,317,627,435,820,433,62,589,25,1619,1118,53;43;M
59234;1518;37;M
59266;5,6,90,52,53,435,707,51;31;M
59285;820,6,1658,587,433,5,9,45,245,25,52,344,348,342,1518;42;F
59296;317,1518,1226,342,919,596,1422,5,822,435,43,9;22;F
59303;9,43,347,44,52,1226,53,1456,1058,106,435,627,317;48;F
59305;348,342,340,435,345,1654,190,1653,583,1148,63,1657,1656,1655,1658;39;M
59320;5,898,6,90,51,52,53,435,707;30;F
59345;25,1411,44;44;M
59346;43,9,6,1430,919,90,25,44,348,1619,1118,820,707,1518;21;F
59349;347,344,106,435,627,5,9,90,51,707,317,190,25,52,820;27;F
59352;5,898,6,90,51,52,53,435,707;3;F
59375;166;45;M
59382;5,9,6,25,44;29;F
59386;166;13;M
59393;166;5;M
59394;44,43,9;12;M
59407;347,25,344,348,53,627,1619,6,51,435,1485,317,707,90,52;39;M
59458;1148,1657,45,9,1485,433,5,166,25,344,820,1058,435;38;M
59462;1485,62,6,589,347,90,25,51,344,52,106,435,627,317,707;36;F
59473;6,245,51,435,317;41;F
59474;5,1658,1657,1653,1654,190,1656,340,1655,345;40;M
59480;1058,9,593,1430,245,43,347,25;40;F
59484;340,1655,820,345,43,1422,1653,1148,1657,45,25,583,1658;35;F
59485;9;8;F
59486;345,1655,340,1656,190,1654,1653,1657,1658,5;8;M
59496;919,627,707,5,583,25,435;31;F
59497;820,1655,53,51,90,190,6,5,433,587,1653,347,348,106,627;51;F
59498;919,51,1619,5,62,6,347,90,44,344,53,820,1058,627,317;37;F
59521;1654,1430,5,9,45,190,43,166,25,44,342,340,820,1518;34;F
59554;45,43,347,25,166;52;F
59555;166;43;F
59566;1653,822,344,1148,245,190,347,51,820,627,596,589,348,106,25;47;F
59570;5,166,25,820,347,90;41;F
59594;347,190,6,9,1485,5,433,587,593,245,43,596,51,348,1518;46;F
59605;6,1658,1148,62,433,5,1654,43,589,822,344,53,820,106,627;44;F
59609;433,583,166;45;M
59627;166;45;F
59651;5,344,820;46;M
59667;1657,1658,583,1654,342;35;F
59674;1655,317,433,1658,1653,1422,1518,627,106,1456,1656,1118,1619,344,596;26;M
59677;5,344,627,317,347,90,348,106,898;40;M
59711;822,344,627,5,45,1148,6,190,340,317,245,43,347,51,820;32;F
59718;51,1148,6,347,822,344,342,820,317,5,43,106,627,245,707;42;M
59720;1148,45,62,9,433,1654,347,25,344,348,1619,1118,627,317,1411;18;M
59736;583,345,317,342,52,344,51,347,190,245,1657,1656,106,627,1655;42;F
59784;9,43,44,820;9;F
59785;106,435;32;F
59797;6,90,1456,25,5,43;45;M
59809;919,1619,53,820,106,435,317,1411,433,1148,583,1653,627,347,51;35;M
59815;51,340,627,1456,317,707;28;F
59817;166;31;F
59818;166,25;9;F
59837;707,62,587,190,25,919,51,344,53,820,1058,106,435,627,317;28;F
59840;433,1518,344,52,51,347,62,6,348,53,106,317,627;32;M
59843;340;36;M
59845;25,166,1518;12;M
59890;62,1148,245,43,51,106,627;55;M
59893;596,52,344,317,166,25;38;F
59904;190,347,51,106,345,627;34;M
59906;1411,627,820,1657,1658,1653,190,342,1656,340,1655;37;M
59924;822,348;51;M
59928;820,342,1654,5,190,347,51,348,340,1655,583,45,1148,245,433;33;M
59958;1653,1658,6,190,43,347,51,1619,1655,106,345,348,1656,53,627;54;F
59973;342,106,627,317,707;36;F
59974;9,5,583,166,52,344,820,627,25;47;M
60004;587,593,1658,245,1653,190,919,1656,340,1058,317,707,345;52;F
60050;6,9,62,347,25,51,44,348,53,820,106,435,627,317,1430;48;M
60068;1411;23;F
60120;90,51,52,1656,317,1657,1653,1654,190,347,348,1619,106,627,345;31;F
60144;1654,589,820,245;32;M
60147;25,52,1118;49;F
60154;62,347,1411;22;F
60166;433,45,344,1118,1518;45;F
60169;51,25,6,45,5,62,245,44,53,820,1518;26;F
60178;45,53,340,820,1411,62,1485,433,190,43,435,106,348,63,707;42;M
60198;433,587,1148,245,347,344,1518,707,1619,898,45,190,166,25;41;M
60205;593,45,62,898,587,433,5,583,1654,596,25,344,342,820,1118;10;M
60208;317,342,245,45,340,53,707,433,1658,1653,347,90,1656,106,627;36;F
60215;245,433,1148,45,583,1655,340,348,51,347,190,5,1654,342,820;30;F
60216;593,1226,587,433,45,245,919;46;F
60238;345,1658,583,342,707;32;F
60243;340;17;M
60247;6,90,347,51,344,340,820,106,317,1653,627,345,1656,1657,596;34;M
60269;587,433,62,45,1430,90,593,1148,583,245,1653,190,919,348,1656;41;F
60271;62,1658,6,347,51,52,344,1656,340,627,106;33;F
60272;347,433,245,1148,45,583,340,348,51,190,5,1654,342,1655,820;3;M
60279;1148,1653,190,348,1656,435;44;M
60316;5,245,190,43,52,820,106,345;49;F
60322;245,1148,5,1657,1658,6,1653,1654,190,344,1118,340,820,106,345;43;M
60328;43,190,344,820,6,347,51,53,106,627,317;41;M
60330;1653,1422,347,90,344,1619,1656,340,820,106,627,345,1411,1148,348;53;F
60334;45,593,1658,1653,190,347,1655,106;54;F
60366;433,245,1148,45,583,1655,340,348,51,347,190,5,1654,342,820;1;F
60388;9,1518;47;M
60406;106,1485,245,1653,51,348,340,820,345,1118,1655,435,1411,1518,1148;29;M
60429;1658,340,820,345,627,106,51,347,43,190,245,62,1485,5,1148;46;F
60464;1656,45,1148,1653,43,25,820;47;M
60503;190,25,51,820,627,317;43;M
60530;5,43,348,340,345,1658;35;M
60536;1485,43,344,1118,1430,1411,5,1518;11;F
60587;1653,919,1058,345,1657,1148,1658,190,1655;34;F
60603;587,45,593,347,90,25,1619,1058,106,627,317,707;31;F
60617;707,43,90,25,51,52,344,1619,1656,53,627,317,347,435,106;29;F
60668;348,344,596,90,347,190,1148,5,1657,245,627;44;M
60674;587,5,9,347,51,344,53,820,627,345,1518,25,106,435,317;35;M
60681;5,45,1148,190,43,25,820;39;F
60697;45,245,25;40;M
60699;1518;39;F
60705;6,245,43,347,51,52,106,5,9,45,166,25,344,820,627;39;M
60707;1518;50;M
60717;1148,5,433,1430,1658,245,1653,347,1619,1656,1655,435,345,45,627;36;F
60723;90,919,1456,5,9,45,1430,43,347,25,166;41;M
60728;62,1657,6,347,90,51,1619,53,627,317;40;F
60778;1118,106,707,345,1518,9,43,347,51,44,344,348,53,1456,627;27;M
60794;245,587,1148;43;F
60800;51,90,1654,6,5,1148,1658,190,43,344,348,53,340,1518;46;M
60802;1430,344,1411,1518;62;F
60846;1430,344,1411,1518;66;M
60886;45,348,583,347,820,1148,245,1653,596,51,1619,1655,1058,106,627;47;M
60897;1430,1518;45;F
60899;587,1658,245,25,1656,1518;59;F
60904;1430,53,1656,1118,52,51,596,589,5,6,1422,106,348,435,317;53;F
60910;1653,589,347,340,1456,587,190,43,25,51,52,348,820,106,627;63;M
60938;1430,1518;17;F
60941;1456,627,348,340;39;F
60946;245,433,1518;37;M
60958;1430,1518;13;M
60959;9;42;M
60977;1430,1518;12;F
60982;345,51,919,348,1656,53,820,435,627,1518;67;M
60990;1430,1518;12;F
61000;1430,1518;46;M
61018;1658,340,820,345,627,106,1655,344,52,51,25,347,6,1653,190;37;M
61030;166,25;49;F
61091;1422,245,583,45,62,433,347,348,51,52,317,627,90,53,106;48;M
61120;25,820,5,166;15;M
61123;25,166;42;F
61137;583,1654,190,1422,348,106,627,340;44;F
61146;9,1658,583,43,347,90,25;38;M
61168;45,62,898,9,433,1058,63,106,435,627,317,707,345,1411,1518;12;F
61192;45,1518,435,1656,348,44,166,1654,5,1485,9,25;40;M
61221;5,245,1422,90,919,25,51,52,348,1619,53,106,435,707;36;M
61269;347,596,25,51,52,344,348,1619,1118,1226,1656,707,345,1411,1518;8;F
61273;190,1148,1430,433,587,593,583,596,25,348,1118,340,1058,317,1411;26;F
61281;90,596,51,348,342,53,820,1456,106,435,627,317,587,52,344;40;F
61300;6;33;F
61305;90,919,1226,53,1058,627;37;F
61316;587,347,919,106,627,317;27;F
61340;822,919,44,348,1226,340,820,1456,1058,106,627,317,345,1411,1518;1;M
61350;53,820,1456,166,9,25;39;F
61356;583,1654,166,25,44,1656,340,1518;7;M
61365;596,919,344,348,1226,1456,1118,1656,1657,1658,583,1654,345;27;F
61369;53,1485,5,9,43,347,25,344,348,820,106,435,627,317,707;34;M
61372;166,25,44,340;7;M
61376;1518;34;F
61386;1658,166,25,44,340,63;6;F
61398;340,1518,43,190,5,919,820;31;M
61403;5,593,596,53,106,6,627,245,1654,1422,43,919,348,1118,820;35;F
61405;106,1619,344,52,51,90,166,9,587,593,43,1518,5,6,25;27;F
61415;1456,1430,1518,1411;43;F
61422;627,106,53,51,1654,62,1657;35;F
61440;25,9,51,44;35;F
61447;1655,583,1656;38;F
61456;1653,190,822,52,1656,53,317,5,6,43,90,51,344,627,106;26;F
61457;5,62,1422,52,589,43,627,9,6,25,44,1118,53,820,1518;42;M
61458;62,898,9,1430,1148,1422,347,596,583,45,1485,919,25,44,707;42;F
61461;45,1430,583,166,51,1411,9,342,53,820,707,1518;35;M
61468;1658,45,190,43,90,344,52,1656,1655,820,63;41;F
61481;9,1430,245,166,25;51;F
61484;1430,1411;71;F
61488;51,53,627,43,317,1518,1411,106,44,1653,190,1422,25,348,435;37;M
61501;1654,44,342;35;F
61503;5,6,43,347,90,51,52,344,627,106;29;M
61520;587,433,5,593,1430,1148,245,347,919,44,348,1118,1226,53,1058;30;F
61541;51,344,433,62,245,190,25,348,53,106,435,317,1485,90,52;39;F
61542;25,166;30;M
61559;5,347,25,1226,820,1058,1518;37;F
61583;1656;43;F
61614;1118,1456,627,9,5,51,820,1518,53,1656,919,25,43,6,245;66;F
61620;1430,1658,583,6,1422,43,344,820;29;F
61626;5,90,44,45,43;48;F
61639;1430,1658,1654,1422,1656,1653,45,340;43;M
61644;898,62,45,593,1654,25,344,348,1655,820,106,317,1518;10;M
61656;596,44;40;M
61663;587,1485,45,1430,245,90,822,919,344,52,1456,820,435,317,707;29;M
61665;347,25,1226,1058,1654,583,348,340,345;41;F
61682;1118,53,627,589,1422,1654,1653,583,62,345,90,6,1658,1657,898;27;F
61686;245,1653,190,348,1655,627;69;M
61695;9,6,596,822,44,1118,43,347,25,51,344,53,820,627,1518;31;M
61719;53,627,1518;;M
61727;5,1148,1653,190,627,51,347;36;M
61767;919,707;37;F
61782;45,245,43,347,1656;37;F
61791;627,53,52,347,1422,45,898,5,9,43,25,44,348,820,1518;48;M
61806;9,45,593,583,166,25,627;41;F
61809;1654,190,1422,347,1656,1653;44;F
61839;1148,820,1658,1653,707,345;35;M
61849;433,45,344,1118,1518;15;M
61891;9,245,90,25,919,344,348,1619,1118,1456,63,707,345,1411,1518;28;F
61897;1653,348,1656,1518;42;M
61924;1148,1430,9,898,1485,5,433,348,340,1655,1058,587,593,1658,1226;34;F
61942;344,820,627,1411,1518,6;33;M
61948;9,43,44,5,898,6,820,51;43;F
61993;1430,43,589,347,627,106,190,25,348;56;M
62001;45,583,1422,347,25,53,820,1058,435,345,1430,1148,52,348,1518;46;F
62043;1430,45,433,5,898,6,43,348,919,1118,340,1456,627,707,1518;48;F
62057;9;21;F
62098;344,90,43,1653,245,6,433,9,347,822,1118,53,627,317,707;17;F
62117;587,9,593,190,43,589,596,25,52,344,348,342,1118,53,820;31;M
62126;1518;17;F
62128;1518;14;F
62130;1518;8;F
62135;1518;12;F
62144;9,347,25,51,44,342,317,1518;34;F
62151;62,593,1148,347,596,25,51,6,190,344,348,1226,820,1058,627;41;F
62166;1653,589,1655,106,435,627,317,707,1411,1518,245,433,1148,1656,62;29;M
62168;1422,53,1148,1485,5,433,9,245,25;46;M
62179;1518;66;F
62220;433,342,345,340;44;M
62237;587,9,62,1430,25,44,1411,1518;36;M
62257;583,587,593,347,52,433,5,1430,6,166,820,1058,106,627,317;33;F
62266;190,166,342,583,1422,340,106,1411,1518;37;M
62320;51,106,627,317,6;47;F
62324;344,317,6,347,51,106,627;49;F
62328;6,190,589,347,51,52,1619,340,627,317,245,53,106,435,707;34;F
62333;6,53,345,1518,62,347,25,51,44,348,342,106,627,317;43;F
62350;433,587,593,245;65;F
62376;340,1118,342,596,345,53,51,347,190,1658,245;41;F
62415;435,707,1430,1148,583,1654,344,348,1655,340;37;M
62419;1422,347,90,919,52,1118,1656,1655,1485,1619,53,820,106,627,317;23;F
62438;1654,245,1657,5,433,587,45,1148,583,1658,43,342,340,820,345;41;F
62448;1430,1058,1411;51;F
62461;587,433,1654,589,347,596,919,52,344,348,1619,1118,1456,627,1411;44;F
62465;90,51,344,1118,53,106,317,1411,627,820,347,589,43,1657,5;44;M
62482;1518,1430;43;F
62484;166;47;M
62500;62,1430,245,190,347,348,1226,53,1058,106,435,627;67;F
62524;43,6;45;M
62657;342,53,106,317,9,1485,345,435,820,51,822,43,6,1148,5;36;F
62681;5,9,62,344,348,1656,1411,1518,583,1654,43,25,919,820,627;46;F
62688;245,6,1148,1430,5,627,593,347,919,51,344,348,1118,340;40;F
62732;342,106,627,317,1518;42;M
62737;45,25,5,820,166;11;M
62746;1654,25,1658;49;M
62747;1658,1654,25;42;F
62784;822,25,344,820,1456,1058,627,317;43;F
62798;1518;42;F
62820;106,435,317,6,43,344,1619,90,245,5,587,9,25,44,1518;50;F
62822;245,1485,1654,190,51,347,1619,340,627,583,1148;43;F
62823;1653,51,340,347,348;39;F
62828;6,51,53,627,106;66;M
62836;583,245,1653,190,340,820;45;F
62842;347,348,342,1118,1226,53,340,1655,820,1411,919,51,1619,1656,1058;40;F
62845;62,45,1658,25,53,435,317,707,345,1518;38;F
62876;53,1518;42;F
62912;43,25,919,344,342,1456,1657,1148,583,1653,190,1655,1058,106,345;34;M
62918;344,627,820,1118,596,90,5,9,45,245,166,25,51;52;F
62921;5,62,1658,1456,820,348,25,245;38;M
62925;707,627,820,53,1619,52,51,919,596,90,347,6,9,43,344;17;F
62934;5,62,1148,1653,190,43,347,25,51,344,348,342,820,627,245;69;M
62975;583,1654,1422,1619,53,1655,627,25,1518;44;F
62979;90,596,344,1619,106,317,5,43,166,25,51,52,1118,820,627;16;M
62981;347,1148,245,90,344,348,1656,820;69;F
62982;245;23;F
62983;1518;16;F
62991;587,45,593,1430,43,90,1658;56;F
63011;5,587,1226,1619,1518;36;F
63013;1518;39;F
63017;25,90,62,433,1148,245,1653,190,43,347,919,348,342,106,627;70;F
63022;898,1658,583,1654,340,1411;25;M
63041;433,45,583,43,347,44,344,342,53,820,1518;37;F
63042;587,9,45,593,245,43,25,627,166,1518;42;F
63046;1518,627,106,820,53,1619,52,44,25,347,166,6,45,9,5;46;M
63052;1518;7;M
63055;1518;40;M
63104;51,820,106,627,317,347,166,5;39;M
63124;587,245,347,53,820,106,317,627,1411,5,43,25,344,1118,1518;45;F
63145;1518;10;F
63153;1658;9;F
63155;1518;38;F
63166;1518;7;M
63176;45,348,820,345,106,435,5,1148,245,1653,190,51,1656,340,1655;47;M
63177;9,44;43;M
63187;53,627,1518;39;F
63205;106;69;M
63211;433,1658,583,348,340;36;F
63217;433,1658,583,245;37;F
63218;1518,245,1411,1619,707,317,90,5,9,25,43,593,587,6,433;33;F
63231;587,919,1619,1411,583,245,1518;34;F
63249;589,1654,1148,1430,1657,593,1485,5,587,44,919,25,822,45,898;38;F
63258;587,593,583,589,596,44,627;44;F
63264;583,1148,1430,43,344,348,1656;40;M
63299;245,106,627,345;42;F
63301;1118,1656,53,317,433,587,593,1430,583,589,919,348,1226,1058,707;25;F
63307;583,1658,347,52,342,1656,53,340,348,5,1148,43,51,820,106;44;M
63310;587,593,583,589,596,44,627;2;M
63319;51,52,348,1619,1118,1656,1655,1456,435,627,1518,62,45,822,820;27;M
63328;587,593,583,589,596,44,627;74;F
63333;43,347,25,51,52,344,820,106,627,1518,587,5,9,6,919;35;M
63334;1430,1518;48;F
63345;589,51,1656,53,1456,707,345,1148,583,1653,190,348,340,1655,627;42;M
63357;44;35;M
63366;245,347,90,919,317,6,106,627;36;F
63398;43,347,25,51,52,344,53,106,627,345,820,1653,1656,1655,340;44;M
63407;1653,1118,707,45,898,5,1485,190,51,344,53,340,348,435,245;39;M
63418;5,9,25,44,1118,1518;39;F
63437;190,348,1656,820,627,1653,43,347,919,51,52,1619,340,345,1658;37;F
63442;90,245,317,627,106,25,348;41;M
63450;583,596,1118,1058,435;16;F
63454;1422,1518,1058,1226,919,25,90,166,245,1430,587,433,348,1619,1411;48;M
63467;919,1619,1058,435,707,1485,1148,1654,1422,340,1430,1653,1656,1655,1456;41;M
63477;1430,1619,1456,51,820;44;F
63487;51,44,344,348,1619,1226,53,820,1456,1058,435,627,707,345,1518;11;F
63499;583,43,347,90,25,51,44,52,344,1619,1118,820,627,45,9;46;F
63500;51,52,344,342,53,1058,245,1430,587,433,43,1411,90,1118,1518;10;F
63505;898,433,25,52,106,707,1422,6,347,51,5,348,342,435,317;43;M
63526;1658,1657,1654,1653,1656,1655;26;M
63539;1658,1653,1654,1657,1656,1655;55;M
63549;1656,1658,583,245,340;42;M
63550;1657,1148,245,1653,1422,347,348,342,340,820,106,707,345,1658,583;43;F
63558;6,43,347,90,596,51,52,344,348,1118,53,820,1456,106,627;31;M
63566;1518;9;M
63579;587,45,583,1226,1655,820,707;67;F
63593;822,25,44,348,1226,1656,53,820,1456,1058,317,707,1411,1518;40;M
63602;45,347,317,51,52,344,342,53,1411,245,1118,587,433,90,1518;6;M
63625;53,1058,63,627,707,62,1657,1658,245,342,1656,1655,1456,345,1518;32;F
63637;433,9,245,1654,348,1456,707,1518,587,583,1422,342;39;F
63655;166,1619,820,44,43,45,5,6,9,25,348,53,435,707,1518;41;F
63670;245;66;F
63677;5,1658,583,1654,25,51,44,53,820,106,627;34;F
63694;587,1058,190,583,347,106,627,51,90,52,317;31;M
63697;43,245,348,53,820,1456,627,5,9,25,6,1518;29;F
63702;166;44;F
63712;106,44,342,245,822;38;F
63717;587,344,1456,317,5,898,6,245,43,1118,348,53,820,106,627;17;F
63721;348,919,1148,593,62,90,9,1619,1518,6,5,587,627,43,25;45;F
63781;340,245,1422;34;M
63782;340;49;F
63783;9,45,43,90,25,51,44,52,348,1118,53,820,435,707,1518;14;F
63804;433,347,51,348,627,245;58;M
63818;433,1430,25,1058,435,627,317,707;31;F
63834;1411,1518;7;F
63842;5,44,51;30;F
63850;587,1148,1653,919,593,583,245,190,43,1226,1656,340,1058;39;F
63857;1655,1411,62,190,51,347,348,1619,1226,53,340,1456,1058,106,245;46;F
63864;1518,627,1226,348,25;43;F
63866;348,1655,820,106,627,317,345,62,5,433,43,347,51,344,245;45;M
63876;51,344,348,342,1619,53,317,627,62,245,25,1655,820,707,1518;32;M
63884;190,51,344,627,245,25,435,317,707,1518;45;M
63907;919;23;F
63910;898,62,1430,583,245,1654,347,25,53,317,1411,5,43,820,627;39;M
63920;245,1654,43,919,344,1619,435,627,317,1518,1430,1148,90,52,820;27;F
63964;9,593,1430,245,166,25;45;F
63972;433,53,317,583,62,45,190,44,1518,106,340,1656,43,1422,348;29;M
64002;1518;46;M
64003;433,9,245,90,919,52,820,1456;37;F
64019;340;14;F
64023;340;52;M
64030;44,822,245,342;38;M
64032;340;16;M
64052;166;42;F
64080;5,1657,1658,583,245,1654,190,347,348,342,340,820,627,345,1411;8;F
64106;106,435,627,9,898,1148,1653,589,347,25,51,348,53,340,820;35;M
64110;43,245,45,1485,5,587,9,6,90,596,25,44,820,627,1518;14;M
64114;317,106,1456,342,348,344,51,347,433,820,707,5,593,1430,1518;39;F
64123;433,45,342,53,1456,1518;35;F
64146;348;34;M
64170;1148,1657,587,1658,245,1654,347,51,342,340,820,106,627,345,1411;10;M
64188;919,1518;45;F
64203;245;18;F
64208;898,344,5,9,340,45,1658,6,583,1654,1422,43,166,25,820;18;M
64237;596,347,1430,1485,5,433,1148,6,1654,190,43,348,820,627,106;31;M
64277;433,45,344,1118,1518;11;F
64312;587,593,822,44,898,1658,245;65;F
64315;53,52,51,90,6,898,5,1658,106,435,627,317,707,1518;35;F
64320;820,898,1654,1422,919,43,583,1658,593,587,433,245,348,1226,1058;28;F
64322;433,45,344,1118,1518;8;M
64327;919,340,1411,433,898,583,43,1118,596;34;M
64330;822,51,340,1656,106,435,345,1148,1658,245,90,52,344,348,820;47;M
64358;1518,45;42;F
64377;433,45,344,1118,1518;45;M
64392;820,106,627,583,1654,1656;37;F
64417;1430,1518;9;F
64421;25,43,1118,1411,5,62,6,589,90,51,1619,1058,627,707,1518;28;M
64425;340,1658;49;F
64427;433,45,344,1118,1518;73;F
64447;433,1657,43,347,90,919,344,627,707,345,587,1658;39;F
64452;593,589,919,340,820,1058,435,627,317,1518;21;F
64456;1430,1518;15;M
64471;433,45,344,1118,1518;79;M
64521;587,1148,245,344,1656,1058,627,707;61;F
64524;345,317,1655,627,106,51,90,347,190,1657,1148,1653,245,1656,820;34;F
64545;166,25,1518;42;F
64552;1148,1654,5,342,345,45,1653,340,1655,1658,1657;38;F
64568;1518;11;F
64589;1619,1148,820,51,627,347,342,583,106,1656;35;F
64591;44,1518;34;F
64592;1518;50;M
64595;53,820,1058,435,627,433,587,5,9,62,45,593,1430,43,44;28;M
64619;433,1658,43,52,344,348,342,1619,1656,1655,627,707,345;37;F
64649;106,245;16;F
64650;317,1619,53,1657,342,820,345,340,106,51,190,1148,583,347,627;39;F
64668;1654,6,9,587,5,62,593,43,347,25,919,51,344,820,627;45;F
64705;9,43,822,51,44,348,342,1655,627,707,245,25,919,820,1518;27;F
64713;5,9,190,43,52,344,348,820,627,317;28;M
64714;53,589,583,62,5,43,51,820,435,627,25,52,106,317,707;34;M
64732;1058,820,1148,51,347,106,627,342,583,1656;1;F
64812;166,340;47;M
64817;5,9,45,1430,43,589,347,90,596,25,44,1118,53,317,1518;36;F
64822;106,1456,348,919,596,90,347,190,245;57;F
64841;1485,9;20;F
64844;5,593,1430,43,90,25,51,52,348,435,317;10;M
64850;9,1430,1657,347,596,822,25,52,344,348,1118,820,106,627,1518;33;M
64874;1485,9;14;M
64928;9,1518;52;M
64942;190,43,347,627,435,245,593,9,5,587,433,90,820,52,1656;41;F
64964;435,707,587,9,593,245,53;21;F
64966;627,1653,820,1656;28;F
65001;589,342,1619,820,1456,435,707,1411,1518,9,596,25,44,344,1118;32;F
65005;45,583,166,25,919;38;F
65044;43,347,25,1226,1456,1058,106,627,1411,587,9,62,589,348;29;F
65069;45,62,9,5,433,1430,1654,43,166,25,344,348,1518;54;F
65097;340;46;M
65103;1619,347,6,1148,1658,1653,190,90,62,583,348,1655,1411,596,1656;38;M
65124;1518,627,51,25,596,90,6,62,593,347,44,53,820;54;M
65127;190,25,53,1456,317,433,43,919,1656,340,820,1058,106,627,707;26;M
65143;1657,583,1654,1656,340,345;38;M
65144;245,6,583,1658,1430,45,5,587,433,43,348,106;14;F
65149;245,348,340,1655,45,1657;38;F
65155;1430,1118,820,433;35;F
65156;52,344,822,1485,51,5,45,1430,347,90,317,1518,25,348,435;31;F
65157;1656,340,6,1148,9,1485,347,25,52,820,106,435,317,707,898;36;F
65158;51,1619,340,820,1456,1058,345,593,1653,190,52,1656,1655,106,435;40;F
65159;1118,1518,627;47;M
65160;583,1654,1422,25,1518;39;F
65163;25,919,348,342,1226,1656,1058,435,627,1518,45,245,1654,1655,707;31;F
65165;62,587,593,1430,583,25,342,1226,53,820,1456,1058;50;F
65167;45,25,919,53,707,1518;2;F
65169;45,1657,1148,1658,583,1654,90,596,1655,1058,106,345;41;F
65170;627,1518;47;F
65171;1518;44;M
65173;45,593,1657,1658,245,345;33;F
65176;6,43,25,919,1118,1656,44,1518,62,9,1619,5,344,587,1411;45;F
65178;1518,245;44;F
65190;433,1148,596,344,348,1118,820,1456,435;37;F
65194;9,1657,51,5,45,1148,1658,245,190,43,52,344,340,1655,820;40;F
65199;43,347,51,52,106;45;F
65204;583,317,43,342,106,820;35;M
65222;45,898,1411,596,190,627,583,1653;37;M
65224;62,5,898,1430,245,25,919,51,344,820,317,1411,587,707;29;F
65231;5,1485,62,1658,6,25,820,106,433,43,348,342,435,317,707;33;F
65234;583,245,1058,1430,1118,1411,1518,587,43,25,919,344,342,53,820;39;F
65238;25,166;43;F
65240;44,1518;26;F
65241;593,1430,6,1058,707,317,627,106,1619,1226,587,433,583,43,919;30;F
65246;5,1422,348,627,1518,6,433,587;24;M
65249;433,45,593,1148,1658,583,1654,1422,1118,1656,1655,340,820,627,1411;35;F
65250;43,53,820,106,627;29;M
65257;340,587,593,1655;39;F
65258;433,62,627,1518,6,43,347,25,919;44;F
65262;1658,583,340,820;40;M
65268;347,1657,1658,1619,345,106,1655,1653,627,1148,51,348,583,820,1656;44;M
65271;5,1422,43,9,25;42;F
65277;348,1118,1656,317,707,1411,1518,433,1485,593,190,25,342,106,435;31;M
65280;43,190,1658,5,25,51,52,344,348,1118,53,820,106,435,627;46;M
65294;5,43,51,344;30;M
65296;433,342,587,5,1430,25,1118,1411,9,45,593,583,43,820,1518;43;F
65299;45,245,340,106,627,1657,1148,1658,190,43,166,347,90,51,345;46;F
65302;435,317,898,45,44;45;F
65316;1518,1654,1657,45,44,63,348,25,245,62,583;55;M
65318;62,1657,1148,1658,1654,190,52,344,1656,340,1655,820,106,627,345;36;F
65319;707,1656,347;48;F
65320;435,433,587,5,593,1148,190,43,347,51,1226,820,106,245;43;F
65321;44,1518;43;M
65322;820,627,1518;45;M
65329;583,52,348,1656,820,106,627;42;F
65332;45,43,44,348,820,63;39;F
65344;45,1430,1657,245,90,25,919,51,44,344,1619,53,820,627,1518;38;F
65347;1518;50;M
65348;1411;46;F
65350;1485,5,587,919,44,347,43,190,593,898,25,344,820,435,627;50;F
65352;106,627,1518,51,596,90,347,6,433,5,9,45,1654,43,919;34;F
65358;5,1485,9,190,166,25,51,344,53,820,435;24;M
65375;1430,90,1655,1456,820,106,627,707,433,587,583;38;F
65378;340,1658,45,52,344,342;46;M
65379;433,45,593,1653,1654,1422,43,919,340,820;58;F
65380;1658,6,1654,51,1656,53,1619,340,627,317,1148,190,347,90,1655;36;M
65384;9,25,44;36;F
65391;822,90,1485,9,45,344,63,43,5,587,593,25,44,348;54;F
65395;317,627,106,1658;37;M
65399;433,593,596,587,1657,245,190,43,919,344,1118,340,820,1058,345;32;F
65402;1411;16;F
65403;51,25,347,5,627,1518,583;31;M
65404;5,9,6,25,820;54;M
65406;45,583,1422,919,51,820,1058,63,106;40;F
65408;45,433,51,583,1657,5,1148,245,1653,190,347,1656,820,106,345;8;M
65419;45,245,342;38;F
65420;1411;13;M
65421;344,51,822,9,1655,1654,583,45,5,317,627,43,1657,62,1518;36;F
65430;1422,190,1654,1653,245,6,583,1658,1148,1430,593,45,62,1518,1411;45;F
65434;1411;46;M
65439;90,51,52,344,348,53,1058,317,627,435,106,820,919,593,587;46;F
65465;433,587,5,593,6,43,347,919,51,1058,627,1518;51;F
65468;344,52,51,347,1422,190,1654,583,1148,5,1653,43,348,1656,820;45;F
65469;5,1657,43,344,348,342,53,820,345,1518;46;F
65471;106;47;M
65483;1422,190,822,919,51,44,348,820,1518,1485,5,9,43,166,25;29;M
65488;9,1148,433,245,1654,1655,435,345,1422,5,1657,1658,348,820,1518;38;F
65496;62,1654,347,25,51,44,106,627,317,9,166,1518;41;F
65509;707,435,1456,919,166,5,45,43,820;37;F
65511;1148,190,347,51,52,344,53,340,820,106,435,627,317,707,345;30;M
65515;1148,6,245,347,340,627,51,820,5,1619,43,106,596,589,90;43;F
65518;166;40;M
65519;1118,589,1422,43,245,707,6,5,433,347,51,106,435,627,317;31;M
65534;1518,106,348,1148,9,62,1430,583,43,166,919,1619,1656,627,1411;42;F
65542;1658;8;M
65558;9,62,898,44,344,348,820,435,707,1518,5,43,166,90,25;41;M
65561;5,587,593,43,596,919,52,344,348,1118,53,820,1456,1058,627;59;F
65568;348,344,1619,1118,53,63,345,433,9,45,245,51,820,627,707;39;F
65576;347,1653,190,627,1657,340,345;32;M
65582;53,340,627,433,1658,43,919,51,344,348,342,820,707,345,1518;31;F
65586;347,245,583,1148,433,593,190,348,1118,340,106,435,345,1518;37;F
65588;5,9,6,52,707,45,43,166,90,51,44,820,435,1518,25;36;F
65590;43,347,51,342,1619,1118,53,820,1456,433,587,90,344,1518,627;38;F
65591;62,1485,5,1430,43,347,25,919,348,340;53;F
65592;6,347,51,53,820,106,627,317,44;38;F
65596;919,25,51,52,344,348,1518;40;F
65604;1518,63,317,344,1619,1456,433,45,245,347,90,822,25,51,342;37;F
65622;435,820,344,52,25,1653,1148,62,1485,5,1658,190,51,106,345;43;M
65627;53,6,43,347,51,1619,106,627,317,433,583,589,919,820,707;26;F
65645;44;33;M
65654;51,245,106,1058,627,435,919,25,593,52,53,1226,820,587,433;49;F
65695;62,5,898,52,53,51,1485,6,347,90,106,435,627,317,707;40;F
65699;344,90,9,5,1485,1148,583,245,43,25,919,51,820,106,627;39;F
65703;52,106,435,317,1518,5,9,166,25,820;34;F
65704;348,596,1654,898,5,587,433,45,593,1430,583,245,166,1619,1411;41;F
65705;348,1619,1656,1456,1058,707,245,90,25,435,317,1518;49;F
65712;583,25,44,1619,1518,1411;33;F
65716;1654,25,106,435,5,190,51,340,820;45;M
65719;25,62,1655,106,5,433,587,43,347,51,52,344,820,627,1518;40;F
65720;1654,583,45,62,433,245,25,919,348,53,820,1456,627;39;F
65733;589,1653,1658,1148,45,5,348,707,245,1654,190,43,90,52,340;49;M
65740;190,587,45,1658,245,344,1655;43;F
65754;5,44;38;F
65758;6,1654,190,43,596,344,348,342,1118,820,106,435;40;M
65764;344,435,1619,1118,1656,1518,62,6,347,51,52,53,106,317,627;39;M
65772;45,583,43,596,51,1118,53,820,1456,627,593,245,166,25,1518;49;F
65777;1430,1422,43,25,44,348,53,1456,1058,627,587,593,245,919,1518;47;F
65815;587,593,1148,1658,245,190,589,90,919,344,340,820,106,707,345;26;F
65816;43,347,51,340,1422,190,245,583,45;51;M
65817;342,1518;34;F
65820;587,583,245,25,44,344,820,1456,106,5,45,43,1430,9,1518;42;F
65821;1422,52,344,1411,166,9,45,43,90,25,919,44,1118,820,707;40;M
65822;5,9,6,25,1518,44;41;M
65823;9,1485,5,596,52,344,348,342,53,820,106,435,627,317,1411;20;M
65824;1148,6,1422,589,820,347,919,52,53,106,627,317,348,1653,25;33;M
65837;1655,106,627,345;33;M
65839;1422,347,919,51,44,348,53,627,43,1430,593,245,1654,25,1518;43;F
65863;1148,1658,1653,190,1226,1656,820;34;M
65873;45,190,52,340,820,63,106;52;F
65875;348,106,435,1411,5,1485,583,190,347,51,344,1118,820,627,317;44;F
65879;25,9,5,6,245,347,90,596,52,344,348,53,627,317,345;46;M
65883;62,1658,583,166,344,1656,820,435,627,5,589,90,348,340,245;31;F
65893;583,348,342,1518;34;M
65895;433,587,1148,6,190,344,106,435,707,245,919,51,53,627,317;32;F
65898;1518,9,62,245,44,342,1058,5,6,43,166,25,348,53,820;33;F
65907;1485,9,1430,43,822,25,51,44,344,348,342,1118,820,435,5;37;F
65920;1654,1411,1518,6,919,342,1619,53,9,62,45,583,1422,25,44;31;F
65949;1653,1654,347,25,51,348,340,820,627,1148,1658,245,190,106,345;26;M
65952;433,587,1658,344,1058,627,820,245,106;30;F
65962;62,5,43,919,348,342,1118,53,106,435,627,317,707,345,1518;40;F
65964;342,1518;4;F
65972;51,53,340,820,627,1654,1148,1118,1058,583,106,348,43,6,5;50;F
66013;51,317,627,1619,898,5,1422,6,245,347,90,52,344,53,435;40;F
66015;1422,589,347,919,348,1226,1456,627,433,593,53,25,44,1058,1518;36;F
66016;345,1657,1148,1658,583,245,190,347,90,52,344,1656,1655,106,627;17;F
66022;6,707,106,53,52,347,45,5,9,43,51,44,344,820,627;40;F
66026;25,919,51,52,342,1656,347,190,245,583,1658,1657,1655,106,627;15;M
66034;9,45,6,43,347,25,51,44,344,348,53,1655,820,317,1518;43;M
66036;1658,583,245,190,347,90,51,52,344,342,1656,1655,106,627,317;8;F
66042;190,347,596,25,52,344,340,627,106;29;F
66055;51,347,43,6,45,62,1485,1148,919,340,344,820,1456,106,435;49;M
66056;62,1657,25,1656,1655,106,898,1658,342,63,435,317,707,345,1518;2;F
66062;587,1422,589,919,51,348,342,1226,53,627,1411,583,245,25,1518;41;F
66067;51,166;44;M
66072;345,583,1148,1658,1430,898,245,596,344,433,5,45,340,820;35;F
66108;1411,1518;17;F
66116;43,627,9,5,25;40;M
66123;898,347,583,433,5,587,593,1422,919,348,53,1058,106,707,345;42;F
66137;1619,25,106,627;36;F
66144;433,5,43,52,53,820,1653,190,347,51,348,627;48;F
66146;707,1411,1518;16;F
66165;587,583,245,1422,589,25,919,51,348,342,1226,53,627,1411,1518;9;M
66169;190,43,51,348,820;48;M
66188;587,583,245,1422,589,25,919,51,348,342,1226,53,627,1411,1518;7;M
66201;1422,1430,1485,1148,583,245,1653,1654,190,25,1118,340,820;26;M
66203;1656,1655,1456,1411,1485,1657,1658,1653,1619,1118,435,1654,820,627,1518;37;F
66210;435,106,53,51,43,1148,45,9,245,25,919,344,820,627,317;30;F
66213;587,1657,1148,1658,583,1654,190,347,51,348,342,627,707,345,1518;38;F
66219;62,627,53,1656,919,347,6,587,583,25,820,106;26;M
66227;583,245,1654,43,347,596,25,51,1118,53,820,1456,627,707,1518;41;F
66243;43,347,348,340,820,435,583,25,344,342,106,627,317,707,1518;31;F
66250;348,106,1658,340;52;M
66255;51,707,5,52,347,43,6,1430,344,348,820,106,435,627,317;75;M
66259;62,1485,5,587,190,43,347,90,25,919,52,707,106,435,317;31;F
66261;166,347,822,9,62,45,51,344,342,1619,53,627,1411,1456,25;32;M
66264;5,898,43,919,340,820,345,1411,583,1658,1657,245,190,348,106;30;F
66286;245;68;M
66287;593,1658,5,898,6,90,51,52,53,435,627,317,707;32;F
66294;347,627,433,6,43,90,919,51,344,1619,53,820,106;66;F
66297;1658,245,1619,1655,1456,106,627,345;34;F
66300;5,62,45,1430,245,43,347,596,51,44,344,342,1619,9,348;29;F
66307;106,627,245,6,1485,433,62,1148,43,25,348,1226,1058,435,317;30;F
66317;435,587,9,62,583,589,347,25,44,348,53,627,317,1411,1518;36;M
66329;52,43,5,9,245,347,90,822,51,344,53,820,627,317,1518;45;F
66332;53,589,593,9,587,433,5,1485,62,90,919,1656,1058,435,317;24;F
66338;1485,190,1456,435,5,9,593,25,51,344,52,1656,820,627,707;34;M
66343;51,52,106,435,317;38;F
66344;347,348,820,435,1657,45,62,5,1422,1411,344,340,106;43;F
66347;5,589,587,245,190,43,25,1656,1655,820;46;M
66363;820,435,317,707;40;F
66366;627,1118,1619,348,52,44,596,90,589,43,62,5,9,6;44;F
66379;43,25,707;52;F
66385;106,627,317;34;M
66389;51,347,1456,106,435,627,317,1518,245,9,6,5,90,166,25;47;M
66397;62,1658,583,1653,44,1655,820,63,1518,25,1656,53,340,345,707;31;F
66398;1485,25,344,1226,53,707,90,51,52,348,435,317,1656,106,627;27;F
66403;43,25,348,45,1657,342,1656,53,340,1655,63,707,345,1411,1518;37;F
66410;45,1148,6,43,344,348,340,820,1456,106,317,345,1518;51;M
66413;340,1518;44;F
66425;43,166,919,342,340,63,627,106,1518,9,6,25,348,820,435;28;M
66432;5,9,25;34;M
66433;344,348,53,1456,63,707,345,583,245,1422,25,342,1619,1411,1518;37;F
66436;1148,1658,245,1653,1654,190,44,340,1655,627,433,342,106,435,707;32;F
66442;44,342,1619,1118,820,1058,63,707,1518,587,433,583,43,90,627;48;F
66443;822,51,44,52,1656,53,63,707,1518,62,190,90,25,344,348;24;F
66481;45,190,344,342,53,820,1655,106,1411,1658,583,1656,707,340,1518;28;M
66493;340,1518;12;M
66514;348,344,340;42;M
66515;1226,1411,53,190,1653,587,593,245,51,1118,820,1058,106,627,707;52;F
66516;1656;42;F
66518;348,1118,820,1058;22;F
66544;9,43,25,51,44,344,348,53,820;28;F
66545;345,707,1456,340,1655,583,1658;7;M
66558;90,51,348,342,53,340,106,627,345,1148,1658,43,919,52,820;39;F
66568;166;43;F
66572;1658,348,342,340,1655,1456,707,345;5;M
66577;6,347,44,106,435,627,317,9,25,348;65;M
66579;340,1518;16;M
66584;344,1226,435,433,587,5,898,593,1148,245,919,348,1118,820,707;29;F
66600;433,166,25,245,1118,1619,344,44,9,5,820;37;F
66603;340,345,51,1655,1657,1654,1658,344,820;48;M
66616;587,1653,43,347,919,51,344,106;46;F
66618;342,340,820,1058,106,435,627,317,345,43,1619,44,45,5,9;30;F
66640;317,5,587,45,1430,593,6,245,347,919,52,348,106,1518,627;44;F
66651;1148,1657,62,433,1430,1658,347,25,51,344,348,1456,435,317,707;34;F
66656;589,1148,1653,190,348,62,51,106,245,317,627,52,53,6,1619;29;M
66667;5,43,1456,627,707,1485,245,1226,1058,433,587,593,919;27;F
66675;43,347,52,344,348,1118,820,106,627,345,1148,190,340,1655,1518;53;F
66679;245;73;F
66692;190,43,347,822,919,51,44,348,820,106,435,317,1518,25,9;52;M
66704;593,43,589,1456,627,707,317,5,9,25,348,342,53,820,435;29;F
66706;190,596,344,348,5,45,1658,583,245,1654,43,342,340,820;43;F
66713;51,45,5,1654,1655,1422,43,589,348,345,1148,583,245,190,340;43;F
66716;5,1485,9,6,190,347,25,44,348,106,435,627,317;65;F
66720;1657,1654,190,52,348,820,106,627,345,43;30;M
66725;190,1654,90,44,348,1655,340,345,51,53,106,435,627,317,1518;46;M
66755;317,347,627,44;37;M
66756;1518,344,1656,345,435,106,627,317,62,593,1148,245,190,347,51;22;F
66767;820,1619,347,62,1485,5,919,25,45,190,43,51,1656,627,707;29;F
66773;6,340,627,347,25;49;F
66775;62,6,347,25,51,1619,53,1456,106,627,317,1518;50;M
66781;1148,190,342,340,1655,820,345;37;M
66783;919,166,1422,1658,1657,1430,898,62,583,1654,596,44,1411,1518,25;41;M
66785;245,190,43,90,596,822,344,348,342,1118,340,820,1456,106,345;66;F
66798;43,820,9,5,44,627,317;20;M
66819;596,52,5,9,6,25,44,344,820;27;M
66821;43,106,435,707,317;35;M
66834;1658;45;M
66840;1658,166,5,25,820,627;39;F
66852;62,51,52,344,53,5,1485,347,820,106,435,627,317,707,1518;36;M
66875;5,433,587,25,52,344,348,1656,1058,435,627,317,707,345,1411;32;F
66904;45,245,1654,43,1656,106,51,347,90,190,1658,340,820,627,345;38;F
66913;25,44;41;F
66915;5,1658,583,6,43,347,90,919,51,344,53,340,820,106,627;37;F
66926;1658;45;F
66944;45,1657,1658,583,25,1655,63,345,707,1656,342;24;F
66949;1430,593,45,587,433,6,348,1619,1656,1456,1058,106,627,317,345;43;F
66952;45,25,344,435,317,5,583,1654,51,44,348,820,627,1518,1411;39;F
66958;90,596,344,1118,340,820;35;M
66964;106,435,627,317,919,51,44,90,43;21;M
66967;43,5,433,348,342,53,340,820,707,1411;35;M
66977;898,348,596,1654,5,587,433,45,593,1430,583,245,166,1619,1411;9;M
67014;433,587,593,1148,583,919,344,348,1226,340;33;F
67027;43,589,347,596,25,919,51,52,344,342,1619,1656,340,820,106;;M
67036;44;3;M
67051;51,344,53,1456,106,435,627,317;40;F
67063;348;49;F
67074;44;9;M
67079;1657,1658,1653,1656,1655;65;M
67081;245;37;F
67095;587,1430,245,919,344,1456;53;F
67105;345,1411,587,43,583,25,1658;41;M
67111;707,245,51,435,90,52,348,342,317,1658,1657,1656,1655,1654,1653;40;M
67112;51,1656,820,1148,347;33;M
67115;433,245,820,44;30;F
67138;51,53,627,5,898,1148,190,340,820;45;M
67146;5,9,43,25,919,51,344,348;42;M
67180;1657,90,317,51,190,347,25,627,345,1148,1653,820,1656;38;M
67184;587,1485,190,43,90,1655,820,433,45,245,347,51,344,348,340;34;F
67197;190,347,51,348,627,433,62,1657,583,90,344,342,340,820,345;34;F
67198;1411,1518,347,344,348,317,707,5,9,43,25,51,820,1456,627;31;F
67202;1148,190,1422,90,51,344,1118,106,317,627,820,53,1619,1653,435;35;F
67213;25,1656,53,820,1058,627,317,5,593,43,344,1226;37;F
67214;1058,106,435,627,317,707,1411,433,587,5,62,245,43,90,25;51;M
67232;43,25,52,1619,820,345,317,627,435,106,340,245,190,347,344;23;F
67245;166,25,1411,433,51,348,820;14;F
67256;53,25,166;35;M
67275;1148,190,43,340,1655,820,106;7;F
67276;1456,317,627,1485,5,433,9,43,347,44,344,342,820,1411,1518;22;M
67284;898,45,62,587,433,9,593,43,596,919,44,342,1226,1456,1058;35;F
67293;9,43,51,52,344,435,627,317;28;F
67301;433,45,593,1430,344,348,1118,820,1058,1411,1518;39;F
67308;1148,1653,190,51,344,348,340,106,627;26;M
67310;190,43,317,627,106,51,347,1148,62,5;34;M
67314;344,53,820,63,1658,190,43,822,342,1656,340,345,1655,1654,1657;37;F
67316;347,5,62,1654,344,820;45;M
67317;593,6,245,43,347,596,25,51,344,348,1118,53,820,1058,627;37;F
67319;344,1118,43,25,342,820,627,1518;36;F
67320;587,5,347,919,51,344,1118,1226,53,820,1058,627,43,822,106;46;F
67342;106,1653,1656,627,1148,51;31;M
67358;166,25,1411;18;M
67372;919,344,348,820,25,587,5,898,6,90,51,52,53,435,707;31;F
67376;1654,1657;52;M
67384;1148,25,51,1118,53,1518,5,6,347,340,106,627,245,90,348;52;F
67386;348,340,345,433,45,1422,245;34;M
67391;166;43;M
67417;90,589,1657,587,593,1148,245,1653,190,596,919,51,348,820,1456;41;F
67418;6,43,25,52,1619,106,435,627;40;M
67427;62,593,6,245,190,347,51,348,1226,53,1058,106,627,317,1518;18;F
67433;583,52,344,1118,435,347,166,43,593,62,51,53,106,627,345;17;F
67459;1518,1422,587,433,1653,1118,348,583,43,596,820,435,1411;24;F
67486;9,596,919,44,1118;21;F
67503;627,63,53,1656,1118,51,596,90,347,589,1653,1657,62,1456,106;38;F
67512;1518;45;M
67518;1658,51,1430,1411,707,53,1619,1058,342,106,190,1148,583,1422,898;31;F
67538;90,317,627,106,348,1118;26;M
67541;45,51,820,317,707,1518;40;F
67550;5,9,583,6,43,822,51,44;32;F
67553;62,5,587,1430,583,245,43,347,90,596,44,344,1118,25,6;33;F
67566;1430,344,627,166,25;30;M
67571;1653,190,347,919,587,5,707,51,348,1148,245,820,43,52,344;51;M
67572;106,1518,44,53,1655;34;F
67579;1148,1422,1653,190,43,90,596,51,52,348,1656,53,1456,1058,106;44;F
67582;1148,1653,1656,1655,820;42;M
67586;62,1485,9,583,43,348,51,53,1656,340,820,627,317,1411,5;28;M
67599;1148,593,587,589,596,25,344,435,90,433,106,707,627,1518,1411;26;F
67601;1518,1118,1411,25,1430,433,245,9,43,90,166,6,5,1619;38;M
67611;1654,190,1656,1518,45,43,347,90,25,51,52,820,106,317,627;32;M
67613;5,53,820,1456,627,1411,1518;11;M
67615;1654,53,820,627,1411;43;F
67626;898,1654,190,345,1518;39;F
67639;106;50;M
67649;9,25,44;35;M
67654;1422,1148,1430,593,9,1485,5,433,587,190,43,25,344,348,820;61;F
67655;1518;3;F
67656;9,90,822,51,52,433,5,6,919,344,820,106,1411,1518,43;39;F
67657;919,822,596,90,43,1430,25;35;M
67667;1654,245,6,593,433,587,45,1658,583,25,342,820,317,435,707;9;F
67683;1518;31;F
67689;5,1485,43,51,344,820,106,627,317;54;F
67693;347,589,1654,245,62,9,5,433,919,52,1656,820,106,627,707;25;F
67697;1658,1411,1653,1657,190,1654,245,45;44;F
67706;1518,1619,51,25,5,6,43,166;71;F
67707;43,344,1655,820,433,587,593,342,340,1658,1657,1148,190,348,345;43;F
67716;43,245,587;67;F
67723;587,45,1430,1658,583,245,1654,347,25,1656,340,820,63,627,707;12;M
67725;707,1148,190,90,25,52,344,1619,53,62,347,51,317,106,627;36;F
67726;245,340,1658;45;F
67736;9;32;F
67747;45,1658,596,919,344,1619,1118,1226,820,345,62,190,1058;40;F
67751;5,25,44,1226,820,1058,627,1411,1518;41;M
67766;340,433,45;38;M
67782;345,820,45,593,1654,25,344,1655,106,1430,245,190,90,435,348;65;F
67791;43,25,919,51,106,435,627,317;34;F
67798;9,62,43,166,347,25,348,52,344,820,1456,106,627,317,345;34;F
67809;347,245,25,52,1619,106,1518;36;M
67815;347,90,51,52,344,348,1656,53,340,820,435,707,5,62,43;34;M
67816;25,51,52,344,342,1656,53,820,1058,1518,1658,348,1456,435,345;37;F
67825;44,51,347,245,43;35;M
67828;898,45,593,1430,583,1411;13;M
67845;52,1226,1518,587,5,9,43,25,344,53,820;28;F
67869;1518;38;F
67882;106,820,1118,596,9,344,43,317,627,6,1619,52,5,90,53;36;M
67893;587,1422,348,1226,53,1456,1058,707,1518,593,1430,43,25;34;F
67922;245,347,1619,1226,1456,317,1411,593,919,820,707,5,9,1430,25;27;F
67927;106,53,1656,45,1657,1653,1654,583,6,1619,1411,25,44,707,1518;42;F
67932;433,45;4;F
67933;1657,25,347,1656,627,317,820,1148,190,51,348,106;21;F
67935;1653;40;F
67964;43,190,1653,1148,1485,5,51,627,345,593,1430,820,1658,53,340;46;M
67971;1657,190,166,51,822,1656,53,340,1655,820,63,44,25,347,43;32;M
67997;245,1656,627,1518;43;F
68008;433,593,43,347,919,51,348,53,106,435,627,317,707,1485,245;33;F
68015;106,583,5,9,1430,1654,190,166,348,53,820,1456,435,627,317;14;F
68019;1430,1657,583,1658,1654,190,347,919,51,348,342,340,106,627,345;45;F
68020;245,433,587,25,1411,317,919;29;F
68023;433,45;2;F
68065;342,345;47;F
68075;433,45;;M
68091;6,90,25,52;43;F
68094;245,190,25,52,53;49;F
68096;9,6,245,25,44,1619,1118,1411,1518;19;M
68108;1411,707,317,627,435,106,53,347,43,1654,6,583,62,9,5;39;M
68120;593,43,5,1148,245,190,347,348,340,820,106,627;43;F
68121;53,348,1653,1657,898,1485,433,1430,583,1654,43,627,1422,435,707;34;M
68125;25;32;F
68152;1430,1411;55;M
68169;919,317,5,245,1654,1518,820,53,348,106;39;F
68170;9,1430,43,347,166,5,583,25,51,53,820,106,435,627,317;11;M
68172;433,5,435,587,245,348,1656,820,1456;74;F
68185;53,820,106,317,345,435,627,5,9,45,245,190,25,348,1518;46;M
68190;190,340,433,587,45,1148,1658,342,1656,820,1655;36;F
68222;348,596,587,5,9,593,1430,43,347,25,51,53,820,627,1518;40;F
68241;1658,245,43,90,919,51,52,344,342,1118,1656,53,1456,707,345;29;F
68244;1656,1518,25,245;45;F
68249;347,1654,1653,1658,1655,106,627,345,1148,190,51,1656,340,45,245;46;M
68264;51,25,190,1148,5,1226,348,589,43,593,62,9,587,919,1058;35;F
68295;25,347,1422,1654,245,6,583,5,9,45,43,44,53,820,1518;42;F
68298;1518;37;F
68303;435,1654,25,51,44,52,344,820,1456;49;M
68313;1148,25,1656,820,1518,345,190,1658;38;M
68314;348,317,25,9,5;58;F
68324;62,433,587,5,45,1658,245,43,90,344,348,340,820,627,345;47;F
68326;1430,62,1485,1658,348,820,435,1148,5,317,106,25,190,6,9;38;M
68363;6,190,90,52,344,53,433,347,627,317,43,51,1619,245,106;39;M
68373;627,1411,1058,1456,1226,1619,348,919,1422,245,6,1430,593,587,345;46;F
68391;1430,1422,348,317,1411;29;F
68430;9,6,245,25,44,1619,1118,1411,1518;18;F
68457;1422,433,5,593,1657,583,6,245,1654,822,348,1656,707,1518,45;37;F
68488;1411,345,340,1657,583,1653,1518;49;M
68505;1653,45,5,583,820,1655,627,245,596,344,1656;27;M
68509;9,6,245,25,44,1619,1118,1411,1518;19;F
68522;9,6,245,25,44,1619,1118,1411,1518;17;M
68537;1456,820,340,51,919,1422,190,1654,1658,583,43,348,342,106,1411;35;M
68540;898,45,1654,43,5,9,25,51,44,344,1118,53,820,106,627;40;F
68545;342,106,1658;32;F
68546;9,6,245,25,44,1619,1118,1411,1518;67;F
68556;5,90,596,1118,53,820;19;M
68578;347,6,1148,1430,62,898,9,1485,5,433,593,1422,53,627,317;36;F
68590;166,25,344,1655;35;F
68602;1118,342,348,51,25,596,347,589,1422,1430,45,898,433,9,1658;41;F
68613;587,245,1653,347,1226,53,1058,106,627;67;F
68632;9,6,245,25,44,1619,1118,1411,1518;50;F
68641;62,1657,6,51,1619,245,347,106,627,317;49;F
68655;587,583,25,1518;39;F
68656;344,52,106,435,317,1518;31;F
68666;1658,190,43,342,820,345,348,340,106;50;M
68672;6,43,25,1518;33;F
68673;9,166;33;M
68680;166,44,820,90,1619,5,25,9;35;M
68694;5,45,822,51,344,1656,53,627,1148;49;F
68706;919,52,1619,435,317,1518,9,190,43,166,25,348,820,627,1411;44;M
68717;344,1619,820,1485,5,62,6,25,51,52,53,106,435,627,317;38;F
68718;51,44,348,53,340,1655,820,63,435,707,345,1411,1485,5,433;37;F
68724;1148,820,583,51,593,1653,919,587,1657,245,1658,1654,190,340,345;44;F
68759;433,245,90,1226;66;F
68761;51;4;M
68770;9,6,245,25,44,1619,1118,1411,1518;51;M
68774;90,596,51,52,344,348,342,1118,1226,1656,53,340,820,1456,1058;12;F
68778;707,1411,1518,1430,5,433,9,45,1658,6,245,25,348,1118,166;44;F
68784;1430,6,43,589,347,51,348,1118,820,435,627,345,1148,245,190;33;M
68791;51;35;M
68812;593;69;F
68816;245,43,90,51,52,344,348,1619,53,1655,820,1456,106,435,627;81;F
68817;51,596,1485,190,347,90,627,820,1656;45;M
68832;166,1430,347,25,51,435,317,53,820,627,62,5,1058,106,1518;45;F
68859;190,347,106,53,820,1456,435,627,317,90,1653,245;40;F
68864;1456,627,1485,5,45,317,898,6,51,52,53,820,106,435,707;34;F
68869;898,43,348,587,9,245,190,166,25,919,820,627,317,1411,1518;37;F
68899;820,25,1654,1518;33;F
68901;5,9,45,1430,1658,6,1118,707,1411,1518,348,919,25,245,166;12;F
68923;5,9,347,53,820,106,435,627,707,1148,190,43,348;40;M
68956;1653,1656,1148,51;32;M
68958;1411,345,707,1456,1118,1619,342,344,52,919,596,1422,1654,583,1657;29;F
68980;433,587,9,43,344,1118,90,44;50;F
68983;9,1148,347,596,25,348,820,1456,317,245,166,51,435,190,1619;29;F
68999;433,1148,1658,583,190,1422,347,25,919,348,820,1456,627,707,345;37;F
69005;43,52,348,340,820,1456,106,1518,587,433,1430,1657,1422,583,25;36;M
69029;1654,51,1422,43,1411,1518,63,433,1658,583,1653,342,317,707;38;F
69031;1657,1148,1658,1654,596,51,344,1118,340,1655,820,317,1518,1411,345;49;M
69037;1118,342,919,90,1657,1485,433,1658,1654,43,344,1456,1058,63,345;40;F
69074;245,1654,190,25,919,344,348,1118,1656,820,1058,435,707,1518;39;F
69085;348,53,1411,345,627,51,44,340,106,707,9,583,342,1656,1518;35;F
69091;596,25,344,1118,317;40;F
69105;583,342,707;38;M
69117;1411,593,245,596,1456;35;F
69137;583,90,51,317,596,5,43,589,347,52,344,1118,340,820,106;29;M
69145;25,166;42;M
69169;348,53,345,707,317,627,43,51;31;M
69211;433,62,51,348,435,52,106,627,317,707;36;F
69235;5,9,166,90,587,593,25;38;F
69243;1456,5,166,25,44;53;F
69267;62,63;36;M
69279;344,342,1619,1118,1656,53,106,435,627,820,1456,317,245,347,51;58;F
69291;344,820,627,1118,1619,596,51,245,6,52,1422,45,53,707,317;45;M
69296;166,25;41;F
69299;166,25;10;M
69300;1656,1456,627,820,589,707,345,106,45,1148,1658,245,190,347,340;47;F
69315;1148;52;M
69316;166,25;8;F
69324;90,6,1518,43,820,317,51,53,627,166,435,5,9,1430,25;48;F
69326;245,589,344,1656,1655,106,627,317,583,1148,190,90,1619,340,345;22;F
69327;62,43,627;47;F
69330;5,45,1148,1658,1654,190,627,1657,583,166,25,344,342,53,345;35;F
69349;344,90,589,166,583,43;44;F
69358;344,348,342,1118,340,627,317,1485,1148,6,245,190,43,347,51;38;F
69365;1518;36;F
69376;106,627,317,43,1411,1518,44,344,51,919,25,6,245,9,433;38;F
69392;53,1518;47;F
69420;9,1658,190,43,25,51,344,5,1148,347,52,820,627,317;45;M
69426;45,5,1657,1148,583,43,596,51,342,1655,627,106,340,1619,347;38;M
69441;5,898,45,347,51,53,9,245,25,106,435,627,1518;29;F
69442;347,51,1619,627,317,1485,589,25,919,52,820,106,435,245,6;32;F
69461;166,25;70;F
69474;587,45,593,1657,1658,583,347,822,1226,1656,53,820,1058,707,1411;34;F
69476;106,1658;34;M
69490;347,25,51,344,53,627,43,52,348,106,435,317;52;F
69497;1058,1411,433,45,583,1654,245,90,919,52,344,348,342,1118,1656;38;F
69499;1485,62,583,707,317,435,51;29;F
69500;596,45,1148,51,1656,1653,190,1655,342,345,348,433,340,1658,820;29;M
69515;433,6,245,1422,347,919,344,1118,340,1518,627,820;24;F
69552;53,433,587,45,593,1657,1658,583,347,822,1226,820,1058,707,1411;6;M
69560;166,25;19;M
69563;1148,433,1658,583,1653,1654,1422,707,340,1655;33;M
69576;587,45,593,1657,1658,583,347,822,1226,1656,53,820,1058,707,1411;3;F
69608;1518;40;F
69609;587,45,593,1657,1658,583,347,822,1226,1656,53,820,1058,707,1411;34;M
69616;317,1148,1653,190,1656,435,345,627,340,342,51,347,1658,820,106;33;M
69617;190,25,340,820,106,627,317;45;F
69626;9,43,820,317;38;M
69648;1518;9;M
69658;1226,1656,1655,820,1058,627,587,5,593,1657,1148,1658,245,190,43;48;F
69660;166,340;32;F
69668;1518;39;M
69680;1518;68;F
69690;51,52,344,348,1619,53,1456,1518;28;M
69693;53,348,51,919,25,347,43,245,593,62,1485,587,433,5,9;29;F
69703;433,898,1653,43,587,45,593,1657,1148,245,348,345,1658;41;F
69710;190,51,53,1655,340,342,1658,245,43,347,820,106,627,317,345;34;F
69712;1518;69;M
69721;190,347,596,52,348,1656;42;F
69737;51,340,1655,1456,345,627,1518,1657,347,1058,52,344,587,898,1148;44;F
69746;5,45,52,344,627,43,90,51,166,25;45;M
69753;348,342,1118,53,340,820,1456,106,627,1411,62,583,43,345,245;38;F
69754;62,1148,190,51,1456,1058,627,433,587,5,593,245,43,919,820;39;F
69763;820,627,1148,1658,583,1654,190,347,345,245,340;45;M
69779;433,587,1658,583,348,342;37;F
69790;45,90,627,707,342,348,593,53,106,317,1411,5,52,1619,435;36;F
69804;593,1619,53,1655,820,587,45,1148,583,245,1653,190,51,1656,340;44;F
69814;45,1658,90,822,919,820,63,5,587,583,245;21;F
69821;51,589,5,1148,583,6,245,596,919,52,1456,106,627,707,345;14;F
69827;43,1655,1058,106,707,593,583,589,822,25,44,344,342,1619,9;39;F
69838;898,347,919,51,44,1226,348,589,433,1653,53,62,1430,593,587;35;F
69840;45,62,898,9,5,587,433,593,583,1654,919,342,1619,1226,1518;40;F
69845;1518,822,1411,5,166,25;38;F
69860;245,90,919,1456,627,1518;44;M
69866;5,166,1654,43,347,596,90,25,51,52,344,1118,53,820,627;48;F
69869;587,593,6,245,43,589,90,25,919,52,53,820,1456,627,1518;40;F
69885;5,245,51,587,62,347,348,820,596,627,43,1118;47;F
69888;1148,190,43,63,25,1656,340,1655,820,106,435,627,317,345,707;29;F
69896;62,1411,707,1456,1619,245,45,583,44,53,1518;37;F
69918;433,5,6,1619,1654,43,596,51,348,317,9,1430,583,1411,1518;41;F
69925;5,62,1430,6,43,347,51,348,1656,820,627,317,345,1518,106;45;F
69927;166,25;41;F
69953;587,43,596,919,51,435,1118,6,190,348,627,106,1058,5,820;35;F
69977;1456,63,707,340,919,25,596,347,627,345,62,587,45,1658,245;49;F
69978;1518,345,898,5,1485,45,6,1422,51,340,317,347,62;40;F
69980;348,435,627,1518,25,44;39;F
69988;166,25;38;F
69989;435,317,707,1411,589,190,245,1148,5,347,51,344,53,820,106;36;M
69995;587,5,1148,6,166,348,344,1118,340,106,435,317,45,43,820;26;F
70013;245,25,51,53,1655,820,106,627,593,583,919,344,1058,345,1518;41;F
70041;345,1226,342,1658,587,1653,919,348,340,1655;32;F
70043;44;26;M
70055;1657,1148,583,1653,1654,347,51,52,1656,340,1655,820,627,345,190;27;F
70075;5,245,1654,166,822,25,1655,820,9,1430,583,43,1118,1411,1518;40;F
70078;1456,106,435,627,317,1411,1118,1422,1148,898,596,51,44,344,820;45;F
70079;44,51,166,190,62,5,898,583,1653,1654,90,348,340,1655,345;38;M
70083;1430,1118,1518;40;M
70089;25,51,1619,820,1456,627,587,1518;48;M
70111;1430,1653,43,820,1456,587,593,1658,919,1226,245,348,1058,435,707;35;F
70126;587,1653,344,1656,345;34;F
70127;627,1518,345,5,820,707,1619,589,347,106,90,53,52,44,6;27;M
70129;345,44,25,822,43,1422,1654,245,6,45,9,5,433,820,1518;46;F
70143;5,347,1456,1058,627,707,433,9,593,1658,43,25,919,820;30;F
70150;5,1518,9,245;36;M
70158;1058,106,627,1411,5,433,1485,1148,1658,1422,348,340,1655,345,1518;45;F
70162;596,1456,1653,1430,1485,1411,1654,1422,1226,1656,1518,1658,919,1118,820;57;F
70186;5,6,43,347,25,51,820,627;32;M
70190;1656,106;42;M
70202;1654,1422,43,347,596,344,1619,1118,340,5,342,627,1148,820,345;46;F
70203;317,627,106,1656,166,1518,707,25,245,433;42;F
70230;166;63;M
70237;596,25,627,433,587,5,1148,1655,90,919,1411,1518,1656,820,1058;54;F
70243;25,1657,245,190,345,593,587,1148,1658,583,1653,1656,1655,1058,707;45;M
70258;43,166,25,342,820,1518;32;M
70265;5,45,1654,90,919,344,348,435,1148,245,1656,340,820,317,345;16;F
70266;166,25,435;10;M
70267;5,25,317,587,1430,1148,43,919,52,1656,435,627;28;F
70285;1619,53,1654,45,5,317,707,347,90,51,820,627,166,25;37;F
70287;6,347,344,348,340,1656,1226,1118,433,245,587,593,919,106,1058;24;F
70289;90,1653,433,898,583,1654;41;F
70296;43,344,435,347,53,317,627,190,51,106,25;40;M
70297;44,53,627,317,5,9,820,348,43,1430,45,166,25;43;M
70300;5,9,166,25,348,820,435,317;11;F
70303;919,435,707;36;F
70311;317,435;31;M
70326;1656;15;M
70336;1485,9,1653,190,44,820,106,53,627,317,347,62,25,51,1518;48;F
70338;820,707,1518;45;F
70347;433,5,1485,45,1430,245,166,90,25;37;F
70348;5,9,45,43,25,51,344,342,53,820,627,317;43;F
70354;51,919,347,190,583,433,587,1148,1658,6,245,53,820,1456,1058;64;F
70377;435,627,345,707,820,1655,342,919,347,1654,5,45,583,43,44;39;F
70378;9,43,25,5;27;M
70380;593,1658,245,190,919,344,1656,820,1058,627,345;29;F
70394;587,62,1148,627,347,435,43,596,348,1118,820;53;M
70395;62,1422,106,583,435,317,707;32;M
70410;1430,1148,1226,1518,1485,1657,1658,1653,1654,1422,1118,1656,1655,1456,1411;15;M
70436;1411,707,1058,820,53,1226,342,44,919,25,822,43,1653,245,1456;45;F
70442;344,348,1619,898,62,45,1658,53,433,245,340;38;F
70454;435,345,340,53,587,433,245,1653,43,90,52,348,1656,1655,1456;50;F
70457;596,25,820;53;M
70462;435,627,317,587,62,25,63,106,6,245,43,344,348,820,1456;51;F
70469;43,6,1148,62,5,347,90,51,344,435,190,25,106,627,317;39;F
70494;245,1518;11;M
70529;822,1456,106,435,627,707,1411,587,593,583,25,919,348,1226,1058;43;F
70530;433,583,43,51,344,348,820,627,1518,1430,25,44;55;M
70533;45,433,245;35;F
70536;596,25,51,52,820,5,1148,6,190,90,919,348,1118,106,435;26;F
70560;245,1518;6;F
70568;596,52,1619,1456,106,433,583,1654,43,919,344,348,53,820,627;40;F
70582;51,435,596,90,52,53,1118;28;M
70595;820,90,52,344,5,898,45,1658,583,43,435,627,317,6,1422;37;M
70596;245,1518;44;M
70605;6,52,898,5,90,53,1422;38;F
70608;1485,898,1148,1654,1422,1655,9,583,245,25,820,435,707,1518;33;M
70617;347,51,53,433,25,348,106,627,6,245,5,9,44,820,1518;34;F
70638;627,25,53,1619,587,5,1485,9,45,593,43,51,44,348,820;31;F
70654;45,106,62,1658;42;F
70658;1518,245;72;F
70682;245,1518;72;F
70710;1518;8;F
70719;6,1485,52,344,1148,9,63,342,245,5,43,90,820,1118,433;43;M
70732;1658,583,1619,90,45,1430,166;41;M
70746;1518;5;F
70750;347,25,919,51,1226,53,1058,627,317,106,62,593,245;44;F
70751;898,1430,43,347,51,344,1058,106;18;F
70756;1653,344,1411,583,190;29;M
70764;898,587,433,1430,1654,1422,822,820,342,44,919,245,9,435,1518;34;F
70769;5,62,1148,245,190,90,919,344,52,1656,1456,820,106,627,317;53;F
70795;5,1518,245,25,43;39;M
70797;51,106,1058,1226,53,435,433,5,245,25,344,820,317,627,1411;28;F
70815;25,344,245,44;46;F
70818;347,62,5,25,51,52,344,53,820,317,627,106,435,1518,1411;26;M
70825;62,583,43,822,25,919,820;40;F
70856;583,1653,1654,1619,1456,1656,627,707,1518,1657,1148,1658,340,1655,820;42;M
70858;45,898,1148,190,166,589,90,25,1619;40;M
70876;45,1148,1658,245,190,1422,340;39;F
70887;9;46;M
70888;90,347,1619,1656,53,820,62,1148,43,919,627,583,317,245,106;18;F
70895;587,593,245,347,90,919,51,344,106,317;8;F
70898;166;39;F
70919;1148,1657,433,5,1485,583,1653,1654,190,43,25,344,342,1655,820;25;F
70927;9,25,166;13;F
70942;342,63,707;29;F
70943;1118,348,51,919,596,1653,45,587,433,43,822,25,44,435;41;F
70959;596,5,245,190,43,347,90,919,52,1456,1656,820,106,317,627;19;M
70969;433,344,820,345,627,106,347,43,1422,583,1654,919,340,1655,1518;39;F
70974;587,707,627,435,106,347,62,593,245,589,919,348,1456,317;28;F
70980;44;53;M
70998;433,43,90,51,52,342,53,820,63,707,245,1148,45,919,1656;36;F
71009;1655,1653,1654,1657,1656;34;F
71033;1657,245,348,820;39;F
71037;44;39;M
71060;166,1518;39;M
71067;596,1430,166,707,1118,1619,5,6,43,44,348,245,25,1411,1518;35;F
71068;1456,43,245,433,587,6,1422,596,822,919,348,1118,1058,1518;45;F
71091;25,822,1422,583,45,62,433,5,9,1430,43,348,820;24;M
71106;51,52,53,435,707;28;F
71115;340,820,1058,707,1656,919,90,43,1653,245,6,1148,45,5,433;3;M
71122;344,1430,6,596,1619,1118,106,627,25,1518;46;F
71148;1226,1058,6,90,166,5,1485,9,25,51,820,435,190,1654,245;24;F
71216;820,1058,63,627,1226,1619,342,433,587,5,9,45,166,25,1518;42;F
71241;6,822,25,51,348,53,707,245,1430,9,44,1456,435,627,1518;37;F
71242;1656,1619,62,45,1430,1657,245,1654,166,90,1456,1658,433,583,1518;40;F
71243;25,43,820,1518;35;F
71250;5,190,347,51,348,1118,106,627,245,1653;45;F
71294;820,1655,344,25,90,245,587,5,9,6,822,919,44,53,1518;41;F
71306;587,593,1148,6,919,344,106,245,90;40;F
71313;51,52,53,435,317,707;30;M
71316;627,25,1118,1518;37;M
71321;1148,190,90,52,344,340,820;24;M
71341;345,433,587,45,1658,583,245,43,589,348;47;M
71355;627,6,898,1619,317,5,1485,435,1148,190,596,53,707,583,1422;33;M
71358;166,53,1518,1430,1619,1411;42;F
71411;1430,166,1619,820,1518,1411;13;M
71415;1518;8;M
71416;1485;29;F
71431;347,1656,245,627,596,90,820,1657,348,342,106,190,589,583,1658;43;M
71442;1518;5;M
71447;1518;39;M
71465;1518;40;F
71493;1658,51,344,342,1656,627,340,347,1653,583;39;F
71503;919,344,587,44,53,1058,627;57;F
71508;627,9,5,898,62,1148,1654,347,1619,106,820,344,51,43,245;52;F
71540;627,106,1058,1456,1118,342,51,433,62,593,1653,347,90,344,1656;24;M
71564;1658,583,593,6,317,1148,43,1653,190,627,587,106,433,820,348;41;F
71583;62,1148,1430,6,245,1422,589,53,820,106,190,43,347,25,317;36;M
71594;587,44,51,90,347,245,6,62,9,5,433,317,627,345,1518;51;F
71596;245,1654,43,820;17;M
71602;1430,6,43,596,344,348,1118,53,820,106,627;47;F
71603;62,433,45,1658,583,245,1118,1226,1456,63,707,1518;46;F
71605;106;37;F
71611;707,1411,1118,245,1485,1148,1654,1422,52,1656,820,106,435,627,317;31;F
71621;1656,1226,1118,342,348,919,90,1422,190,1658,1148,340,820,345,1518;40;F
71624;347,25,51,52,344,1656,53,1655,820,106,627,317,707,345,1518;25;F
71631;106,245;35;F
71662;435,707;30;M
71679;1148,583,1422,347,90,51,348,820,1058,106;28;F
71683;43,45,898,433,587,593,583,245,1653,919,344,342,340,1058,63;33;F
71684;1485,587,435,1518,433,5,9,45,1430,245,43,25,44,348,820;45;F
71690;345,1658,51,342,707;35;F
71692;348,340,587,433,1658;51;F
71714;6,106,1456,344,53,245,1485,90,25,51,627,435,52,317,707;35;F
71739;51;36;M
71748;44;32;F
71755;1654,589,43,90,919,344,53,340,820,317,1430,45,5,627,435;31;F
71770;51;1;F
71790;342,627,820,1456,1655,90,347,245,1658,583,1148,1653,1656;38;M
71805;1226,1619,344,52,51,25,90,347,589,1422,190,245,1058,627,345;40;M
71830;433,45,1653,245,190,1422,348,342,1118,1656,1655,1456,106,627,345;37;F
71842;1655,1118,348,52,5,51,919,596,90,347,43,245,6,898,1485;21;F
71854;51,342,1619,63,106,317,345,5,45,245,190,340,1655,820,627;29;F
71856;51,52,344,348,1118,53,106,820,1456,1518,627,345,245,1654,342;36;F
71887;344,44,1518;43;F
71891;1619,317,345,166,1658,820,51,919,347,190,245,45,5,106,627;48;M
71895;1430,1658,245,190,342,1655;48;F
71897;9,1430,6,43,707,1411,1518,820,106,435,317,587,593;25;F
71912;45,6,347,25;22;M
71917;1619,5,9,6,166,90,25;48;F
71919;342,707,5,9,45,6,347,25,344,348,1456,317,627,106,820;29;F
71929;317,627,106,820,1456,1656,52,344,919,90,190,245,1148,62,5;23;M
71932;342,1658,245;32;F
71935;5,62,53,106,317,245,1654,43,347,25,51,52,820,627,1518;42;F
71948;1656,53,106,707,1485,9,5,43,25,1619,820,627,317,1411,1518;41;F
71959;1657,1658,245,190,347,90,348,1619,1656,340,1655,820,106,627,345;36;M
71966;1619,1658,90,345,820,1657,245,190,347,348,1656,340,1655,106,627;2;M
71988;348,106,5,190,43,347,53,820,627,707,1518;51;M
71994;627,5,43,51,820,106,435,317;30;M
71996;587,62,1118,106,433,1148,583,6,1654,43,589,347,919,52,344;49;F
71999;9,347,90,51,52,53,627,44,1430,62,1518;47;F
72006;1118,340,627,62,190,347,344,52,53,6,1653,90,51,1656,1655;49;F
72049;348,166,1654,245,45;44;F
72072;5,1430,1148,1658,245,190,1422,347,344,820,435;53;F
72128;25,52,820,435,1518,1653,348,342,340;50;M
72133;45,344,53,106,345,1518,6,1653,190,347,90,1656,340,1655,627;54;M
72185;106,317,1656,1118,1485,1654;47;F
72208;90,347,583,45,433,587,6,245,344,53,5,1430,25,820,627;39;F
72223;51,344,53,820,106,345,1148,190,348,340;49;M
72256;9,1518,166,25,627;37;F
72272;1518,348,1118,25,43,593,62,5,1058;30;F
72279;245,433,587,9,593,45,583,1654,25,919,53,820,1058,707,1518;34;F
72322;1411,1619,44;32;M
72395;45,1658,1657,1655;36;F
72401;1430,1619,1411;46;M
72434;106,627;44;F
72471;1656;17;F
72475;1518,707;30;F
72494;43,1422,190,1148,433,1430,820,348;32;M
72506;53,820,1058,5,9,45,43,347,25,44,348,1456,627,1619,1518;36;M
72511;1148,43,919,1058,587,593,25,317,627,53,1619,51,347,1653,106;23;F
72515;5,587,62,45,583,245,43,347,52,820,627,707,1411,919,53;40;F
72516;62,45,25,51,1656,1518,1654,347,919,348,53,820,106,627,317;38;F
72518;345,344,583,45,1658,1654,348,340,1655,106;47;M
72530;348,5,9,53,340,820,63,106,435,627,317,707,345,1518,1411;26;M
72564;52,1619,53,1058,345,433,587,583,1422,90,919,348,342,1226,627;24;F
72594;5,43,25,1118,820,1411;48;M
72606;166;54;M
72622;1456,106,627,1411,1518,5,898,583,1654,1422;47;M
72626;433,62,45,6,245,1654,347,25,51,53,820,627,1518;45;F
72654;347,90,1456,627,707,433,5,9,43,25,51,342,53,820,1518;33;F
72668;583,245,347,90,25,51,344,342,1619,53,106,627,707,1518;9;F
72680;190,589,347,90,596,51,52,433,1422,348,1118,53,627,345,1411;63;M
72697;1430,1619,1411;5;M
72699;5,62,583,245,43,347,25,344,52,342,1619,53,627,707,1518;4;F
72725;6,589,433,587,593,1658,1422,919,1118,340,1655,1058,106,627,345;34;F
72726;190,1148,1430,62,587,347,340,1518,820,52,344,1656,106,627,317;32;F
72736;53,1422,5,587,433,9,1430,245,25,44,348,627,317,1518;48;F
72738;43,25,820,106;24;M
72749;347,25,919,51,52,344,342,1619,53,820,1058,106,627,707,1518;2;M
72750;1430,1411;49;F
72755;45,245,43,52,344,106,627,433;37;F
72807;45,820,166;66;F
72814;5,583,6,25,51,344,52,53,820,317,627,1518;12;M
72853;1656,53,627,707,345,433,1430,583,1658,6,1653,348,342,1655,1456;31;F
72889;1430,1411;50;M
72890;1658;41;F
72908;53,1655,63,1518,433,45,1148,1658,245,1654,51,820,348,345,340;36;M
72917;5,6,43,90,25,51,52,344,820,627,1518;47;F
72951;593,43,589,348,1226,1456,1058,707,1411,1518,587,1430,25,1118;55;F
72989;627,5,45,245,190,43,347,25,51,52,820,106;44;M
72994;593,245,43,596,1118,106,45;38;F
73000;583,1148,1657,9,433,5,593,1430,6,43,340,820,1456,1058,1411;1;F
73019;1430,45,9,583,43,44,348,820;38;F
73022;707,1656,1654,190,347,593,583,596,1148,245,1653,1422,90,342,1118;45;F
73041;348,1619,53,106,627,317,5,1485,9,583,1654,25,820,435,1518;39;M
73046;5,1430,6,43,90,25,820,627,1411,1518;48;M
73086;345,627,1456,53,342,52,51,919,433,9,1430,43,166,90,25;45;M
73174;820,627;30;M
73176;583,1422,596,342,1118,1456,63,435,707,51;31;M
73193;245,1422,43,25,348,53,820,106,317,433,190,919;50;M
73203;1619,1456,1118,1430,433,317,627,596,348,106,919,435,45,53,5;69;M
73241;1656,53,627,707,45,1148,43,347,51,820,106,435,317,1518,190;28;F
73249;1654,1422,43,342,1456,53,1619,44,347,245,1430,45,587,25,51;41;F
73274;587,62,245,583,347,51,53,435,627,317,9,1430,43,25,44;38;M
73305;589,820,627,707,433,45,43,347,25,44,342,5,245,1656,1518;44;F
73322;1657,1658,1653,596,52,340,106,435,593,583,190,919,348,1655,345;45;F
73324;435,627,317,345,1411,433,593,25,919,348,342,1619,1226,1058,707;33;F
73358;5,1430,25,919,1656,820,317;36;M
73387;43,90,25,51,52,820;34;F
73390;1148,1653,53,106,345,348,51,347,190,245,6,62,627;41;F
73395;1485,63,190,589,25,820;19;M
73409;1058,348,190;53;F
73431;9,347,25,51,44,344,627,317;30;M
73449;90,1411,6,5;51;M
73502;587,245,90,51,344,820,106,627;16;M
73525;433,587,5,1148,245,627,1518;40;F
73546;44;46;M
73571;587,5,245,347,90,51,344,348,820,627;18;F
73598;9,90,919,52,51,1619,53,106,6,347,25,44,627,317,1518;52;F
73605;627,820,1656,344,43,1148,190,347,90,596,51,52,1118,1058,106;51;F
73639;5,1422,1148,593,587,45,43,347,919,51,344,1226,1456,106,627;40;F
73648;1148,1658,6,245,190,340,820,627;42;M
73650;587,1058,627,707,1411,245,593,433,62,44,348,53,1518,435,317;33;F
73660;344,1619,1118,1411;27;M
73689;43,90,52,245,822,344;74;M
73711;166;39;F
73715;1655,342,583;42;F
73718;53,1619,52,25,190,1653,62,6,589,347,51,340,106,627,317;27;M
73721;1118,90,344,342,340,707,583,898,9,5,53,820,45,245,1518;42;F
73761;820,707,317,1411,435,51,347,6,1148,348,106,627,190,342,1658;48;M
73777;5,51,344,820,106;43;F
73780;25,166;38;M
73813;587,5,245,1422,43,820,1456,348,345;63;F
73827;587,348,820,1430;42;F
73838;166,25;12;F
73842;43,45,245;46;F
73852;9,1654,53,1148,898,433,1518,1411,340,51,25,90,43,245,190;19;M
73858;25,166;10;M
73859;90,25,44,1619,1118,820,627,45,245,1518;41;F
73887;166,25;5;F
73888;106,898,53,1422,627,433,347,1148;28;M
73902;1518,317,106,51,347,1653,6,9,5,43,822,25,44,627;51;M
73945;1430,1148,1658,1653,190,1422,90,52,344,348,1118,1656,340,1655,1518;39;M
73970;587,45,593,1658,245,43,342,53,340;38;F
73995;587,5,593,43,347,822,820,106;65;F
74009;43,44;58;F
74034;245,106,345,1657,583,1653,190,347,344,348,1655,1226,340,1058,627;40;F
74098;435,44,9,348,245,25,1518;43;F
74134;587,627,43,593,348,1518;50;F
74191;9,6,90,317,1430,245,166,25;38;F
74193;53,589,1148,5,9,245,347,51,820,106,317,348,627,45,6;34;M
74201;1148,433,1456,1226,344,919,1658,1430,45,5,587,593,1653,245,1058;36;F
74243;1148,596,1658,52,1118,1518,62,90,347,51,344,53,820,1456,106;50;F
74246;1148,1658,6,190,347,90,820,1058,627,345,587,1657;42;F
74250;433,1657,1658,919,1656;45;F
74296;583,347,245,1430,5,433,919,1518;40;F
74307;1619,1411,627,1430,25,51,1456,106,52,1485,62,45,344,435,90;35;M
74320;45,53,317,627,898,1148,190,25,51,344,340,820,435,707,1411;23;M
74323;1485,245,1148,5,9,820,344,25,347,43,190,45,51,52,53;32;M
74337;589,5,587,1148,190,43,90,25,52,1226,1656,1456,820,1058,106;36;F
74341;245;43;F
74367;1654,190,43,822,51,1619,820,106,435,1518,583,25,342,317,707;35;M
74372;1148,190,347,919,51,52,344,1118,1655,820,106,435,627,317,707;36;M
74373;9,245,43,25,1619,1411,1518;40;F
74492;5,9,1430,43,51,348,53,820,1456;41;M
74501;1485,820,43,5;86;M
74511;589,190,6,1430,1485,433,9,583,347,25,820,106,435,627,317;30;M
74524;45,1657,583,919,342,1058,1456,345,1411,433,1430,1654,1422,1518;39;F
74527;1518;11;M
74551;820;85;F
74582;627,245,820,6;73;F
74590;820;81;F
74603;9,1485,45,90,25,51,344,348,342,53,1655,106,435,317,707;40;F
74619;820,1656,51,1148;36;M
74623;340,347,43,435,627,820,5,1148,190,1653;58;F
74624;344,51,25,5,45,245,166,347,90,342,1619,1118,820;34;F
74643;53,1655,1653;37;F
74651;1518,433,45,1430,583,245,43,52,342,1619,53,820,1058,627,1411;38;F
74673;53,245,1654,596;17;M
74720;627;90;F
74725;5,1422,51,344,820,1456,345,1657,1658,340;43;M
74731;51,348,342,1226,1456,1058,435,627,345,433,1657,1658,583,190,245;31;F
74747;1658,919,587,433,340,245;16;F
74751;435,707,1411,9,433,5,919;46;F
74761;43;71;F
74791;190,1658,1657,5,9,347,90,25,51,1619,53,820,106,317,1518;27;F
74805;627,348,106,53,52,51,347,589,1422,190,1653,6,583,1658,62;36;F
74811;106,627,317,1411,62,190,43,25,51,344;21;M
74850;190,1422,589,347,919,44,344,1118,1656,1226,340,820,106,435,1411;28;F
74874;707,587,627,245,820,347,344,43,51,53;81;F
74875;5,596,52,344,1148,627,1518,245,90,1411,25,166;48;F
74919;596,52,344,1148,347,317,627,245,166,90,25,1411;49;M
74967;583,1422,25,340,1411;32;F
75003;435,317,1518,5,43,1411,9,583,6,347,25,44,820,106,627;40;F
75030;5,348,820,345;39;M
75042;1430,190,348;51;M
75070;587,62,245,190,342,1226,53,1058,435,317,707,345;38;F
75074;45,433,1657,1148,1654,190,347,90,344,348,342,1656,1655,820,345;37;F
75105;433,45,347,919,53,627,317,707;30;F
75108;245;59;F
75119;106,317,1058,820,53,342,43,1658,1430,45,5,1518,435,166,1422;40;F
75150;317,1518,820,1656,348,347,43,1654,583,1430,45,1485,5,9,166;34;F
75164;1658,52,340,820,345;38;F
75177;587,627,53,433,62,45,593,919;22;F
75224;919,245;26;F
75268;433,348,245;61;F
75289;433,53,1518,1411,345,317,627,587,5,898,45,190,43,342,63;15;F
75297;245,589,44,51,52,344,53,1518,9,25,820,106,435,627,317;23;F
75313;898,9,433,5,317,627,707,1518,820,583,596,44,348,1118,435;50;F
75317;6,52,1118,317,245,596,820,627,347,9;62;F
75325;9,245,43,25,1619,1411,1518;13;M
75336;9,166,347,25,820,106,627,317,1518;30;M
75344;344,25,43,190,587,898,6,245,347,90,51,52,106,627,317;50;F
75368;245,1422,589;25;F
75386;43,62,9,1654,1118,1518;49;F
75390;9,245,43,25,1619,1411,1518;11;M
75404;627,1653,342,90,348,1148,596,583,1655,190,1654,1657,345,1658,340;39;M
75452;9,245,43,25,1619,1411,1518;6;M
75471;345,190,1658,1657,1148,1653,1654,347,51,348,1656,340,1655,820,627;48;M
75483;1656,1485,106,1653,190,51,52,344,820,627,317,707,1148,43,347;68;F
75494;1653,245,190,347,25,62,51,344,820,435,1518,1485,43,340,106;51;F
75496;9,245,43,25,1619,1411,1518;3;M
75514;53,1619,344,51,25,433,1430,6,245,347,90,52,348,627,1518;51;F
75569;6,347,51,52,344,1619,820,106,317,627;40;F
75573;5,1148,1658,43,166,589,344,1655,345,820,822,190,583,348,340;20;M
75618;589,596,51,348,52,1619,1118,53,63,106,627,317,707,1411,347;42;F
75679;5,1657,583,245,190,43,347,90,51,344,53,1655,820,106,627;21;M
75700;583,62,433,45,593,1654,43,166,348,1118,53,1456,1058,627,1411;47;F
75720;435,627,1619,348,344,44,51,90,347,1430,5,9,43,1118,1518;45;F
75765;1655,44,1518;36;M
75796;627,106,820,1619,344,51,347,1422,245,433,587,5,6,90,919;22;F
75804;90,43,5,245,342,820,63,62;34;F
75814;1148,1657,43,344,1658;43;M
75835;45,1657,1658,583,1654,44,342,340,1655,63,707,1518;35;M
75836;587,919,348;47;F
75850;9,820,106,627,317,347,43;37;M
75863;9,25,44;1;F
75916;1422,347,52,348,342,43,53,820,627,435,317,106,5,6,51;6;F
75936;190,43,347,345,1658,822;37;M
75938;25;42;F
75976;245,1148,1658,1653,190,347,596,51,342,1656,1655,820,106,627,345;34;F
75991;9;81;F
75996;347,342,919,245,9;42;F
76031;344,596,90,347,190,1653,245,1148,898,433,345,340,707,63,5;17;M
76043;347,53,820,627;55;F
76048;9;75;M
76078;9;73;F
76084;51,347,627;40;M
76085;593,245,1456,106,435,627;27;F
76107;25,317,52,62,1619,106,347,627,90;39;M
76111;344,53,1058,106,627,587,45,583,1653,1654,43,348,1118,245,44;12;M
76120;587,347,90,51,53,9,45,1654,43,1518,25,919,44,342,820;35;F
76154;898,1485,1148,1653,1619,627,345,1518,1657,1658,1654,1655,348,342,1656;39;F
76202;90,820,5,1148,245,340,62,583,190,43,589,44,1619,63,106;41;M
76219;53,820,106,627,5,43,347,51,44,1656;34;M
76262;433,587,62,593,1430,589,919,1226,1456,1058,348;39;F
76306;45,1654,596,344,1118,53,820,6,245,90,342,627,317,43,822;49;F
76326;433,62,245,589,347,51,1619,1656,53,820,106,627;16;F
76343;51,43,245,6,583,433,45,347,90,1619,1456,106,627,317,707;37;F
76429;45,583,1654,347,90,51,344,342,1619,820,1456,106,627,317,707;9;M
76464;433,1430,1658,190,348,345,245;44;F
76484;820,106,51,344,435,627,345,340;28;M
76491;1456,435,433,5,9,898,1430,583,6,245,166,589,25,44,1518;44;M
76510;583,90,51,44,52,344,342,1619,53,820,1456,106,627,317,707;8;M
76526;898,583,245,1654,190,344,1118,340,106,345,627;43;F
76534;433,587,593,1430,245,347,1148,1226,627;20;F
76572;25,51,1118,820,317,627,1485,5,45,1148,245,1654,90,43,52;13;F
76580;9,6,44;29;F
76606;9;61;F
76612;44,344,1656,53,340,820,106,43,25,919,348,627,190;39;F
76623;62,433,587,190,1422,51,1058,707,245,6,1226,63,106,627,317;59;F
76624;1148,583,190,1422,347,51,52,348,342,1655,245;30;M
76638;587,1430,1653,344,342,1656,106;48;M
76673;43,1148,245,347,1456,627,340;44;F
76682;62,1657,1658,1653,25,593,1148,245,51,919,53,820,106,627,345;35;M
76767;919,347,589,43,1422,1430,593,9,1518,1411,707,1058,1456,342,44;49;F
76775;90,1656,340,106,435,707,1485,583,6,245,1654,190,589,344,342;34;F
76790;62,6,90,25,53,435,44,1518,317,707;72;F
76797;51,1619,53,820,435,919,347,1422,6,1226,1058,106,627,317,707;21;F
76816;9;49;M
76824;190,348,435,587,245,347,90,596,919,51,1226,820,1058,106,317;17;F
76827;919,1148,245,190,25;46;F
76848;433,348,106,435,340,627,1456,347,245,1148,43;44;M
76851;347,1485,435,317,245,51,627,53,1422,90,898,52,5,1619,6;25;F
76867;1226,53,317,435,1456,1619,347,583,1148,1430,593,589,25,919,707;26;F
76887;587,433,9,62,593,1422,347,25,919,44,342,1456,707,1411,1518;12;F
76896;9,5,587,433,62,1422,589,919,1118,53,820,43,166,596,25;44;F
76917;5,6,1422,43,347,51,52,348,342,53,820,106,435,627,317;3;F
76933;1518;17;F
76982;5,45,43;42;M
77007;627,1518;11;F
77044;627,1518;46;M
77046;1658,1518;47;F
77057;344,52,51,919,596,90,347,43,583,1430,593,45,5,433,245;30;F
77059;1430,1422,51,820,317,1148,6,245,347,90,348,344,52,340,627;12;M
77066;347,596,822,25,51,44,53,820,106,627,1411,1518,898,583,348;33;F
77070;90,43,190,1148,593,62,1485,5,587,707,627,106,820,53,344;48;F
77083;1518,433,45,245;38;M
77086;52,53,51;3;F
77093;245,347,90,919,51,344,348;46;F
77108;43,45,9,6,44,1518;54;F
77111;919,51,1456,106,435,6,1148,1485,5,433,583,245,1653,627,1518;41;F
77134;587,45,1148,1658,245,1653,190,596,1118,340,820,345;48;F
77151;45,51,317,435;;M
77190;245,1422,166,433,1118,1226;50;M
77194;589,25,919,348,1058,433,1226;22;F
77197;317,5,1430,919,51,348,6,245,90,347,344,820,627,435,106;20;F
77227;1658,1148,1653,245,190,347,25,51,344,820,435,106;34;F
77243;5,9,45,25,51,52,344;30;M
77247;245,1430,1485,433,593,1658,583,1654,596,342,340,1456,435,707,345;41;F
77261;1456,1411,589,1430,1657,1654,1422,1656,1655,820,627,345,1148,1658,1118;35;F
77273;9,45,6,43,44,52,1518;54;M
77295;1430,43,1456,1058,707,1518,587,5,9,6,90,25,919,44,1118;29;F
77301;627,25,1411;18;M
77305;433,62,245,1654,342,1118,53,340,587,593,1658,1655,820,345;38;F
77330;44;36;F
77343;1148,245,190,25,919;46;M
77375;62,898,9,5,433,245,347,596,25,344,348,1619,53,820,106;12;M
77419;1118,898,25,190,6,62,44,340,820,9,53,106,627,317,1518;33;F
77420;433,898,1430,583,245,190,596,25,348,1118,340,106,627,345,1518;10;M
77421;6,596,44,1118,1456,106,43,1619,1058,317,433,587,593,245,90;61;F
77427;5,587,1148,583,190,347,51,340,820,245,6,1654,919,106,627;38;F
77428;245,166,25;10;F
77467;583,45,1430,1411,1518,9,25,348;44;M
77468;1658,342,190,1148,5,822,820,106,45,245,583,348,1654,340,345;36;F
77486;51,347,348,53,627,317,25,344,1619,342,44,62,822,106,435;59;F
77510;820,627,317,707,898,190,347,1485,6,106,51,25,435;18;M
77538;106,433,587,5,62,1148,245,190,347,919,51,344,348,820,627;44;F
77566;348,106,1422,53,627,51,245,90,317,707,52;30;F
77587;5,9,62,1430,245,1654,43,166,596,822,342,1118,53,433,1518;35;F
77589;1118,52,51,596,589,1654,433,45,1658,245,347,348,340,820,106;54;F
77606;9,45,6,43,52,1518;20;F
77641;1657,1148,1658,6,1654,190,90,347,51,52,1619,340,820,435,345;33;F
77642;1657,1148,1658,6,1654,190,347,90,51,52,1619,340,820,435,345;39;M
77662;90,1430,62,433,820,587,45,245,348,1411,627;29;F
77690;53,820,106,435,627,317,707,898,1485,6,190,1422,347,25,51;46;F
77714;44,1518;42;M
77726;435,627,317,1411,106,63,53,1619,166,43,1422,1653,5,51,707;34;F
77762;9;28;F
77774;820,25,6,1148,898,5,1485,62,190,347,51,106,435,317,707;71;F
77814;43,25,245,1456,1058;52;M
77818;1148,1430,587,1485,593,190,1422,43,347,344,1118,53,820,1058;24;F
77849;9,1148,190,347,90,25,51,344,820,627,1518,106,435,587,317;22;F
77850;344,820,347,6,1485,5,898,1148,190,25,106,435,627,317,707;73;M
77883;106;38;M
77894;344,5,1485,898,1148,190,347,51,25,820,106,435,627,317,707;13;M
77936;348,25,9,45,1430,583,1411,1518;40;F
77998;589,190,1653,593,45,1485,5,587,433,1430,348,627,106,435,317;40;M
78008;5,9,45,166,90,822,627,25,51,44,1118,53,820,317,1518;33;F
78018;44,1518;36;F
78034;1118,1456,106,5,583,43,90,596,627,6,51,820,435,317,707;28;F
78044;62,1430,347,25,344,348,820,627,45,43,51,53,1411;40;F
78048;587,1658,1655,1657,190,435,1148,43,1654,245,344,348,820,345;71;F
78050;5,25,344,1118,1518,820;45;M
78060;435,25,347,5,9,43,51,52,344,53,820,627,1411,6;27;F
78094;820,317,345,707,1658,6,43,52,344,435,627,342,106,62,63;31;F
78101;345;65;M
78104;5,1148,190,589,347,90,1619,340,820,106,627,317;23;M
78118;45,347,25,919,342,53,435,317,9,6,43,51,344,820,627;28;F
78120;1422,1058,587,5,9,166,589,347,51,25,820,1118,593,627,1518;56;F
78126;45,5,90,25,51,344,348,53,340,820,345,435,1148,245,52;48;M
78130;317,587,1619,106,627,1118,1411,1518,348,44,6,9,5,43,25;49;M
78133;166;10;F
78135;1619,1518,245,583,25;43;F
78138;45,820,583,245,43,44,1456;33;F
78145;43,1619,433,45,1148,1654,190,51,344,1656,340,1655,820,106,345;32;F
78167;166;20;F
78174;6,245,347,90,919,51,52,344,1226,53,317,627,820,1058,106;20;F
78177;344,1655,820,627,43,1653,245,1148,62,5,45,1657,1658,345,340;33;F
78179;1655,63,1658,1657,1485,9,45,583,166,822,1518,596,820,5,245;45;M
78183;433;34;M
78200;5,1148,43,820,9;37;M
78257;45,1430,6,347,90,344,52,820,627,317,587,5,245,43,822;44;F
78271;51,90,433,6,53,106,435,1411,707,317,627,898,1619,1422,1148;29;M
78307;1656,1653,245,587,433;38;F
78314;627,1411,25,433,1518,245;38;M
78321;1148,1653,347,340,820,1518,345,317,627,1656,1422,190,51,344,53;26;M
78337;587,1430,6,1654,25,44,348,53;40;M
78343;190,1653,245,51,344,1118,53,820,435,106,43,596,919,627,1518;36;F
78357;9,106,627,317,345,707,53,344,348,44,25,1422,245,587,433;45;F
78361;1653,245,9,5,820,435,1456,587,593,43,347,596,25,1118,1518;41;F
78369;245,1485,44,344,53,707,1411,190,627,51,52,317,25,348,435;36;F
78384;53,1619,589,583,433,9,45,44,1118;38;F
78390;1430,589,347,919,1118,627;18;F
78400;342,53,348,1656,820,1456,1411,5,433,583,245,1654,90,1058,52;47;F
78419;433,45;49;M
78435;433,587,593,1430,90,1656,63,106,627,45,245;36;F
78452;1411,342,1422,43,1653,245,583,1654,190,348,1656,1657,1658,340,345;36;F
78524;1118,1226,820,52,344,342,1456,1058,63,435,43,1653,583,1658,707;39;F
78532;62,347,822,25,51,44,344,348,342,1619,53,106,435,627,317;57;M
78548;340,317,345,245,1654,583,190,51,1422,347,1619,53,1456,106,627;42;F
78550;1430,5,1422,51,52,707,435,53,898,1518;27;F
78575;1657,1148,245,1653,43,90,596,52,348,1656;65;F
78597;44;32;F
78623;51,820,1657,342,348,433,1653,345,1148,1658,245,340,1655,627,1654;32;M
78628;6,45,583,1654,53,820,707,345,1411,62,5,44,1118,1518;33;F
78636;25,1518;39;F
78638;43,627,245;41;F
78644;347,820,435,62,6,51,44,53,106,433,245,25,1619,627,317;31;M
78645;435,9,5,43,347,820,627,6,245,25,348,1619,106,317,1518;29;F
78648;51;38;F
78686;90,1654,340,433,45,1657,1148,1658,583,245,1653,348,1656,1655,345;37;F
78700;190,1422,44,53,340,820,63,106,435,25,627,51,52,707,317;29;M
78703;348,1619,53,820,1518,5,62,583,25,44,344,1656,106,627,317;39;F
78705;53,435;74;M
78716;166;70;F
78721;190,340,820;46;M
78722;1657,583,90,596,25,348,1118,340,627,345;45;M
78725;25,1518;2;M
78726;583,6,43,347,51,52,344,106,627,317,342,1619,90,822,245;36;M
78741;9,1430,583,25,820,435,44;29;F
78756;1148,348,627,52,51,25,90,43,347,820,106,435,317,707;49;M
78762;166;73;M
78775;1654,62,707,433,5,9,1430,6,43,90,1456,44,1619,53,1411;29;F
78785;433,593,1430,1658,43,919,348,1118,1226,1456,1058,1518;30;F
78794;583,43,822,52,820,1456,106,435,627,317,707,1518,345,53,1422;23;F
78814;51;4;F
78840;587,9,43,25,44,52,1118,53,1058,820,1456,435,627,317,707;51;F
78852;348,90,596,820,43,347,25,51,52,344,106,435,627,707,317;13;M
78857;51;2;F
78891;90,1654,1653,1657,45,9,5,6,245,347,52,820,106,627,1518;47;F
78900;589,347,342,1619,627,317,90,25,52,707;38;F
78933;190,587,5,1430,43,347,596,25,51,820,106,435,627,317,707;16;M
78943;44,245,433,627,1518,90,6,1411,5,1619;35;M
78954;587,190,43,347,52,344,348,340,820,106,435,627,317,345,1411;21;M
78960;25;30;F
78961;5,9,45,6,245,43,347,51,348,53,820,106,435,627,25;25;F
78963;52,45,583,245,1422,347,51,1619,53,340,1456,106,627,317,345;41;M
78988;1118,45,9,5,43,52,820;51;M
78993;1485,1430,317,1518,435,5,9,1148,190,43,25,51,52,344,348;31;M
79035;44;42;M
79057;919,342,44;5;M
79076;1654,1422,51,52,1148,583,245,347,1619,53,340,106,627,317,345;12;M
79080;9,43,25,44;19;M
79096;587,43,106,627,44;19;F
79107;1430,1422,347,1518,433,1148,1658,6,245,190,90,919,348,340,106;40;F
79121;1657,1148,1654,1422,342,1226,1655,707,587,1653,919,1656,1058;37;F
79129;190,52,347,106,627,1653,6,5,43,90,245,919,1148,1619,51;67;F
79175;583,245,1654,190,1422,347,51,52,1619,53,340,106,627,317,345;10;M
79250;1430,583,6,43,919,1226,1656,53,1058,707,587,1422,589,1411,348;20;F
79251;1656,53,1655,707,345,5,9,347,25,51,820,106,627,317,1518;42;F
79285;1118,53,1058,106,435,317,1411,587,62,6,43,589,347,596,919;34;F
79343;1657,1658,583,245,190,589,347,90,596,348,342,1656,820,106,627;12;F
79384;53,345,1655,1619,348,51,347,245,45,5,25,44,344,820,1518;33;F
79389;1657,1658,583,245,190,589,347,90,596,348,342,1656,820,106,627;8;M
79395;1118,345,1654,1653,433,1657,1658,348,820,583,627,347,190,1148,45;37;M
79428;1657,1658,583,245,190,589,347,90,596,348,342,1656,820,106,627;42;F
79440;106,587,5,593,1430,1148,245,344,348,53,340,1411,1058,627,345;51;F
79464;5,589,344,348,1118,820,106;22;M
79545;9,820,106,627,317,1518,1619,51,25,347,90,245,6,62,433;18;M
79547;190,245,1658,1485,1148,347,106,317,5,9,6,43,51,1656,627;41;F
79577;587,433,9,1654,43,90,25,919,820,106,435,627,345;18;F
79608;43,433,1518,9,90,166,5,6,1422,25,44,348,1118,317,1411;29;M
79612;53,435,317;36;F
79636;433,593,9,342,53,1456;38;F
79642;62,583,1653,1654,43,589,919,342,106,1658,245,347,340,627,345;31;M
79683;245,51,44,1518,5,9,53,820,1619,344,919,25,6,583,593;38;F
79719;43,919,1456,593,62,5,53,1655,820,433,1430,1148,1658,627,345;30;F
79735;44,1118;27;F
79767;822,1619,1118,1226,1656,1655,627,317,1411,9;34;F
79768;43,90,344,348,340,1430,6,245,347,25,51,106,435,627,317;38;F
79791;345,1518,433,587,9,593,245,43,822,25,348,342,53,340,820;41;F
79793;822,1518,9,5,433,1422;41;M
79875;898,45,583,1654,52,5,1485,9,245,919,344,820;34;M
79881;90,347,348,344,919,25,45,433,5,1654,43,342,820,627,1518;37;M
79887;1656,1148;30;F
79930;1430,62,433,6,245,919,348,1058,435,627;28;F
79931;919,51,627,1226,1058,433,587;33;F
79950;9,1430,25,53,820,627,1518;46;M
79967;5,43,820,435;29;F
79969;44,106,9,25;41;M
80007;1485,898,583,245,1653,589,347,44,52,348,342,106,435,707;44;M
80013;51,1619,5,1148,6,245,1653,190,43,347,90,919,52,106,627;43;F
80038;5,62,1658,347,25,51,53,340,627;38;M
80050;317,1619,25,347,1430,1518;46;F
80068;25,43,9,1518;49;F
80072;1411,106,53,348,51,347,9,435,627,317;41;F
80078;62,9,1485,5,587,190,51,344,348,1118,25,53,820,1058,435;28;F
80094;9;28;M
80145;627,245,1430,9,45,43,166,25;48;M
80159;1656;34;M
80189;433,587,583,6,919,589,347,25,51,44,1456,1058,435,627,1518;28;F
80194;344,627,433,5,9,62,1658,6,43,589,1656,53,820,44,707;30;F
80196;9,25,44,820,627,317;35;M
80305;44,919,25,90,589,43,433,1456;24;F
80328;25,9,166;46;M
80385;596,919,51,52,820,435,627,317,5,62,6,245,43,106,63;38;F
80410;347,51,53,317,6,106,627;39;F
80416;347,344,106,1411,1118,5,6,25,44,1619,627,317,245,43,1518;43;F
80539;1518,62,1657,1148,583,1653,347,51,44,53,340,1485,25,435,707;42;F
80551;433,583,344,1411,707,317,627,53,25,90,5,245,6,1118,1518;29;F
80562;6,106,25,44;42;F
80591;1456,898,1058,1430,433,587,593,627,245,347,348,822,919,25,6;53;F
80617;435,52,51,90,347,1653,5,627,345,62,1422,348,342,106,707;36;M
80637;5,90,589,898,1658,1653,190,596,51,348,53,820,106,627,345;43;F
80667;106,627,820,344,90,5,347,25,51,52,1653,1657,1148,1654,190;34;M
80696;5,6,52,820,1058,342,348,1654,1657,1518;31;F
80709;347,1658,51,627,820,245,340,106;34;M
80723;6,106,5,1148,1653,190,43,347,51,52,344,348,1656,627,820;48;M
80725;1653,1655,1148,190,344,345,106,435,62,45,43,51,53,9,5;68;F
80774;1518;47;M
80800;348,1654,583,190;36;M
80807;1654,707,1148,587,245,345,348,822,106,45,43,25,9,5;63;F
80831;5,9,6,25,44,1118,1518;32;F
80852;44,1118;38;M
80853;347,1518,1411,707,1485,90,52,344,317;27;M
80863;898,820,45,593,1430,1658,583,245,1654,1422,43,166,25,342,1118;45;F
80887;1658;38;M
80894;1456,433,245,43;66;F
80901;344,345,245;31;F
80928;45,1422,90,1118,5,6,43,347,51,52,344,53,820,627,1518;43;M
80930;1118,1411,44;46;F
80938;6,51,344,1118,1226,1411,347,348,340,106;34;M
80950;348,1658,1657,1656,1655,1654,1653;43;F
80952;1456,1148,1485,190,820,106,919,435,45,43,51,25,9,6,5;20;M
80955;820,106,245,190;44;M
80969;9,587,433,5,62,1422,589,596,1411,1430,6,245,347,25,348;48;F
80971;1657,1118,245,1654,1485,1422,596,25,919,348,1656,1058,627,707,1518;62;F
80998;1148,347,25,106,435,627,317;24;F
81037;1658,190,340;33;F
81040;166,587,1430,245,43,25,919,44,344,348,1619,1118,1411,1518;52;M
81134;587,53,1518,43,245,45,62,1619,1658,1657,1656,1655,1654,1653;47;F
81139;25;38;F
81157;51,344,820,433,62,245,347,25,348,1619,1656,106,435,317,627;50;F
81171;1058,106,435,707,43,596,822,1518,1118,9,6,5,90,25,166;46;M
81196;5,347,596,919,44,1619,1118,53,820,106,317,627;15;F
81223;1456,1430,1058,1411,707,1655,1658,45,919,1656;46;F
81292;347,90,51,348,820,245;73;M
81313;433,1485,1148,1518,342,1619,820,1058,345,593,1657,1658,245;39;F
81315;6,596,822,1518,5,43,90,1118,707,9,166,25,435,106,1058;18;M
81345;347,820,707,5,62,583,1656,63,106,627,317,345;31;F
81378;245,43,820;75;F
81388;587,1653,245;67;F
81392;317,435,25,344,51,52,106,5,9,1148,6,43,53,820,627;28;F
81400;53,627,106,1058,820,51,43,190,1148,587,593,1653,347,348,1226;50;F
81429;344,52,348,317,5,6,820,589,707,627,106,1656,51,347,245;30;M
81446;5,1658,1422,1656,820,51,348,1118,106,62,583,190,43,596,25;35;F
81452;245,43,347,596,51,344,1226,1118,1655,820,1058,627,707,9,44;49;F
81453;340,435,1518,62,898,583,347,317,1411,433,1430,1654,106,627,707;22;M
81463;51,317,707,345,1658,43,589,347,90,342,1118,1656,53,340,820;23;M
81523;820,5,90,596,822,707,6,43,9,166,25,1118,106,435,1518;13;F
81533;5,1619,6,1411,1422,25,1118,1518;27;F
81540;1456,90,347,1654,1485,1658,583,43,25,51,53,820,627,5,6;33;F
81542;1655,51,245,1485,9,45,1654,43,44,53,435,1518,583,6,25;35;M
81558;583,1653,52,1655,1058,45,1148,106,90,190,627;27;M
81628;587,1485,593,583,1654,43,589,51,1226,53,1456,1058,106,627,707;29;F
81640;627,317,1148,43,919,344,348,1411,245,52,820,435;36;F
81679;1422,43,25,1118,1518;61;M
81698;587,593,344,342,1226,707,317,435;32;M
81720;1657,1658,583,1422,919,1226,340,1456,433,587,593,245,166,707,435;31;F
81730;1422,1118,1411,1518;34;M
81752;433,1658,245,1653,166,44,342,1619,53,1655,627,707,345,25,1518;34;F
81753;1148,5,433,190,43,51,52,344,348,53,820,63,106,627,317;60;F
81792;5,53,106,344,347,593,1430,245,820,317,9,25,51,1058,627;36;F
81794;45,919,433,1148,1430,245,348,627,344,51,90,347,190,435,820;16;F
81818;1656,820,435,1518,627,317,1411,347,43,6,9,5,25,919,348;41;M
81828;1658,6,1654,190,43,166,347,919,51,1656,340,820,433,45,245;34;F
81832;245,1654,347,596,919,1619,1118,53,820,106;13;F
81842;919,348,596,347,245,1148,593,62,433,43,51,1118,1456,106,627;39;F
81923;9,62,245,347,51,52,342,589,45,433,5,25,348,820,1518;36;M
81926;433,587,9,1518,25;38;M
81959;433,587,583,6,43,347,919,51,344,342,1118,820,1058,106,707;20;F
81972;9;41;M
81995;5,1485,9,1430,6,245,43,90,25,44,344,1619,1118,1411,1518;48;M
82001;106,1148,1485,348,820;35;M
82024;5,1485,9,1430,6,245,43,90,25,44,344,1619,1118,1411,1518;13;M
82095;433,593,245,1456,1058,435,342,44,1518;37;F
82108;1658;31;F
82110;317,435,820,53,344,44,919,43,9,5,587,166,25;43;M
82223;6,25;48;M
82230;433,1430,1658,245,1422,919,1619,340,1456,1058,345;31;F
82234;707,433,62,1658,245,347,90,51,44,106,627,317,589,919,1619;28;F
82281;1456,25,51,348,1656,820;31;M
82302;5,190,347,90,25,51,52,53,820;32;M
82397;45,433;54;F
82400;1430,347,62,1485,5,245,43,90,919,51,52,106,435,317,707;43;F
82402;583,190,347,25,44,342,340,1456,106,707,51,317,435,627,52;29;F
82407;340,593,9,53,820,1456,1058,106,435,627,317,1518;42;F
82412;1654,919,1619,1656,1655,1485,1657,1658,583,347,822,344,820,627,345;36;F
82413;1619,340,62,593,1430,1657,583,348,1058,627,1655,25,190,1653,245;45;F
82418;583,342,106,627,345,433,45,6,90,51,52,53,435,317,707;33;M
82431;435,62,90,347,106,1619,627,52,1656,53,707,245,6,51,317;39;F
82434;1430,583,1422,25,348,53,820,190;24;M
82445;589,90,51,1118,820,106,707,5,898,52,627,435,317,53,344;39;F
82469;347,90,596,51,1619,1118,53,340,627,583,348,106,317,707,1518;34;F
82474;820,1518;49;F
82481;898,1485,587,45,593,1658,245,1654,1422,919,344,340,820,627;40;F
82487;593,52,348,342,820,1456,1058,435,317,707,53;35;F
82497;5,45,340,1655,106,627,1653,1656;48;M
82507;1518;40;F
82530;1148,347,51,106,627;52;F
82541;5,348,25;45;F
82550;1518,435,820,1655,1485,45,1658,342,707;31;F
82569;1148,627,1656,43,190,1653;45;M
82571;1619,106,627,317,1518,5,9,62,43,25,919,51,44,53,820;25;M
82587;1148,347,1656,345,820,344,25,43,1653,245;59;M
82589;45,1430,6,90,25,51,1456,627,317;45;F
82609;62,5,1148,6,43,51,344,1656,1655,1058,106,190,340,820,345;46;F
82610;1148,6,90,1619,9,62,190,347,51,348,53,820,435,707,1518;25;M
82615;1226,1656,1148,62,433,1485,1658,245,190,52,820,106,435,317,707;36;F
82616;53;4;F
82639;347,51,106,435,627,317;67;F
82651;1655,1456,45,1485,433,53,627,317,5,820,340,344,190,1148,245;67;F
82653;53;8;F
82663;44,9,919,435,53,344,347,62,45,43,51,342,820,627,1619;35;F
82672;245,1518;63;M
82679;9,583,44,53,820;38;M
82681;5,25,344,106,1518,44,1118,1619,6,43,820,627,317,1411,9;41;F
82682;1518;42;M
82688;1118,90,433,5,6,245;43;M
82701;1485,822,51,919,25,627,820,707,90,898,5,1148,245,190,106;37;F
82707;344,820,627,317,5,9,43,25,52;32;M
82711;5,583,6,1653,44,53,1058,707,1518,1148,190,43,51,52,820;28;F
82721;435,317,9,707,25;32;F
82724;1148,166,52,344,820,1518,433,5,190,43,596,822,25,919,44;31;F
82744;166,25;43;M
82763;44;49;F
82787;5,587,1653,1226,53,340,1456,627,317,1411,106,435,25,1422,1148;31;M
82812;1655,62,593,1430,1657,583,245,1653,190,25,348,1619,340,1058,627;7;F
82814;190,43,347,51,52,344,820,106,435,627,317,5,9,166,25;50;M
82816;5,9,898,62,43,347,25,51,820,1411;42;M
82847;62,593,1430,1657,583,340,1619,245,1653,190,25,348,1655,1058,627;16;M
82848;190,433,62,6,245,347,919,344,1118,53,820,1058,106,435,627;44;F
82890;1430,347,51,348,342,53,1456,435,5,43,52,106,627,317,707;32;M
82903;1485,5,62,245,51,1619,53,106,43,347,52,627,317;39;F
82917;822,44,344,53,340,820,1456,1411,345,1518,583,1422,43,25,435;32;M
82947;1485,62,1653,25,348,1226,53,1058,707,587,593,435;37;F
82959;583,45,9,43,51,44,344,820,627,106,317,1118,5,1411,6;12;F
82961;5,898,6,52,1485,62,245,43,25,51,53,435,317,707,345;;F
82967;1430,62,1485,898,6,90,52,53,435,707,340,317,5,43,51;31;M
82968;1456,1058,1518,1411,345,347,190,587,43,340,627,5,593,583,919;35;F
82976;587,62,593,1430,6,245,43,589,919,1226,53,820,1058,5,348;42;F
82983;5,589,347,898,596,25,51,340,820,435,245,919,1118,317,627;16;F
82990;1656,435,106,1226,919,90,43,6,1148,1430,62,587,433;77;F
83021;9,44;47;F
83031;9,44,53,627,1518;37;M
83060;62,433,340,1411,245,1658,1148,1657,45,342,1226,1655,820,1058,345;37;F
83064;51,53,433,6,245,25,1118,820,627,348,43,90,344,1456,9;45;M
83066;6,5,898,1485,62,245,43,25,52,51,53,435,317,707,345;30;F
83082;344,1411,1485,53,1422,898,106,348,90,435,51,627,317,52,707;47;F
83084;707,627,106,820,1058,593,245,43,347,919,344,340;48;F
83087;433,5,1148,43,51,348,820;44;F
83093;44;42;M
83099;44;47;F
83112;25,51,317,707,435;35;M
83117;348,1118,1226,340,53,106,627,317,345,587,822,25,820,1058,435;36;F
83123;44;28;M
83126;5,9,43,25,51;43;F
83132;51,596,587,593,919,344,1118,1058,627,317;33;F
83172;44,1118;54;M
83174;53,340,106,627,317,345,5,1657,6,43,347,348,820;28;M
83176;44;13;F
83179;51,90,347,9,5,25,1619,820,44;47;M
83194;433,25,919,627;39;F
83198;317,627,435,106,1656,1619,51,25,347,190,1653,1654,6,1148,583;32;F
83201;347,822,52,344,106,435,1518,433,5,245,190,43,820,51,25;38;M
83206;44,342;35;F
83219;190,347,25,340,1655,435,1411,589,51,53,433,1422,820,348,1148;37;M
83229;44;16;F
83234;53,1226,342,348,347,589,1422,1653,245,583,1430,593,317,707,1411;39;F
83235;43,25,348;33;M
83263;1657,1654,1619,1655,106,627,51,1656,1653,347,25,190,1148,435,583;33;M
83276;1658,340;8;M
83278;433,44,53;36;F
83284;347,1654,1430,5,587,9,62,593,583,43,25,51,44,348,820;45;F
83295;245;35;F
83340;45,43,90,25,51,53,435,707,1518,5,44,9;31;F
83354;53,51,52,344,1656,63,348,342,1118,820,106,627,45,245,43;43;F
83355;1656,340,1456,1518,5,1148,1658,1653,190,43,52,342,1118,1655,345;70;M
83356;5,9,6,25,44;33;F
83357;583,43,106,5,51,347,90,627,1411,593,919,52,435,317,707;38;F
83365;1411,820,433,898,1422,347,596,25,44,1118,53,340,1655,627,1518;33;M
83378;1654,62,1226,25,596,347,583,1430,5,587,1148,245,43,589,348;38;M
83379;435,1456,433,25,919,44;28;F
83384;820,106,435,627,317,345,5,433,9,45,6,1656,51,44,1518;33;F
83386;1485,1653,347,51,435,1518,707,317,1655,53,589,190,1148,62,5;19;F
83402;51,342,106;34;M
83423;5,6,245,43,347,25,44,344,1619,1118,106,627,317,1411,1518;43;M
83430;1430,1411;41;F
83442;52,6,898,5,1485,62,245,43,25,51,53,435,317,707,345;2;F
83453;347,25,344,1118,53,433,1430,90,52,348,820,435,627,317,707;40;F
83481;6,587,5,62,245,43,347,51,344,348,1619,627,106,1456,1411;65;M
83483;820,1518,707,5,583,43,348;35;F
83508;9,44;34;F
83510;1456,1658,344,587,1430,1657,1148,1653,90,348,340,345,820,1655,190;7;M
83521;106,1456,53,348,51,347,1422,62,5,6,44,820,435,627,317;41;F
83549;45,1657,1148,1654,43,347,344;47;M
83560;6,589,347,596,25,344,348,1118,53,820,1058,106,707,345,1518;26;F
83562;9;46;F
83566;45,1430,1148,347,919,1118,53,340,820,1518,5,433,348,344,435;52;M
83575;627,317,433,587,9,45,1430,43,347,51,52,348,1118,1058,435;20;M
83582;245,166,25,51,52,344,342,1619,820,62,45,433,587,6,1518;46;M
83593;898,1430,596,52,106,435;39;M
83602;25,51;32;F
83612;345,1411,344,52,596,347,190,589,919,106,587,245,1653,51,627;33;F
83613;44,1518;48;F
83654;822,1655,345,9,898,45,1658,583,1654,43,25,344,340,820,1518;43;M
83656;45,1658,43,348,53,340;39;F
83669;51,347,589,43,1653,6,587,1430,344,348,53,340,1058,435,317;24;M
83697;820,106,317,627,433,5,62,1430,245,43,348,51,25,822,347;45;M
83721;1658,245,342,1118,1656,53,340,707,1411,345,596,348,1655;43;F
83733;53,340,1655,820,106,627,345,1653,1657,1430,433,1658,583,190,348;37;F
83739;1656,5,433,1657,435,317,1518,43,1653,1658,1148,589,245,106,347;35;F
83742;317,1518,51,347,190,583,1456,90,25,5,9,43,44,820,435;38;M
83772;51,5,43,820,9;22;M
83776;25;24;F
83800;317,90,51,52;28;M
83810;898,52,435;47;F
83811;627,1518,1411,345;14;F
83831;9,166,25;46;M
83844;190,43,347,90,51,52,344,348,340,1655,1456,106,627,317,345;42;M
83884;433,5,43,51,344,53,820,627;28;M
83907;433,587,5,898,583,1619,1656,53,106,435,627,707,345,1518;30;M
83930;587,245,822;68;M
83951;593,898,433;39;F
83976;1058,1656,820,1456,1422,1654,583,1657,1430,1485,1518,317,435,1411,707;38;M
84018;1148,1653,344,1656,1655,106,435,317,345,190,348,340,820,627;30;M
84049;62,245,25,51,1619,1058,106,627,317;34;F
84051;1430,583,245,43,347,627,1456,1518;42;F
84063;433,587,62,348,435,317;28;F
84112;90,51,348,62,347,25,106,435,627,317,707;39;M
84129;1430,190,25,51,344,1118,53,627,583,348,820,106,435,317,707;29;F
84161;106,348,52,919,593,62,433,587,6,347,90,25,51,53,627;68;F
84164;583,245,1654,1422,44,344,348,342,53,1655,820,63,707,1411,1518;47;F
84175;1485,435,1654,348,1619,627,317,707,820,9,1118,166,43,6,5;27;M
84208;1619,1456,627,1411,1518,820,1118,342,348,344,51,25,596,43,6;30;F
84243;9,25,317,44;36;M
84257;5,9,245,44,1518;45;F
84285;596,9,25,344,347,51,348,53,190,5,820,106,435,627,317;39;M
84296;433,587,1422,596,1118,1226,1058,919;42;F
84324;589,1658,1653,1654,1657,1656,1655;47;M
84325;25,820,435;38;M
84328;1518,587,593,245;40;F
84335;1148,1653,347,344,190,1485,43,348,820,435,1411,62,106,627,433;48;M
84342;433,1148,1658,583,1654,190,1422,822,348,342,1619,1656,340,1456,1058;39;F
84359;317,53,6;35;M
84363;90,919,52,344,348,1619,820,1518,6,433,5,9,43,1430,245;42;F
84402;1657,1485,822,1411,433,587,9,25,44;39;F
84408;51,344,627,1411,1485,190,348,1148,820;49;M
84409;9,5,43,25,919,820,1518;49;M
84450;45,1430,593,583,190,1456,1058,1518,1411,62,245,1655,627,1653,433;29;F
84451;6,245,589,25,53,1456,63,106,627;29;F
84470;245,44,52,106,435,317;23;M
84480;820,51,589,43,190,1485,25,53,340,435,317,707;29;M
84497;1654;37;M
84504;90,51,344,820,1422,707,433,1658,587,593,1430,919,1226,1656,1058;22;F
84518;1653,1148,25,1058,245;46;F
84519;596,51,820,627,5,1148,190,43,317,1518,707,245,589,348,435;38;F
84521;587,5,45,593,583,245,25,166;41;F
84554;347,344,435,627;48;F
84562;25,166,190,1654,587,43,52,435,707;24;M
84571;53,583,1658,51,344,435,707;24;F
84577;1654,342,106,435,627,25,1656,53,317,707,340,51,347,245;36;M
84586;1653,820,1058;17;F
84589;344,52,1118,820,63,627,1485,45,190,51,340,106,435,317,707;37;M
84623;317,707,433,1485,25,52,348,435,245,51,53,898,1422;37;M
84624;6,90,51,1655,5,1656;47;F
84659;52,820,90,347,190,9,62,51,25,44,1118,106,627,317,1518;24;M
84663;190,1148,6,589,347,627,344,106,435,317,707;21;F
84683;5,9,245,25,44,344,1518;47;M
84687;1658,1058,919,1655,627,707,1657,1148,190,347,340,820,106,1518,345;44;M
84700;347,596,919,344,820,435,627,317,51,25,190,245,1148,1485,5;37;F
84707;348,53,106,317,1518;29;M
84719;1653,596,51,348,1656,342,344,347,1658,1657,45,53,340,627,345;37;F
84779;245,9,25,44,1118,627,1518;8;F
84787;5,43,25,166;40;F
84788;587,433,583,190,51,347,90,919,344,1226,1456,1058,245,348,820;39;F
84810;6,898,5,44,1118,53,820,106,627,317,1411,9,347,25,1518;40;F
84813;90,166,43,1422,1654,583,5,433,593,1430,245,348,342,820,1518;41;F
84825;820,627,1619,51,190,45,1430,1148,1658,245,1456,345;44;F
84859;1518,5,348,1226,1058,627,433,587,593,583,245,1422,43,919,820;48;F
84865;5,433,62,190,43,589,347,344,345,627,106,1619,53,1655,435;26;M
84873;62,106,1058,340,344,90,347,190,1653,245;74;F
84885;9,245,25,44;16;M
84890;5,433,1148,51,348,53,820,1456,106,345,627,435,347,43,245;62;F
84907;583,593,62,5,587,433,6,245,43,166,589,90,344,9,25;28;F
84915;1430,583,1118,53,9,6,44;27;M
84920;9,44,1118;52;M
84933;25,44,1118,435,1518;16;M
84938;9,898,190,166,596,44,53;31;M
84943;6,44,1118;42;F
84949;5,583,1654,245,190,1118,707;49;F
84951;9,345,44;29;M
84954;44,1118;12;F
85047;44;22;M
85050;1058,1518,1411,1655,1422,587,1657,1658,583,245,1654,1656,1456,435,345;34;M
85054;44,245,1118,820,627,1485,5,587,433,9,62,43,347,25,51;;M
85055;44,1518;32;F
85067;90,52,587,589,348,53,106,435,1411,707;32;F
85091;1653,583,53,340,245;46;M
85099;1485;35;M
85118;1422,1430,593,433,43,190,1654,583,1658,1148,5,62,45,1657,820;51;M
85147;90,43,245,45,433,587,627,1518;38;M
85168;6,1118,820,1456,707,1656,1226,919,62,587,433,593,90,53,1058;54;F
85175;435,587,1653,245,822,348,1226,1058;63;F
85178;9;30;F
85228;190,919,1456,435,317,707;28;F
85230;583,45,1485,433,898,245,1422,344,348,53,435,707;35;F
85234;5,62,345,820,1456,53,347,1518,627,1058,1226,587,919,44,344;49;F
85272;9;53;F
85273;433,1430,1657,245,1654,90,596,25,1118,340,1655;43;F
85275;44,9;41;F
85276;1118,433,5,583,6,1654,43,589,90,44,1619,53,1456,707,1411;31;M
85284;1655,1456,63,627,1518,433,5,9,1430,1657,44,820,435,317,707;26;M
85302;1430,1411;41;M
85310;1430,5,25;29;M
85318;9;17;F
85323;433,1485,898,583,1422,348,340,435;9;F
85327;342,190,822,345,820,344,347,340,348;42;M
85332;583,589,596,707,898,63;39;M
85342;44;39;M
85348;166,9,44,43,1430,1619,245,6,5,1118,587,90,433,1411,1518;40;F
85350;9;56;M
85374;345;64;F
85384;44;39;M
85386;435,1422,245,583,45,898,1485,433;;F
85404;5,9,62,1430,6,53,1456,627,317;60;F
85409;1518,5,1430;48;M
85416;822,1485,5,9,1658,1655,820,435,1518,345;31;M
85426;90,347,190,245,6,583,1430,593,5,433,348,435,1518;27;F
85445;5,43,589,25;27;F
85447;1430,1411;16;M
85467;6,44;9;F
85477;90,822,52,348,1656,1456,820,347,25,51,344,53,106,317,627;32;M
85487;6,44;7;F
85510;1485,1657,1653,348,1226,1656,106,435,707,1411,1518,627,820,1655,1118;50;M
85511;1148,6,190,589,347,51,52,344,53,340,106,435,627,317,707;21;M
85518;433,5,62,1148,43,347,51,52,342,1655,820,627,345,1657;51;F
85525;1658,43,25,51,52,245,345;60;F
85527;627,345,1518,820,53,1619,344,52,51,90,347,1422,245,6,583;42;M
85529;43;45;M
85530;45,593,1148,1653,433,587,1657,1658,583,1654,348,342,1655,1456,1058;41;F
85558;5,1422,1654,1653,1657,1658,583,347,820,627,62;41;F
85569;45,1657,1148,1658,348,1655,345;48;F
85572;348,583,45,5,1656,1655,1657,1658,1653,1654;62;M
85589;43;15;M
85590;51,43,245,45,9,5,44,627;40;F
85602;1456,106;21;F
85609;43;19;F
85617;190,6,1658,593,43,919,51,348,1118,53,820,1456,1058,627,707;42;F
85643;1657,1658,1422,25,44,1118,1656,1655,1456,707,1518,5,43,53,820;41;M
85644;6,1619,820,707,1518,245,25,9;37;F
85646;9,347,25,344,1058,317,707,5,1485,1148,190,51,820,106,627;42;F
85649;9,5,433,587,898,1430,245,1654,919,52,348,342,435,106,707;30;M
85666;707,317,1518,1148,6,347,90,51,344,9,45,43,25,5,166;40;F
85684;1411,820,53,1654,433,62,1657,583,1658,245,43,919,342,707,345;35;F
85706;347,1656,1518,106,340,51,1422,190,45,1657,1658,245,1654,25,348;46;M
85770;44,1518;34;F
85807;1518,166,25;43;F
85839;1619,344,25,822,190,1148,1485,1518,53,51,43,6,45,5,166;41;M
85892;1653;70;M
85902;627,435,190,6,1148,9,1518,53,344,51,25,166,43,45,5;9;M
85956;344,51,190,245,6,1148,1485,1518,53,25,166,43,45,9,5;9;F
85967;1456;52;F
85968;435,627,317,106,1656,593,1653,190,919,53,340,820,1148,43,51;33;F
85973;44,90,45,1485,5,9,6,43,347,820,1518,25,51,1456,627;52;F
85977;1654;14;M
85984;822;70;F
86009;433,9,1430,583,347,51,53,1456,820,627,1485,5,43,25;28;M
86029;43,1430,9,51,344,348,53,820,627,1518;40;F
86042;43,5,90,1619,6,44;35;M
86048;9,6,43,347,25,1518,44;36;F
86068;1656,317,25,1456,62,51,44,53,627,707,245,347,106,345,1518;41;F
86090;25;36;M
86093;44;29;M
86102;45,44,433;32;F
86135;433,1653,583,62,51,44;25;F
86148;25,51,6,1430,5,245,43,348,820,317,1518,9,1619,1411,627;47;F
86152;51,348,1411,25,1422,245,5,9,1430,6,596,1118,1518,820,627;50;F
86157;898,593,1518,53,1226,1619,342,348,919,25,43,1422,1654,583,44;41;F
86159;347,51,344,919,1118,820,435,317,345,1411,433,25,106,627,1518;20;F
86161;627,53,1619,348,344,589,433,822;73;M
86193;6,245,53,627,1411,9,45,1430,90,44;46;F
86222;51,53,106,435,627,1411,1058,1226,348,52,919,25,190,1430,587;43;F
86230;583,62,898,9,1485,5,433,6,347,44,435,317;16;M
86232;190,45,593,919,344,342,820,340,106,317,898,51,52,53,707;33;F
86240;1656,62,1148,1653,190;47;F
86243;1430,433,90,596,919,344,348,342,340,820,1456,435,627,317,345;33;F
86249;44,433;7;M
86259;1658,190,345;36;M
86263;1655,435,1656,1657,583,822,342,1226,820,1058,707;43;F
86271;1485,5,1654,90,344,53,340,1655,820,435,1148,1653,190,347,627;44;F
86279;245,347,51,1619,53,340,106,433,25,820,627,190,1422,43,348;33;M
86284;9,45,6,43,52,1518;24;M
86287;52,435,5,9,62,6,43,347,51,44,53,820,627,707,1518;29;F
86299;44,433;4;M
86300;1485,1657,1658,1654,1422,1619,1226,1456,1058,1411,587,583,245;44;F
86304;348;38;M
86322;44,433;2;M
86323;1148,190,347,90,51,52,344,820,106,627;18;F
86324;1148,1656;32;M
86345;62,347,51,348,1619,1656,1456,106,627,53;34;F
86359;1118,53,340,1655,435,627,317,6,45,5,1619,342,90,822,106;39;M
86370;44,433;38;M
86380;51,25,106,43,583,44;44;M
86399;51,1657,1148,245,190,43,347,820,106,627,345,1658;37;F
86424;51,627,707,53;26;F
86456;6,45,583,166;36;F
86469;5,9,6,245,190,347,25,51,1619,53,820,317,627,1411,1518;9;M
86477;583,340,820,1655,245,44;10;M
86519;52,342,1619,53,627,5,1518,9,45,6,43,596,344,1118,820;29;F
86528;44,1226,1058;25;F
86538;1118,587,245,1518;43;F
86573;90,1619,52,190,347,51,53,245,317;33;F
86574;317,9,5,43;49;M
86593;53,627,435,317,707;30;M
86622;9;32;F
86624;1619,62,53,106,435,5,43,348,347,627,245,587,596,51,820;20;M
86646;52,344,166,25,44,820,106,435,627,317,45,62,5,9,822;31;M
86649;6,1619,820,317,345,1658,433,5,62,52,340,106,90,45,587;63;F
86686;433,583,44,1656,53,106,627,707;35;M
86688;1422,51,342,1118,1226,53,1456,1058,1518,433,347,1619,820,627,1411;41;F
86697;245,43,106,1148,1657,45,5,340,820,627,345;37;M
86700;344,1118,435,317,707;31;M
86704;583,62,53,345,707,627,1518,106;39;F
86712;245,1148,593,898,5,587,822,348,342;38;F
86714;1656,5,9,1148,25,1518,627,347,51,345,62,45,1654,190,1655;68;F
86764;345,1058,1456,820,1655,340,1656,919,347,43,190,1653,245,1148,1430;45;F
86767;1422,43,166,347,344,1619,820,627,1411,1518,52,25,90,6,5;32;M
86770;1430,593,898,5,433,587,45,583,245,1654,51,344,348,63,707;37;F
86785;1430,62,9,1485,5,898,43,347,52,344,348,820,106,435,317;27;F
86795;587,5,245,820,1518;39;F
86804;90,596,43,1658,1657,62,9,5,342,1118,340,1655,820,63,106;47;M
86805;344,1226,1656,1655,1456,106,44;41;M
86820;52,919,25,347,1653,593,898,587,433,1430,583,589,1226,1058,245;32;F
86862;433,593,583,1422,44,342,627,317,1411;32;M
86894;5,1430,245,25,51,344,435,627,1518;35;F
86897;317,106,820,52,51,347,587,5,9,6,43,25,919,44,1518;35;F
86903;52,1656,317,707;45;F
86911;1655,340,348,583;39;F
86933;1430,1411;50;M
86938;587,9,593,1430,43,25,919;46;F
86942;1422,587,1518,433,1485,1430,245,919,348,820,435,707;48;M
86977;433,1658;59;F
86978;5,347,51,344,52,53,1456,106,627,90,820,245,593,1619,45;35;M
86982;344,1619,5,1148,1653,190,347,51,52,340,820,106,627,317,345;48;M
86984;345,106,348,1118,596,90,1657,1619,1518,5,6,25,1411,9,44;45;F
86994;5,43,44,25,435,344,820,245,348;52;M
86996;345,820,1655,340,1656,596,347,43,190,1653,245,583,1658,1148,1657;10;F
87000;51,245,9,6,820,5,62,43,25,44,342,1619,53,627,1518;33;F
87022;245,1657,593,5,587,433,317,45,1653,43,344,53,1655,1456,106;44;F
87045;433,62,1430,583,1422,347,25,44,1456,317,627;31;F
87048;5,45,245,820,1518;10;F
87067;344,53,820,9,587,5,43,25,44;30;F
87070;1653,593,45,62,898,245,51,53,1655,1456,345,1658,190,348,340;35;F
87071;1619,1118,820,1456,435,707,62,51,52,53,317,6,347,106,627;51;M
87075;90,245,433,587,62,593,1653,347,919,51,53,1456,1058,106,627;49;F
87087;1226,433,587,62,593,245,1653,347,919,51,53,1456,1058,106,627;71;F
87104;44;35;M
87113;340,1619,62,593,1430,1657,583,245,1653,190,25,348,1655,1058,627;48;M
87130;51,435,317,707,583,1485,1118,627,5,820,9,1148,43,25,1518;34;F
87157;344,245,898,5,9,1430,583,1654,43,166,596,25,820,1411,1518;12;M
87170;1653,627,435,190,106,51,45;20;M
87183;435,627,345,5,587,433,9,45,583,1654,43,62,1430,1411,1518;42;M
87190;342,106,627,1518,63;36;F
87207;1411,1430;22;M
87216;166;41;M
87220;90,347,190,6,5,62,1658,245,51,344,342,1656,820,106,627;35;F
87235;822,6,25,51,44,53,1518,627,820,52,344,596,5,245,43;51;M
87236;344,1656,53,340,1655,820,63,106,627,317,707,245,25,52,435;25;F
87242;1430,1658,190,25,707;67;M
87245;347,45,43,348,106,627,317;22;M
87251;166;3;F
87255;9,190,43,822,25,820;65;M
87257;342,63;34;M
87263;5,1148,1653,190,347,51,52,344,1619,340,820,106,627,317,345;15;F
87264;342,63;36;F
87266;9,44;38;M
87272;583,245,190,1422,43,347,344,53,820,1411,627,52,51,589,25;26;M
87278;166;39;F
87286;9,898,1430,583,245,1654,43,25,51,344,348,53,820,1411,1518;7;F
87310;166;8;F
87329;9,6,1118,1518,25,44;47;F
87330;1148,62,5,190,43,589,347,596,25,51,348,1656,340,820,627;65;F
87346;1411,1654,1430;46;F
87357;166;10;M
87359;44;29;M
87383;587,919,1226,1058;32;F
87385;106,435,627,587,43,347,596,52,1118,1430,1422,90,1619,1226,1058;37;M
87407;340,25,190,1430,5,589,51,435,317,1411,433,9,245,1058;21;F
87415;348,587,5,45,1657,1148,1658,190,1422,43,342,1656,340,820,345;39;M
87459;9,5,898,190,43,90,52,344,348,340,820,106,627,317,245;19;M
87491;1058,433,587,62,593,1657,1148,1658,245,1653,919,1656,1655,345,1518;39;F
87504;1658,245,345;47;F
87525;44;38;M
87539;45,25,1518;50;F
87554;245,1653,348,1226,1656,1058,106,707;36;F
87566;245,43,90,919,51,348,1619,1226,1118,53,820,1058,627,707,1518;41;F
87567;245;59;F
87571;190,245,6,1658,1148,45,62,433,1657,1653,347,340,1655,627,345;36;F
87592;25;34;F
87593;45,6,43,347,25,52,344,348,340,820,435,106,627,317,245;50;F
87595;1430,190,347,25,51,52,344,348,1118,1226,53,340,820,627,1518;34;F
87623;44;32;M
87625;190,820,6,90,919,52,345,587,1148,1653,589,348,1226,1456,1058;50;F
87632;25,44;54;M
87668;348,190,106,627,347,51,245,820;38;M
87683;25,90,62,5,9,45,1430,43,51,44,63,435,1411,707,1518;46;M
87705;9,44;43;M
87709;1485,52,820,627,51,435,317,707;37;M
87717;166,190,1654,245,1485,5,9,45,43,25,919,44,344,342,820;32;F
87734;1654,1411,587,898,1619,1226,1456,1058,317,1658,245,589,347,919,627;25;F
87735;1430,1411;43;F
87739;433,587,1657,245,589,919,52,344,348,1619,707,1518;35;F
87749;820,1226,1058,587,433,245,347,919,348,1619,1456,106,435,627,317;22;F
87750;44;32;F
87758;1518,1411,345,344,919,90,5,44,348,433,1653,1655,820,822,245;38;M
87773;344,348,342,1619,1226,53,1411,5,589,90,627,593,1430,820,1058;52;M
87774;1430,1411;46;F
87781;1619,707,5,245,190,43,347,51,52,344,348,820,106,627,317;52;F
87809;587,433,593,583,25,53,707,44;33;F
87824;1654,45,898,9,43,596,822,25,919,348,1118,53,820,106,435;49;F
87861;1422,52,5,820,1148,106,190,583,1619,90,435,317,51,627,53;39;M
87882;62,1148,190,43,342,106,63;8;F
87901;919;18;F
87914;44;44;F
87915;347,51,344,820,627;37;F
87929;1619,53,820,106,627,52,51,25,596,43,5,6,347,90,1518;57;F
87950;435,1411,62,347,51,627,919,820,106,317,6,43,25,44,1518;47;F
87958;587,898,245,919,348,342,435,317;31;F
87967;347,43,51,820,627,9,90,245,1118,1430,1619;34;F
87978;596,51,44,344,348,1118,53,820,435,1411,1518,5,9,1430,25;53;M
87993;1518,106,1456,6,62,9,5,433,245,347,51,44,53,820,627;46;F
88011;25,347,90,1148,1430,45,5,820,1619,919,43,245,6,587,1518;8;F
88019;51,344,1656,5,62,1148,583,245,190,43,342,340,820,63,106;40;F
88020;62,1148,245,166,919,25,5,587,90,344,820,1619,627,317,1518;11;M
88021;1058,106,317,435,707;36;F
88023;43,245;51;M
88024;344,1656,627,245,190,340,820,5,62,1148,583,43,342,63,106;11;M
88033;1456,52,6,45,1148,5,245,43,90,25,919,344,1619,1518,587;13;F
88041;1518;39;F
88047;344,90,52,435,345,347,25,317,627,190,51,44,348,340,106;41;M
88059;1148,1653,589,596,348,1118,340,820,1058,106,627,1411;15;M
88065;52,53,1485,5,1148,583,51,6;44;F
88081;190,347,44,25,51,52,53,106,435,589,344,348,627,317,707;27;F
88083;90,52,344,1619,820,627,707,5,6,596,25,51,44,342,1118;40;F
88089;342,190,822,345,820,344,347,340,348;32;M
88126;822;61;M
88127;53,166,1422,583,9,1430,245,43,25,51,44,348,820,627,1518;38;F
88144;62,317,707,53,5,1485,898,45,6,347,90,51,52,106,435;36;F
88146;9,43,166,347,596,25,44,52,344,1118,820,627,1518;19;M
88168;53,106,435,317,51;43;F
88178;1430,6,9,43,919,25,51,44,53,820,1058,627,1518;53;F
88186;1658,245,1422,62,347,90,51,52,348,1619,1656,53,1655,106,627;47;M
88189;433,6,245,190,347,51,53,1226,435,583,344,348,1656,1058,106;52;F
88204;898,45,1148,1658,583,1654,190,44,348,342,340,345;34;F
88219;1148,1658,583,245,1653,1654,347,348,1118,1656,340,820,1058,106,627;46;F
88223;90,1619,820,1456,106,435,627,1658,583,245,52,344,1118,345,1518;39;F
88224;53,1619,44,51,919,25,347,43,1654,6,583,62,627,345,1518;40;F
88226;1655,820,1456,106,345,45,1148,1653,1654,190,919,344,1656,317,707;46;M
88247;6,190,43,51,52,106,5,245,347,344,348,1619,820,627,707;25;F
88278;1058,820,53,1226,44,919,51,25,90,347,43,245,1485,5,587;49;F
88292;1430,1411;45;M
88298;347,1653,245,6,1658,1657,5,433,587,593,25,919,1058,627,1518;27;F
88302;627;19;F
88309;1655,340,1654,1656,90,347,1422,190,6,583,1148,1430,62,898,627;24;M
88310;5,62,1148,6,1654,53,627,587,593,190,347,348,340,345,1058;39;F
88315;6,245,90,1456,707,44,1518;35;F
88337;820,593,345,433,45,1430,1657,1148,1658,583,1653,1654,190,348,340;40;M
88342;5,9,1148,1658,190,43,347,25,51,53,820,106,435,627,317;31;F
88343;340,63,317,707,1430,583,43,347,25,919,348,53,820,106,627;41;F
88378;43,51,820,106,435,1518;30;F
88383;190,1518,347,245,1148,898,587,62,593,1226,53,1058,106,627,345;46;M
88396;44;42;F
88404;25,589,43,593,433,1430,1658,583,245,348,1226,340,820,1058,707;24;M
88405;5,1430,1148,6,245,1422,43,51,344,348,1118,820,1518;25;F
88415;245;49;F
88425;5,9,45,583,6,1422,43,347,90,25,51,820,1456,627,1518;67;F
88433;190;46;M
88437;43,1619,433,45,1148,1654,190,51,344,1656,340,1655,820,106,345;42;M
88440;190,583,1658,1148,433,345;36;M
88455;1518;42;F
88457;1654,190,1422,166,52,348,342,53,340,820,63,345,1411,1148,43;41;M
88474;5,9,43,25,44,1118,317,1411;23;M
88475;9,43,25,51,53,820,106,1518,317,627,1656,1653,1658,1657,1654;40;M
88476;44;12;F
88505;53,317,5,245,190,43,347,51,344,348,1619,820,106,627,707;74;F
88512;1654,90,5,6,820,347,53,62,51,52,106,435,627,317,707;32;M
88523;5,1653,43,90,820,106,627,593,347,51,52,344,435,317,707;42;F
88528;1118,1655,820,1456,1058,627,707,1411,1518,433,587,9,245,822,53;29;F
88531;348,340,1658,1654,53,345;39;F
88535;44;11;M
88555;44;43;F
88559;347,90,596,52,1619,1118,53,9,5,43,25,344,820,627,1518;44;F
88563;90,822,348,53,820,317,1411,9,51,44,627;44;F
88575;43,433,45,1148,1654,190,1619,51,344,1656,340,1655,820,106,345;5;F
88579;25,596,347,53,1456,1518;44;F
88592;53,5,51;67;F
88622;5,1485,898,6,90,51,52,53,435,707;42;M
88623;822;56;F
88625;6,245,90,44,1456,707,1518;35;M
88646;106,345,342,1118,820,1456;39;F
88688;587,627,1118,51,25,596,820,1456,1058,1518;45;F
88695;52,106,435,627,317,1518,707;55;M
88718;43,433,45,1148,1654,190,51,344,1619,1656,340,1655,820,106,345;4;M
88723;5,6,43,347,51,44,1656,820,106,627;74;M
88724;1654,43,347,51,344,1619,1655,45,6,190,340,820,707,348,245;34;F
88725;9,62,583,166,347,90,822,51,44,53,820,106,707,345,1518;4;M
88727;1430,1518;43;F
88730;51,1619,348,53,106,1456,63,317,627,707,25,1422,9,1411,1518;40;M
88734;245,583,45,587,433,5,62,52,344,342,820,63,106,317,707;33;F
88741;5,1485,898,6,90,51,52,53,435,707;41;F
88758;433,1518,43,1430,44,1118,1411,245,9,6,90,1619,5,25,166;35;F
88759;1653,90,342,1619,627,9,245,43,347,25,44,1118,820,1518;43;F
88771;1456,9,1148,596,51,435,345,43,190,347,52,348,1118,106,627;30;M
88775;348,53,340,345;24;M
88777;5,62,6,1654,347,90,51,52,53,820,106,435,627,317,707;31;F
88789;51,25,347,43,245,6,5,1411,820;51;F
88793;587,433,5,1485,898,6,90,51,52,53,435,707;12;M
88795;43,25,51,1619,1118,820,1456,627,1518;8;M
88804;1430,1518;12;F
88816;51,820,9,6,44,627;46;F
88823;5,62,6,1654,347,90,51,52,53,820,106,435,627,317,707;2;M
88830;435,1411,627,106,90,347,1422,1658,5,342,820,317,707;39;F
88839;822;20;F
88843;589,347,627,245,583,1658,1148,5,587,433,1653,342,340,1655,345;30;F
88849;433,1430,583,245,317,344,1518;30;M
88859;43,1430,9;47;M
88861;1430,1518;6;F
88865;5,62,6,1654,347,90,51,52,53,820,106,435,627,317,707;4;F
88868;433,5,1485,898,6,90,51,52,53,435,707;10;M
88882;1518;38;M
88892;583,1226,1058,1430,190,348,53,627,317,62,6,347,25,1456,106;39;F
88903;317,1657,1148,1658,1656,820,627,45,6,245,190,347,51,340,106;49;F
88922;5,898,1657,1658,1619,1456,245,347,90,51,342,340,820,627,345;40;F
88925;62,1654,43,596,51,344,348,342,1656,53,820,1456,63,106,707;37;M
88929;433,5,1485,898,6,90,51,52,53,435,707;4;F
88945;1118,342,344,51,245,1148,587,5,593,583,43,596,589,919,627;60;F
88950;245,44;43;M
88970;51,44,53,317;36;M
88979;1411,587,25,707,5,1430,245,1518;51;M
88980;345,707,317,820,1658,245,1653,190,347,919,51,1619,53,106,627;49;F
88982;5,898,1657,1658,245,347,90,51,342,1619,340,820,1456,627,345;43;M
88984;340,344,45,9,5,43,347,25,52,51,53,106,627,317,707;47;M
89013;433,45,245,1653,190,589,342,340,345;44;F
89014;44,348,53,583,589,25;35;F
89025;9,62,45,593,1657,245,1653,43,589,347,596,822,342,627;40;F
89030;317,627,106,1058,1656,1226,1619,348,44,51,25,347,583,593,1518;42;M
89046;1485,583,51,344,348,53,106,317,52;31;F
89050;5,1148,245,1653,190,43,347,90,51,820,106,435,627,317,345;31;M
89058;90,190,1654,245,45,587,62,583,43,344,342,106,63,627,707;5;F
89081;433,43,347,51,44,1656,820,106,627;74;F
89083;348,344,52,51,347,1422,583,45,62,5,1657,1653,1654,43,345;49;F
89088;1657,43,344,820,627,317,53,25;38;M
89092;317,627,348,44,25,583,9;44;F
89103;5,9,45,583,6,1422,43,347,90,25,51,820,1456,627,1518;67;F
89113;587,62,583,1654,190,43,344,342,53,820,1456,63,106,627,707;2;M
89135;5,1148,190,43,344,820,345;47;F
89141;25;48;F
89145;340,5,1148,1485,45,1658,1654,53,1655,820,106,435,345,583,317;36;M
89158;347,51,344,820,707;26;F
89166;25,820,63,627,245,43,347,348;49;F
89168;5,6,1422,820,348,1430,627,51,587,347,344,317,106,52,435;35;F
89174;25;54;F
89233;317,587,5,1148,190,43,347,596,51,348,1058,106,593,245,1653;51;F
89241;5,45,589,342,1619,820,63,106;35;M
89246;5,9,45,583,6,1422,43,347,90,25,51,820,1456,627,1518;70;M
89251;45,589,51,342,1456,1058,707,5,9,245,43,347,919,820,627;40;F
89254;1518,53,317,5,820,106,44,1656,25,90,43,245,6,1657,9;47;F
89280;190,90,25,820;48;M
89355;5,9,45,583,6,1422,43,347,90,25,51,820,1456,627,1518;58;F
89356;45,25,820;36;M
89361;347,5,1657,245,190,51,52,344,1619,340,820,106,627,1658;44;M
89389;245,1148,583,25,919,51,820,627,317,5,45,43,44,348,342;37;F
89396;348,1226,1456,1430,583,245,344,1118,63,345;45;F
89405;344,53,9,43,347,51,52,44,820,106,317,627;43;F
89411;25,9,593,1430,1653,1654,43,90,344,1118,1226,53,627,345,1518;11;F
89421;45,1658,627,345;46;F
89425;25,919,51,44,820,1456,1058,627,345,1518,1619,53,106,1430,90;30;F
89436;433;53;F
89442;1657,245,25,348;39;M
89453;190,347,919,1619,1656,820,106,90,53,435,627,51,52,317,707;32;M
89465;5,9,45,583,6,1422,43,347,90,25,51,820,1456,627,1518;85;F
89466;45,583,166,25;43;F
89473;1657,587,433,1148,1658,583,190,589,347,348,342,627,707,345,1518;35;M
89486;433,317,1518,106,627,707,345,347,43,583,587,45,593,245,44;40;F
89512;344,707,627,106,820,340,1656,1619,52,51,90,190,1653,1148,587;37;F
89516;62,1658,347,51,1619,53,106,627,317;46;M
89521;5,9,45,583,6,1422,43,347,90,25,51,820,1456,627,1518;92;M
89525;245;44;F
89543;1619,1411,43;35;F
89556;344,106,317,627,433,1430,6,190,43,347,90,51,342,340,820;33;M
89558;43,1619,1411;9;M
89580;43,1619,1411;6;F
89587;43,1619,1411;3;F
89595;25,583,43,90;46;M
89643;62,587,433,593,1653,1654,43,25,344,1118,1226,1656,820,1058,627;44;F
89659;43,166,433,587,5,9,6,245,90,25,919,44,342,1619,1411;71;F
89676;344,1656,1456,106,433,898,1148,583,1653,1654,43,348,1118,340,820;42;F
89687;433,9,44,435,317;28;F
89710;44,1118,51,6,90,348,345,317,53,347,344,1656,106,627,1518;45;F
89711;52,5,1148,6,245,1653,190,43,347,90,919,51,1619,106,627;68;M
89714;245,1148,898,5,1422,347,52,53,1456,106,435,627,317,1518,6;46;M
89730;44;45;F
89732;62,6,245,1422,347,51,44,348,53,820,106,627,317;51;F
89736;1485,245,53,820,707,345,6,347,90,51,344,106,435,627,317;46;F
89787;820,62,25,53,106,317,5,6,43,51,344,348,347,90,627;36;M
89821;587,5,1148,25,919,1619,45,593,1430,245,43,344,820,1411,1518;46;F
89822;587,593,1148,190,919,348,1118,53,820,435,345;38;F
89836;1456,25,43,1430,587,1619,106,707,627,433,342,1518,245,898,53;41;F
89839;5,433,9,45,6,245,1619,1058,919,820;51;F
89840;90,596,51,344,348,53,627,345,1658,1654,1656,1655;42;M
89845;1118,345,43,347,1653,190,90,1619,820,106,435,627,1148,344,348;46;M
89863;1422,1430,245,820,435,317;57;M
89873;345,45,589,347,348,340,820;35;M
89900;6,1422,166,106,9,1430,245,25,44,348,1619,820,627,317,1518;16;M
89901;1619,627,317,45,53;48;M
89905;593,1430,348,820,1456,627,435;46;F
89915;707,317,90,106,820,1658,62,5,1657,347,51,342,1655,627,345;39;F
89918;344,106,317,707,587,5,1485,1148,6,245,43,51,348,820,435;28;F
89927;62,1653,1422,43,1058,45,593,1430,1654,190,90,348,1148,1658,1226;40;M
89970;1148,820,583;34;M
89979;317,5,593,51,53,707,435;48;F
89991;5,9,25,820;20;M
90012;1619,919,166,1430,433,5,9,6,245,43,90,25,44,348,342;71;M
90061;45,1430,1619,1411,1518;9;M
90074;245,433,342,1411,345,1518;33;F
90113;1411,52,820,435,1518;52;F
90126;587,1430,1118,433,1411,1518;34;M
90175;63,340,1656,44,43,1422,1654,1653,1658,1657,245,190,1148,344,1655;35;F
90187;1430,583,245,1422,53,106,435,317,707;14;F
90198;5,1430,6,190,51,52,106,435,627,317,589,596,90,347,245;43;F
90209;1654,43,347,25,1619,627,5,9,45,245,51,344,53,820,1518;37;F
90245;593,583,6,347,344,53,90,1456,317,627,106,51;15;F
90272;5,593,25,51,435,317,707;11;F
90274;5,9,43,25,51,44,1518,820;30;F
90277;435,51;11;F
90278;317,5,9,6,347,822,25,51,44,348,1118,53,820,627,1518;23;M
90288;190,245,6,583,1148,898,347,90,51,53,106,435,627,317,707;31;M
90290;707,1456,1655,1619,44,90,245,433,62,45,1430,1658,1654,166,1518;49;F
90304;347,596,344,342,106,627,1658,190,43,51,1118;46;M
90314;1422,589,347,90,596,51,344,348,1118,1656,53,1655,820,106,627;54;F
90340;1411,433,1518;6;M
90371;627,345,1654,6,1148,587,433,245,347,919,340,1655,820,1058,1518;45;F
90394;106,627,433,245;34;F
90396;245;35;M
90414;433,587,1430,1118,1411,1518;4;M
90424;317,5,1485,898,6,90,52,53,435,707;37;M
90432;1518,245,44,53,1456;33;M
90438;820,1656,1118,348,344,919,596,589,43,245,1430,5,593,1148,190;23;F
90456;820,919,1148,593,45,1619,344,25,90,43,245,587,5,1411,1518;43;M
90464;433,593,1430,1422,43,822,919,820,1456;34;F
90482;90,627,317,587,245,166,919,1118,53,1411,5,9,25,44,1518;38;M
90486;433,5,1485,898,6,90,51,52,53,435,707;33;F
90530;106,593,589,345,1657,587,1658,245,190,1653,51,1226,820,1058,627;40;F
90554;245;2;F
90562;707,43,6,1654,433,245,435,589,596,919,51,1118,1656,340,820;17;F
90572;707,340,820,106,245,43;37;M
90579;348,1485,627,245,51,52,435,317;29;F
90593;820,43,1653,587,433,919,1148;40;F
90600;245,593,898,9,1485,1430,1148,6,43,596,348,1118,1656,820,627;25;M
90620;1430,43,589,919,44,52,820,1058,627,9,25,1656,53;47;F
90623;166,1619,245,90,1430,5,9,6,25,44,1118,1518;38;M
90645;1654,43,347,596,52,344,348,1118,340;39;M
90658;53,1456,1058,106,317,627,707,1518,587,62,583,6,1422,919,345;47;F
90670;1658,43,347,51,820,106,627,583,1654,190,348,340,345;37;M
90703;317,435;30;M
90712;44,25,1118;42;M
90716;25,44,1118;12;M
90719;25,44,1118;8;F
90742;44,348,1619,1226,820,1456,1058,707,1518,1411,1118,919,587,433,344;40;F
90782;1653,1422,43,347,90,822,51,1655,317,348,53,820,106,1518,627;40;F
90805;348,1148;44;M
90811;245,1653,51,1656;47;F
90816;44,9,593,348,1456,106,627;42;F
90825;587,9,347,90,52,106;46;F
90829;166;44;F
90834;820,347,190,245,9,5,1430,25,348,106,627,317,1411,1518;37;F
90839;1118,348,52,25,596,1653,345,344;45;M
90841;5,1485,6,348,53;32;M
90842;583,51;26;M
90855;25,166;47;M
90857;1411,348,1058,587,593,245,43,596,822,344,342,1118,1226,1456,627;42;F
90860;62,5,45,1430,583,245,43,347,25,919,63,435,317,707,1518;40;F
90863;1518;38;F
90866;1148,245,1654,347,25,348,820,106,627,317;42;F
90878;583,245,1654,347,90,25,919,52,344,53,820,435,627,317,707;10;M
90880;1619;34;M
90882;51,45,898,435,317,707;42;F
90883;435,53,52,51,25,43,190,245,6,1148,62,9,1485,45,5;44;M
90884;1148,90,596,919,51,344,342,1619,1118,106,587,583,347,1456,627;69;F
90890;44;39;F
90923;9,342,1118,820,106,627,90,45,43,25,44;39;F
90949;1518;39;F
90960;317,627,340,1430,593,587,433,1658,190,51,348,1226,53,1058,345;36;F
90967;1518;40;M
90978;245,43,596,822,348;39;F
90982;1518;9;M
90988;51,52,1118,1656,53,340,106,435,820,1456,627,433,1148,1658,1422;40;F
90991;1518,44;45;M
90998;9,348;37;F
91006;587,593,6,43,90,44,344,53,1058,627,1518;39;F
91032;1518;6;M
91036;589,435,317,344,1118,627,345,190,1148,348,820,106;28;M
91048;44;34;M
91073;342,1619,1656,53,1456,627,1518,9,6,1422,919,348,707,1411,44;37;F
91119;317,106,820,53,44,51,347,9,52,627,435;29;F
91138;1619,53,820,106,435,627,317,1518,62,433,1148,6,1653,190,340;29;M
91156;43,1422,6,1430,593,45,5,587,919,1518;44;F
91159;347,90,25,51,52,344,106,435,627,317,707;45;F
91166;820,1058,1518,245,166,25;58;M
91169;1148,820,345,1658,342;31;M
91171;1518;36;F
91173;587,1485,583,43,347,5,433,9,25,919,344,1655,820,435,627;39;F
91197;898,1485,5,433,587,9,245,589,25,919,51,1226,820,627,317;37;F
91200;62,820,106,9,6,43,347,51,25,1656,53,435,627,317,245;49;F
91203;1485,707,62,1656,53,1657,1658,583,589,90,596,51,627,345,820;26;F
91207;9;57;F
91234;583,245,190,43,589,347,919,348,1118,1655,820,1058,106,435,345;44;F
91238;9,345,1654,1658,5,45,245,190,43,52,344,1656,340,1655,820;43;F
91257;53,1518;43;F
91284;820,1058,1518,245,166,25;48;F
91285;5,6,245,1619,106,627,317;38;M
91317;190,53,1655,627;37;M
91344;9,5,166,90,25;30;M
91410;898,1148,1658,245,1654,190,1422,51,627,345;41;M
91411;1148,245,190,1656,1655,433,1518,1657,1658,345;39;F
91424;52,820,435,627,317,9,62,43,596,51,44,344,1118;32;F
91426;435,627,317,25,44,348,1518;51;M
91444;43,25,51,44,52,348,1456,627,1518,433,9,6,822,344,820;63;M
91488;1430,6,1422,90,52,1118,53,1456,317,627,345,596,25,51,44;54;M
91507;820,190,245,1485,348,44;48;F
91522;1148,1658,245,1654,190,919,51,1619,340,820,106,627,317,345;41;F
91528;1518,587,90,344,51,348,5,1430,6,245,43,25,52,820,1456;42;F
91536;583,245,51,44;36;M
91641;587,9,25;33;M
91651;5,6,245,52,53,43,90,596,344,820,1118,9,25,44,1518;26;M
91666;62,433,587,593,1657,589,347,90,919,1226,1655,1058,345,1518,1411;41;F
91675;9,1485,5,587,433,245,166,919,342,1619,627,1411,1518;10;F
91686;52;30;F
91690;190,43,25,340,106,435,627,245,44;25;M
91710;627,106,53,52,51,25,347,589,6,62,433,348,1456,1411;27;M
91760;1430,1658,1653,919,1619,1226,1656,1485,1654,43,347,51,106;34;F
91769;1430,347,348,340,1456,1058,106,45,1655,190,627,596,583,245,433;41;F
91779;245,1653,1518,90,342,106,627,707,1658,43,596,340,1655,820,345;48;F
91787;9,62,245,1656,53,340,1655;41;F
91789;45,1657,1148,1658,1654,190,53,340,1655,820,627,345,245;36;F
91793;62,589,627,707,1485,587,348,106;45;F
91809;5,25,51,348,820;33;M
91841;1148,820;37;M
91874;593,45,898,1485,587,433,62,583,1422,344,342,340,1456,63,345;38;F
91878;344,707,1518,245,6;45;F
91890;45,43,347,822,51,52,9,5,90,166,25;37;M
91893;596,1518;52;M
91921;44;41;F
91927;245,1653,51,53,1655,106,627,317,1411,345,1518,433,587,44,340;39;M
91929;1148,190,820,345;32;F
91949;627,1654,5,9,43,820,1518;50;M
91977;9,6;27;F
91980;1653,190,1148,51,25,245,45;46;F
92046;1485,62,1658,919,51,106;36;F
92059;919,53,627,1518;37;F
92063;1058,51,25,596,347,6,593,340,820,627,43,190,245,1148,348;34;F
92074;5,1485,245,1619,43,25,820,190,348,106,589,342,90,596,627;70;M
92089;43,707,433,593,583,1422,25,348,342,1518;37;F
92092;245,25,820,1518;56;F
92097;433,587,583,1654,25,919,1226,1656,53,1058,627,707;30;F
92137;62,587,1658,6,245,348,1226,1058;42;F
92144;1518,245;40;F
92155;6,190;35;F
92182;190,25,340,627,5,347,51,52,344,53,820,106,435,317,707;31;F
92193;627,106,53,1656,344,90,6,1657,45,5,245,347,348,1619,1655;44;F
92222;9,1118,1518,820,5,25;53;M
92227;245,44,1430;19;F
92260;1148,52,344,1456,106,627,707,245;36;F
92283;1148;48;F
92289;51,1619,53,1456,707,317,345,1518,1653,1430,348,820,106,627,587;45;F
92292;43,166,347,90,596,435,106,63,1456,340,53,1656,1619,342,44;33;M
92301;5,1485,245,1619,43,627,25,190,820,348,106,589,342,90,596;67;F
92305;106,587;51;M
92307;1658,435,348,1654,45,1430,9,5,6,90,1118,1619,25,1411,44;39;M
92320;25,90,166,5,9;33;F
92321;1655,51,1148,347,25,52,820;66;F
92322;44,5,9,43,347;43;F
92332;433,1653,190,1422,43,589,90,596,25,919,52,348,1118,435,1411;34;M
92344;433,25,1118;18;F
92403;25,9,44;47;F
92406;820,348,44,596,43,190,245,1148,1485,5;21;M
92416;25,44;32;M
92467;1148,347,627,820,1655,1653,190,433;67;M
92470;5,1485,245,1619,43,627,25,190,820,348,106,589,342,90,596;42;M
92483;1118,707,348,53,25,9,6,820,344,51,596,43,1148,5;28;M
92486;1485,5,6,245,347,51,52,344,342,53,820,106,627,317,1518;35;F
92494;62,9,433,596,25,51,44,348,1118;33;F
92502;44;20;M
92512;1653,43,596,51,348,1118,53,820,1456,1518;59;F
92517;43,9,44;47;M
92527;919,435,1485,1456,245;53;M
92532;344,348,627,1518,5,9,62,1430,583,6,245,347,90,25,51;9;M
92540;44;17;F
92578;44;49;M
92581;347,344,1655,435,317,1411,627,53,166,25,51,1518;49;M
92619;90,52,627,1518;22;F
92675;25,1430,627,1658,44,52,348,342,1456,1058,707,433,45,245,1422;31;F
92691;1430,1654,190,347,25,348,340,345,1518;33;M
92694;25,6,583,245,43,347,919,51,52,344,1118,627,9,44,820;38;F
92703;1619,52,342,63,345,583,344,1656,53,1456,1058,627,435,317,707;30;F
92707;245,44,53,106,1518,1058,62,583,6,1422,347,627,317,707,345;14;F
92708;345,627,820,344,52,347,190,1148,9,5,51,340,1655,245;36;M
92719;1655,707,587,245,1619,45,593,52,344,53,820,1456,317,90,433;33;F
92720;5,45,1430,245,43,90,25,919,1118,1411,6,1518,583,9,433;31;F
92723;919,1226,898,1148,245,190,43,90,596,52,348,1118,340,820,345;51;F
92796;587,593,25,919,44,1518;43;F
92804;587,433,45,593,245,1654,25,348,53,1456,627,707,1518;42;F
92809;62,25,44,52,820,627,106,1456,1619,344,51,919,347,6,317;43;F
92837;190,1118,1619,340,1058,1226,317,345,627,106,820,347,90,51,348;30;M
92884;435,106,820,53,342,51,25,90,347,1654,6,45,9,43,44;39;M
92902;587,1422,1518,345,317,707,627,106,1058,53,347,245,6,583,62;72;F
92906;25,90,9,43,433,5,45,166,1619,820,6,1118,1430,245,1518;41;M
92912;51,348,898,433,9,45,1657,245,1118,1619,1430,1411,5,43,44;8;F
92926;1658,245,43,347,44,340,190,25,51,348,106,435,627,317,345;42;M
92961;587,245,1619,347,106,627,317;48;F
92966;820,344,340,822;58;M
92981;1655,245,1658,587,45,1657,1148,1653,345;42;M
93006;627,317,245,9,25;28;M
93020;1657,1148,583,1658,1653,190,51,348,53,340,1655,1456,345;33;F
93025;317,245,9,25;28;F
93036;1518;8;F
93037;62,1658,245,1422,347,90,25,344,340,820,106,583,348,345;33;F
93068;1118,51,43,348,583,596,62,627,1430,25,245,433,166,1518,587;46;M
93072;587,5,1430,6,245,43,166,90,25,344,348,1619,1118,1411,1518;45;M
93087;820,317,435,433,62,583,347,90,51,52,344,53,106,1411,707;29;F
93144;45,347,245,1658,1148,62,587,593,1653,190,43,919,342,1226,1655;43;F
93158;340,1518,317,106,347,1148,898,1485,587,43,90,919,1118,1226,627;46;M
93159;1430,583,53,627,1518;6;F
93179;1518,25;44;M
93185;1656,1118,340,820,106,627,583,245,51,25,44,348,435,317,1411;31;M
93194;43,1456,435,317,707;41;F
93236;1430,583,1422,919,344,348,342,1118,53,1456,1411,1518;4;F
93240;347,6,1430,593,433,587,245,51,348,106,627;50;F
93244;52,344,1656,1226,348,919,707,433,587,62,190,1422,593,820,106;33;F
93249;51,90,43,1430,1485,5,347,25,348,53,820,106,435,627,317;12;M
93255;51,596,1653,45,245,1654,347,90,348,345,1657,1148,1658,190,25;44;M
93286;1430,1619,1411;5;F
93327;596,1653,90,707,317,627,63,1656,51,62,1657,347,53,1456,106;44;F
93338;45,433,1654;42;M
93348;5,898,593,1658,6,90,51,52,53,435,627,317,707;35;M
93361;898,1485,1430,1148,1658,1654,348,1226,587,593,245,919,1655,1058,435;18;F
93376;1118,1456,1411,1485,1657,1653,1422,1619,1655,1518,1654,1656,106,627,707;33;F
93379;348,345,106,596,347,433,1655,627,190,245,1653,1058,90,1658,593;30;F
93409;5,1430,583,1422,347,90,344,52,627,51,348,106,435,317,707;34;F
93423;62,1653,347,90,51,53,106,627;52;F
93446;707,1655,45,6,245;49;F
93449;627,820,6;45;M
93450;43,90,51,44,52,820;39;F
93459;44;41;M
93462;1653,190,90,1656,1456,707,63,1430,1148,593,583,45,433,587,43;51;F
93472;919,44,820,106,435,627,345,433,587,45,52,344,348,317,707;37;F
93503;433,45,593,43,589,596,25,51,52,344,348,1118,820;24;F
93508;5,1148,347,627,106,245,345;50;F
93518;587,62,1148,6,919,43,90,51,1656,53,106,627,317,190,347;28;F
93527;1456,317,433,5,62,1430,43,347,25,1411,627,51,44,820,106;26;M
93535;1654,43,347,25,51,52,344,1656,53,820,627,317,707,583,245;33;F
93542;433,347,90,52,344,348,1118,1656,820,106,627,345,1148,190,1422;39;F
93591;1422,1654,245,583,1430,45,1485,587,43,51,53,1456,627,1411,1518;64;F
93593;583,1518;9;M
93594;820,1456,435,627,1518,90,1619,1411,1118,5,9,1430,6,43,44;6;F
93599;5,166,25,9;27;F
93602;1430,435,898,1422,6;29;F
93621;820,106,9,43,25,627,317;46;F
93634;583,6,51,52,344,342,53,1655,106,435,317,345;32;F
93650;245,627,106,820,348,344,51,90,347,1653,1148,190,1656,53;40;M
93684;1430,1654,1422,25,919,44,340,63,1518;43;M
93686;106,627,1148,583,347,51,344,1653,62,593,63,707,1456,587,43;46;M
93687;245,166,1430,1619,1411;74;M
93696;340,898,62,45,1658,627,1518,245,43,347,25,51,1656,820,106;49;F
93706;1658,43,347,106,317;29;M
93710;245,166,1430,1619,1411;71;F
93723;1411;23;F
93732;344,51,596,90,166,43,6,1485,5,9,1148,245,190,25,820;45;F
93755;5,9,45,245,1422,43,25,919,44,820;39;M
93756;5,190,43,90,822,919,52,344,1619,820,1058,627,707,51,435;40;F
93781;919,44,342,53;35;F
93833;1148,587,433,1430,106;47;F
93842;53,587,90,245,1657,1058,596,340,51,190,347,627,583,1619,433;38;F
93863;190,6,1148,5,90,52,344,53,820,347,1058,587,51,106,627;55;F
93885;596,1653,62,1657,347,90,51,1118,1656,53,1456,106,627,317,1518;15;F
93892;1658,45,245,190,340,820,627,345;39;M
93896;5,45,1653,43,25,1656,53,106,627,587,583,1518;41;M
93919;6,51,435,25,5,245,43,347,822,919,820,63,106,627,317;59;F
93936;1411,435,820,190,1148,898,5;27;F
93973;1653,1654,347,1656,340,627,345,435,820,1655,344,190,1148,1657,1485;25;M
93978;9,5,166,25;35;M
94045;1485,5,45,1430,1148,245,51,344,53,106,627,317,707,1411,1518;31;F
94050;1430,593,43,347,25,51,52,344,348,1619,1118,53,627,707,317;45;M
94059;43;47;F
94061;190,6,62,347,90,51,1619,1656,106,317,627;17;F
94096;1619,45,51,348,44,1518,347,433,587,90,52,245,166,1430,1411;43;M
94100;62,1657,6,589,596,25,51,344,1118,820,1518,348;46;M
94126;1657;37;M
94140;593,317,1226,25,44,348,1456,1411,707;54;F
94161;1148,25,190,348;52;F
94169;1654,347,52,344,1656,106,627,317;33;F
94182;1058;60;F
94185;245,1148,25,435,106,1485,52,317,1619,51,53,6,5,627,898;38;F
94227;5,52,348,820,1456,106,435,317;39;F
94233;433,587,593,1148,190,43,347,90,51,344,1226,820,1058,627;62;F
94254;919,106,435,627,317,190,347,348,1226,1058;31;F
94258;433,245,344,106,435,317;32;F
94261;90,596,25,919,52,1118,1656,1456,435,627,5,43,344,348,820;24;M
94271;587,43,596,919,344,1118,1226,1656,820,1058,106,345,5,245;33;F
94289;1430,433,6,90,596,25,52,344,348,1118,53,106,627,707,1411;20;F
94319;53,348,344,44,822,1654,583,1658,5,9,90,51,342,166,25;27;F
94347;1422,589,347,627,1058,53,342,5,9,6,25,44,1118,1518;33;F
94348;44,340,5,1148,6,90,919,53,1656,62,347,51,106,627,317;57;F
94380;587,245,43,90,25,52,348,1118,53,820,106,317,707;43;F
94401;583,43,90,51,52,344,1656,53,340,1655,820,106,435,627,317;39;M
94415;44;72;F
94416;1456,90,1485,45,1148,583,245,1653,347,51,348,340,820,106,627;67;F
94417;587,5,190,43,90,919,51,52,344,1619,820,1058,627,435,707;14;F
94433;1485,587,433,5,1148,6,1653,190,347,51,348,340,820,435,106;41;M
94463;347,51,53,820,435,627,317,707;34;M
94468;433,5,1430,1658,43,589,347,25,348,1118,53,820,1518;47;M
94506;820,1058,433,587,593,1430,245,1654,90,596,25,919,627,1518,1118;43;F
94509;9,166,596,25,1118,820;18;M
94511;587,1619,245,1518;31;M
94513;433,1656,53,1456,63,106,627,317,345,52,583,1118,1430,1411,1619;42;M
94516;1518;57;F
94532;166,9,25,106,627,317;29;F
94537;5,45,245,43,25,53,820,1518;40;F
94543;44;33;F
94553;820,51,25,43,6,5,9;45;M
94564;347,919,51,348,1619,1226,53,820,1456,1058,106,627,317,166,25;41;F
94570;43,90,1658,1657,1656,1655,1654,1653;39;M
94623;1653,627,587,1148,347,1658,190,345;58;F
94659;106,9,1485,5,53,820,1456,435,627,317,43;44;M
94676;5,43,1430,1148,347,51,52,106,627,587,593,245,1653,1456,345;60;F
94736;433,587,90,919,344,348,340,106,627,1658,1657,1656,1655,1654,1653;39;F
94757;433;37;F
94759;583,348,1226,1456,433,587,593,1422,43,589,166,1430,1619,1411,245;37;F
94808;5,593,1430,1148,43,822,919,52,348,1118,53,340,820,627,435;48;F
94836;1148,53,62,245,433,51,348,1456,627,317,707,52,25,90,596;38;F
94888;9,1654,25,51,44,344,1656,53,820,106,435,627,317;33;F
94891;1658,245,340,820;39;M
94895;245,5,1658,1653,919,348,53,627,707,1518,1656;32;F
94922;587,5,1422,43,90,919,51,52,344,1619,820,1058,435,627,707;38;M
94932;1658,583,245,190,25,340;38;M
94975;433;29;F
95061;1118,53,707,433,9,45,1430,583,245,43,44,820,435,317,1518;29;F
95074;25,63,44,1518,6,1654,1456,707,433,587,583,589,43,596,627;39;F
95106;1148,898,6,245,1518;33;F
95113;45,1657,1148,190,347,51,1656,1658,1653,340,1655,820,627,345,1518;37;M
95140;5,593,1430,583,1411,345,627,1058,342,245;32;F
95164;593,1430,583,1654,90,25,919,51,52,344,820,106,627,317,707;9;M
95169;348,820,340,190,106,627;45;F
95208;45,90,106,5,583,245,919,348,1656,820;37;F
95218;62,5,43,25,1456,627;40;F
95219;1658,62,347,596,1655,63,627,1485,898,1430,25,1118,820,106,340;28;M
95226;1655,1656,62,433,1657,1658;52;M
95243;53,342,1656,106,1411,51,347,190,245,344,1619,340,345,1653;34;F
95245;1657,62,347,53,340,51,1658,45,1148,190,1655,820,106,627,345;35;F
95254;1658,62,433,45,90,596,919,51,344,1619,1118,820,106,1518;18;F
95311;583,589,6,190,43,90,51,52,348,53,820,106,627,317,347;32;M
95354;9,43,90,52,344,53,820,345,62,1654,347,51,106,627,317;32;M
95386;1148,919,45,6,245,43,51;36;F
95451;433,347,44,1058,707,1518;38;F
95465;820,245,340,1658;39;F
95470;25,1518;51;F
95506;583,45,62,1654,347,1656,53,340,106,627,345,1411,51,190,245;37;M
95539;587,5,9,1430,6,1654,25,51,52,344,342,53,820,435,627;61;F
95544;433,62,1518,1657,45,1658,245;41;F
95561;1422,245,583,433,45,1430,53,1058,5,9,6,25,44,1118,1518;44;M
95579;348,1118,433,9,1430,583,245,1422,589,596,25,919,1226,435,44;19;F
95609;62,45,1657,1148,1658,190,347,51,53,340,1655,820,106,627,345;1;F
95652;583,340,44,1422,190,347,25,344,627,106,317,51,52,435,707;34;F
95666;342,53,106,317,1657,1658,245,90,344,1656,340,1655,820,627,345;33;F
95676;25,166;40;F
95692;62,45,1657,1148,1658,190,347,51,53,340,1655,820,106,627,345;6;F
95726;190,340,820,1456,1658,245;43;M
95728;43,1656,106;27;F
95745;1411,1619,44;36;M
95746;1430,583,589,347,90,919,52,344,348,342,106,435,627,317,707;34;M
95755;433,5,62,1430,245,589,347,90,344,348,342,1118,53,1655,820;25;M
95758;587,5,62,1430,1657,1148,1658,6,190,43,348,106,627,45,593;38;F
95762;1148,820,1058,317,707,1653,1430,587,433,9,25,44,348,627,1518;47;F
95774;1411,317,344,51,822,90,347,1422,62,9,627,5,44,348,820;32;F
95776;62,45,1657,1148,1658,190,347,51,53,340,1655,820,106,627,345;36;M
95777;90,1619;37;M
95801;43,25,52,53,1456,435,1485,6,347,51,344,820,106,627,317;31;M
95813;707,62,593,1430,347,90,1118,53,820,106,435,52,348,627,317;43;M
95816;627,106,1422,1654,583,62,245,589,90,919,344,348,1456,1058,345;37;F
95818;51,344,820;31;M
95851;43,347,25,9,51,53,627,1518;52;F
95886;44,166,245,25,1430,1518,433,9,587,1655,1656,1657,1654,1653,1658;47;F
95895;627,317,820,53,348,344,52,51,347,5,9,245,43,25,1518;48;M
95919;1518;40;F
95960;245,43,919,348,435,627,317,106,1058,1456,1226,344,51,347,587;67;F
95979;347,51,106,627,1654,1657,1655;34;M
96032;43,596,51,344,1118,1456,433,5,45,583,25,342,53,627,1518;41;F
96056;245,106,317,433,587,347,348,627;32;M
96103;43;50;M
96110;62,45,593,245,43,106;40;F
96147;433,245,53,627,345,1658;60;F
96165;106,435,317,707,345,1411,433,45,583,43,347,25,53,627,1518;39;M
96178;62,583,589,53;23;F
96194;1411,1658,9,707,345,1518;38;M
96198;6,1422,347,51,348,62,344,342,1619,63,106,435,627,589,919;43;F
96255;344,51,919,347,1422,245,583,62,1148,1653,190,43,348,340,820;15;M
96259;245,627,1619,51,433,44,52,1118,53;34;M
96275;345,433,587,9,45,1658,245,1653,190,43,919,51,344,348,1656;49;F
96301;1430,627,340,1619,45,5,245,1411,1518;47;F
96331;583,245,190,348,435,707;32;M
96339;433,587,593,1430,919,1118,1058,1518;46;F
96362;1148,583,190,347,596,52,1118,1656,340,820,106,627,43,51,348;38;M
96365;433,5,9,62,45,583,245,1654,43,166,25,51,1619,1456,1518;5;F
96398;45,583,44,52,344,342,63,627,707,9,1148,43,51,348,820;37;F
96450;1148,627,1654,344,52,1656,340,1655,1456,1658,190,90,342,345,1226;31;F
96468;5,9,62,1657,1658,245,43,25,44,1619,627,707,1411,1518;32;F
96473;45,1148,1658,43,919,340,820,345;42;F
96484;1518,6,43,596,822,25,52,44,1411,9,90,344,820,627,1118;41;F
96509;5,9,62,53,106,348,1656,820,43,245,587,51,344,627,1518;42;F
96510;53,1655,63,627,345,245,1422,25,44,820,1456,1518,9,45,43;43;F
96515;1658,62,5,433,587,596,919,51,344,348,342,1619,820,1456,245;41;F
96534;433,5,90,596,435,25,1430,245,43,348,627,1411,1518;59;M
96575;90,347,43,6,1430,433,587,5,9,1654,25,51,344,435,627;63;M
96585;1655,1422,1657,1658,583,1654,190,347,51,344,348,1656,627,345,1411;31;M
96591;347,1226,106,627;29;F
96593;6,62,593,1430,1148,583,1422,25,919,344,1226,1656,1058,106,627;24;F
96607;1226,919,348,1148,190,347,51,1619,340,820,627,345,1657,1658,245;42;F
96628;5,583,63;40;F
96656;348,344,51,90,1430,62,1485,5,317,707,347,43,583,433,342;39;F
96668;340,707,45,1430,583,245,1654,1422,43,347,342,53,820,627,1518;40;M
96680;1655,1118,1619,596,433,1430,583,1422,435,317,589,348,820,106,1411;31;M
96699;190,347,822,348,1226,53,106,1518,1658,583,25,51,820,627,435;27;F
96713;627,5,898,1430,1148,6,245,1654,190,347,51,348,1619,53,1655;42;F
96717;6,1422,1619,1118,53,820,1485,5,347,433,898,90,25,627,1518;41;F
96730;53,587,5,1148,190,347,820,1456,106,627,1411,1518,1654,340,1658;39;F
96733;106,627,707,1411,5,1430,583,245,43,589,90,822,25,919,340;50;F
96752;5,898,583,190,51,53,340,820,435;40;M
96755;1485,1148,1653,90,1619,435,245,1411,1422,820,1058,106,627,589,340;31;F
96782;45,1657,1654,347,822,52,348,342,1656,1655,106,627,1411,433;36;M
96788;583,587,593,1430,1654,43,347,90,919,52,820,106,627,317,707;7;M
96803;52,53,820,1518,62,43,106,6,347,90,51,344,1619,627,317;34;F
96818;919,25,90,347,583,62,9,5,587,340,820,627,317,106,435;29;F
96914;1518,25,43,587,245,1456;34;F
96918;348,342,1118,1656,340,820,5,45,1148,245,1653,190,43,1655,1518;61;F
96921;53,5,1485,593,1430,1422,43,51,820,1058,106,435,627,317,1518;29;M
96929;587,1430,245,348,347,25,44,1118;51;F
96992;6,1653,190,43,344,820;40;F
97025;345,1655,344,25,1658,6,245,190,347,90,51,52,106,627,317;70;M
97067;593,433,245,90,344,1226,1058,106,587,190,919,1456,1148,43,348;52;F
97233;345,707,63,53,342,344,593,596,44;72;F
97240;6,166,1430,1619,1411,1518;45;M
97274;1658,245,1655,820,1456,345;34;F
97300;44;43;M
97308;25,90,347,43,587,5,1148,190,51,1226,1656,820,106,627,707;35;F
97398;593,1430,589,90,596,25,1619,1118,1518,1411;47;F
97413;5,9,587,898,593,1430,245,43,919,44,53,627;52;F
97419;627,45,347,1656,51,245;47;M
97452;106;46;F
97469;5,593,1430,43,166,347,348,820,1518;44;F
97470;62,1654,627,317,1411,5,9,245,1422,43,25,348,820,435;45;F
97501;53,106,317,627,1518;31;F
97517;106,627,345,1518,45,166,90,25,317;40;M
97519;342,820,583,43,589,25;34;M
97522;1658,245,190,43,347,25,51,44,348,340,106,435,627,345,317;39;F
97535;5,433,1656,1058,587,90,1148,347,1619,820,51,627,1655,245,1653;24;M
97566;1430,1411;39;F
97602;106,627,317,435;30;M
97628;587,25,593,245,52;46;F
97643;345,627,1456,1619,190,1653,1658,1657,1430,587,433,245;37;F
97658;627,317,5,43,347,25,587,593,245,1653,190,919,51,1656,340;44;F
97665;1657,1658,245,190,347,25,51,44,348,340,106,435,627,317,345;10;F
97676;44,1226,1655,106,435,593,1654,1456,5,433,342,53,317,9;38;F
97688;317,51,62,9,587,433,25,919,348,1226,53,1058,106,627,1518;39;F
97699;1430,1411;46;M
97737;587,593,245,52,25;46;M
97771;589,90,25,44,1619,340,106,433,1422,919,348,1226,1058,627,245;30;F
97810;1485,1657,6,43,51,344,820,348,52,25,190,1653,1148,1430,5;33;F
97825;1226,820,106,583,919;28;F
97828;1430,1411;12;M
97841;45,62,9,587,5,1148,1658,583,1654,190,347,340,820,627,345;30;F
97846;435,1411,1518;29;M
97852;587,25,919,1619,1118,1226,106,1485,1148,347,53,820,435,627,317;33;F
97871;583,1658,245,51,1656,53,820,106,627,1657,1654,190,1422,340,345;44;F
97886;1658,245,190,43,347,25,51,44,348,340,106,435,627,317,345;8;F
97895;1430,1411;15;F
97899;1656,1619,342,348,344,25,1654,245,1658,583,587,433,593,45,919;39;F
97910;90,1653,245,6,62,9,587,433,589,25,344,1118,348,1058,435;32;M
97922;43,347,25,51,344,348,342,53,340,820,1518,5,1411,45,583;42;F
97929;53,1411,1518;53;M
97977;44;48;M
97982;25;45;F
98000;5,593,245,347,596,919,52,1118,53,627;27;F
98055;62,1657,1148,1658,245,190,43,347,348,340,106,435,627,317,345;4;F
98057;1654,583,5,1657,1148,1658,1653,347,53,340,1655,106,435,627,345;29;F
98107;317,340,820,43,51,344,627,106,1655;28;M
98123;919,1456,43,1654,593,1430,45,9,5,587,433,245,25,1518,44;37;F
98164;344,348,1118,820;17;F
98180;44;49;M
98231;1658,1657,1656,1654,1653,1655;45;M
98238;5,45,43,44,53,820;40;F
98240;1148,52,1118,53,6,51,344,245,43,919,820,5,1619,106,627;18;F
98242;433,245,1619,1118,1518;37;F
98243;90,52,435,1518,344,51,25,190,1485,5,9,45,919,53,820;24;F
98287;433,45,245;39;M
98297;1518;40;F
98324;1485,43,347,919,52,348,342,1118,53,820,106,435,317,707,1518;36;F
98326;583,347,344,106,627;40;F
98335;1430,44,1619,435,707,9;32;F
98341;44;43;F
98345;1430,1411,587,1655,1518;38;F
98357;5,9,583,245,25,820;36;F
98385;5,820,627,317,1518,43,1657,587,245,90,44,25,344;35;F
98423;1118,53,820,6,5,1654,245,1148,43,589,347,90,51,106,627;23;F
98429;9,245,43,25,1619,1411,1518;40;M
98443;919,1118,707,433,593,1430,1658,342,1656;31;F
98455;9,62,347,25,51,44,1518;28;F
98460;45,1657,1656,1148,1658,190,6,245,51,340,820,627,106,317,347;15;F
98477;51,583,347,344,106,627;11;F
98496;433,587,1656,53,820,317,1226,51,245,1430,190,1058,106,627,345;22;F
98548;1654,51,820,245,1656;35;F
98622;593,433,587,1430,6,347,51,348,1619,1226,1456,1058,106,627,317;41;F
98640;9,62,1430,1148,583,43,166,919,348,1619,1656,106,627,1411,1518;11;M
98642;43,1654,340,317,106,51,1657,1148,245,190,90,596,348,627,345;54;F
98675;53,1058,587;50;F
98683;9,1485,5,587,1658,583,347,344,348,1655,106,435,627,317,1411;37;M
98692;1518,245,25,820;28;M
98706;347,90,5,433,919,6,245,52,344,348;52;F
98708;587,1485,62,45,1148,583,6,1654,1422,919,344,342,1619,1655,1456;37;F
98741;627,433,5,1148,919,51,52,1118,106,6,245,190,596,344,348;24;M
98786;43,596,1619,1118,820;41;M
98822;317,627,106,820,53,51,25,347,583,9,587,1619,1118,5,43;39;M
98837;52,1118,1656,340,345,435,106,90,190,583,43,596,344,342,820;22;F
98845;1518,340,348,43,1430,587,245;63;F
98905;433,587,5,9,348,53,45,1430,6,25,51,44,344,820,1518;51;F
98932;1118,190,593,347,596,51,53,106,627,1148,245,90,348;49;F
98939;245,587,593,1148,6,1653,43,347,344,1456,1058,317,345,707;71;F
98950;433,587,5,62,593,1422,347,25,44,1619,820,317,707,1518,245;41;M
98989;1430,1619,1411;36;M
98999;9,62,1430,1148,583,43,166,919,348,1619,1656,106,627,1411,1518;8;F
99003;1654,190,43,51,53,340,106,627,45,583,6,90,919,52,348;42;F
99007;245;47;M
99017;1456,63,106,317,345,62,45,583,1422,589,347,51,627,1411,1518;42;F
99025;90,53,1422,627,898,52,5,6,1619;55;M
99039;245,1654,25,820,627,1518;37;F
99047;583,919,44,1226;34;F
99048;344,52,6,62,347,51,106;41;F
99059;245,1654,190,1656,1655,820,106,45,593,587,1148,1653,589,583,627;39;F
99096;1430,1619,1411;35;F
99109;1654,1058,1456,44,1619,45,1430,245;49;M
99114;1518;44;F
99123;435,1656,344,596,90,245,433,5,9,6,43,166,25,348,820;28;M
99134;5,9;39;F
99141;166;41;M
99149;1411,1422,583,9,6,25,348,820,435,5,43,166,90,52,344;36;M
99157;1430,1619,1411;6;M
99170;1654,340,1518;39;F
99177;25,90,43,6,5,9,62,45,51,44,52,53,435,707,1518;49;M
99179;1518;13;F
99189;348,919,25,589,587,1430,583;32;F
99210;1485,6,245,347,1118,63,106,627;34;F
99221;51,340,345,62,45,1658,245,627;34;F
99238;45,627;32;M
99241;1655,190,90,51,43,25,106,1148,627,820,435,53,919,587;25;M
99245;1655;35;M
99271;347,51,106,627,245;50;F
99280;1430,1619,1411;2;M
99287;1058,63,342;34;F
99325;1518;42;M
99330;90,51,347,106,317,627;46;F
99337;1654,340,1518;15;M
99360;583,1654,43,53,340,820,106,435,627,1518,6,190,51,348,345;33;M
99384;433,90,347,589,62,1430,1654,190,1422,25,348,106,435,317,345;48;F
99424;1518;9;M
99441;1653,1518,435,51,5,62,245,347,348,53,820,106,627,317,345;56;F
99501;25,435;35;M
99514;5,45,245,90,106,345,43,347,51,344,53,820,627;27;F
99521;45,44,1422,43;50;F
99556;5,9,45,583,347,822,51,44,52,1619,53,1655,820,317,1518;38;F
99565;344,820,1655,1619,52,44,1518,51,822,347,583,45,9,5,317;47;M
99650;43,348,340,820,106,435,25;43;M
99664;1658,1657,1656,1655,1654,1653;45;M
99701;1518,1411,1654,583,45,43,344,53,820,627;36;M
99724;245,25,348;17;F
99742;51,627,106,43;20;M
99744;106,43,51,627,1654,596,820,348,583,190,347,345;38;F
99746;587,1148,190,822,1619,820,1430,1657,1456,627,317,1518,44,25,9;50;F
99749;1430,25,348,1226,820,1058,63;46;F
99823;1148,1657,1653,919,820,627,345,433,593,1658,245,348,1456;28;F
99830;166;69;F
99848;6,1118,44;38;F
99867;90,1226,435,5,9,43,25,51;37;F
99879;45,43,583,245,44,25;34;F
99888;1118,347,1518,435,317,707;65;F
99905;106,190,51,1148,348;33;M
99919;433,587,898,593,1430,583,1654,25,1619,1226,820,1058,627,1411,1518;45;F
99928;166,340;48;M
99929;587,593,62,1148,6,245,190,43,347,919,51,1058,106,435,627;36;F
99966;433,52,53,25,435,1058,587,245,1653,190,90,1226,820,1456;70;F
99981;190,822,25,44,1656,1456,627,1518,9,1148,43,166,51,820,435;33;F
100000;9,6,43,25,342,1118,820,1411;51;F
100061;1430,1422,589,919,344,348,340,1058,627,707,1411,820,190,345,245;21;F
100132;44;41;F
100159;348,25,347,166,593,587;72;F
100185;190,106,340;25;F
100187;587,5,1430,43,347,344,820,106,627,317;32;M
100192;820,587,62,1430,1518,707,627,317,435,344,25,45,433,90,52;61;M
100209;1118,90,44;48;M
100222;1118,6,44;35;F
100235;166;67;F
100237;433,106,627,317,587,1430,1148,1658,583,1654,190,347,344,1118,820;19;F
100244;1456,1058,43,1422,1654,245,6,1657,1430,593,45,587,433,25,1518;35;F
100252;345,627,348,596,90,190,245,1148,1657,51,106,317,340,1654,43;77;F
100284;9,5,6,25,44,1118,1518;9;M
100306;433,62,190,43,347,25,51,1619,1656,1456,1058,106,627,317,1518;37;M
100328;583,433,627;52;F
100369;6,44,1118;7;F
100377;9,1148,6,43,347,245,25,919,1656,53,820,1058,627,435,317;28;F
100392;587,5,1485,9,106,435,707,627;34;M
100401;25;29;M
100404;6,583,1658,1148,1657,1430,593,45,62,898,9,1485,5,106,627;38;M
100405;245,6,43,1656,1411,345,1456,433,1658,51,44,342,1118,627,1518;8;M
100432;1148,1658,245,919,52,342,1656,1655,820,707,345,433,45;33;F
100440;25,435,245,52;27;F
100473;52,1118,1656,53,820,106,435,317,707,6,245,43,90,596,51;36;F
100483;345;35;M
100504;6,44,1118;41;M
100534;1518;39;F
100536;433,52,344,820,1058,106,435,317;28;F
100537;347,106,317,627,1518;47;M
100559;9;53;M
100572;44,820,1518,25;41;F
100589;245,589,90,919,52,348,1226,820,1058,106,1518;46;F
100642;344,919,433,1430,6,348,1656,1226;27;F
100648;587,593,25,51,1226,53,1058,435,627,317,1518;36;F
100663;1411,1518,1656,53,820,627,51,25,5,1422,43,348,106,435,317;29;M
100668;433,245,347,919,344,106,317,627,707;26;F
100676;433,593,1658,583,919,1226,1058,345;35;F
100683;5,820,587,583,90,919,51,53,435,1518;35;F
100690;245,166,1430,1411,1619;44;F
100738;245,43,347,596,51,1118,820,106,627,317,5,53,435,707,1411;32;M
100744;9;52;F
100758;90,1654,1430,45,62,433,1658,245,707,1518;44;F
100766;1619,820,62,898,5,45,1654,347,90,25,342,245,51,627,1518;44;F
100775;5,62,25,51,44,344,9,53,820;24;F
100780;44,707,340,25,43,1658,1657,45,5,1148,190,342,1656,820,1518;63;F
100782;5,25,9;37;M
100785;62,593,25,52,348,342,340,820,245,190,43,51,53,1058,627;27;F
100837;1518;10;M
100853;6,44,1118;9;M
100878;6,25,348,52,1148,5,587,43,347,90,820,106,627,9,51;65;F
100885;5,45,583,347,340,106,627;58;M
100891;6,1430,593,106;29;F
100911;25,106,317,707,52,435;29;M
100925;317,43,106,435,1411;28;M
100981;53,1655,820,627,707,1518,9,1430,25,44,1656;28;F
100984;1456,583,43,90,25,51,44,52,1619,53,435,707,9,1411,1518;42;F
101017;1430,1411;60;F
101024;1654,1148,1658,1657,45,62,5,898,245,435,317,707;32;F
101044;435,707,1148,43,90,51,52,344,1656,627,317;16;M
101086;317,1456,51,25,347,589,43,1430,62,433,9,919,44,348,53;24;F
101138;627,317,90,43,1430,1485,1148,1658,1653,1654,596,820,435,106,345;47;M
101157;348,245,45,62,433,5,1654,43,90,342,1619,53,820,627,1518;11;M
101165;1148,245,1653,190,1422,347,51,44,348,53,1456,627,317,25,435;40;M
101226;1518;43;F
101230;1656;35;M
101232;44;11;F
101248;43,51,1518;38;F
101297;587,1657,245,344,342,1619,1118,627,348,820,1148,347,919,345,190;43;F
101323;1148,62,1430,1653,43,347,51,348,53,340,1655,1058,106,627,345;24;F
101333;347,90,25,919,51,52,344,348,1226,820,1058,106,435,627,317;29;F
101339;1422,898,340,106;34;M
101347;583,190,347,51,53,820,106,627,317,587,5,6,25,348,919;36;F
101348;25,6,1148,5,51;30;M
101358;1518;7;M
101359;6;39;M
101377;44;8;M
101393;43,245,6,1148,62,51,344,106,317,1058,53,1226,52,347,627;35;M
101408;1148,1430,9,1485,5,43,51,25,820,435;29;M
101410;245,707,919,44,342,820,1456,45;39;F
101426;1411,1619,44;37;M
101438;44,1518,9,43,245,5,587,919,25;32;F
101439;5,433,340,820,1058;45;M
101449;317,707,53,106,627;39;F
101454;52,1654,6,9,53,435,51,25,90,45,1485,5,106,627,317;21;F
101475;1430,190,347,25,44,348,106,9,596,340,435,627,317,1411,1518;37;F
101502;1518,25,919,44;64;F
101511;1148,245,190,43,347,51,348,1118,340,820,106,435,627,317,345;44;F
101546;433,587,62,593,1430,245,822,25,348;49;F
101566;43,190,593,45,62,347,596,51,344,340,106,435,627,317,707;29;F
101574;43,51,1118,6;48;M
101579;25,1518;40;F
101587;583,1518;31;F
101596;1422,43,347,90,596,919,44,348,1118,820,1456,106,627,317,1518;44;F
101601;43,190,245,6,1148,593,45,1485,5,587,433,51,52,344,106;69;F
101608;43,1422,190,433,9,62,1148,6,596,25,348,1118,53,1456,106;31;M
101652;1411,627,1226,342,344,52,44,919,347,43,593,62,5,587,9;30;F
101700;1148,6,190,347,51,344,317,627,106;56;F
101801;190,25,820,9;32;M
101805;5,820,707,53,435,106,583,317,90,245,51,6,1619;42;F
101820;5,9,1148,822,25,919,1655,820,340;25;F
101840;1422,347,25,342,53,340,1456,317,345,51,820,106,583,1654,435;35;M
101845;1456,1058,707,1411,1518,433,898,1148,583,190,919,344,1619,340,345;39;M
101848;345,627,106,820,340,348,51,347,43,190,245,1148,45,1485,5;11;F
101854;63,342,707,62,347,583,820,43,317,51,106,898,5,627,1619;28;M
101878;1058,820,53,1226,51,347,43,245,1430,1485,1148,190,25,348,435;46;F
101917;433,317,340,820,1058,707,627,587,5,245,1118,53,1456,1654,1619;39;F
101932;1658,245,166,596,919,1656,106,707,1411,898,45,1118,1456,433,1518;25;M
101970;1654,820,1657,1658,190,347,1656,45,1148,245,1653,340,1655,627,345;39;F
101983;245;14;F
102025;1485,5,45,1148,245,190,43,51,348,340,820,106,435,627,345;14;M
102034;5,45,1148,6,245,1653,52,344,1518,707,190,43,347,627,106;28;F
102118;43,583,1148,62,5,9,593,6,347,25,51,348,1656,53,820;33;F
102129;583,9,43,90,25,44,52,1619,53,1456,1411,51,435,707,1518;11;M
102148;51,342,820,435,106,587,593,43,919,348,1058,627,317,707,345;49;F
102164;1485,9,52,53;27;F
102177;44,1411,345,707,435,1656,51,596,43,589,90,1118,53,820,106;29;M
102178;62,1485,5,587,1422,347,90,919,342,1456,627,317,707,9,44;40;F
102179;245,1518;41;F
102182;43,62,433,5,9,1430,245,90,596,919,44,348,1118,1456,1518;32;M
102233;9,5,1518,317,433,45,190,43,51,340,820,245,166;39;M
102249;1430,589,820,435,1518;30;F
102282;90,1411;43;F
102293;347,1422,1658,45,5,898,245,43,51,348,340,820,106,435,345;72;F
102319;583,190,44,53,435,106,63,1518;22;F
102349;52,587,9,25,348,1619,53,627,317,1518;49;F
102350;5,43,348;37;M
102373;1485,1430,245,53,820,317,435,707;33;F
102419;1656,340,1655,345,62,1653,317,347,43,190,1148,51,820,106,627;36;M
102446;583,1148,62,348,1619,340,627,45,1657,1658,919,1656,345,1518;37;F
102477;90,53,627,317,5,62,1654,190,347,596,51,344,348,820,106;42;M
102516;1656,53,340,1655,820,1456,63,627,1518,345,1411,106,435,317,707;29;M
102517;1148,1658,245,190,1422,347,919,1656,1655,820,106,627;32;F
102578;1657,62,433,53,627,1658,245,1654,190,342,345;32;F
102590;627,9,62,1430,245,1422,25,44;38;F
102597;44,1518;42;F
102664;9,45,1430,43,589,51,52,820,435,25,44,348,53;42;M
102676;6,589,919,51,52,344,348,1118,1226,1656,53,1058,106,317,1518;29;F
102697;5,43,707;27;F
102726;1518;41;M
102733;1148,1657,433,245,1653,190,347,25,344,53,820,106,627,707,345;35;F
102734;1518,707,820,347,43,45,1148,1658,583,6,919,342,1619,1456,63;26;F
102755;433,898,90,1226,340,1456,1058,106,627,1411;29;M
102830;433,1658,1654,245,1653,190,347,344,348,1619,340,1655,1456,627,1656;33;F
102855;589,596,344,1655,5,583,43,342,1656,820,1118,433,45,707,1518;28;F
102894;348,627,5,583,245,43,342,1656,820,106,707,1118,1518,433,45;33;M
102904;627,1058,820,51,347,43,190,1148;39;F
102913;9;22;M
102937;1485,433,43,589,51,1619,53,820,435,1411,1148,347,919,627,317;29;F
102939;245;40;M
102951;43,9,25,707,44;40;M
102967;9;58;M
102972;433,9,1658,1654,342,1619,1456,707,1518,62;36;F
102975;1653,1118,53,63,1411,345,347,587,62,593,43,596,1456,707,1518;45;F
102983;90,52,348,53,340,1058,63,106,317,51,1657,6,245,190,347;40;M
102984;919,433,583,245,1654,43,44,342,53,1518;42;F
103003;820,1456,317,1518,433,5,9,62,6,43,347,90,51,106,627;28;F
103029;435,1655,1653,1456,63,62,433,43,596,919,348,342,1118,820,45;13;F
103047;1655,1656,5,1657,820,345;36;M
103076;707,45,245;44;M
103089;25,347,1148,1456,1226,1430,593,62,5,587,433,9,6;32;M
103099;5,9,6,25,44,1118,1518;39;F
103103;5,433,1430,6,43,589,90,1518,348,1619,1118,340,820,1058,106;30;F
103150;707,587,433,583,6,1654,43,589,596,25,44,1456,63,627,1518;44;M
103151;1148,45,62,433,1658,583,245,190,43,347,90,1226,340,820,345;29;F
103156;62,1148,190,1653,347,596,348,52,51,25,820,1118,1456,106,340;43;F
103182;5,1430,6,43,347,25,51,344,820,627,1518;44;F
103200;1411,9;25;M
103215;25;43;M
103227;347;53;M
103241;596,347,43,1430,62,433,53,1656,1118,44,6;27;F
103271;62,898,9,1485,5,433,6,25,51,52,348,106,435,627,317;46;M
103273;51,25,1456,433,9,6,44,1411;41;F
103320;1653,6,1148,898,5,51,344,348,1619,53,820,106,435,317,345;24;M
103340;593,5,587,433,919,348,1118,1226,1656,53,820,1058;68;F
103349;43,1656,820,707,1422,25,435,317;29;F
103352;245,190,347,90,51,52,344,348,1226,340,820,63,106,627,1518;7;F
103364;627,435,1226,51,43,5,919,344,820,1058,106,317;30;F
103396;62,317,348,344,25,1148,5,43,347,53,435,627,9,51,820;36;F
103401;5,9,1430,583,1653,589,596,25,44,344,348,1118,820;27;F
103406;106,348,51,919,25,90,583,9,587,1658,1653,1654,1657,1656,1655;18;M
103440;51,347,53,820,62,1657,583,190,340,106,627,1658,348,1656,345;49;M
103450;62,593,1430,6,1654,347,51,44,348,1118,53,1655,63,627,1518;41;M
103472;919,25,90,190,245,6,1148,593,9,1485,433,5,43,1656,820;18;F
103478;822,596,90,347,589,166,43,190,1654,1653,583,1658,1148,1485,62;40;F
103496;589,347,596,51,52,344,1118,340,820,106,627,1411,90,342,1658;37;F
103512;5,340,820,919,25,822,596,347,43,245,1148,62,898,587,433;19;M
103520;1148,1430,593,433,45,1653,1654,190,347,919,51,348,1656,340,1655;36;M
103525;63,340,348,344,52,51,90,347,190,1654,245,6,1148,1657,45;9;M
103531;1148,342,1422,596,344,587,1658,166,52,25,44,919,348,820,1058;52;F
103533;433,5,45,583,43,589,596,344,342,1118,1656,1655,820,707,1518;4;M
103551;1518;42;F
103576;345,1118,53,1655,1456,1148,1654,90,596,51,344,1619,340,106,627;46;F
103589;9,166,25;45;M
103622;583,5,9,45,166,25;39;F
103662;1658,25,44,53,820;76;M
103665;1619,1653,5,25,344,317;32;M
103667;1456,347,587,51,344,820,106;42;F
103673;106,317,5,9,25,919,51,348,342,1118,820,435,627,6,43;18;F
103697;587,9,593,44,348,1226,1456,1058,435,1518;51;F
103701;587,1654,344,90,596,25,919,51,342,1118,820,1411,1456,627,166;14;F
103703;25,596,166;31;F
103732;1118,1456,63;34;F
103749;45,1518,25;40;F
103767;1148,6,245,1653,25,344,348,1656,820,106,435,627,317,345,1518;35;F
103773;1655,317,1148,190,347,51,344,1656,340,820,106,627;40;M
103784;1518;44;M
103799;52,344,342,1656;60;F
103814;1456,345,344,51,1653,583,1148,6,245,190,348,627,347;49;F
103824;919,820,1518;41;F
103863;348,820,1518;29;F
103864;106,627,245;39;M
103887;43,1619,45;52;F
103890;90,52,348,1118,1148,5,6,347,51,344,340,820,106,435,627;66;F
103905;1619,106,317,345,1518,627;43;M
103907;45,898,1485,5,43,347,340,1655,820,345,1658,190,51,344,317;36;F
103955;1430,593,1657,583,348,340,1518;48;F
103971;317,627,596,6,9,433,5,245,43,90,25,919,44,52,1118;47;M
103980;44;36;F
104002;1518;16;F
104029;1518;44;M
104062;593,919,344,1226,53,435,627,317,707;20;F
104067;45,43,344,1656;36;M
104074;6,245,43,348;35;M
104159;245,106,627;9;F
104162;433,45,245,43,822,25,348,1456,707;44;F
104163;6,43;27;M
104185;25,51,106,1430,1657,348,1655,433,45,1658,707;41;F
104202;106,627,435,317,707;57;M
104224;435,317,5,9,62,1148,43,347,25,51,344,348,53,820,627;61;F
104256;245,106,627;6;M
104258;53,340,106,317,62,1658,583,190,43,589,596,51,820,627,345;44;M
104264;596,1654,45,433,348,820,898,583,1653,190,25,344,340,627,1655;37;M
104321;587,433,62,593,1148,919,1619,1226,53,820,1058,106,627,345;29;F
104332;9,6,245,166,25;45;F
104342;1456,342,1654,51,348,53,627,1658,344,1655;36;F
104366;433,587,1430,347,919,1118,820,1518;45;F
104375;1422,1148,6,1658,245,190,347,340,583,1653,596,627,1411,51,1456;42;F
104392;6,43;23;F
104436;6,45,433,245,347,51,344,820,627,106,43,1619,63,5,62;31;F
104437;1485,43,344,25,5,51,106,1619,1656,820,627,1148,347,45,919;48;F
104438;245,166,90,25,820,1456,627;54;M
104448;433,1430,1148,1658,583,190,589,348,1656,340,820,106,1411;16;M
104449;44;2;F
104459;5,587,43,90,45,593,1430,919,1619,1411;40;F
104491;1518;11;M
104496;5,62,6,347,51,52,348,344,1656,53,820,106,627,317,1518;27;M
104512;62,589,25,106;26;M
104539;9,6,919,44;33;F
104541;245,347,589,596,919,348,1656,820,106,627,317,345,433;19;M
104574;106,627,317,43,5,6,9,245,44,1619,1518;40;F
104596;6,1148,5,1485,45,62,1430,583,1422,919,820,106,435,317,707;40;F
104605;1619,5,1118,707,1518,433,245,43,166,589,90,25,44,435,9;18;F
104616;44;5;F
104624;25,919,51,344,348,342,1619,1118,53,820,106,627,317,707,345;23;F
104634;245,106,627;2;F
104651;44,1118,63,345,707,1058,1456,1655,53,1656,596,1653,1658,587,1518;49;M
104659;51,90,1148,5,340,245,6,1658,190,1411,106,820,53,43,9;12;F
104702;51,627,707,1430,5,1456,245,1148,43,347,1655;49;F
104703;1619,340,245,1658,348,106,627,587,593,1148,583,190,820,345,1058;38;F
104714;342,1518,433,1148,1658,583,1654,190,344,53,340,820,1456,707,345;40;M
104723;62,347,106,90,25;31;F
104732;51,53,820,1058,106,627,317,587,593,245,43,919;49;F
104740;587,5,9,45,593,1226,820;40;F
104753;898,5,596,51,344,342,106,435,1148,1653,190,348,1118,1656,820;45;F
104755;106,1118,348,347,190,583,45,5,1654,1148,1657,1658,596,340,820;15;M
104768;1058,1118,25,433,9,1518;18;F
104781;593,6,245,190,589,347,52,344,1226,53,1058,106,435,627,317;29;F
104798;348,820,1456,627,433,1148,1658,190,43,51,53,340,1655,106,345;43;F
104817;433,6,596,1118,1411,1518;12;M
104850;820,53,348,344,51,25,347,43,1148,62,9,5,627,435,317;24;F
104883;1148,52,348,53,6,245,1422,43,347,90,51,820,106,627,317;42;M
104909;345,348,90,6,45,1658,1653,190,43,53;66;M
104912;245,106,627;39;F
104915;44,589,6,1619,90,1654,433,347,51,52,344,1656,106,627,317;33;M
104934;435,627,317,707,345,1411,589,593,62,587,1430,1422,919,1518;26;F
104944;6,1657,1148,1658,1654,190,347,90,51,52,1619,340,820,435,345;9;F
104963;1518,245,1118,820,707;32;F
104979;317,5,62,1148,1658,583,589,596,51,53,340,820,106,627,345;12;F
104980;344,345,627,106,53,25,90,589,43,583,45,1485,347,51,348;23;M
104994;344,90,245,45,62,1656,53,6,347,51,1619,106,627,317;29;F
105000;1148,51,1656,190,5,583,245,347,344,25,919,1619,820,106,627;18;F
105014;1430,1148,245,190,43,166,347,90,919,25,51,53,627,707,1411;39;M
105031;1411,1518,63,106,627,43,6,433,5,90,348,1619,1118,820,317;42;M
105072;348,344,52,44,919,90,245,6,1430,593,898,9,587,1518,25;37;F
105085;707,1654,62,1658,583,6,245,347,51,1619,340,1655,106,317,627;36;F
105095;433,9,593,1658,1654,166,25;42;F
105096;347,1058;35;M
105112;166;35;F
105113;53,340,106,627,245,1422,589,348;45;M
105130;1657,1148,1658,6,1654,190,347,90,51,52,1619,340,820,435,345;6;M
105146;1430,1058,919,1654,245;51;F
105156;44;28;F
105157;45,62,5,190,43,1118,820,707,583,245,1654,589,25,1656,340;30;F
105168;52,627,317,5,1430,1148,245,43,51,820,1456,707;45;F
105185;898,1658,583,1653,1422,589,596,53,1118,340,1655,63,345,1411;31;M
105187;166,190,347,90,596,25,44,348,1118,53,627,43,9,5,1518;38;M
105194;1518;43;M
105206;44;49;F
105219;1653,344,348,51,340,345,190,1148,106;35;M
105222;1518;15;M
105242;587,583,245,1653,90,348,342,1656;13;F
105253;1656,433,587,45,1658,1653,1654,190,347,340,1655,820,627,345,1518;42;F
105268;1148,45,898,433,5,43,52,51,820,106,435,627,317,9,6;26;F
105279;1456,1518,1485,1430,1657,1658,1653,1654,1656,1655,1411,1422,25,44,348;41;M
105289;1148,62,1485,6,25,51,1619,820,317,106,627,5,9,44,1518;31;M
105296;9,1430,43,347,51,44,342,627;32;F
105324;9,62,6,347,25,44,1456,106,627,317;49;M
105348;589,25,342,820,707,587,1658,90,52,1619,1656,53,340,106,345;41;M
105360;62,63;4;M
105378;6,245,1654,589,919,344,348,342,1118,106,435,627,317,707,1518;45;F
105411;9;16;F
105419;1657,1658,6,1653,25,919,1619,1656,1058,627,317,707,345,1422,190;40;F
105430;53,9,245,1655,1456,1411;39;M
105446;51,347,166,1658,62,9,433,5,6,245,25,820,344,627,1518;34;F
105452;62,63;1;F
105499;433,587,62,593,1430,245,25,919,52,348,342,1456,435,317,707;31;F
105500;1654,245,6,583,1430,1118;37;M
105505;898,45,593,1430,583,1654,1422,43,166,25,919,627,1226,1456,1058;43;F
105506;5,45,583,347,52,344,1619,53,340,627,1658,1422,342,1655,1656;40;F
105519;245,1654,1422,348,1656,1655,63,707,345,433,45,593,1658,342,1518;31;F
105528;62,45,1658,583,6,245,347,51,1619,53,340,106,627,317,345;43;M
105530;1619,53,627,6,347,90,51,52,820,317,707,43,106,1485,435;32;M
105583;348,1518;16;M
105588;433,587,190,43,90,25,51,52,344,348,820,345,1619,627,1518;31;M
105620;433,587,5,45,593,583,245,1654,589,919,1058,627,317,707;36;F
105621;45,593,43,1655,820,317,51,347,898,5,1658,1518,627,106;47;F
105644;433,5,9,6,245,43,90,596,25,919,44,52,1118,627,317;47;F
105645;433,166;23;F
105659;43,1654,245,583,25,1656,820,106,627,1411,919,1058,435,317,707;32;F
105664;90,340,1655,820,1456,63,53,1656,1118,344,5,433,45,596,1518;49;M
105690;583,245,1653,90,1619,342,1656;38;F
105697;245,1654,45,1619;44;F
105710;587,1422,593,1148,190,822,25,820,1058;51;M
105760;707,45,245;8;F
105762;587,62,25,348,1226,53,1456,1058,435,707;39;M
105787;245,25,53,627,1518;46;F
105789;344,1656,345,898,62,347,106,53,51,5,43,820,1422,1411,340;27;M
105799;53,348,51,347,589,43,1422,190,1148,5,587,1411,6,919,106;25;F
105820;53,342,51,25,347,245,583,1430,45,62,5;8;M
105875;1058,345,317,627,106,53,51,596,43,6,62,583,347,25,1118;35;F
105906;45,583,245,1653,342,1656,345;10;F
105944;435,1654,1430,593,62,348,587,1657,1658,1653,340,627,345,1655;30;F
105949;1148,583,1658,43,347,919,51,52,344,342,1656,53,340,1655,627;12;F
106024;9,62,245,1654,43,25,44,348,342,1619,53,1456,627;5;M
106057;45,593,166,25;40;F
106081;593,919;41;M
106134;707,52,596,1657,317,435,5,1148,190,347,51,344,820,106,627;40;M
106140;9,1485,5,6,53,347,25,90,51,52,106,707,435,627,317;35;M
106161;587,919,348,1485,5,9,45,245,43,589,51,25,627,317,707;32;F
106167;1655,245,433,347,342,345,1518;36;M
106174;44;39;M
106176;44,919,25,593,587,433,62,6,245,51,1456,1058,627,707,1518;34;F
106183;53,627,593,1430,190,51,106,9,45,245,43,25,820,317,707;32;M
106194;1653,589,5,433,45,1654,190,596,344,1118,340,820,63,435,1518;20;M
106197;52,90,1422,1654,245,583,1658,1148,1657,45,5,348,1118,340,345;39;F
106217;25,1118,1619,627,707,5,45,1430,583,245,43,51,342,820,1456;34;F
106221;433,587,25,344,1518;45;F
106226;25,43,1422,245,45,62,9,5;3;F
106234;9,1518;46;M
106261;593,1148,1658,6,43,919,344,52,348,1226,340,1058,435,245,1518;20;F
106270;587,593,1518;41;F
106272;898,1658,583,1654,347,51,52,1619,1656,53,340,106,627,317,1411;14;M
106277;5,51,25,43,9;41;M
106300;1430,348,106,433,5,9,6,245,166,25,919,44,820,627,1518;55;F
106342;587,593,919,1058,1658,245,1422;14;F
106367;344,51,43,1422,62,6,347,348,106,435,627,317,707,1518;38;F
106404;43,344,348,340,627,347,919,1518,583,820,106,52,245,317,707;37;F
106438;6,1148,1657,45,1485,62,190,347,90,51,53,820,106,627,1411;46;F
106511;1619,53,1456,345,45,1148,583,1654,190,43,344,342,340,1655,106;32;F
106524;433,587,25,344,1518;49;M
106535;6,433,587,5,9,593,583,43,25,344,820,1456,1058,627,1411;48;F
106575;6,1518;38;F
106578;25,344,1655,317,627,1518,5,593,6,919,106,347,345,190,820;36;F
106587;1148,6,347,51,348,1656,433,587,5,43,52,344,820,106,627;70;M
106614;5,1619,1655,820,106,627,1657,1653,1654,51,345;65;M
106620;9;42;F
106622;190,245,1148,1658,583,1422,347,52,342,1656,53,340,1655,627,345;44;M
106638;190,1654,1653,433,45,1657,1658,583,245,90,348,1656,340,1655,345;6;M
106670;820,340,596,90,190,1654,1653,245,5,433,45,51,344,1118,1518;10;M
106683;593,43,52,6,1148,245,51,45,1658,1654,340,345;39;F
106693;1619,1655,820,5,62,6,245,347,25,51,44,53,1456,627,1518;8;F
106697;1456,898,1653,589,348,820,435,1422,245,1148,5,43,433,596,1411;20;M
106715;9;16;M
106730;433,587,6,43,347,596,1118,820,627,1518;59;F
106744;9,583,43,25,51,44,52,1118,1619,53,1456,435,707,1411,1518;43;M
106752;1518;5;F
106769;898,9,5,587,593,6,245,919,51,52,344,53,820,627,1518;43;F
106779;166,1226,1619,1656,1655,53,1411,317,1058,52,919,43,593,587,5;29;F
106795;596,347,919,51,52,344,348,1118,53,820,1058,106,435,627,317;20;F
106810;919,596,347,1430,25,587,593,245,44,1518;34;F
106827;9,5,1148,190,347,596,51,344,1118,820,106,435,627,317,707;76;F
106849;348,1619,1226,53,1058,707,433,587,245,589,919,1518;7;M
106893;1658,245,1653,1654,190,1656,820,63,435,433,45,596,1118,344,1518;51;F
106904;1518;5;F
106907;44,1422,43,45;17;M
106914;6,45,433,587,62,1658,245,190,347,51,919,53,627,106,1656;54;M
106925;1148,1657,45,62,1658,583,245,1654,342,344,1656,340,1655,627,345;39;F
106950;6,43,344,51,53,1456,627;45;F
106954;340,1658;12;M
106991;348,1118,53,340,820,245,435,317,707;40;M
106992;587,593,1658,340;11;F
107003;6,43,5,62,190,347,51,52,344,53,820,106,317,627,25;43;M
107038;62,51,344,820,63,627,317,1518,6,43,347,90;35;M
107050;25,6,1148,62,919,51,52,344,53,340,106,435,627,317,1518;25;F
107074;587,593,245,589,347,342,1118,1656,345;38;F
107086;344,1656,5,433,45,1658,245,1653,1654,190,596,1118,340,820,1518;16;M
107152;1518,347,5,9,52;29;M
107165;44,342,707,1518,583;31;F
107168;627,44,345,822,1658,9,5,43,90,51,1118,348,340,820,106;37;M
107217;317,627,344,25,596,90,5,1148,190,347,51,52,1118,820,435;62;F
107230;53,317,1657,1430,45,62,9,433,5,822,1456,106,435,627,245;20;M
107265;583,347,51,627,45,166,25;40;F
107301;62,9,5,587,433,245,43,822,348,342,106,627,707,345,1411;63;F
107308;5,62,51,317,627,820,43,53;53;M
107315;45,1422,43,44;13;M
107316;9,1658,166,347,25,51,344,348,53,820,1456,106,435,627,317;37;M
107326;25,51,52,344,348,342,1619,1118,53,340,820,1456,1058,435,627;16;M
107328;433,1658,596,919,1655,1058,43,587,245,342,1118,820,1456,627,1518;37;F
107334;44;33;M
107349;583,6,342,1619,53,106,317,1456,245,347,25,51,820,627,1518;47;M
107354;1148,1658,1653,190,43,347,51,348,342,53,340,1655,106,627,435;39;M
107390;596,344,1411,433,587,5,9,1430,6,245,919,348,1118,820,1518;34;F
107404;433,1656,340,1058,435,627,62,593,1430,6,90,348,53,106,317;30;F
107405;51,820,340,190,106,627,345,1411,1518,583,45,62,1653,342,1656;45;F
107433;1653,106,90,190,1148;44;F
107438;44;2;F
107445;583,1658,587,190,1430,344,5,348,627,345,342,340,820,106,245;36;F
107459;347,51,344,62,898,5,587,345,317,593,1658,245,43,340,1518;45;M
107474;1422,1653,583,45,62,9,1485,5,587,433,593,348,1456,435,707;32;F
107478;245,435,627,317,348,6,62,1422,347,51,707,106,25,589,1518;27;F
107483;45,1654,51,25,1656,820,317,245,190,52,106,627;49;F
107517;820,345,43,62,587,1430,589,25,1619,1118,1456,435,627,317,707;36;F
107549;9,583,43,90,25,51,44,1619,1118,53,1456,435,707,1411,1518;7;F
107578;1485,1655,43,5,9,1658,1654,342,820,63,166,45,583,245,707;30;F
107592;433,45,1430,820,627,1411;38;F
107601;1226,342,347,43,433,593,1657,1658,583,1422,1655,1058,707,1653,245;43;M
107607;45,1422,43,44;50;M
107660;347,1654,433,583,245,43,919,51,52,344,342,53,820,627,317;8;M
107673;317,587,593,583,1654,1422,589,53,1456,62,919,1619,627,1058,1518;32;F
107699;9;46;M
107738;1654,43,166,822,1485,344,348,1148,51,5,820,245,190,25,44;51;M
107739;919,90,1654,245,433,587,898,1430,593,1148,1658,190,589,340,345;36;F
107748;1658,1653,1411,1226,1058,820,627,348,347,345,340,190,106,51,25;34;F
107755;53,347,593,1658,1653,1654,190,348,1656,340,1655,1058,435,627,345;41;F
107758;190,433,45,1657,1148,1658,583,245,1653,90,348,1656,340,1655,345;3;F
107809;340,435,5,1518,344,348,106,627,317,62,347,51,52,53,820;44;M
107888;1430,593,45,43,1456;38;F
107904;5,9,245,347,51,820,106,627;47;F
107913;820,245,5,9;48;F
107926;245,1456,106;43;F
107959;1655,340,344,1485,1148,583,245,1654,43,919,1118,1656,820,1456,627;41;F
107974;53,1118,1518;30;F
108005;45,1422,43,44;10;M
108013;433,593,1658,245,342;33;F
108025;245,44;36;F
108040;6,1148,62,5,52,820,344,340,347,919,348,1118,106,627,1518;36;F
108095;1658,1148,45,9,5,587,25,919,44,53,820,106,435,317,707;41;F
108101;1422,435,593,348,707,1518,345;32;M
108110;44,627;28;F
108129;587,245,1653,348,1656,1655;53;F
108153;43,1430,1118,1518,1619,6,1485,5,9,62,166,822,25,1411,44;38;F
108156;53,820,1456,317,433,45,593,1657,583,245,919,342,340,435,707;34;M
108174;62,106,1518,6,245,90,919,51,52,1058,627;41;F
108211;5,898,45,1657,1148,1654,190,43,919,51,348,340,1655,820;36;M
108226;5,45,1653,43,347,52,342,1118,820,106,1656;46;M
108227;25,166,1411,9,44,1518,1619,245,6,5,1430,1118,90,433,587;29;F
108261;1422,919,1118,627,1226;44;F
108269;45,190,43,348;37;M
108277;53,340,345,1518,45,583,1653,1654,190,51,342,1656,106,627,1411;11;F
108298;340,1658;46;M
108300;25,62,898,1485,5,433,9,245,589,90,820,435,627,317,707;33;M
108319;5,9,62,45,1430,1654,43,347,25,51,44,348,53,820,1518;35;F
108330;627,1518,1148,190,43,596,25,51,52,348,1118,53,340,820,106;32;M
108338;627,1619,190,1148,106,53,90,820,6,5,317,707,51,52,435;31;M
108344;820,106,317,627,707,435,53,52,51,25,90,1422,43,1485,5;33;M
108351;1226,1430,587,5,245;60;M
108355;707,317,63,1653,1656,53,1456,51,347,589,62,583,627,587,106;34;F
108372;347,52,1411,1654,340,820,707,45,190,43,51,106,627,345,1658;44;F
108382;190,1148,345,348,1658,1653,596,51,1655,1656,342,1657,627,583,820;32;F
108387;62,1485,433,5,9,1430,583,245,43,166,25,44,342,820,63;41;M
108401;62,347,90,51,1656,53,106,627,317;29;M
108404;43;70;M
108406;919,587,1518;44;M
108448;190,1658,347,51,1656,340,106,1657,345,627,25,344,348,53,820;42;M
108477;433,5,45,1430,245,166,90,919,348,53,340,820,627,707,345;65;M
108498;1653,190,347,25,51,344,1656,53,340,820,627,345,106,1658,348;39;F
108513;25,52,344,106,317,5,190,43,347,51,1619,53,820,627,245;87;F
108515;1658,1657,317,1653,1148,1485,5,820,106,345,245,190,347,348,627;41;M
108518;1654,43,1485,5,1148,1422,820;51;M
108525;587,44,62,1430,190,25,51,344,347,348,106,627,822,1518;57;F
108554;435,317,707;32;M
108605;433,5,190,43,347,344,1226,1656,340,1655,1058,106,317,435,627;40;M
108611;433,5,1485,9,62,1430,583,245,43,166,25,44,342,820,63;8;F
108619;51,52,1656,53,435,62,6,245,43,820,1456,63,317,707,1518;40;F
108652;344,1226,317,245,1619,106,63,43,62,5;31;M
108667;5,45,190,583,245,1653,43,596,51,344,587,898,1148,1656,820;36;M
108718;1422,347,822,344,51,348,53,433,5,43,1456,106,1619,90,820;59;M
108726;433,587,593,245,25,1518;48;F
108754;1411,433,587,9,45,593,1148,1422,43,166,25,919,44,1456,1058;56;F
108764;433,5,1485,9,62,1430,583,245,43,166,25,44,342,820,63;4;F
108769;62,63;1;F
108779;1658,43,190,1654,1653,6,1148,1657,1430,45,52,344,1656,1655,345;31;F
108793;1518;41;M
108818;587,1430,1518;45;F
108847;1422,627,707,1657,1658,1148,190,43,347,90,342,345,820,1655,340;41;F
108857;9;46;F
108863;190,1658,347,52,53,1655,820,106,587,5,43,919,627,345;64;F
108867;5,1485,1422,43,90,25,51,52,53,820,106,435,627,317,707;30;F
108895;45,62,347,51,1657,1658,1653,1654,190,1655,106,627,317,345;61;F
108973;6,106,627,1430,1411;49;F
108979;245,106,317,707,1411;30;M
108985;6,245,1518;2;M
109022;583,1118,53,340,433,45,1430,1148,1654,344,348,190,345,1658,820;34;F
109081;919,347,589,1653,45,1485,898,593,1148,1658,245,1654,1422,340,820;40;M
109111;62,1485,5,433,1430,1422,43,822,348,1619,1118,1226,1456,707,1411;60;F
109121;627,1456,820,1655,53,51,347,43,1653,583,9,44;38;F
109126;44,1118;13;M
109146;53,1226,1118,6,62,433,587,43,596,919,51,820,1058,627,317;39;F
109168;1653,1148,190;48;F
109169;433,1430,190,347,919,1619,1226,53,106,627;44;F
109184;898,1422,347,344,1226,106,627,433,1058,317;41;F
109187;9,583,347,25,44,342,1655;34;F
109194;433,898,583,1422,347,919,51,435,317;26;M
109208;190,90,340;22;F
109214;1422,596,317,1118,433,898,1430;62;F
109219;245,62,5,1485,9,898,1430,6,1422,919,25,51,44,820,1518;48;F
109231;44,1118;11;M
109239;593,1430,6,43,347,90,44,52,348,53,317;30;F
109293;45,1422,1118,1518;45;M
109296;62,45,1148,1658,245,1653,1654,1422,347,919,1619,340,820,627,345;11;M
109319;51,347,62,9,433,63,1518,345,820,340,52,25,245,583,1658;43;F
109321;1518;7;M
109326;707,245,1654,822,344,348,1656;42;F
109330;433,5,1485,9,62,1430,583,245,43,166,25,44,342,820,63;70;M
109347;44;82;F
109350;627,51,820,106,596,342,589,90,245,43;51;M
109373;1518;8;F
109376;345,433,190,25,348,1226,340,1456,1485,898,1148,1653,245,1058,435;53;F
109383;1430,1658,245,1653,1654,190,348,340,433,45,593,1148,583,1655,345;45;F
109425;9,583,25,344,342,1118,53,820;19;M
109428;245,347,90,51,348,820;66;F
109457;433,1430,6,589,348,1118,1656,53,1518,820;32;M
109458;5,62,45,1657,583,43,347,90,822,51,342,53,1456,106,627;41;F
109460;44;32;M
109478;344,53,340,820,1058,106,627,347,1422,1148,587,245,1653,1656,1518;45;F
109489;5,44,820,435,9,1518;40;F
109516;433,245,1518;58;M
109526;45,433;47;F
109555;62,1148,6,43,347,51,344,348,1118,53,820,106,435,627,317;27;F
109561;166;44;M
109572;433,587,593,1430,1148,1658,190,919,348,1226,340,1058,345;50;F
109576;1655,53,51,43,1654,45,433,587,593,1148,1658,1653,190,919,348;43;F
109586;1518;11;M
109590;43,707,433,1118,1226,1058;39;F
109646;44,820;35;F
109656;43,347,90,596,25,919,51,1118,1226,820,1058,106,317,627,1411;40;M
109662;347,919,51,44,344,1118,53,820,106,435,627,317;21;M
109678;190,1654,583,1658,1148,593,898,587,51,1226,1656,53,340,1655,1653;48;F
109681;106,342,51,433,45,1148,1658,190,43,589,347,919,340,820,345;35;F
109686;345,1658,340;48;M
109692;1518;45;M
109708;1658,340;44;F
109715;348,45,583,1653,1654,190,342,1656,53,340,106,627,345,1411,1518;8;M
109735;1430,245,1456,587,1518,593;34;F
109767;1658,1654,190,43,589,822,25,51,44,348,342,820,435,707,1518;40;M
109772;1456,593,1430,6,245,1422,90,51,344,348,53,820,435,627,52;61;M
109783;898,587,5,44,25,1430,1485,106,1619,90,51,627,707,52,317;46;F
109792;245,317,627,1456,52,344,44,25,596,347,435;30;M
109803;345,6,1654,90,53,63,106,433,1148,583,245,51,52,340,627;5;M
109827;6,344,348;26;M
109828;433,45,1653,190,1422,43,90,342,1656,340,1655,820,63,707,345;5;M
109830;348,342,1619,627,433,340,596,583,820,345,1654,1657;33;F
109849;433,5,1485,9,62,1430,583,245,43,166,25,44,342,820,63;71;F
109855;587,1485,5,898,6,90,51,52,53,435,707;37;F
109907;1518;67;F
109917;245;50;M
109951;820,51,347,6,433,587,5,62,1148,245,1653,190,43,919,1656;63;F
109963;433,5,9,1430,583,43,919,52,344,348,1656,53,820,1456,627;37;M
109978;51,45,1619,53,433;31;M
109983;433,587,45,1430,1657,1148,1658,583,1653,1654,190,1656,340,1655,345;15;F
110065;317,1411,1148,245,1654,43,25,44,348,342,9,5,433,820,1518;42;M
110074;593,45,62,898,433,1518,106,348,1653,587,347,1226,1456,1058,627;43;F
110078;1657,433,5,1485,9,45,1658,1422,1656,340,1655,820,63,707,345;3;F
110089;6,43,347,90,919,51,52,344,1619,1118,53,820,106,627,317;21;F
110090;342,1655,1430,1518;42;F
110097;45,348,1619,53,820,1058,106,435,627,317,587,593,245,1653;51;F
110118;347,51,348,342,53,340,106,1518,5,627,43,25,820;41;M
110130;52,1118,707,1430,342,583,190,43,25,627,347,348,1655;27;M
110135;707,433,62,1148,245,25,51,593,1430,43,919,348,340,317,345;32;F
110138;1658,1148,1657,62,5,348,342,1118,53,820,106,627,317,707,345;30;F
110144;583,245,25;37;F
110147;1657,1658,1653,1654,190,1656,340,1655;32;F
110150;347,51,1058,106;29;F
110151;1518;69;M
110178;52,1619,1226,344,51,90,6,587,62,347,1058,106,627,317,345;54;F
110189;45,583,1653,1654,190,348,342,1656,53,340,106,627,345,1411,1518;5;F
110223;45,90,44,43;52;M
110279;9,1518;39;M
110300;245,587,589,25,348;51;M
110309;1653,190,347,1656,340;39;F
110311;5,820,433,43;23;M
110330;627,51,245,347,106;48;M
110337;1430,1518;14;F
110342;51,317,345,587,589,919,344,348,1619,1226,1058,106,435,627,707;32;F
110352;25,51,342,340,1655,435,627,317,345,898,45,245,348,589,90;47;M
110453;44;31;F
110475;347,1653,583,1658,62,5,587,1148,245,190,90,342,340,1655,106;49;F
110476;62,433,6,245,347,90,344,1118,1226,1456,1058,106,435,627,1411;56;F
110479;45,1658,245,1654,340,1655,345;44;M
110508;1518;71;F
110510;245,9,44;33;F
110514;45,5,9,1148,1657,1658,190,1422,43,822,52,342,1118,340,820;7;F
110529;6,62,340,1411,627,1619,348,51,90,347,43,9,245,53,106;12;F
110531;820,345,5,1148,1653,245,43,90,51,52,106,627,190,1656,1655;36;M
110547;1655,1430,342,1518;16;M
110553;25,1430,1518;42;M
110584;593,1653;51;F
110588;820,1058,106,317,627,1658,433,1148,919,1619,53,1656,90,347,245;19;F
110593;1656,707,627,317,345,1485,45,1658,25,919,51,1456,63,245,1655;34;M
110606;433,587,5,6,245,347,1118,820,1058,627,1518;31;F
110644;342,106,345,433,587,45,593,1658,245,1654,25,919,1619,1656,820;33;F
110651;53,707,433,62,347,1058,106,317,587,593,583,589,596,627;34;F
110652;1430,1657,43,1411,435,340,1656,348,25,190,1653,583,1658,45,345;41;M
110743;317,435,106,53,51,347,190,583,62,1485,340;37;F
110748;593,627,707,433,587,1619,1226,435,317,1411,1422,348,1058,589,919;25;F
110749;433,43,919,1226,627,1518;39;F
110758;62,6,5,1422,43,347,51,52,1619,53,820,106,627,317,707;54;M
110789;90,51,52,245;50;M
110790;1148,90,919,51,348,1656,340,1655,1058,627,433,587,593,1430,245;50;F
110794;433,593,1430,1518;35;M
110809;433,45,1430,1656,820,627,317,707;38;F
110812;245,1654,43,347,90,25,51,52,627,707,317,1518;46;M
110813;166,106,5,9,62,435,317,707,345,45,53,340,820,63,627;38;F
110824;106,820,340,348,1118,51,90,43,5,9,1658,822,345,44,627;34;F
110827;190,347,345,1148,583,245,1653,1655;38;F
110842;433,5,1430,6,245,43,347,25,51,1619,53,106,627,1411,1518;55;F
110852;5,245,1655,106;31;M
110860;1148,43,919,52,820,627,707,1518;32;F
110866;53,317,52,340,820,106,627,433,6,1430,583,245,44,348,1518;49;M
110880;6,1653,25,106,627,51,1518,340,919,589,1148,587,435,707;31;F
110886;583,9,5,433,587,45,245,25,820,1518;38;F
110910;433,587,62,593,1148,6,245,1422,43,347,919,52,344,1226,1058;32;F
110922;44;33;M
110942;1456,1411,345,1058,1422,587,245,1654,344,1226;51;F
110965;342,345,45,1148,1658,583,1485,190,1422,340,435,1411,1655,1657,1656;15;M
110968;1148,433,587,5,245,1654,43,919,51,52,348,342,1655,820,627;36;F
110971;5,106,435,627,190,62,583,245,43,589,51,44,344,820,1411;22;M
111031;5,898,45,1657,1654,345,1148,1658,190,43,166,1656,340,1655,820;37;F
111035;1430,1619,1518;47;F
111039;166,25;9;M
111040;1654,347,1656,340,1655,106,1148,1658,583,245,1653,190,25,51,348;44;F
111048;1518;11;F
111057;1430,1657,1658,583,245,190,43,1118,53,340,1655,820,1456,627,345;38;F
111059;44,1655,106,627,317,1658,53;41;M
111108;53,5,6,342;33;F
111133;1456,1058,245,583,45,62,433,587,593,1430,919,44,53,627,1411;44;F
111139;589,51,344,53,1058,627,317,707,5,6,43,106,820,1118,348;40;F
111155;1430,1518;9;F
111183;106,51,347,1654,1657,44,344,1619,5,43,1411,9,6,90,25;46;F
111195;43,593,587,6,820;44;F
111201;245,190,1657,1653,1654,820,340,1655,345;41;M
111222;1655,340,53,348,51,25,190,1653,9,1485,45,1658,90,344,435;31;F
111229;43,1619,6,190,347,90,25,51,52,344,106,627,317,1411,1518;18;M
111235;53,820,348,344,90,6,1430,5,9,43,347,25,51,52,627;48;F
111249;596,90,166,43,1654,583,593,433,9,245,25,919,1118,1656,1518;47;F
111264;106,435,317,707,345,587,5,9,1654,1518,245,43,820,627,25;48;M
111267;25,1518;49;M
111277;583,245,166,25,820,106;44;F
111344;45,1657,1658,1653,1654,190,340,1655,820,345;35;M
111361;1654,45,1485,51,44,344,53,627,5,433,587,9,25,820,1518;42;F
111368;435,820,340,53,344,25,822,43,1654,1148,45,898,9,1485,5;44;F
111378;45,583,90,25,44,52,342,53,345,1518;35;F
111403;820,1655,348,589,347,627,25,43,190,583,342,1430,707,1118,52;26;F
111412;433,6,190,90,106;29;F
111495;587,433,1485,45,593,43,344,348,106,435,317,5,166,9,25;40;F
111523;317,62,6,245,347,90,344,53,106,627,707,1518;41;M
111543;1658,190,589,344,1655,1518;33;F
111550;53,317,345,340,348,6,1148,62,43,347,90,51,106,627;42;M
111552;90,347,589,1653,6,1148,1657,62,9,5,1485,43,348,707,1518;30;F
111560;1655,342,340,1118,52,51,596,589,43,190,245,1658,1148,587,433;32;F
111571;52,344,348,342,1656,1411,433,9,45,583,6,166,25,1226,820;40;F
111591;245,340,820,1058,63,106,627,345,433,587,5,898,45,1148,1658;57;F
111594;1118,1619,596,347,1422,5,6,245,1654,43,589,348,106;38;F
111615;62;44;F
111632;627,433,1485,45,1657,583,245,347,342,1656,1655,1456,63,1411,707;2;M
111641;342,53,435,627,5,1658,43,347,344,820;39;F
111655;1485,9,5,583,589,25,44,51,53,106,435,627,317,707,1518;27;M
111669;62,1658,583,1653,51,52,344,1619,1656,106,627,1655;38;M
111671;9,583,245,1653,51,53,317,627,62,25,44,52,344,1619,1656;11;M
111680;166,25;52;M
111686;245,1422,1654,433,1430,347,25,44,344,1619,1456,106,627,1411,1518;49;F
111690;51,52,106,627,62,348,344,1656,1518,435,317,707;24;F
111719;1655,1656,51,919,1658,1657,5,433,45,245,1653,347,342,106,627;36;F
111733;433,5,9,106,435,317;50;F
111735;1518;52;F
111779;51,90,347,6,9,5,627,317;29;F
111784;1430,707,587,45,1058,348,1226,593,583,1657,245,433,1654;36;F
111804;433,587,9,593,1430,245,43,166,25,919,348,1619,820,1411,1518;54;M
111805;1058,1411,1456,1226,1619,1422,1485,1654,1655,433,1148,245,1653,1656,1518;5;F
111854;43,627,820,51,347;52;M
111883;106,820,589,62,9,43,1619,583,6,919,348,166,5,25;52;F
111893;44;45;M
111911;245,347,51,90,52;48;F
111947;342,5,45,1148,245,1653,1654,190,43,90,51,344,340,1655,820;66;F
111992;589,1654,1430,45,587,245,822,348,1226,106,435;57;F
111995;1654,190,347,25,1656,707,348,1148,43,51,1655,1058,106,627,345;31;F
112008;1485,433,45,822,25,51,44,342,1656,53,345,1518,340,63,435;57;M
112055;1658,245,1653,1422,90,919,344,1226,53,820,1058,106,627,707,345;42;F
112129;340,1422,190,1653,1658;12;F
112134;1411,433,9,6,919,348,1619,1118,1456,43,90,344,5,587,245;43;F
112157;52,344,5,245,347,90,435,627,317,587,9,25,44,106,1518;21;F
112185;6,90,51,106;35;M
112194;707,435,1456,1656,25,347,1658,1657,45,5,245,190,43,340,820;39;F
112201;433,5,9,62,822,25,51,1118,53,898,593,43,44,1456,1058;31;F
112207;1485,62,43,51,348,1456,1148,190,347,344,820,106,627;47;F
112209;25;50;M
112210;1655,52,919,822,90,43,6,433,1657,347,51,53,106,627,707;41;M
112246;1656,340,1655,1654,627,106,245,1653,51,317,583,43,347,25,348;44;M
112248;43,190,6,1148,1430,1485,5,51,344,53,820,1058,106,435,317;32;F
112303;589,43,1422,190,6,1430,45,62,348,1656,53,820,435,627,345;45;F
112326;53,63,317,62,43,347,820,627,51,1148,6,245,190,1656,106;36;F
112328;5,9,43,347,51,1118,820,106,435,627,317;31;M
112343;583,433,587,1485,1430,1148,1653,245,1422,919,1118,1656,1456,707,1518;6;M
112365;9,919,44,1456,1058;41;F
112405;1456,106,627,1118,52,43,6,62,5,596,589,90,919,344,348;50;F
112427;587,45,1430,1654,190,1411,340,919,43,245,583;47;F
112430;587,1148,245,348,345;52;F
112443;53,340,1655,820,1456,1058,63,106,435,627,317,707,345,1411,1518;1;F
112470;44;5;F
112489;245,822,820;76;M
112518;587,1430,25,51,44;70;M
112549;1518;52;M
112557;822;20;F
112599;1430,342,1148,583,245,1653,1654,1118,1226,1656,340,1655,1456,707,1411;40;M
112677;1422,1148,1658,1485,587,593,245,820,45,340,1657,1655,1656,1654,1653;49;M
112694;1518,919,44;33;F
112703;583,25,166;37;M
112711;106,5,627,45,583,347,51,1656,1653,1655,1657,1658,43,345,340;38;M
112717;43,1619,1411;34;M
112726;1518,820;48;F
112728;433,587,9,43,822,44;34;F
112732;166;32;F
112750;345,340,53,919,822,1422,190,1148,1657,1430,593,9,898,1485,5;32;F
112767;45,245,347,90,344,1656,106,1518;40;F
112768;245,1655,106;32;F
112811;5,62,45,1422,347,90,596,25,44,53,820,106,435,627,317;46;M
112819;587,433,62,583,25,51,44,1619,1656,53,627,317,707,1411,1518;54;M
112824;435,317,707,1422,53,5,898;33;F
112827;51,348,340,1058,106,820,919,596,593,587,1148,583,245,1654,190;46;F
112834;25,51,52,344,820,317,433,583,6,1654,347,348,106,627,1518;30;M
112872;51;31;F
112883;820,707,342,1619,1657,1148,1658,1653,1422,347,596,919,1118,627,1518;15;F
112888;5,190;29;M
112930;190,25,820,345,433,5,1485,898,6,90,51,52,53,435,707;37;M
112949;1411,347,1422,5,587,1430,1148,190,25,51,340,1456,435,627,317;29;F
112962;1657,1653,1619,1456,435,707,1148,1656,1518;38;M
113000;1655,820,1657,1148,1658,245,1653,190,43,25,52,340,435,627,345;76;M
113022;820,1058,106,435,345,1485,1658,919,1118,340,1656,627,707,1518,1411;36;F
113033;43,90,51,52,317;25;M
113056;587,5,9,62,25,44,348,820,1456,707;61;F
113074;820,342,51,5,45,245,43,347,596,1118,340,106,345,627,1655;38;M
113078;1619,627,707,345,340,90,348,1656,342,245,587,820,1657,433;38;F
113082;707,1518,25;28;M
113129;9,43,25,52,1226,1058,627,44;28;M
113133;9,1518;29;M
113191;342,820,348,344;39;F
113199;1518;45;M
113201;45,245,317;45;M
113204;44;4;F
113215;1656,1226,9,1058,6,25,44,317;31;F
113220;1518;9;F
113226;43,589,822,342,820,707;38;F
113227;587,45,245,43,919,342,1456,707;10;F
113232;51,1658,1656,1655,820,63,106,435,627,317,707,345,433,45,1148;24;F
113234;44,820;35;M
113259;583,1657,62,9,587,433,43,435,44,1518;27;F
113281;347,348,53,627,106;29;M
113299;5,1485,9,898,45,1148,1654,43,822,25,344,53,340,820,435;45;M
113329;166,62,45,1518,52,344,1619,820,627,5,9,6,25,44,53;34;M
113344;245,1148,51,317,190,62,587,5,43,919,348,627,820,1058,106;42;F
113377;245,1148,347,1619,53,340,9,62,51,820,106,627,317,1411,90;26;F
113421;627,1058,1226,1658,1430,345;28;F
113429;190,5,587,345,707,1619,627,1656,1148,245,1653,347,90,52,348;58;F
113440;5,1148,190,347,822,1655,106,317,43,51,52,344,340,820,627;30;F
113454;5,1148,190,43,347,51,52,344,820,340;29;M
113475;433,9,593,583,1654,1422,43,344,25,44;34;M
113500;433,587,1485,62,822,1422;56;F
113513;1411,1430,45,5,1148,1658,6,245,1654,190,51,43,347,1657,340;41;M
113519;342,190,822,345,820,344,627,340,348;34;F
113525;5,1485,9,43,589,822,51,344,342,820,707;13;M
113584;1411,5,45,1657,1148,1658,583,245,190,347,348,342,1656,707,345;4;M
113595;1148,1653,190,43,52,348,1619,1656,53,340,820,1456,435,627,1518;61;F
113616;1656,435,62,317,1657,1148,6,245,190,347,51,340,820,106,627;51;M
113618;5,433,45,1148,245,190,43,347,596,344,1619,1118,340,820,707;65;M
113623;587,583,822,1518;83;F
113631;245;17;M
113638;589,43,190,245,5,433,435,627;21;M
113643;45,348,583,1657,1654,433,245;37;M
113686;190,347,51,317,587,433,1422,43,589,344,348,820,1058,627,106;26;M
113706;5,587,433,898,593,1430,583,1422,25,348,342,53,627,1411,1518;41;M
113710;245,9,433,5,587,45,593,25,919,344,53,820,1058,707;30;F
113723;583,1654,43,25,1619,1656,63,707;2;M
113733;5;30;F
113735;344,820,63,106,587,5,9,593,45,43,919,25,44,342;29;F
113755;106,820,1226,342,348,43,190,1654,6,245,583,1430,45,62,5;39;M
113762;1658,583,245,348,342;43;F
113771;587,62,1430,583,245,589,25,348,1619,342,1226,1456,1518,6,433;35;F
113787;593,342,245;36;F
113794;45,43,589,347,596,822,51,344,342,820,106,707;8;F
113806;593,1430,589,919,348,1226,1456,1058,106,627,317,5,1518;31;F
113808;1148,583,1653,347,51,1656,820,106,627,345;34;F
113865;1411,6,433,1430,627,245,1654,43,25,919,1619,1518,1118,587,90;34;F
113882;348,627,345,106,820,190,245,5,317,1653,1485,1148,1657,1658,1518;44;M
113889;587,45,245,43,919,1456,707;3;M
113893;25,583,166;9;M
113912;583,245,348,342;33;M
113922;53,820,435,106,1656,6,62,5,433,245,43,90,919,348,627;29;F
113941;43,51,106,627,53,190,347,822,344,348,342,340,820,345;40;M
113956;1654,822,51,5,1430,25,1118,1456,345,45,1658,1422,43,596,340;11;M
113973;1485,5,53,707,345,1518,106,820,9,347,25,51,44,627,317;48;M
113977;587,5,1148,347,90,52,1619,1656,627,707,345,820,348,245,1653;63;M
114000;345,433,587,245,589,52,53,106,1485,6,90,344,435,317,707;39;F
114037;106,820,340,51,25,1148,62,9,1485,5;29;M
114039;820,1456,1518;44;F
114042;52,344,348,53,9,433,820,435,317,707,1518,190,62,43,25;34;M
114056;45,1148,190,43,589,347,822,51,344,342,820,627,317,707,1411;38;M
114070;435,340,190,1658,583,1148;39;M
114071;433,45,25,90,583,593,5,1485,245,190,919,344,1619,1058,707;27;F
114078;52,1148,1653,51,1656,820,106,627,317,1518;29;M
114092;45,245,317,1518;42;F
114110;62,1658,190,344,1226,53,345;29;M
114111;245,90,5,1485,9,1148,6,51,435,106,820,1118,348,25,43;27;F
114149;347,90,25,51,435,627,5,9,6,190,43,822,820,106,317;23;F
114154;1518,1411,90,245,6,1118,1430,587;43;F
114156;25,166;51;F
114164;5,62,43,347,51,340,1411,1658,106,627,583,245;42;F
114188;1422,43,347,90,596,51,52,344,53,317,245,589,348,1118,820;33;M
114189;583,25,166;6;M
114199;190,245,1658,1148,1657,1430,433,45,1653,43,1656,1655,340,106,345;35;F
114203;1518;33;M
114209;62,45,919,106,627,1518,317,707,25,593,587,5,433,9,245;1;M
114229;9,245,44;38;F
114246;9,62,1430,583,6,245,43,347,90,51,44,348,53,820,1518;39;M
114277;5,9,45,1658,43,347,822,51,344,342,53,820,627,707,1411;2;F
114284;435,1518,63,44,166,43,51,25,1148,45,9,5;45;M
114328;62,9,5,1148,245,25,51,44,63;74;F
114370;1654,6,45,62,5,9,51,44,344,348,342,53,1518,435,820;31;F
114397;1518;42;M
114409;45,44,9,245,1654,43,347,344,53,5,25,51,820,627,1518;49;F
114434;433,347,25,44,53,820,627,1518;47;F
114438;587,1430,6,245,1456,627,1518;46;F
114439;62,51,52,106,1518,190,347,596,348,1118,53,1456,627,317,345;40;M
114467;245;44;F
114473;1485,898,1422,1619,1118,1655,1430,1657,1148,1658,1654,43,90,344,820;36;F
114481;5,587,433,1518,1411,707,627,820,53,919,1422,1654,6,583,43;31;M
114513;9,435,317,707,25;64;F
114542;344,51,347,589,433,9,62,1430,6,43,25,348,106,435,317;63;F
114546;166,5,45,1658,1422,43,596,342,1118,53,340,820,1456;6;M
114558;45,245,43,347,344,820,106,627,5,90,51,52,435,317,707;31;F
114591;1518;7;M
114592;435;25;F
114604;44,5,62,583,245,1619,707,596,589,344,342,90,45,43,63;40;F
114605;52,820,317,62,5,1657,1148,245,1653,190,347,51,340,106,627;13;M
114625;9,1485,433,1430,25,51,820,106,435,627,317;26;M
114628;1518;7;M
114632;589,347,596,25,51,52,344,1118,340,435,627,433,820,245,106;30;M
114663;345,347,1148,25,44,1518,587,433,45,6,245,919,1058,627,707;20;F
114667;52,344,342,1619,317,627,587,44,51,596,43,245,348,820;24;M
114669;6,1148,627,1518,1485,5,45,1654,1653,43,348,1656,1655,106,245;37;F
114680;583,245,1653,190,589,347,51,1619,1656,340,820,106,627,317,345;47;F
114714;583,51,52,1619,1118,627,433,245,342,1456,435,317,707;36;F
114741;1226,53,1411,317,627,435,5,9,1430,245,43,51,348,342,820;37;F
114756;25,51,44,53,345,344,342,1619,63,106,627,707,1518,62,583;38;F
114776;1619,106,627,707,5,6,43,589,347,596,52,1118,53,820,1058;41;F
114793;44,1118;45;F
114811;627,435,5,1430,1148,190,347,51,52,820,106,245,919,344,348;48;F
114812;166;49;M
114837;433,587,1485,593,44,707;42;F
114846;44,43,347,627;47;M
114850;5,190,43,52,344,1456,106,345,1411,1518,1653,1656,1655,820,627;36;M
114854;190,589,1656,317,1411,1518,51,348,53,340,1655,820,63,106,435;39;F
114870;433,5,9,44,106,627,317;25;F
114871;245,344,1655,820,707;47;F
114895;5,9,190,25,53,820;58;M
114897;348,1619,627,1518,1485,1430,245,596,52,344,1118,106,435,317,707;46;F
114906;44;52;F
114961;106,627,435,317,1518,5,9,43,166,25;40;F
114963;43,347,919,820,627,9,44,53,1518;28;F
114985;583,190,1422,90,596,25,348,1118,53,340,1655,106,627,707,345;42;M
115001;1430,593;26;F
115034;1118,348,344,43,245,898,45,1148,190,1656,820,1058,106,627,1518;42;F
115036;53;60;M
115055;45,1148,347,51,1656,106,190,245,345,583,587,627,1658;42;M
115068;166;15;M
115079;1518;50;M
115097;1619,1118,53,340,1058,345,433,587,62,45,919,106,627,317,707;45;F
115102;9,245,44;2;F
115185;245,25,44;37;F
115189;347,52,1655,317,1148,6,348,5,51,344,820,106,435,627,707;32;F
115205;43,1148,245,190,589,627,820,345,90,106;30;F
115240;1148,1653,348,45,433;37;M
115247;1456,345,820,1656,342,433,45,1657,1148,1658,245,190,1653,340,1655;41;M
115252;1518,25,596,347,43,190,1658,51,52,344,348,106,627;32;M
115269;51,106,587,5,245,1653,190,90,52,348,1656,820,627,707,345;22;M
115272;25,44,245;45;F
115292;433,9,44,820,25;51;M
115323;5,9,45,583,6,43,596,919,51,44,344,342,1118,53,820;41;F
115400;5,1485,898,1148,583,6,1422,596,1619,53,435,627,317,707;32;F
115407;5,1485,1658,1422,43,347,90,51,344,53,106,317,820,627,707;29;M
115442;245;24;F
115469;344,820,1518;37;F
115495;1430,44;28;F
115496;1654,51,52,348,342,1226,820,1456,1058,435,627,317,707,1411,1518;15;F
115512;1657,1148,1658,245,1653,190,43,25,52,340,1655,820,435,627,345;48;M
115525;5,9,43,166,25,106,435,627,317,1518;42;M
115536;44,1118;11;F
115543;44;9;F
115559;587,1430,6,245,90,1118,1518,1411;44;M
115580;5,9,45,245,1654,43,347,25,51,44,344,53,820,627,1518;12;F
115591;6,1654,25,53,345,627,820,52,44,583,9,5,43,344,1518;43;F
115597;587,5,1657,190,43,344,340,820,1058,627,345;46;F
115622;627,62,90;27;M
115629;5,51,820,106,435,627,317,707;50;M
115640;1655,820,63,106,627,707,1411,1518,433,45,1148,1658,1653,342,345;41;F
115647;1658,347,52,820;34;M
115664;1226,51,1653,583,1658,587,348,1422,1430,898,433,25,340,1411,1518;27;M
115667;5,9,43,166,25,106,435,627,317,1518;12;F
115685;45,1485,5,9,1148,1654,166,53,820;39;M
115689;5,62,43,347,106,627,317,9,6,245,1422,166,90,25,1518;45;F
115690;44;5;M
115693;433,45,593,1654,919,348,342,1226,1456,1058,707,1411,1518;67;F
115694;433,62,583,52,627,707,435,106,348;25;M
115715;1657,45,1148,1658,583,245,1653,190,1422,90,340,1655,820,1456,435;39;F
115743;433;46;M
115749;62,583,344,342,1619,53,25,51,44,627,707,1518,63,106,345;6;F
115781;5,9,43,166,25,106,435,627,317,1518;9;M
115787;44;;M
115808;45,1148,1658,583,1518,1422,596,822,25,340,1655,344,342,1619,1118;17;M
115820;433,5,1430,1148,1658,6,245,589,347,344,348,820,707,345,1518;31;F
115833;5,9,45,245,1654,43,347,25,51,44,344,53,820,627,1518;21;F
115836;433,45,593,342,1226,1058,707,1411,1518;65;M
115843;62,627,317,433,593,1430,1148,245,190,25,919,51,348,53,106;37;F
115850;5,9,43,166,106,435,627,317,25,1518;14;M
115853;1058,1456;73;M
115873;1058,106,627,317,43,347,919,51,52,344,348,1226,1656,53,820;54;F
115876;44;37;M
115906;1148,43,347,596,51,820,627;24;M
115907;25,596,344,1118,53,106,1518,5,9,347,51,52,820,627,317;39;F
115908;1657,1148,1658,245,1653,190,43,25,52,340,1655,820,435,627,345;74;F
115910;5,25,51,344,1411;17;F
115924;25,1518;46;F
115925;245,25,51,44,820,627;15;M
116118;245,347,43;74;F